/* GLE - The GTK+ Layout Engine
 * Copyright (C) 1998 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __GLELAYOUT_H__
#define __GLELAYOUT_H__


#include	"glemisc.h"


#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */



#define	GLE_IS_LAYOUT_WIDGET(widget)	(gle_widget_get_layout (GTK_WIDGET ((widget))) != NULL)
#define	GLE_IS_NAMED_WIDGET(widget)	(gle_widget_get_glename (GTK_WIDGET ((widget))) != NULL)



typedef struct _GleLayoutData	GleLayoutData;
struct _GleLayoutData
{
  GtkWidget	*widget;
  gint		 destroyed_handler;
  const gchar	*glename;

  GList		*args		/* of type GleGArg */;
};


GleLayoutData*	gle_layout_new			(const gchar	*glename);
void		gle_layout_destroy		(GleLayoutData	*layout);
void		gle_layout_associate		(GleLayoutData	*layout,
						 GtkWidget	*widget);
void		gle_layout_disassociate		(GleLayoutData	*layout);
GleLayoutData*	gle_widget_get_layout		(GtkWidget	*widget);
void		gle_layout_apply_to_widget	(GleLayoutData	*layout);
void		gle_layout_update_from_widget	(GleLayoutData	*layout);
void		gle_layout_reset		(GleLayoutData	*layout);
GleLayoutData*	gle_layout_lookup		(const gchar	*glename);







#ifdef __cplusplus
#pragma {
}
#endif /* __cplusplus */


#endif	/* __GLELAYOUT_H__ */
