/* GLE - The GTK+ Layout Engine
 * Copyright (C) 1998 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include	"config.h"

#include	"gle.h"
#include	<gdk/gdkkeysyms.h>


/* --- global variables --- */
const guint     gle_libversion_major = LIBGLE_MAJOR;
const guint     gle_libversion_revision = LIBGLE_REVISION;
const guint     gle_libversion_age = LIBGLE_AGE;
const gchar     *gle_libversion = LIBGLE_VERSION;


/* --- prototypes --- */
static gint	gle_snooper		(GtkWidget   *grab_widget,
					 GdkEventKey *event,
					 gpointer     func_data);


/* --- static variables --- */
static	gint	snooper_id = 0;
static	gchar	*prg_name = NULL;


/* --- functions --- */
void
gle_init (int          *argc_p,
	  char       ***argv_p)
{
  gint argc;
  gchar **argv;

  if (snooper_id)
    return;

  if (!argc_p)
    argc = 0;
  else
    argc = *argc_p;

  if (!argv_p)
    argv = NULL;
  else
    argv = *argv_p;

  if (argc < 1 || !argv || !argv[0])
    prg_name = g_strdup ("");
  else
    prg_name = g_strdup (argv[0]);

  snooper_id = gtk_key_snooper_install (gle_snooper, NULL);
}

const gchar*
gle_prg_name (void)
{
  return prg_name;
}

static gint
gle_snooper (GtkWidget   *grab_widget,
	     GdkEventKey *event,
	     gpointer     func_data)
{
  if ((event->state & (GDK_CONTROL_MASK | GDK_MOD1_MASK)) &&
      (event->keyval == '\t' || event->keyval == GDK_Tab))
    {
      GtkWidget *event_widget;

      event_widget = gtk_get_event_widget ((GdkEvent*) event);
      if (event_widget)
	while (event_widget->parent)
	  event_widget = event_widget->parent;
      gle_main_window_popup (event_widget);
      return TRUE;
    }
  return FALSE;
}
