/* The GIMP -- an image manipulation program
 * Copyright (C) 1995 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <string.h>
#include "buffer.h"


static GimpBufferClass my_class =
{
  STORAGE_NONE,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL,
  NULL
};


void
gimp_buffer_init (GimpBuffer * buffer,
                  Tag tag,
                  gint width,
                  gint height)
{
  g_return_if_fail (buffer != NULL);
  g_return_if_fail (width > 0);
  g_return_if_fail (height > 0);
  g_return_if_fail (tag_valid (tag) == TRUE);

  buffer->width = width;
  buffer->height = height;
  buffer->depth = tag_bytes (tag);
  buffer->tag = tag;
  buffer->autoalloc = TRUE;
  buffer->autovalidate = TRUE;
  buffer->klass = (void*) &my_class;
}


void
gimp_buffer_uninit (GimpBuffer * buffer)
{
}


gint
gimp_buffer_width (GimpBuffer *buffer)
{
  g_return_val_if_fail (buffer != NULL, 0);

  return buffer->width;
}


gint
gimp_buffer_height (GimpBuffer *buffer)
{
  g_return_val_if_fail (buffer != NULL, 0);

  return buffer->height;
}


Tag
gimp_buffer_tag (GimpBuffer *buffer)
{
  g_return_val_if_fail (buffer != NULL, tag_null());

  return buffer->tag;
}


void
gimp_buffer_delete (GimpBuffer *buffer)
{
  g_return_if_fail (buffer != NULL);
  g_return_if_fail (buffer->klass != NULL);
  g_return_if_fail (GIMP_BUFFER_CLASS(buffer->klass)->delete != NULL);

  GIMP_BUFFER_CLASS(buffer->klass)->delete (buffer);
}


gboolean
gimp_buffer_focus (GimpBuffer        *buffer,
                   GimpPortion       *portion,
                   gint               x,
                   gint               y)
{
  g_return_val_if_fail (buffer != NULL, FALSE);
  g_return_val_if_fail (buffer->klass != NULL, FALSE);
  g_return_val_if_fail (GIMP_BUFFER_CLASS(buffer->klass)->focus != NULL, FALSE);
  g_return_val_if_fail (portion != NULL, FALSE);

  return GIMP_BUFFER_CLASS(buffer->klass)->focus (buffer, portion, x, y);
}


gboolean
gimp_buffer_alloc (GimpBuffer        *buffer,
                   GimpPortion       *portion,
                   Alloc              how)
{
  g_return_val_if_fail (buffer != NULL, FALSE);
  g_return_val_if_fail (buffer->klass != NULL, FALSE);
  g_return_val_if_fail (GIMP_BUFFER_CLASS(buffer->klass)->alloc != NULL, FALSE);
  g_return_val_if_fail (portion != NULL, FALSE);

  return GIMP_BUFFER_CLASS(buffer->klass)->alloc (buffer, portion, how);
}


gboolean
gimp_buffer_validate (GimpBuffer        *buffer,
                      GimpPortion       *portion,
                      Validate           how)
{
  g_return_val_if_fail (buffer != NULL, FALSE);
  g_return_val_if_fail (buffer->klass != NULL, FALSE);
  g_return_val_if_fail (GIMP_BUFFER_CLASS(buffer->klass)->validate != NULL, FALSE);
  g_return_val_if_fail (portion != NULL, FALSE);

  return GIMP_BUFFER_CLASS(buffer->klass)->validate (buffer, portion, how);
}


gboolean
gimp_buffer_use (GimpBuffer        *buffer,
                 GimpPortion       *portion,
                 Use                how)
{
  g_return_val_if_fail (buffer != NULL, FALSE);
  g_return_val_if_fail (buffer->klass != NULL, FALSE);
  g_return_val_if_fail (GIMP_BUFFER_CLASS(buffer->klass)->use != NULL, FALSE);
  g_return_val_if_fail (portion != NULL, FALSE);
  
  return GIMP_BUFFER_CLASS(buffer->klass)->use (buffer, portion, how);
}


gboolean
gimp_buffer_query (GimpBuffer    *buffer,
                   GimpPortion   *portion,
                   GimpMemStatus *status)
{
  g_return_val_if_fail (buffer != NULL, FALSE);
  g_return_val_if_fail (buffer->klass != NULL, FALSE);
  g_return_val_if_fail (GIMP_BUFFER_CLASS(buffer->klass)->query != NULL, FALSE);
  g_return_val_if_fail (portion != NULL, FALSE);
  g_return_val_if_fail (status != NULL, FALSE);
  
  return GIMP_BUFFER_CLASS(buffer->klass)->query (buffer, portion, status);
}


gboolean
gimp_buffer_data (GimpBuffer     *buffer,
                  GimpPortion    *portion,
                  GimpPixelArray *array)
{
  g_return_val_if_fail (buffer != NULL, FALSE);
  g_return_val_if_fail (buffer->klass != NULL, FALSE);
  g_return_val_if_fail (GIMP_BUFFER_CLASS(buffer->klass)->data != NULL, FALSE);
  g_return_val_if_fail (portion != NULL, FALSE);
  g_return_val_if_fail (array != NULL, FALSE);
  
  return GIMP_BUFFER_CLASS(buffer->klass)->data (buffer, portion, array);
}
