/* Balsa E-Mail Client
 * Copyright (C) 1997 Jay Painter
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <gtk/gtk.h>
#include "error.h"
#include "index_interface.h"
#include "main_window.h"
#include "postoffice.h"
#include "mailbox.h"


extern PostOffice *postofficeX;


int
main (int argc, char *argv[])
{
  Mailbox *mailbox;

  gtk_init (&argc, &argv);

  /*
   * make sure that important global structures are initalized --
   * trust me, it's easier to do it here than to make sure it's initalized
   * in every function that needs it.  Order does matter here, sorry!
   */
  mail_init ();
  postoffice_init ();
  main_window_init ();

  mailbox_menu_update (postofficeX);
  
  /*
   * give things a kick start here
   */
  if (postofficeX->mailbox_list)
    {
      mailbox = (Mailbox *) postofficeX->mailbox_list->data;
      mailbox_open (mailbox);
      index_update (mailbox);
    }


  gtk_main ();
  return 0;
}
