/* Balsa E-Mail Client
 * Copyright (C) 1997 Jay Painter
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <string.h>
#include <gtk/gtk.h>
#include "gtkclist.h"
#include "index_interface.h"
#include "main_window.h"

extern MainWindow *mainW;

void mailbox_menu_select (GtkWidget *);
void move_menu_select (GtkWidget *);


/*
 * takes the mailbox and lists it's contents in
 * the mailbox index
 */
void
index_update (Mailbox *mailbox)
{
  GList *list;
  Message *message;
  gint i;
  gchar temp_num[10];
  gchar *text[4];

  gtk_clist_freeze (GTK_CLIST (mainW->index_clist));
  gtk_clist_clear (GTK_CLIST (mainW->index_clist));

  i = 0;
  list = mailbox->message_list;
  while (list)
    {
      message = list->data;
      list = list->next;

      sprintf (temp_num, "%d", i+1);
      
      text[0] = temp_num;
      text[1] = mail_message_from (message);
      text[2] = mail_message_subject (message);
      text[3] = mail_message_date (message);

      gtk_clist_append (GTK_CLIST (mainW->index_clist), text);
      gtk_clist_set_row_data (GTK_CLIST (mainW->index_clist), i, message);

      i++;
    }

  gtk_clist_thaw (GTK_CLIST (mainW->index_clist));
}

void
index_select (GtkWidget *widget, gint row, gint column, GdkEventButton *bevent)
{
  Message *message;

  if (bevent && bevent->button == 3)
    g_print ("Three\n");

  message = (Message *) gtk_clist_get_row_data (GTK_CLIST (mainW->index_clist), row);
  display_message (message);
}

/*
 * remove the old mailbox menu, and create a new one
 * from the current postoffice 
 */
void
mailbox_menu_update (PostOffice *postoffice)
{
  GList *list;
  GtkWidget *menuitem;
  Mailbox *mailbox;

  /*
   * get rid of the old...
   */
  gtk_option_menu_remove_menu (GTK_OPTION_MENU (mainW->mailbox_option_menu));

  if (mainW->mailbox_menu)
    gtk_widget_destroy (mainW->mailbox_menu);
  if (mainW->move_menu)
    gtk_widget_destroy (mainW->move_menu);
  mainW->mailbox_menu = NULL;
  mainW->move_menu = NULL;


  mainW->mailbox_menu = gtk_menu_new ();
  mainW->move_menu = gtk_menu_new ();


  /*
   * create the new menu
   */
  list = postoffice->mailbox_list;
  while (list)
    {
      mailbox = list->data;
      list = list->next;

      menuitem = gtk_menu_item_new_with_label (mailbox->name);
      gtk_object_set_user_data (GTK_OBJECT (menuitem), mailbox);

      gtk_signal_connect (GTK_OBJECT (menuitem), "activate",
			  (GtkSignalFunc) mailbox_menu_select,
			  menuitem);

      gtk_menu_append (GTK_MENU (mainW->mailbox_menu), menuitem);
      gtk_widget_show (menuitem);

      menuitem = gtk_menu_item_new_with_label (mailbox->name);
      gtk_menu_append (GTK_MENU (mainW->move_menu), menuitem);
      gtk_widget_show (menuitem);
    }

  gtk_option_menu_set_menu (GTK_OPTION_MENU (mainW->mailbox_option_menu),
                            mainW->mailbox_menu);
}

void
mailbox_menu_select (GtkWidget *menuitem)
{
  Mailbox *mailbox;

  mailbox = (Mailbox *) gtk_object_get_user_data (GTK_OBJECT (menuitem));
  if (mailbox != mailbox->postoffice->open)
    {
      mailbox_open (mailbox);
      index_update (mailbox);
    }
}
