
#ifndef __REGION_H__
#define __REGION_H__
#include <unistd.h>
#include <sys/types.h>
#include <sys/mman.h>
#include <glib.h>
typedef struct _AudioRegion AudioRegion;

#define REGION_MMAP 0
#define REGION_MALLOC 1
#define MIN_MMAP_LENGTH 12

#define AT_SYNC 0
#define AT_ASYNC 1

struct _AudioRegion 
{
   int      type;                /* the type of the region    */
   
   char    *filename;            /* the filename of the mmap  */
   int      fd;                  /* the fd for mmaped regions */
   off_t    offset;              /* the initial offset        */
   size_t   length;              /* the length of the buffer  */

   gint     bps;                 /* currently unused */
 
   void    *data;                /* the data for the region   */
};

typedef struct _TmpRegion TmpRegion;

struct _TmpRegion
{
  int type;                   /* type of the data */
  size_t length;              /* the length of the data */
  gint  bps;         /* the number of channels */
  
  gint  sample_rate;          /* sample rate CURRENTLY UNUSED */
  
  void *data;                 /* the data */
};

/* access functions */

AudioRegion * region_new                (size_t length, gint bps);           
AudioRegion * region_new_from_file      (char *, gint bps);
AudioRegion * region_new_from_fd        (int fd, size_t, off_t offset, gint bps);
AudioRegion * region_new_from_data      (void *, size_t length, gint num_channels);
void          region_delete             (AudioRegion *);
void          region_copy               (AudioRegion *,
					 AudioRegion *,
					 off_t ,
					 off_t ,
					 size_t);


AudioRegion *region_combine (AudioRegion *, AudioRegion *);		       
void region_resize (AudioRegion *, size_t, size_t);	 
void region_sync (AudioRegion *, gint);
void region_zero (AudioRegion *);

void           tmp_region_init (TmpRegion *dest,
				AudioRegion *src,
				size_t, 
				size_t);


#endif /* __REGION_H__ */














