/* Histogram 1.0 - Generates histogram distributions for The GIMP
 * Copyright (C) 1996 Kris Wehner and Ed Connell
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* 
 * Renders a histogram of either a grayscale or rgb color image 
 * showing the shade distribution (intended for use with levels.c).
 */

#include "gimp.h"
#include <stdio.h>
#include <string.h>
#include <bsd_mem.h>
#define R 0
#define G 1
#define B 2

/* Declare local functions.
 */
/*static void image_menu_callback (int, void *, void *);*/
static void ok_callback (int, void *, void *);
static void cancel_callback (int, void *, void *);
static void rgb_histogram (Image, long);
static void gray_histogram (Image, long);
static void pick (Image);
static void scale_callback(int, void *, void *);

static char *prog_name;

static int dialog_ID;
static int scale_ID;
static int scale_value=1;

int
main (argc, argv)
     int argc;
     char **argv;
{
  Image src;
  int group_ID;
  /*  int image_menu1_ID;
  int src_ID;*/
  
  /* Save the program name so we can use it later in reporting errors
   */
  prog_name = argv[0];

  /* Call 'gimp_init' to initialize this filter.
   * 'gimp_init' makes sure that the filter was properly called and
   *  it opens pipes for reading and writing.
   */
  if (gimp_init (argc, argv))
    {
      src = 0;
      /*src_ID = 0;*/

      /* Create a dialog.
       */
      dialog_ID = gimp_new_dialog ("Histogram");
      group_ID = gimp_new_row_group (dialog_ID, DEFAULT, NORMAL, "");
      /*      image_menu1_ID = gimp_new_image_menu (dialog_ID, group_ID, 
	      IMAGE_CONSTRAIN_RGB | IMAGE_CONSTRAIN_GRAY,
	      "Image");*/

      scale_ID = gimp_new_scale (dialog_ID,group_ID, 1, 50, scale_value, 0);
      gimp_new_label (dialog_ID, scale_ID, "Scaling factor");

      /*      gimp_add_callback (dialog_ID, image_menu1_ID, image_menu_callback, &src_ID);*/
      gimp_add_callback (dialog_ID, gimp_ok_item_id (dialog_ID), ok_callback, 0);
      gimp_add_callback (dialog_ID, gimp_cancel_item_id (dialog_ID), cancel_callback, 0);
      gimp_add_callback (dialog_ID, scale_ID, scale_callback, &scale_value);
      
      if (gimp_show_dialog (dialog_ID))
	{
	  src = gimp_get_input_image (0);
	  if (src)
	    {
	      gimp_init_progress ("Histogram");
	      pick(src);
	    }
	}

      /* Free the image.
       */
      if (src)
	gimp_free_image (src);
      /* Quit
       */
      gimp_quit ();
    }

  return 0;
}

/*static void
  image_menu_callback (item_ID, client_data, call_data)
  int item_ID;
  void *client_data;
  void *call_data;
  {
  *((long*) client_data) = *((long*) call_data);
  }*/

static void
scale_callback (item_ID, client_data, call_data)
     int item_ID;
     void *client_data;
     void *call_data;
{
  *((long*) client_data) = *((long*) call_data);
}

static void
ok_callback (item_ID, client_data, call_data)
     int item_ID;
     void *client_data;
     void *call_data;
{
  gimp_close_dialog (dialog_ID, 1);
}

static void
cancel_callback (item_ID, client_data, call_data)
     int item_ID;
     void *client_data;
     void *call_data;
{
  gimp_close_dialog (dialog_ID, 0);
}

static void
pick(Image src)
{
  long divisor;
  /* 256 is the height of the histogram output */
  divisor = scale_value;
  switch(gimp_image_type(src))
    {
    case INDEXED_IMAGE :
      gimp_message("Histogram: Sorry, I seg fault on indexed images");
      break;
    case RGB_IMAGE :
      rgb_histogram(src, divisor);
      break;
    case GRAY_IMAGE :
      gray_histogram(src, divisor);
      break;
    default :
      gimp_message("Wow!");
    };

};



static void gray_histogram(Image src, long divisor)
{
  Image dest;
  unsigned char *srcp;
  unsigned char *destp;
  int count[256];
  long width, height;
  int i, j, k,l;
  
  srcp = gimp_image_data (src);
  width = gimp_image_width (src);
  height = gimp_image_height (src);
  dest = gimp_new_image (0, gimp_image_width( src), gimp_image_height(src), gimp_image_type(src));
  destp = gimp_image_data (dest);
  bzero(count,sizeof(count));
  for (j = 0; j < 255; j++)
    {
      count[j] = 0;
    }
  l = 0;
  for (i = 0; i < height; i++)
    {
      for (j = 0; j < width; j++)
	{
	  count[srcp[l]]++;
	  l++;
	}
      if ((i % 5) == 0)
	gimp_do_progress (i, height);
    }
  for (i = 0; i < 256; i++)
    count[i] /= divisor;
  k=0;
  for (i =255 ; i >= 0; i--)
    for (j = 0 ; j < 256; j++, k++)
      destp[k] = 255;
  k = 0;
  for (i =255 ; i >= 0; i--)
    for (j = 0 ; j < 256; j++, k++)
      if (count[j] >= i)
	destp[k] = 0;
  gimp_display_image (dest);
  gimp_update_image (dest);
  gimp_free_image (dest);
}



static void
rgb_histogram (Image src, long divisor)
{
  Image Rdest, Gdest, Bdest;
  unsigned char *srcp;
  unsigned char *Rdestp, *Gdestp, *Bdestp;
  long width, height;
  int count[3*256];
  int i, j, k,l;
  char name_buf[256];

  srcp = gimp_image_data (src);

  width = gimp_image_width (src);
  height = gimp_image_height (src);
  
  sprintf (name_buf, "%s-red", gimp_image_name (src));
  Rdest = gimp_new_image(name_buf,256,256,GRAY_IMAGE);  
  sprintf (name_buf, "%s-blue", gimp_image_name (src));
  Bdest = gimp_new_image(name_buf,256,256,GRAY_IMAGE);  
  sprintf (name_buf, "%s-green", gimp_image_name (src));
  Gdest = gimp_new_image(name_buf,256,256,GRAY_IMAGE);
  Bdestp = gimp_image_data(Bdest);  
  Gdestp = gimp_image_data(Gdest);  
  Rdestp = gimp_image_data(Rdest);
  bzero(count,sizeof(count));
  for (j = 0; j < (3*256); j++)
    {
      count[j] = 0;
    }
  l = 0;
  for (i = 0; i < height; i++)
    {
      for (j = 0; j < width; j++)
	{
	  count[(srcp[l])*3 + R]++;
	  l++;
	  count[(srcp[l])*3 + G]++;
	  l++;
	  count[(srcp[l])*3 + B]++;
	  l++;
	}
      
      if ((i % 5) == 0)
	gimp_do_progress (i, height);
    }
  for (i = 0; i < (3*256); i++)
    count[i] /= divisor;
  k = 0;
  for (i = 256; i> 0; i--)
    for (j = R; j < (3*256); j +=3, k++)
      Rdestp[k] = Gdestp[k] = Bdestp[k] =255;
  k=0;
  for (i = 256; i> 0; i--)
    for (j = R; j < (3*256); j +=3, k++)
      if (count[j] >= i)
	Rdestp[k]=0;
  k = 0;
  for (i = 256; i > 0; i--)
    for (j = G; j < (3*256); j +=3, k++)
      if (count[j] >= i)
	Gdestp[k] = 0;
  k = 0;
  for (i = 256; i > 0; i--)
    for (j = B; j < (3*256); j += 3, k++)
      if (count[j] >= i)
	Bdestp[k] = 0;
  
  /*Red*/
  gimp_display_image(Rdest);
  gimp_update_image(Rdest);
  gimp_free_image(Rdest);
  /* Green */
  gimp_display_image(Gdest);
  gimp_update_image(Gdest);
  gimp_free_image(Gdest);
  /* Blue */
  gimp_display_image(Bdest);
  gimp_update_image(Bdest);
  gimp_free_image(Bdest);
}




