/* GIMP Plugin Preview Widget                                                 
 * Copyright (C) 1998-1999 Shawn T. Amundson                
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.           
 *                                                                            
 * This library is distributed in the hope that it will be useful,             
 * but WITHOUT ANY WARRANTY; without even the implied warranty of              
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU           
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */      

#ifndef GIMP_PREVIEW_H
#define GIMP_PREVIEW_H

#include <gtk/gtk.h>
#include <libgimp/gimp.h>
#include <libgimp/gimpui.h>

/*
#ifdef __cplusplus
extern "C" {
#endif *//*/ __cplusplus */

#define GIMP_TYPE_PREVIEW            (gimp_preview_get_type ())
#define GIMP_PREVIEW(obj)            (GTK_CHECK_CAST ((obj), GIMP_TYPE_PREVIEW, GimpPreview))
#define GIMP_PREVIEW_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), GIMP_TYPE_PREVIEW, GimpPreviewClass))
#define GIMP_IS_PREVIEW(obj)         (GTK_CHECK_TYPE ((obj), GIMP_TYPE_PREVIEW))
#define GIMP_IS_PREVIEW_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GIMP_TYPE_PREVIEW))

typedef struct _GimpPreview      GimpPreview;
typedef struct _GimpPreviewClass GimpPreviewClass;
typedef struct _GimpPreviewEvent GimpPreviewEvent;

struct _GimpPreviewClass {
  GtkVBoxClass parent_class;

  void (* update_preview) (GimpPreview *preview, GimpPreviewEvent *event);
  void (* preview_changed) (GimpPreview *preview);
};

struct _GimpPreview {
  GtkVBox parent;

  GDrawable *drawable;

  GtkWidget *preview;
  GtkWidget *progress_bar;

  gdouble scale;      /* Scale of Preview   */

  guint width;        /* Width of Preview   */
  guint height;       /* Height of Preview  */

  guint image_width;  /* width of image area viewed in the preview */
  guint image_height; /* height of image area viewed in the preview */

  guint image_x;      /* left of image area viewed in the preview */
  guint image_y;      /* top of image area viewed in the preview */

  guchar *check_row_0;
  guchar *check_row_1;
  gint check_size;
  gint check_dark;
  gint check_light;

  guchar *buffer;

  gpointer private_data;
};

struct _GimpPreviewEvent {
  gdouble scale;

  guint x;
  guint y;

  guint width;
  guint height;

  guchar *scaled_data;
};

GtkType    gimp_preview_get_type (void);
GtkWidget* gimp_preview_new      (GDrawable *drawable);
void       gimp_preview_update   (GimpPreview *preview);

/* size_data = (preview->width) * preview->drawable->bpp; */
void       gimp_preview_draw_row (GimpPreview *preview, 
				  guint row, guchar *data);

void       gimp_preview_force_redraw (GimpPreview *preview);

/*
#ifdef __cplusplus
}
#endif *//* __cplusplus */

#endif /* __GIMP_PREVIEW_H__ */
