enum {
  ENC_ISO_8859_1 = 1 << 0,
  ENC_ISO_8859_2 = 1 << 1,
  ENC_ISO_8859_3 = 1 << 2,
  ENC_ISO_8859_4 = 1 << 3,
  ENC_ISO_8859_5 = 1 << 4,
  ENC_ISO_8859_6 = 1 << 5,
  ENC_ISO_8859_7 = 1 << 6,
  ENC_ISO_8859_8 = 1 << 7,
  ENC_ISO_8859_9 = 1 << 8,
  ENC_TIS_620    = 1 << 9,
  ENC_JIS_0208   = 1 << 10,
  ENC_GB_2312    = 1 << 11,
  ENC_KSC_5601   = 1 << 12,
  ENC_ISO_10646  = 1 << 13
};

Charset charsets[] = {
  { 0,  "ISO-8859-1", "iso8859-1", conv_ucs4 },
  { 1,  "ISO-8859-2", "iso8859-2", conv_8bit },
  { 2,  "ISO-8859-3", "iso8859-3", conv_8bit },
  { 3,  "ISO-8859-4", "iso8859-4", conv_8bit },
  { 4,  "ISO-8859-5", "iso8859-5", conv_8bit },
  { 5,  "ISO-8859-6", "iso8859-6", conv_8bit },
  { 6,  "ISO-8859-7", "iso8859-7", conv_8bit },
  { 7,  "ISO-8859-8", "iso8859-8", conv_8bit },
  { 8,  "ISO-8859-9", "iso8859-9", conv_8bit },
  { 9,  "TIS-620",    "tis620.2529-1", conv_8bit },
  { 10, "EUC-JP",     "jisx0208.1983-0", conv_euc },
  { 11, "EUC-CN",     "gb2312.1980-0", conv_euc },
  { 12, "EUC-KR",     "ksc5601.1987-0", conv_euc },
  { 13, "ISO-10646",  "iso10646-1", conv_ucs4 }
};

static PangoEngineRange basic_ranges[] = {
  /* Language characters */
  { 0x0000, 0x02af, "*" },
  { 0x02b0, 0x02ff, "" },
  { 0x0380, 0x058f, "*" },
  { 0x0591, 0x05f4, "*" }, /* Hebrew */
  { 0x060c, 0x06f9, "" }, /* Arabic */
  { 0x0e01, 0x0e5b, "" },  /* Thai */
  { 0x1e00, 0x1fff, "*" },
  { 0x2000, 0x9fff, "*" },
  { 0xac00, 0xd7a3, "kr" },
  { 0xf900, 0xfa0b, "kr" },
  { 0xff00, 0xffe3, "*" }
};

static const guint32 char_mask_map[] = {
  0,
  ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_5|ENC_ISO_8859_6|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_TIS_620,
  ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_5|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_TIS_620,
  ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_5|ENC_ISO_8859_6|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9,
  ENC_ISO_8859_1|ENC_ISO_8859_9|ENC_KSC_5601,
  ENC_ISO_8859_1|ENC_ISO_8859_8|ENC_ISO_8859_9,
  ENC_ISO_8859_1|ENC_ISO_8859_3|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9,
  ENC_GB_2312|ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_6|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_KSC_5601,
  ENC_ISO_8859_1|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9,
  ENC_GB_2312|ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_5|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_KSC_5601,
  ENC_GB_2312|ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_KSC_5601,
  ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_5|ENC_ISO_8859_6|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_KSC_5601,
  ENC_ISO_8859_1|ENC_ISO_8859_4|ENC_ISO_8859_9,
  ENC_GB_2312|ENC_ISO_8859_1|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_KSC_5601,
  ENC_ISO_8859_1|ENC_ISO_8859_3|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_KSC_5601,
  ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_KSC_5601,
  ENC_ISO_8859_1|ENC_ISO_8859_3|ENC_ISO_8859_8|ENC_ISO_8859_9,
  ENC_ISO_8859_1|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_KSC_5601,
  ENC_ISO_8859_1|ENC_ISO_8859_3|ENC_ISO_8859_9,
  ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_9,
  ENC_ISO_8859_1|ENC_ISO_8859_4|ENC_ISO_8859_9|ENC_KSC_5601,
  ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_9,
  ENC_ISO_8859_1|ENC_KSC_5601,
  ENC_GB_2312|ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_KSC_5601,
  ENC_ISO_8859_1|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_9,
  ENC_ISO_8859_1|ENC_ISO_8859_2,
  ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_9|ENC_KSC_5601,
  ENC_GB_2312|ENC_ISO_8859_1|ENC_ISO_8859_3|ENC_ISO_8859_9,
  ENC_GB_2312|ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_9,
  ENC_GB_2312|ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_9,
  ENC_ISO_8859_1|ENC_ISO_8859_9,
  ENC_ISO_8859_4,
  ENC_GB_2312|ENC_ISO_8859_4,
  ENC_ISO_8859_2,
  ENC_ISO_8859_2|ENC_ISO_8859_4,
  ENC_ISO_8859_3,
  ENC_ISO_8859_2|ENC_ISO_8859_4|ENC_KSC_5601,
  ENC_GB_2312|ENC_ISO_8859_2,
  ENC_ISO_8859_3|ENC_ISO_8859_9,
  ENC_ISO_8859_3|ENC_KSC_5601,
  ENC_ISO_8859_3|ENC_ISO_8859_9|ENC_KSC_5601,
  ENC_KSC_5601,
  ENC_ISO_8859_4|ENC_KSC_5601,
  ENC_ISO_8859_2|ENC_KSC_5601,
  ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_9,
  ENC_ISO_8859_2|ENC_ISO_8859_3,
  ENC_GB_2312,
  ENC_ISO_8859_7,
  ENC_GB_2312|ENC_ISO_8859_2|ENC_ISO_8859_4|ENC_KSC_5601,
  ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_KSC_5601,
  ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_KSC_5601,
  ENC_GB_2312|ENC_ISO_8859_7|ENC_KSC_5601,
  ENC_GB_2312|ENC_ISO_8859_5|ENC_KSC_5601,
  ENC_ISO_8859_5,
  ENC_ISO_8859_8,
  ENC_ISO_8859_6,
  ENC_TIS_620,
  ENC_GB_2312|ENC_KSC_5601,
  ENC_JIS_0208|ENC_KSC_5601,
  ENC_JIS_0208,
  ENC_GB_2312|ENC_JIS_0208|ENC_KSC_5601,
  ENC_GB_2312|ENC_JIS_0208,
  ENC_GB_2312|ENC_GB_2312|ENC_JIS_0208|ENC_KSC_5601,
};

static const guchar char_masks[] = {
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  3,  4,  5,  6,  7,  5,  8,  9, 10,  8,  4,  8,  8, 11,  5, 12,
 10, 13, 14, 14, 15, 16, 17, 14, 15, 17,  4,  8, 17, 14, 17,  4,
 18, 19, 19, 12, 19, 12, 20, 21, 18, 19, 18, 19, 18, 19, 19, 18,
 22, 18, 18, 21, 19, 12, 19, 23, 20, 18, 19, 24, 19, 25, 22, 26,
 27, 28, 19, 12, 19, 12, 20, 21, 27, 28, 27, 19, 27, 28, 19, 18,
 22, 18, 27, 29, 19, 12, 19, 23, 20, 27, 28, 24, 28, 25, 22, 30,
 31, 32, 33, 33, 34, 34, 33, 33, 35, 35, 35, 35, 34, 34, 33, 33,
 34, 36, 31, 32,  0,  0, 31, 31, 34, 34, 33, 37, 35, 35, 38, 38,
 35, 35, 31, 31, 35, 35, 39, 39, 31, 31, 31, 32,  0,  0, 31, 31,
 38, 40, 41, 41, 35, 35, 31, 31, 42, 33, 33, 31, 31, 33, 33, 41,
 41, 43, 43, 33, 33, 31, 31, 33, 33, 41, 42, 42, 31, 32,  0,  0,
 33, 33, 41, 41, 33, 33, 31, 31, 33, 33, 33, 33, 35, 35, 44, 44,
 34, 34, 33, 33, 33, 33, 42, 42, 31, 31, 31, 32, 35, 35, 33, 33,
 33, 33, 31, 31,  0,  0,  0,  0,  0, 33, 33, 45, 45, 34, 34,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 46,  0,
 46,  0, 46,  0, 46,  0, 46,  0, 46,  0, 46,  0, 46,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 47, 47,  0,  0,
  0,  0,  0,  0,  0,  0,  0, 48,  0, 46,  0,  0,  0,  0,  0,  0,
 41,  0,  0,  0,  0,  0,  0,  0, 49, 50, 41, 36,  0, 43,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 47, 47, 47,  0, 47, 47, 47,  0, 47,  0, 47, 47,
 47, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51,
 51, 51,  0, 51, 51, 51, 51, 51, 51, 51, 47, 47, 47, 47, 47, 47,
 47, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51,
 51, 51, 47, 51, 51, 51, 51, 51, 51, 51, 47, 47, 47, 47, 47,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 52, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53,  0, 53, 53,
 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52,
 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52,
 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52,
 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52,
  0, 52, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53,  0, 53, 53,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54,
 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 55,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 55,  0,  0,  0, 55,
  0, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55,
 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55,  0,  0,  0,  0,  0,
 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55,
 55, 55, 55,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 55, 55, 55, 55, 55, 55, 55, 55, 55, 55,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56,
 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56,
 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56,
 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56,  0,  0,  0,  0, 56,
 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56,
 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 51,  0, 54, 57, 57,  0,  0, 57, 57,  0,  0,
 41, 41,  0,  0,  0, 41, 57,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 57,  0, 57, 57,  0,  0,  0,  0,  0,  0,  0, 57,  0,  0, 54,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 41,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 41,
  0, 41, 41, 41, 41,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0, 57,  0,  0,  0,  0,  0, 41,  0,  0,  0,  0,  0,  0,
  0,  0,  0, 41,  0,  0, 52,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 58, 58, 59, 59, 59, 58, 59, 59, 59, 59, 58, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 58, 58, 59, 59, 59, 59, 59, 59, 58, 58, 58, 58, 59,
 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 61, 61, 59, 59, 59, 59,
 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 59, 59, 59, 59, 59,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 57, 57, 57, 57, 41, 41, 41, 41, 41, 41,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 41,  0, 41,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 41,  0, 41, 41,  0,  0,  0, 41, 57,  0,  0, 41,  0,  0,  0, 57,
  0, 57,  0,  0,  0,  0,  0,  0,  0,  0, 57,  0,  0, 57, 57,  0,
 57, 59, 59, 59, 59, 62, 59, 60, 60, 60, 60, 60, 58, 59, 60,  0,
  0,  0,  0,  0, 57, 57, 46, 46,  0,  0, 59, 59, 58, 60, 59, 59,
 59, 59,  0,  0,  0,  0,  0,  0, 46,  0, 59, 59, 61, 59, 59, 59,
 59,  0, 41,  0,  0,  0,  0,  0,  0,  0,  0,  0, 59, 59, 59, 59,
 60, 60, 59, 59, 60, 60, 59, 59, 59, 59, 58, 41,  0,  0, 46, 46,
  0,  0, 59, 59, 59, 59, 59, 59, 59, 59,  0,  0,  0,  0, 59,  0,
  0,  0, 41, 41,  0,  0, 41, 41,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0, 57,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 57,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 57,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,  0,  0,  0,  0,  0,  0,
  0, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,  0,  0,  0,  0,  0,
  0, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 58, 58, 58, 58, 58, 59,
 59, 59, 59, 59, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
 57, 57, 57, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46,
 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 57, 57, 57, 57, 46, 46, 46, 46, 46, 46, 46, 46, 57, 57, 57, 57,
 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
 57, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60,
 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60,
 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 41,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 57, 57,  0, 41, 41, 41, 41, 41, 41, 41,  0,  0,  0,  0,  0,  0,
  0,  0, 57, 57,  0,  0, 41, 41,  0,  0,  0,  0, 41, 41,  0,  0,
 41, 41,  0,  0,  0,  0, 57, 57, 41,  0,  0, 57,  0,  0, 57, 57,
 41, 41,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 57, 57,  0,  0,  0,  0,  0,  0,  0, 41, 41,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 41,  0, 41,  0,
  0, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59,  0,  0,  0,  0,  0,  0,  0,
 57, 59, 60, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59,  0,  0,  0,  0,  0,  0,  0,
 41, 41,  0, 41, 41, 41,  0, 41, 41, 41, 41,  0, 41, 41,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 57, 57, 57, 57,  0, 46,  0,  0, 57, 57, 57, 57, 57, 57, 57, 57,
 57, 57,  0, 57, 57, 57, 46, 46,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60,
 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60,
 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60,
 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 57,
 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
 57, 57, 57, 57,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
 57, 57, 57, 57, 57, 57, 57,  0,  0,  0,  0, 46,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46,
 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46,
 46, 61, 61, 61, 61, 61, 61, 61, 61, 61, 59, 59, 59, 59, 59, 59,
 59, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,  0,  0,  0,
 46, 61, 61, 61, 61, 61, 61, 61, 61, 61, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 59, 59, 59, 41,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,  0,
 41, 41, 41, 41, 41,  0,  0,  0, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,  0,  0,  0,  0, 41,
 41,  0,  0, 41,  0,  0, 41,  0, 41,  0,  0, 41, 41, 41,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 57, 57,  0, 57,  0,  0,  0, 57, 57, 57, 57, 57, 46, 57, 46,  0,
 46, 57,  0, 46, 57, 57, 57,  0, 57, 57, 46, 46, 46, 46, 57,  0,
  0, 59, 61, 59, 61, 61, 59, 61, 61, 59, 61, 61, 61, 60, 59, 59,
 61, 59, 60, 59, 61, 59, 61, 59, 60, 60, 61, 60, 59, 61, 61, 61,
 59, 59, 58, 60, 59, 60, 59, 61, 61, 61, 59, 60, 61, 60, 60, 60,
 61, 59, 61, 61, 61, 59, 60, 59, 60, 60, 59, 59, 61, 60, 60, 60,
 61, 61, 59, 59, 59, 59, 61, 59, 59, 61, 59, 58, 59, 58, 59, 59,
 61, 61, 59, 60, 59, 59, 58, 58, 59, 59, 59, 59, 59, 59, 60,  0,
  0,  0, 41,  0,  0,  0, 57,  0, 57, 46,  0, 57, 57, 46, 57, 46,
 41, 57, 57, 46, 57, 57,  0,  0, 57,  0, 46, 57,  0,  0, 41, 46,
 46, 57, 57,  0, 57, 57, 57, 46, 57, 46,  0, 57, 57, 57, 57,  0,
  0,  0, 46, 46,  0, 46, 41,  0,  0,  0, 57, 46,  0,  0,  0, 46,
 57, 57, 46, 46, 57, 46, 46, 57,  0, 46, 57, 57,  0, 57, 46,  0,
  0, 46,  0, 46, 57, 57, 57, 57, 57, 57,  0,  0,  0, 57, 46, 57,
  0, 46,  0, 57, 57, 57,  0,  0, 46,  0, 46, 46, 46,  0,  0,  0,
 57,  0, 57, 46,  0, 46, 57, 57,  0,  0,  0, 57,  0, 46,  0, 46,
  0, 57,  0,  0,  0,  0,  0,  0,  0, 57, 57, 41,  0, 57, 57, 57,
 57, 57,  0,  0,  0,  0,  0, 46, 46, 46, 46, 46,  0,  0, 46, 46,
 46, 59, 61, 59, 61, 61, 61, 61, 59, 59, 61, 61, 59, 59, 59, 60,
 61, 59, 61, 59, 60, 59, 60, 59, 60, 59, 60, 59, 60, 60, 59, 59,
 59, 59, 59, 60, 59, 59, 60, 58, 58, 59, 59, 59, 59, 60, 60, 60,
 60, 60, 59, 61,  0, 57,  0, 46, 46, 57, 57, 57, 57, 46, 46, 46,
 46,  0,  0, 46, 46, 46,  0, 46,  0, 57,  0,  0, 46,  0,  0, 57,
 57,  0,  0, 57, 46,  0, 57,  0,  0,  0, 41, 46, 46,  0, 57, 57,
  0, 41,  0, 57, 57,  0, 41,  0, 57, 46, 41, 57,  0, 57,  0, 57,
  0, 57,  0,  0, 46,  0, 41, 46, 41,  0,  0, 57,  0, 57,  0,  0,
 46,  0,  0, 46,  0, 46, 46, 46, 46, 46, 46,  0, 46,  0, 57, 57,
  0,  0,  0,  0,  0, 57, 41,  0,  0,  0,  0,  0,  0,  0,  0, 57,
  0,  0, 41, 57, 57, 46,  0,  0,  0, 41, 57,  0,  0,  0, 57, 46,
 46, 57,  0, 41, 41,  0,  0, 57, 46,  0, 57,  0, 46, 57, 46, 57,
 41, 57,  0, 46,  0,  0, 46,  0, 46, 46, 46,  0,  0, 46, 57, 57,
  0, 57,  0, 57,  0, 41,  0,  0, 57,  0, 57,  0,  0,  0, 46,  0,
  0,  0, 41,  0,  0,  0, 41,  0,  0, 41,  0, 41, 46, 57,  0, 46,
  0, 41, 57,  0, 46,  0, 41,  0, 46, 57, 57,  0, 57,  0, 41, 57,
  0, 60, 59, 58, 58, 61, 60, 58, 60, 61, 60, 58, 60, 60, 61, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 61, 58, 61, 59, 61, 59,
 59, 59, 59, 60, 59, 59, 59, 60, 60, 58, 59, 59, 61, 59, 61, 60,
 59, 59, 59, 59, 59, 60, 59, 59, 59, 59, 60, 59, 60, 59, 59, 59,
 59, 59, 59, 59, 59, 60, 59, 59, 59, 59, 59, 59, 61, 59, 59, 59,
 59, 59, 59, 59, 58, 58, 60, 61, 58, 59, 59, 61, 59, 59, 61, 46,
 57,  0,  0,  0,  0, 57,  0,  0, 46,  0,  0,  0,  0, 57,  0,  0,
  0, 41,  0,  0,  0,  0,  0,  0, 41, 41,  0,  0,  0,  0,  0,  0,
  0,  0,  0, 46,  0, 46,  0, 46, 46, 46,  0,  0, 57, 41,  0,  0,
  0,  0, 57, 41,  0, 41,  0, 41,  0,  0, 46, 46,  0,  0, 41,  0,
  0,  0,  0,  0,  0, 41,  0,  0,  0, 41, 41,  0,  0,  0,  0, 57,
  0, 41,  0,  0,  0, 41, 57,  0,  0,  0, 57,  0,  0,  0, 41,  0,
  0,  0,  0,  0,  0, 41, 46, 57,  0,  0,  0,  0, 46, 57, 46,  0,
  0,  0,  0, 46,  0, 46,  0,  0,  0, 41,  0, 57,  0,  0,  0, 41,
 41, 41,  0,  0, 41,  0, 57, 46,  0, 41,  0, 46,  0,  0,  0,  0,
  0,  0, 57,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 41,
  0, 60, 59, 59, 59, 59, 59, 59, 59, 59, 58, 59, 59, 59, 59, 59,
 59, 59, 58, 59, 59, 59, 59, 58, 59, 59, 58, 59, 58, 59, 59, 61,
 60, 60, 59, 60, 60, 60, 60, 58, 60, 60, 59, 60, 58, 60, 58, 59,
 59, 61, 58, 59, 61, 61, 61, 59, 59, 59, 61, 59, 60, 59, 59, 59,
 59, 59, 60, 59, 59, 60, 59, 58, 60, 58, 58, 60, 60, 60, 60, 59,
 61, 60, 59, 61, 61, 60, 60, 60, 60, 61, 59, 61, 60, 61, 59,  0,
 57, 46, 46,  0,  0, 46, 41,  0, 46, 46, 41,  0, 46, 57,  0,  0,
  0,  0, 57,  0,  0, 57, 46, 57,  0, 46,  0, 46, 46,  0,  0,  0,
 57,  0, 46,  0, 46, 57,  0,  0,  0,  0, 41, 46, 57,  0,  0, 46,
 46, 46, 46, 46,  0, 46, 57, 57,  0,  0,  0, 46, 46, 57,  0,  0,
 46,  0,  0,  0, 57,  0, 57, 46,  0, 57,  0, 57, 57, 41,  0, 46,
  0, 46,  0,  0,  0,  0,  0,  0,  0,  0,  0, 46, 41, 57, 41,  0,
 46, 57,  0,  0, 46,  0,  0,  0,  0,  0,  0, 46,  0, 46,  0, 46,
 57, 41,  0, 46,  0, 46, 57,  0, 57, 57, 57, 46, 46, 57,  0, 46,
 57, 46, 46, 57,  0,  0, 57, 57, 57,  0, 57,  0,  0, 46, 57,  0,
  0, 57, 46,  0,  0,  0, 46, 57, 46, 46, 46, 46,  0, 57,  0,  0,
 46, 59, 59, 59, 60, 58, 59, 59, 61, 60, 58, 61, 59, 61, 60, 59,
 60, 59, 59, 61, 59, 59, 60, 60, 60, 60, 60, 60, 59, 61, 59, 61,
 61, 61, 61, 60, 59, 59, 59, 58, 59, 59, 60, 58, 60, 60, 59, 59,
 61, 61, 59, 59, 60, 59, 60, 59, 59, 59, 59, 58, 61, 58, 61, 59,
 59, 60, 59, 59, 59, 61, 59, 61, 59, 60, 60, 59, 59, 59, 59, 60,
 59, 59, 60, 59, 59, 58, 59, 59, 59, 59, 59, 59, 59, 60, 59, 57,
  0, 46, 46, 41,  0,  0,  0, 41, 57, 41,  0,  0,  0, 41,  0,  0,
 46, 41, 41, 46,  0,  0,  0,  0,  0,  0,  0, 57,  0, 46, 46, 57,
 57, 46, 46, 57, 41,  0,  0,  0, 46, 57, 57, 57, 46, 46,  0,  0,
  0, 46, 46, 46,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 57, 46,
  0, 41,  0, 57,  0, 41,  0, 57,  0, 57,  0, 46,  0, 41,  0,  0,
 46,  0, 57,  0,  0, 41, 57,  0, 57, 41,  0, 41,  0, 41, 41, 57,
  0,  0, 41, 41, 57,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 46,  0,  0, 41,  0, 41,  0,  0, 41, 46, 57, 41,  0,  0, 57, 57,
 46,  0,  0,  0,  0, 57, 46,  0, 57,  0,  0,  0,  0, 57,  0, 57,
 57,  0,  0,  0,  0, 57, 57, 57,  0, 57, 46,  0,  0, 46,  0,  0,
 57, 60, 59, 60, 59, 59, 61, 59, 59, 59, 60, 59, 59, 59, 61, 58,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 60, 61, 61, 59, 59, 61, 60,
 58, 60, 59, 60, 58, 61, 59, 60, 60, 60, 60, 59, 59, 58, 61, 61,
 59, 60, 60, 60, 58, 61, 61, 60, 59, 59, 60, 59, 60, 59, 60, 61,
 60, 61, 61, 61, 61, 59, 60, 61, 58, 61, 59, 61, 59, 59, 61, 60,
 60, 60, 59, 61, 60, 60, 59, 60, 61, 59, 61, 59, 59, 58, 59, 57,
  0,  0, 46,  0, 57, 46, 46,  0,  0, 46,  0, 46, 46, 46,  0,  0,
  0,  0,  0, 41,  0, 46,  0,  0, 57,  0, 57,  0,  0, 46,  0, 57,
 41,  0, 46, 46,  0, 57, 57,  0, 46, 46,  0,  0,  0, 41, 46,  0,
  0,  0,  0,  0,  0,  0, 46,  0,  0,  0,  0, 57,  0,  0,  0, 46,
  0, 46, 46, 41,  0,  0,  0,  0, 57, 57, 57, 57, 46, 57,  0,  0,
  0, 46,  0,  0, 57,  0, 57, 57, 46, 46,  0, 57,  0,  0,  0, 46,
 46, 41, 41, 57, 57, 57, 46,  0, 46, 57, 57, 57, 57, 57, 46, 57,
 57, 57, 57, 57,  0, 46, 46, 46, 57, 46,  0, 46, 46, 46,  0,  0,
  0, 46,  0, 57, 57,  0, 46,  0, 57, 57, 57,  0, 57, 57, 57, 57,
 57, 57, 46, 46,  0, 46, 46, 46,  0,  0,  0, 57,  0, 57, 46, 57,
 57, 61, 59, 61, 59, 59, 60, 61, 61, 60, 59, 60, 61, 61, 61, 61,
 59, 61, 61, 58, 61, 61, 59, 59, 60, 60, 59, 60, 60, 59, 60, 59,
 61, 59, 58, 61, 59, 59, 61, 59, 60, 59, 60, 61, 59, 59, 59, 59,
 61, 58, 61, 61, 61, 61, 61, 61, 61, 61, 59, 61, 61, 59, 59, 59,
 59, 59, 61, 59, 61, 59, 61, 59, 60, 59, 58, 59, 59, 59, 59, 59,
 59, 60, 61, 60, 59, 60, 61, 61, 61, 59, 59, 60, 60, 60, 59,  0,
 57,  0, 46,  0, 46,  0, 57,  0,  0,  0,  0, 46, 57,  0, 57, 46,
 57,  0, 46,  0, 46, 46, 46,  0,  0, 46, 46, 46,  0, 46,  0,  0,
  0,  0,  0, 46, 57,  0, 46, 46, 57, 46, 46, 57, 57, 46,  0, 46,
  0, 46,  0, 57, 46,  0,  0,  0, 57,  0,  0, 46,  0, 57,  0, 46,
 57, 57, 46,  0, 57,  0, 46, 46, 57, 57,  0,  0, 46, 46, 46, 46,
 46, 46, 46, 46, 46, 46,  0, 46,  0, 46, 46,  0, 46, 46, 46, 46,
  0, 41,  0,  0,  0, 57, 46, 46, 57, 46, 46,  0,  0, 57, 57,  0,
  0,  0, 57, 46,  0,  0,  0,  0,  0,  0, 57,  0, 46, 46,  0, 46,
  0, 46,  0,  0, 41,  0, 57, 57,  0, 46,  0,  0,  0,  0, 41, 46,
 57, 46,  0,  0, 46,  0,  0,  0,  0,  0,  0, 46, 41,  0,  0,  0,
 46, 59, 61, 61, 61, 59, 59, 61, 59, 59, 61, 59, 61, 59, 61, 60,
 61, 60, 59, 61, 59, 58, 59, 61, 59, 59, 59, 59, 61, 59, 60, 61,
 59, 61, 59, 61, 60, 59, 60, 59, 59, 61, 61, 59, 59, 59, 59, 58,
 61, 59, 59, 58, 59, 61, 60, 59, 59, 59, 59, 59, 61, 59, 58, 59,
 59, 61, 59, 58, 61, 61, 61, 61, 59, 59, 61, 59, 61, 61, 61, 59,
 59, 59, 59, 59, 59, 61, 61, 61, 61, 59, 59, 61, 60, 59, 61,  0,
 57, 46, 46, 46, 57,  0, 41, 57, 46, 57, 57, 46,  0,  0,  0, 46,
  0, 46,  0,  0, 46,  0,  0,  0, 57, 57, 41,  0, 57, 57,  0, 46,
  0,  0,  0,  0,  0,  0,  0, 57,  0, 41, 41, 41, 41,  0, 41,  0,
  0, 46,  0, 46,  0, 46,  0, 46,  0, 46,  0, 46,  0, 46, 46,  0,
  0,  0,  0,  0, 46, 57,  0, 41,  0, 46,  0,  0, 46, 46,  0,  0,
  0, 46, 46, 46, 57,  0, 46,  0,  0,  0, 41,  0, 57, 46,  0, 57,
  0, 46,  0, 57, 57, 46, 46,  0, 46,  0, 46, 46, 46,  0,  0, 46,
  0,  0, 46, 46,  0, 46,  0, 46,  0,  0,  0,  0,  0, 57, 57,  0,
 46, 46,  0,  0,  0,  0, 41,  0, 46, 57,  0,  0, 46,  0, 46, 46,
  0,  0,  0,  0, 41,  0,  0, 41, 46,  0,  0, 46,  0,  0, 46, 46,
  0, 59, 59, 61, 61, 59, 59, 61, 59, 59, 59, 59, 61, 61, 59, 58,
 59, 61, 60, 59, 60, 59, 60, 59, 59, 61, 59, 61, 59, 59, 59, 61,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 61, 61, 61, 59,
 59, 59, 59, 58, 61, 59, 59, 61, 61, 61, 59, 59, 61, 59, 59, 59,
 59, 59, 61, 59, 61, 59, 59, 59, 60, 61, 61, 60, 61, 59, 59, 59,
 59, 61, 59, 59, 58, 59, 61, 59, 59, 59, 59, 61, 61, 59, 59,  0,
  0,  0,  0,  0,  0, 46, 57,  0,  0,  0,  0,  0,  0,  0, 46, 46,
  0,  0,  0, 46,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0, 46,  0, 41,  0,  0,  0,  0,  0,  0, 41,  0, 41, 46,
  0,  0,  0,  0, 41,  0,  0, 46,  0,  0,  0,  0, 57,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 57,  0,  0, 41,  0,  0,
  0, 41,  0,  0, 46,  0,  0, 46,  0,  0, 57, 57,  0, 46, 57, 46,
 57, 46, 46,  0, 46,  0,  0,  0,  0,  0,  0, 46,  0, 46,  0,  0,
 57, 46,  0,  0, 46, 46,  0,  0,  0, 57, 57,  0,  0, 46, 46, 46,
  0,  0,  0, 57, 57,  0, 46,  0, 57, 46, 46, 41,  0, 41,  0,  0,
  0,  0, 41, 41,  0,  0, 41,  0, 41,  0,  0,  0, 46,  0,  0, 57,
  0, 59, 59, 61, 59, 59, 59, 59, 60, 61, 61, 59, 61, 60, 61, 61,
 60, 59, 59, 61, 59, 59, 59, 59, 59, 61, 61, 60, 59, 59, 61, 59,
 60, 59, 60, 59, 59, 59, 59, 60, 59, 59, 60, 59, 61, 60, 60, 61,
 60, 60, 59, 59, 59, 59, 59, 61, 59, 59, 61, 61, 61, 61, 61, 61,
 61, 60, 59, 59, 60, 59, 60, 59, 61, 61, 60, 61, 59, 61, 58, 61,
 58, 59, 59, 61, 59, 58, 61, 61, 59, 59, 59, 61, 60, 59, 59,  0,
  0,  0, 57, 46, 46, 46, 46,  0, 41,  0,  0, 57, 46,  0,  0,  0,
  0,  0, 46, 57,  0,  0,  0,  0,  0,  0,  0, 46,  0,  0,  0,  0,
 57, 46, 57, 57, 46,  0, 46, 46,  0, 46,  0, 46,  0, 46, 46,  0,
  0,  0, 46,  0, 46,  0,  0,  0, 46,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 46, 57,  0,  0,  0, 41, 41,  0,  0, 57,  0,  0, 57, 46,
  0,  0, 46,  0, 46, 46,  0,  0, 46, 46, 46,  0,  0, 46,  0, 57,
 57,  0,  0,  0, 46,  0,  0,  0,  0,  0,  0,  0,  0, 46,  0, 46,
 41,  0,  0,  0, 57,  0,  0, 41, 46, 57, 57,  0, 41, 46,  0,  0,
 57,  0, 57,  0,  0, 41, 57, 46, 41, 41, 41, 46,  0, 46,  0,  0,
  0, 46,  0,  0,  0, 46,  0,  0,  0, 46,  0,  0,  0,  0, 57,  0,
 46, 60, 59, 59, 60, 59, 59, 58, 59, 59, 60, 59, 59, 59, 59, 58,
 60, 58, 59, 59, 58, 60, 59, 59, 59, 59, 58, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 61, 59, 59, 59, 59, 59, 58, 58, 61, 61, 59, 58,
 59, 60, 59, 59, 60, 59, 59, 58, 60, 59, 58, 59, 59, 59, 60, 59,
 59, 58, 58, 59, 58, 61, 59, 59, 59, 59, 59, 61, 61, 59, 59, 59,
 59, 59, 59, 59, 59, 58, 59, 59, 59, 58, 59, 59, 58, 59, 60,  0,
 46, 46,  0, 57,  0, 57,  0,  0,  0, 57,  0,  0,  0,  0,  0,  0,
  0,  0, 46, 57,  0,  0,  0,  0,  0, 46, 46,  0, 41,  0, 57, 57,
  0,  0,  0,  0,  0,  0,  0,  0, 57, 57,  0,  0,  0,  0, 41,  0,
  0,  0,  0, 41,  0,  0,  0,  0,  0,  0, 41, 41, 46,  0, 41,  0,
  0, 57,  0,  0,  0, 57,  0, 41,  0,  0,  0,  0,  0,  0, 41,  0,
  0, 57,  0, 41,  0, 57,  0,  0, 41, 41,  0,  0,  0,  0, 41, 41,
  0,  0,  0,  0, 57,  0,  0,  0,  0,  0,  0, 57, 57,  0, 46, 41,
 46,  0,  0, 46,  0,  0, 46,  0,  0, 57, 41, 41,  0, 41,  0,  0,
  0,  0, 46,  0, 46,  0,  0, 46,  0,  0,  0,  0,  0, 46,  0, 57,
  0,  0,  0,  0, 57, 57, 57,  0,  0, 57, 57,  0, 57,  0,  0, 46,
  0, 59, 58, 59, 61, 61, 59, 60, 59, 60, 60, 60, 59, 60, 60, 61,
 59, 60, 59, 59, 61, 59, 59, 60, 61, 61, 61, 59, 61, 59, 58, 59,
 59, 61, 61, 59, 60, 59, 59, 60, 60, 60, 59, 61, 59, 59, 60, 60,
 58, 60, 59, 59, 60, 60, 61, 60, 61, 59, 60, 59, 59, 59, 59, 59,
 60, 59, 60, 59, 59, 61, 59, 58, 59, 59, 58, 58, 58, 58, 58, 59,
 59, 59, 59, 60, 60, 59, 61, 59, 60, 61, 59, 59, 59, 60, 59,  0,
  0, 46, 57, 57, 57,  0, 46, 46, 46,  0, 57,  0,  0, 46,  0,  0,
  0,  0, 46, 57,  0,  0, 57, 57,  0, 57,  0,  0,  0,  0, 46,  0,
  0,  0,  0, 46, 46, 57,  0,  0, 57, 46, 46, 46, 41,  0, 46, 46,
  0,  0, 46,  0,  0,  0,  0,  0,  0, 57,  0, 57,  0,  0, 57,  0,
  0,  0,  0, 41,  0,  0, 57,  0,  0, 41, 46, 57,  0,  0,  0,  0,
 57, 57, 46, 57, 57,  0,  0, 46, 46, 41, 57,  0, 57, 57,  0,  0,
  0,  0,  0, 46,  0, 46, 41,  0, 57,  0, 41,  0, 57,  0, 41,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 41, 46,  0, 57,  0,  0,  0, 57,
  0, 57,  0, 57, 46, 46, 46, 46, 46, 46,  0,  0, 46,  0,  0,  0,
  0, 57,  0, 46,  0,  0,  0,  0, 57,  0,  0, 41, 57,  0,  0, 57,
 57, 59, 59, 61, 59, 60, 59, 59, 59, 60, 59, 59, 59, 59, 59, 59,
 59, 61, 61, 59, 61, 59, 60, 59, 59, 59, 59, 59, 60, 59, 59, 59,
 61, 58, 59, 59, 59, 59, 60, 59, 59, 60, 61, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 61, 59, 59, 59, 59, 60, 59, 59, 59, 59, 59,
 59, 59, 60, 59, 59, 59, 58, 61, 59, 59, 61, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 61, 61, 61, 61, 59, 59, 61, 59, 59, 59, 59, 46,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 57,  0,  0,  0,  0,  0,  0,  0, 57, 57,  0,  0,  0,  0,
  0,  0,  0,  0, 41,  0,  0,  0,  0,  0, 46,  0,  0,  0,  0,  0,
  0,  0, 46, 46,  0, 46,  0,  0, 46,  0,  0,  0,  0,  0, 46,  0,
  0, 57, 57,  0, 41,  0,  0,  0,  0, 57,  0,  0, 57,  0,  0,  0,
  0,  0, 46,  0, 46,  0, 46,  0, 46,  0,  0,  0, 46,  0,  0,  0,
 46, 57,  0, 46,  0,  0, 57,  0,  0, 57,  0, 46,  0,  0,  0,  0,
  0, 46,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 41,  0,  0,  0, 57,  0, 41, 41,  0,  0,  0,
  0,  0,  0,  0,  0,  0, 57, 46,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 59, 59, 59, 59, 59, 59, 59, 59, 59, 58, 59, 59, 59, 59, 59,
 59, 59, 61, 59, 61, 59, 59, 61, 59, 59, 59, 59, 59, 59, 59, 59,
 60, 59, 59, 58, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 60, 60, 59, 61, 60, 60, 59, 60, 60, 61, 60, 61, 60, 60, 59, 60,
 59, 59, 61, 60, 60, 61, 61, 59, 59, 60, 61, 58, 61, 59, 59, 59,
 60, 60, 59, 61, 59, 60, 59, 59, 58, 59, 60, 59, 58, 61, 59,  0,
 46, 46,  0, 46, 46, 57,  0, 57, 57, 57,  0, 57, 57,  0,  0, 57,
  0,  0,  0, 57,  0, 57, 41, 57, 57, 57, 57, 57, 57, 46, 46,  0,
 46, 46, 57, 57, 57, 57, 57,  0,  0,  0, 46, 46, 41,  0, 41,  0,
 57,  0,  0, 57, 57, 57, 57,  0, 57, 57,  0,  0,  0, 46, 46, 57,
 41,  0, 57, 41, 57, 57, 57, 57,  0,  0,  0,  0, 57,  0,  0,  0,
 57,  0, 57, 57, 41,  0,  0, 41,  0,  0,  0,  0,  0, 46, 57, 57,
  0, 57, 41,  0, 57, 57, 41, 41, 57, 41,  0, 41, 41,  0, 57, 41,
 46,  0,  0,  0,  0, 41, 41,  0, 57, 46, 57, 46, 46,  0,  0, 46,
  0, 57,  0,  0, 57,  0, 46, 41, 41, 57, 57, 41,  0, 41, 41, 57,
  0, 57,  0,  0, 46, 46, 57,  0, 46, 41, 46,  0, 46, 46,  0,  0,
  0, 59, 61, 59, 60, 61, 59, 61, 58, 59, 59, 59, 61, 59, 59, 59,
 59, 60, 59, 59, 61, 59, 59, 59, 60, 60, 60, 60, 60, 61, 60, 60,
 60, 61, 61, 59, 59, 60, 58, 59, 60, 61, 61, 60, 59, 58, 60, 61,
 61, 60, 59, 59, 59, 60, 59, 59, 59, 61, 59, 58, 59, 59, 61, 59,
 60, 61, 58, 61, 58, 60, 61, 59, 59, 59, 59, 59, 58, 59, 61, 60,
 59, 60, 59, 59, 59, 59, 59, 59, 59, 60, 61, 59, 59, 59, 59, 46,
  0, 46, 46,  0,  0,  0,  0,  0, 46,  0,  0,  0, 46, 46,  0,  0,
 57, 57,  0,  0, 46,  0, 46, 46, 46, 46, 46, 46, 46,  0,  0,  0,
  0, 41, 46, 46,  0,  0,  0,  0,  0, 57,  0, 57, 57, 46,  0,  0,
  0, 57,  0, 57,  0, 57,  0, 57, 57,  0, 41,  0,  0, 46, 41, 46,
 41, 46,  0,  0, 46,  0,  0,  0,  0,  0,  0, 46,  0,  0,  0,  0,
  0,  0, 46,  0,  0,  0,  0,  0,  0, 57,  0,  0,  0,  0,  0,  0,
 41, 46,  0,  0, 46, 46, 46,  0, 57,  0, 46,  0,  0, 46,  0, 41,
 57,  0,  0,  0, 41,  0, 41,  0,  0,  0,  0, 57,  0, 41,  0,  0,
  0,  0, 46, 46,  0,  0, 46, 57,  0,  0,  0,  0,  0, 41, 57,  0,
  0, 41,  0,  0, 57,  0, 57, 41,  0, 41,  0, 46,  0,  0, 46,  0,
  0, 59, 59, 59, 61, 59, 61, 60, 59, 60, 59, 59, 59, 61, 61, 59,
 59, 59, 59, 59, 61, 59, 59, 59, 59, 59, 59, 59, 59, 61, 61, 59,
 59, 59, 59, 59, 59, 59, 59, 61, 59, 59, 61, 60, 60, 59, 59, 59,
 58, 59, 59, 59, 59, 59, 59, 59, 61, 59, 59, 61, 59, 61, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 60, 59, 61, 60, 59, 59, 60,
 59, 59, 59, 59, 61, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,  0,
  0,  0, 46,  0,  0,  0,  0, 41,  0,  0,  0, 41,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0, 46,  0,  0,  0, 57,  0,  0,
 41,  0, 41,  0,  0,  0,  0,  0,  0,  0, 41,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0, 46, 41,  0, 41,  0, 41, 41,  0,  0,
  0,  0,  0,  0,  0, 46,  0,  0,  0,  0,  0,  0,  0, 57,  0,  0,
  0,  0, 41,  0,  0,  0, 41,  0,  0,  0,  0, 46,  0, 57, 57,  0,
  0, 57, 57,  0,  0, 57, 57, 57, 57, 46,  0, 57,  0,  0, 57, 46,
  0, 57, 57, 57, 57,  0,  0, 57,  0,  0,  0,  0,  0, 57, 57,  0,
  0, 46, 57, 57,  0, 46, 57,  0, 46,  0,  0,  0, 57,  0,  0, 46,
 46, 57,  0,  0, 46, 46, 57,  0, 46, 57, 46, 57, 46, 57,  0,  0,
  0, 59, 59, 59, 59, 58, 61, 61, 59, 59, 59, 58, 59, 60, 61, 59,
 59, 61, 59, 58, 59, 59, 58, 61, 60, 59, 59, 61, 61, 60, 59, 58,
 58, 59, 61, 59, 60, 60, 59, 58, 59, 59, 59, 59, 60, 59, 59, 59,
 59, 59, 59, 59, 61, 60, 59, 59, 59, 59, 59, 61, 59, 59, 61, 58,
 59, 60, 60, 58, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 60, 60, 60, 59, 61, 58, 60, 58, 61, 60, 60, 60, 58, 46,
 46,  0,  0,  0, 57,  0, 46, 57,  0,  0, 57, 46,  0,  0,  0, 57,
 46, 46,  0, 46, 46, 57, 46, 57,  0, 46, 57,  0, 57,  0, 46, 46,
 57,  0,  0,  0,  0, 46, 57, 57,  0,  0,  0, 41,  0, 57,  0,  0,
  0,  0,  0, 46,  0, 57, 57, 57, 57, 46,  0,  0,  0,  0, 57,  0,
  0,  0, 41,  0,  0,  0,  0,  0, 41, 57, 57,  0,  0,  0,  0,  0,
 41, 46, 46, 57,  0,  0, 57,  0,  0,  0, 41, 57,  0,  0,  0, 41,
 41,  0, 41, 41,  0,  0,  0,  0, 46,  0, 46,  0, 41,  0,  0,  0,
  0,  0,  0, 41, 46,  0, 57, 57,  0,  0, 57, 41,  0,  0, 46, 46,
 46, 57, 46, 46, 57,  0,  0,  0, 46,  0, 57, 46,  0,  0,  0, 57,
  0, 57,  0, 57, 41, 57,  0, 57, 57,  0,  0, 57,  0,  0,  0, 57,
 46, 59, 59, 59, 59, 61, 60, 60, 59, 60, 61, 59, 59, 61, 59, 61,
 59, 60, 59, 59, 59, 58, 59, 59, 59, 61, 60, 59, 60, 59, 59, 59,
 61, 59, 59, 59, 59, 59, 59, 59, 58, 59, 58, 59, 58, 59, 58, 59,
 61, 59, 61, 61, 59, 61, 60, 60, 61, 58, 59, 58, 59, 61, 59, 59,
 59, 61, 60, 59, 61, 59, 60, 58, 59, 60, 60, 58, 60, 60, 59, 59,
 60, 60, 59, 61, 59, 59, 59, 60, 59, 60, 59, 61, 60, 59, 59, 41,
 57, 57, 46,  0, 46, 57,  0, 57, 46, 46, 57, 57, 57,  0,  0,  0,
 57, 41, 57,  0,  0, 46,  0, 57, 57, 57,  0,  0, 46,  0, 41,  0,
 41, 57,  0,  0,  0,  0,  0,  0, 57, 41, 57,  0,  0, 46, 57,  0,
  0,  0,  0,  0,  0, 57,  0, 57,  0, 41,  0,  0, 46, 57,  0,  0,
  0,  0,  0, 57, 46, 57, 46,  0,  0, 46,  0,  0, 57, 57,  0, 46,
 46, 46, 46,  0,  0,  0, 57, 57, 57, 57,  0,  0,  0, 46,  0,  0,
 57, 46,  0,  0, 46,  0,  0, 46,  0,  0, 46, 57,  0, 46, 46,  0,
  0, 46,  0,  0,  0, 57,  0,  0, 46,  0,  0, 46,  0, 57, 46, 57,
 46, 46, 46, 46, 46, 46, 46,  0,  0,  0, 46,  0,  0, 46, 46, 57,
  0,  0, 57,  0, 46, 46, 57,  0,  0, 46,  0, 46, 57, 57,  0,  0,
 57, 60, 59, 59, 59, 60, 61, 60, 60, 61, 60, 61, 59, 59, 59, 60,
 59, 59, 59, 59, 59, 61, 59, 59, 59, 59, 59, 61, 61, 59, 59, 61,
 59, 60, 60, 60, 59, 59, 59, 59, 59, 59, 59, 61, 59, 60, 59, 59,
 60, 59, 60, 59, 59, 60, 59, 59, 59, 60, 61, 59, 59, 60, 59, 59,
 59, 59, 60, 60, 60, 58, 59, 61, 60, 60, 60, 61, 60, 60, 59, 60,
 60, 59, 59, 61, 59, 59, 61, 59, 61, 61, 61, 61, 61, 61, 59, 46,
  0,  0,  0, 46, 46, 41,  0,  0,  0, 57,  0,  0, 57, 57,  0,  0,
  0,  0, 46,  0, 57,  0, 57,  0,  0,  0, 57, 57,  0, 46,  0, 57,
 57,  0,  0, 57, 41,  0, 46, 41, 46,  0,  0, 46, 46, 46,  0, 46,
 41, 46, 57, 41, 57,  0, 41,  0, 57,  0,  0, 46, 57, 41,  0,  0,
  0,  0,  0,  0,  0, 57, 46, 41,  0,  0, 46, 46,  0,  0,  0,  0,
  0, 57,  0,  0,  0, 46,  0,  0, 46,  0, 57,  0, 57, 46,  0, 57,
 57, 41,  0,  0,  0,  0, 46, 46, 46, 46,  0, 46, 46, 46, 46, 46,
 57, 41,  0, 57, 46,  0, 57,  0,  0, 57, 57, 41,  0,  0,  0,  0,
 46, 57,  0,  0,  0,  0, 57,  0, 57, 57,  0,  0,  0, 57, 57, 57,
  0,  0,  0,  0,  0, 57,  0,  0,  0,  0, 57, 41,  0,  0,  0, 57,
 46, 59, 59, 61, 61, 59, 61, 60, 59, 59, 59, 61, 59, 59, 59, 59,
 58, 59, 59, 59, 58, 59, 59, 58, 59, 59, 59, 59, 58, 59, 58, 60,
 59, 59, 58, 59, 58, 59, 59, 58, 60, 59, 60, 58, 60, 59, 61, 59,
 59, 61, 59, 58, 59, 60, 59, 59, 58, 58, 59, 59, 59, 60, 59, 58,
 59, 59, 60, 58, 58, 59, 59, 60, 60, 59, 59, 58, 59, 59, 58, 59,
 60, 59, 59, 59, 59, 61, 58, 60, 59, 59, 59, 59, 59, 58, 58,  0,
  0, 41, 41,  0,  0,  0,  0,  0,  0,  0, 41, 46,  0,  0, 57,  0,
 41, 41,  0,  0, 57,  0,  0,  0, 41, 41, 41,  0,  0, 46,  0,  0,
  0,  0,  0,  0, 41,  0,  0, 57, 46, 57,  0, 41, 57,  0, 41,  0,
  0,  0, 41,  0,  0,  0, 41, 46,  0,  0, 41,  0,  0,  0, 57,  0,
  0,  0, 46, 41,  0,  0,  0, 41, 57, 41, 57, 57,  0,  0,  0,  0,
  0, 46, 46,  0, 46,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0, 57,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 41,  0,  0, 46, 41, 41, 41,  0, 41,  0, 41,  0,  0, 57,
 41,  0,  0,  0,  0,  0, 46, 41, 57,  0, 57, 46, 57, 57, 57, 46,
 57, 57, 57,  0,  0, 46, 57, 46, 46,  0, 57, 46,  0,  0,  0, 57,
  0, 60, 61, 59, 61, 61, 59, 59, 59, 59, 60, 59, 61, 59, 60, 59,
 58, 58, 59, 61, 60, 59, 58, 61, 59, 59, 59, 59, 59, 61, 60, 60,
 60, 60, 59, 61, 59, 59, 59, 60, 60, 60, 59, 60, 61, 60, 61, 59,
 59, 61, 61, 60, 61, 59, 59, 59, 60, 59, 59, 61, 59, 59, 59, 59,
 59, 59, 59, 61, 59, 59, 61, 61, 59, 61, 61, 61, 61, 61, 60, 61,
 61, 58, 59, 61, 59, 59, 60, 59, 59, 60, 59, 59, 60, 59, 61, 57,
 57,  0,  0,  0, 57,  0,  0,  0,  0, 57, 57,  0,  0,  0,  0,  0,
  0, 57, 57, 46,  0, 57, 46, 57, 57,  0, 46, 57,  0,  0,  0, 46,
 46, 46, 46,  0, 46, 46,  0,  0, 46,  0,  0, 57, 46,  0,  0,  0,
  0, 57,  0,  0,  0, 57,  0,  0,  0, 57,  0, 46, 57, 57,  0, 46,
  0,  0, 57,  0, 46, 46, 46, 57, 57, 57, 46,  0, 57, 57, 46, 41,
 57,  0, 57, 57, 57,  0, 57, 57, 57, 57, 46, 57, 57,  0,  0, 46,
  0,  0, 46, 46,  0, 46, 46, 46, 46, 46,  0,  0, 57, 57, 57, 57,
  0, 57,  0, 57, 46,  0, 46, 57,  0,  0,  0,  0, 46, 46, 57, 57,
  0, 57, 46,  0,  0,  0,  0, 57, 46, 57,  0,  0,  0,  0, 46,  0,
  0, 57,  0,  0,  0,  0, 46,  0,  0,  0, 46, 46,  0, 46, 46, 46,
 46, 61, 61, 61, 61, 61, 59, 59, 61, 59, 61, 60, 59, 59, 59, 60,
 59, 59, 61, 59, 59, 59, 59, 59, 59, 61, 60, 58, 59, 60, 58, 59,
 59, 59, 61, 61, 59, 61, 61, 59, 59, 60, 59, 61, 60, 61, 61, 60,
 60, 59, 59, 59, 59, 60, 59, 59, 59, 59, 59, 59, 59, 59, 61, 61,
 59, 61, 61, 61, 59, 59, 59, 60, 58, 61, 59, 59, 59, 61, 60, 59,
 59, 61, 58, 59, 59, 59, 61, 60, 59, 59, 60, 60, 59, 59, 59, 41,
 46,  0, 46, 41,  0,  0,  0, 46, 57, 57, 46,  0, 57,  0, 46, 46,
 46,  0, 57,  0,  0,  0, 57,  0, 57,  0,  0, 41,  0,  0,  0,  0,
 57, 41, 57, 46,  0, 57,  0, 57, 57, 57, 57,  0, 46, 46, 46,  0,
 46,  0,  0, 46, 46,  0,  0, 46, 46,  0, 46,  0, 46,  0, 46,  0,
 41,  0,  0,  0, 57,  0, 57,  0,  0, 46,  0,  0,  0, 46, 46, 57,
 57,  0, 46,  0,  0,  0, 57,  0,  0,  0, 41, 41,  0,  0, 46,  0,
 46, 57,  0, 46,  0,  0,  0,  0,  0, 46, 46,  0,  0, 57, 41,  0,
  0,  0, 46,  0, 57,  0, 57, 41, 46,  0,  0,  0,  0, 46,  0, 46,
 46, 46, 46,  0,  0, 46,  0,  0,  0,  0,  0, 46, 46, 41,  0, 57,
 46,  0,  0, 46, 57,  0, 41, 41,  0,  0,  0, 46, 57,  0, 46,  0,
 46, 61, 58, 59, 59, 59, 61, 59, 59, 59, 61, 59, 60, 60, 59, 59,
 59, 59, 59, 59, 61, 59, 59, 59, 59, 59, 60, 59, 59, 61, 58, 61,
 59, 61, 59, 59, 61, 61, 61, 61, 61, 59, 61, 59, 59, 59, 59, 59,
 59, 59, 61, 59, 61, 59, 59, 59, 60, 59, 59, 59, 59, 59, 61, 59,
 58, 59, 59, 59, 59, 59, 59, 61, 59, 60, 59, 59, 59, 61, 59, 58,
 59, 59, 59, 59, 59, 59, 59, 59, 60, 60, 60, 59, 59, 59, 59,  0,
  0,  0, 46,  0, 46, 46,  0, 46, 41,  0,  0,  0,  0,  0,  0,  0,
  0, 57, 57, 41,  0, 46, 46,  0,  0, 46, 41,  0,  0,  0, 57,  0,
  0,  0,  0,  0, 57, 41,  0,  0,  0, 46,  0, 41, 46, 57, 57,  0,
 57,  0, 41,  0,  0, 46,  0, 46, 46,  0, 46, 41, 46,  0,  0,  0,
 46, 41, 46,  0, 41, 57,  0, 41,  0,  0, 41,  0,  0, 57, 57,  0,
 46,  0, 57,  0, 41,  0,  0, 46, 57,  0, 41,  0,  0,  0, 46,  0,
  0, 41, 57,  0, 46, 41, 57, 41,  0,  0,  0,  0, 41,  0,  0,  0,
  0,  0, 41,  0, 41,  0,  0,  0,  0,  0, 41,  0,  0,  0, 41,  0,
 57,  0,  0,  0, 41,  0,  0,  0,  0, 46,  0,  0,  0,  0,  0,  0,
  0,  0, 46,  0,  0,  0,  0,  0, 57,  0,  0,  0,  0, 41,  0,  0,
  0, 59, 59, 58, 59, 61, 59, 59, 59, 59, 58, 60, 58, 59, 61, 60,
 59, 59, 59, 59, 61, 61, 60, 58, 60, 60, 59, 60, 59, 59, 60, 60,
 59, 59, 59, 59, 59, 60, 59, 59, 60, 61, 59, 59, 61, 58, 58, 60,
 59, 60, 59, 59, 59, 61, 60, 58, 59, 61, 59, 61, 59, 61, 60, 59,
 59, 59, 60, 60, 59, 59, 60, 59, 59, 59, 59, 61, 60, 58, 59, 59,
 61, 59, 60, 59, 60, 58, 59, 60, 58, 59, 59, 59, 59, 59, 58,  0,
  0,  0, 41, 41,  0, 41,  0, 57,  0,  0,  0, 46, 57,  0,  0,  0,
 57, 57,  0, 46,  0,  0,  0, 57,  0, 57,  0, 57, 57,  0,  0, 57,
  0, 57,  0,  0, 57, 57,  0, 57,  0, 46,  0, 57, 41, 46,  0, 57,
 57,  0,  0,  0,  0,  0,  0, 41,  0, 57,  0,  0, 57, 57,  0,  0,
  0, 57,  0, 46, 46, 57, 46,  0,  0,  0,  0, 57, 57,  0, 46, 57,
  0,  0, 57,  0,  0,  0, 46, 57,  0,  0,  0,  0,  0,  0,  0,  0,
 57,  0, 46, 41,  0, 57, 57, 46, 57, 57,  0,  0, 57, 57, 46, 46,
 46, 57,  0,  0, 41,  0, 46, 46,  0,  0, 57, 41, 41, 41,  0, 41,
 46,  0, 46, 46,  0,  0, 57, 41,  0, 41, 57,  0, 57,  0, 57, 57,
 41, 41,  0, 57, 57, 57,  0,  0,  0, 46,  0,  0,  0, 46, 41, 57,
 57, 59, 59, 59, 59, 60, 59, 60, 60, 59, 59, 59, 59, 60, 59, 60,
 58, 60, 59, 59, 60, 61, 60, 59, 59, 59, 58, 58, 61, 59, 61, 59,
 59, 60, 58, 60, 58, 59, 59, 59, 59, 58, 59, 60, 61, 59, 59, 60,
 59, 59, 61, 61, 61, 61, 61, 61, 59, 58, 61, 58, 59, 58, 58, 60,
 59, 61, 59, 59, 60, 58, 60, 58, 60, 58, 59, 58, 59, 59, 60, 60,
 61, 59, 59, 58, 60, 59, 60, 60, 58, 59, 60, 59, 59, 59, 61,  0,
  0,  0, 46,  0, 57,  0,  0, 57, 41, 41,  0,  0, 46,  0, 41,  0,
 41, 57,  0,  0,  0,  0, 57, 57, 41,  0,  0,  0,  0, 57,  0,  0,
 41,  0, 41,  0,  0,  0,  0, 46, 46,  0,  0, 41,  0,  0, 57,  0,
  0,  0, 41, 41, 57,  0,  0,  0,  0, 57,  0, 41,  0,  0, 57,  0,
  0,  0,  0,  0, 41,  0, 41, 41,  0, 41,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0, 41,  0,  0, 57,  0, 46, 57, 57,  0,  0,
 41,  0,  0,  0,  0,  0, 57,  0,  0, 46,  0,  0,  0,  0,  0,  0,
 57,  0, 57, 57, 57,  0,  0, 57, 41, 57, 41,  0, 57,  0, 57, 57,
 57,  0,  0, 41,  0,  0,  0,  0, 57, 57, 46, 57,  0, 57,  0,  0,
 46,  0,  0,  0, 57, 57,  0, 57,  0,  0,  0, 57,  0, 57, 41, 57,
  0, 59, 59, 59, 59, 59, 60, 58, 60, 59, 60, 60, 60, 60, 58, 61,
 59, 60, 59, 59, 60, 61, 58, 59, 59, 59, 60, 59, 59, 60, 59, 59,
 61, 59, 61, 61, 59, 59, 60, 59, 61, 60, 59, 59, 61, 59, 60, 60,
 60, 60, 59, 60, 59, 59, 60, 59, 59, 59, 59, 59, 60, 59, 60, 60,
 61, 61, 59, 59, 59, 61, 59, 59, 61, 61, 61, 59, 59, 60, 59, 60,
 60, 58, 61, 60, 59, 60, 59, 60, 59, 59, 59, 58, 61, 59, 60, 57,
  0, 46,  0,  0, 46,  0,  0, 57,  0, 57,  0, 57,  0,  0,  0, 41,
 57,  0,  0, 41,  0, 57,  0, 57, 46,  0, 57,  0, 57, 57, 46,  0,
  0,  0, 46, 46,  0, 46,  0, 46, 46,  0, 46, 46,  0, 46,  0, 57,
 57,  0,  0, 57,  0, 46, 57, 57, 57,  0,  0,  0,  0,  0, 41,  0,
  0, 46,  0, 46, 57,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 57,
 57, 57, 57, 57, 57,  0,  0,  0, 46, 46, 57,  0, 46, 57, 46,  0,
 46,  0, 46,  0,  0, 46,  0,  0,  0, 57,  0,  0, 57,  0,  0, 57,
 57, 57,  0, 57, 57, 41, 41,  0,  0,  0,  0, 41,  0, 46, 41, 46,
 46,  0,  0,  0,  0, 46,  0, 46, 46, 46, 46, 46, 46,  0, 46, 46,
  0, 46, 41, 57,  0,  0, 57, 57,  0,  0,  0,  0,  0, 46,  0,  0,
  0, 60, 58, 59, 59, 59, 59, 59, 59, 61, 60, 59, 59, 59, 59, 58,
 59, 59, 61, 61, 59, 59, 59, 61, 60, 60, 59, 59, 60, 60, 61, 59,
 60, 60, 60, 60, 61, 61, 61, 59, 60, 61, 61, 59, 61, 59, 60, 59,
 60, 60, 59, 60, 60, 61, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 59, 61, 59, 58, 59, 59,
 59, 59, 59, 59, 61, 59, 60, 61, 59, 59, 59, 59, 59, 59, 59, 41,
  0, 57,  0, 46,  0, 57, 46,  0,  0,  0,  0,  0,  0,  0,  0, 57,
  0,  0,  0, 57, 41,  0,  0, 57,  0,  0,  0,  0,  0, 41,  0, 41,
  0, 41, 57,  0,  0,  0, 46, 57, 57,  0,  0,  0,  0, 57,  0, 57,
 57, 41,  0, 57,  0, 57, 41,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 46,  0, 46,  0, 41, 41,  0,  0,  0, 57,  0, 57,  0, 57,  0,  0,
  0,  0, 57,  0,  0, 57,  0, 41, 57,  0, 57,  0,  0,  0,  0, 41,
 57,  0,  0, 46,  0,  0,  0, 41, 41,  0,  0,  0,  0,  0, 57,  0,
 46, 46, 41,  0,  0, 46,  0,  0,  0, 57, 57,  0, 46,  0,  0,  0,
 41, 46,  0,  0,  0, 57,  0,  0,  0,  0,  0, 46,  0, 57, 57,  0,
 46,  0, 57,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 46,
 46, 59, 59, 59, 61, 59, 59, 58, 59, 59, 59, 59, 59, 61, 59, 59,
 60, 59, 59, 59, 61, 59, 59, 59, 59, 61, 59, 59, 59, 60, 59, 60,
 59, 59, 61, 59, 59, 59, 59, 59, 59, 59, 58, 59, 59, 59, 59, 59,
 59, 59, 59, 58, 60, 58, 59, 60, 59, 58, 60, 59, 59, 61, 60, 59,
 60, 58, 58, 60, 59, 59, 61, 59, 58, 59, 59, 60, 59, 58, 60, 58,
 59, 61, 59, 59, 59, 58, 59, 60, 60, 60, 59, 59, 61, 59, 59,  0,
 46,  0, 46,  0, 46,  0, 46, 46, 46, 46,  0,  0,  0, 46,  0,  0,
  0,  0,  0,  0, 46, 57,  0,  0, 46,  0,  0, 57, 57,  0,  0,  0,
  0,  0,  0,  0,  0, 41,  0, 57, 46,  0,  0, 46,  0, 46, 41,  0,
  0, 46,  0,  0, 57,  0,  0, 46,  0,  0,  0, 57,  0,  0,  0,  0,
  0, 57,  0, 41,  0,  0,  0,  0,  0,  0, 46, 41, 57, 41, 46,  0,
 57,  0,  0,  0, 46,  0,  0,  0,  0,  0,  0, 46,  0,  0,  0, 46,
 46,  0,  0,  0,  0,  0,  0,  0, 41,  0, 41,  0,  0, 46,  0,  0,
  0,  0, 46,  0,  0,  0,  0,  0,  0,  0,  0, 41,  0, 57,  0, 57,
  0,  0, 41,  0,  0,  0,  0,  0,  0,  0, 57,  0,  0,  0,  0,  0,
  0, 41,  0, 41,  0,  0,  0, 57, 46, 41,  0,  0,  0,  0, 41, 57,
  0, 60, 59, 58, 59, 59, 59, 59, 61, 59, 61, 59, 59, 59, 59, 61,
 59, 61, 59, 59, 59, 60, 59, 59, 58, 58, 58, 59, 59, 60, 61, 59,
 59, 59, 59, 59, 60, 59, 59, 61, 58, 59, 59, 58, 59, 59, 59, 59,
 61, 59, 58, 58, 59, 59, 59, 59, 60, 60, 59, 61, 59, 59, 59, 58,
 59, 60, 59, 59, 59, 61, 59, 59, 59, 59, 59, 58, 59, 59, 59, 59,
 59, 61, 59, 59, 59, 59, 59, 59, 59, 61, 59, 59, 61, 59, 59,  0,
 57,  0,  0,  0, 57,  0,  0,  0,  0, 41,  0,  0,  0, 41, 57,  0,
 46, 46,  0,  0,  0,  0,  0, 57,  0,  0,  0,  0, 41,  0,  0,  0,
 46,  0, 41, 41,  0,  0,  0,  0,  0, 46,  0, 46, 46,  0,  0,  0,
  0,  0,  0, 41,  0,  0,  0,  0,  0,  0,  0, 41,  0,  0,  0,  0,
  0,  0, 41, 41,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0, 41,  0,  0,  0,  0,  0,  0, 41, 41,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0, 41,  0,  0,  0,  0, 41,  0,  0,  0,  0,
  0,  0,  0,  0, 41,  0,  0,  0,  0,  0, 41,  0, 41,  0,  0,  0,
  0,  0, 41,  0,  0,  0, 41,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 57, 60, 61, 60, 61, 59, 59, 61, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 60, 59, 59, 59, 59, 61, 59, 61, 60, 59, 59, 58, 60, 59,
 59, 59, 59, 61, 59, 59, 60, 60, 59, 61, 59, 59, 60, 59, 58, 59,
 58, 59, 59, 59, 59, 59, 59, 59, 59, 61, 59, 59, 59, 59, 59, 58,
 59, 58, 60, 60, 60, 60, 60, 61, 59, 59, 60, 59, 59, 59, 59, 59,
 59, 59, 58, 59, 59, 59, 59, 58, 58, 61, 59, 60, 61, 59, 59, 41,
  0, 46, 46, 57, 57,  0, 57, 46,  0, 57, 57, 46,  0, 46,  0,  0,
  0,  0, 46, 46,  0,  0, 57,  0, 41,  0, 46, 46,  0,  0, 41,  0,
  0, 46,  0,  0,  0,  0,  0,  0,  0,  0, 46,  0,  0,  0, 41, 41,
  0,  0, 41, 46, 46, 57,  0, 57,  0,  0, 41,  0, 41,  0,  0, 57,
  0, 57, 46,  0,  0, 57, 41,  0,  0,  0,  0, 57,  0, 57,  0, 57,
  0,  0, 57, 57, 57, 46, 57, 57, 41, 46,  0, 57,  0,  0,  0,  0,
  0, 46,  0,  0,  0,  0,  0,  0,  0,  0, 46, 57, 41,  0,  0, 46,
  0,  0,  0, 46,  0, 46,  0,  0,  0, 46,  0,  0,  0, 46,  0,  0,
  0,  0,  0,  0,  0, 46, 46, 46, 41,  0,  0,  0,  0, 46,  0, 57,
 46, 57,  0, 57, 46, 46, 46,  0, 46, 46, 46, 46,  0,  0,  0, 46,
  0, 61, 61, 58, 61, 59, 61, 61, 61, 61, 61, 59, 59, 59, 61, 61,
 61, 59, 61, 59, 60, 61, 59, 58, 60, 59, 59, 59, 59, 61, 58, 59,
 60, 60, 60, 59, 59, 59, 61, 61, 59, 61, 61, 59, 59, 59, 58, 59,
 60, 59, 59, 59, 61, 60, 59, 60, 59, 59, 58, 61, 61, 60, 60, 60,
 60, 61, 59, 59, 61, 59, 59, 59, 60, 61, 60, 59, 59, 58, 59, 59,
 60, 59, 60, 59, 61, 59, 60, 59, 59, 61, 58, 59, 59, 60, 60,  0,
  0, 57, 57, 57,  0, 57, 57, 41, 57, 46,  0,  0, 57,  0,  0, 46,
 57,  0, 41, 57, 57, 41, 41,  0,  0, 57, 41, 57,  0,  0,  0, 46,
  0, 46,  0, 46, 46, 46, 46, 46,  0, 46, 46, 57,  0, 46, 57,  0,
  0, 46, 46, 57,  0,  0,  0,  0, 57, 57,  0, 57, 57, 57, 57, 57,
  0, 41, 41,  0, 57, 46,  0,  0,  0, 57, 57,  0, 57,  0,  0,  0,
 46,  0,  0, 57, 46, 57, 46, 57,  0,  0,  0, 57,  0,  0, 46,  0,
 46, 57, 57, 57,  0, 57,  0,  0, 57,  0, 46, 57,  0,  0, 57, 57,
 57, 46,  0, 57,  0, 46, 46, 46, 46,  0, 46, 46, 46, 46, 46,  0,
  0, 46,  0,  0, 46,  0,  0, 46,  0,  0,  0, 57, 57,  0, 46,  0,
  0, 41, 46,  0,  0,  0,  0, 57,  0, 57, 46, 57,  0,  0, 57,  0,
  0, 59, 59, 59, 59, 60, 59, 60, 59, 58, 60, 61, 59, 59, 61, 59,
 59, 61, 60, 61, 59, 60, 58, 59, 58, 60, 59, 60, 61, 60, 60, 59,
 59, 60, 59, 61, 59, 61, 61, 61, 61, 59, 61, 61, 59, 61, 61, 61,
 59, 61, 61, 61, 61, 59, 59, 59, 59, 60, 60, 59, 60, 59, 61, 59,
 61, 59, 59, 60, 59, 59, 60, 59, 59, 60, 60, 59, 58, 59, 60, 61,
 59, 59, 59, 59, 60, 59, 59, 60, 60, 58, 59, 59, 61, 59, 59, 41,
  0,  0, 46,  0,  0, 57,  0, 41, 57, 57,  0,  0, 57, 41, 57,  0,
  0, 57,  0, 57, 46, 57,  0,  0,  0,  0,  0, 46,  0, 46, 46, 46,
 46, 46,  0, 46, 46,  0, 46, 46, 46, 46, 46, 46,  0,  0, 46, 57,
  0,  0, 57,  0,  0, 57,  0,  0, 46,  0,  0,  0,  0,  0,  0, 46,
 57,  0,  0, 41, 57, 57, 57, 57,  0,  0,  0, 57, 46,  0,  0, 41,
  0, 57,  0,  0,  0,  0, 46,  0, 57, 57, 41,  0,  0, 46, 57,  0,
 46, 57,  0,  0, 46,  0, 46,  0, 41,  0, 41, 57, 46,  0, 57,  0,
  0, 57,  0, 57,  0, 41,  0, 57, 41, 57, 41, 57, 46,  0,  0,  0,
  0,  0,  0,  0,  0, 46,  0,  0,  0,  0, 46,  0, 46, 46, 46,  0,
 46, 46,  0,  0, 46,  0, 46, 57,  0, 41, 57, 41,  0, 46,  0, 41,
 57, 60, 59, 60, 60, 60, 58, 59, 59, 61, 59, 60, 58, 60, 59, 60,
 59, 59, 60, 59, 60, 59, 58, 59, 60, 59, 60, 59, 58, 58, 58, 59,
 59, 59, 59, 60, 60, 59, 59, 59, 59, 59, 58, 59, 59, 60, 61, 59,
 59, 59, 59, 61, 61, 59, 60, 59, 60, 59, 59, 60, 58, 59, 58, 60,
 59, 59, 59, 59, 59, 59, 59, 58, 59, 59, 59, 60, 59, 59, 60, 58,
 59, 59, 58, 58, 59, 59, 59, 59, 59, 59, 58, 59, 59, 59, 61, 46,
  0,  0,  0, 46,  0, 46, 46,  0,  0, 46,  0,  0,  0,  0,  0, 46,
 57,  0,  0,  0,  0,  0, 41,  0, 46,  0,  0,  0, 57, 41,  0, 57,
  0,  0, 57,  0,  0, 57,  0, 46,  0,  0, 57, 41,  0,  0,  0, 57,
  0, 57, 46,  0, 46,  0, 57, 46,  0,  0, 57, 46,  0, 46,  0,  0,
  0, 46, 57,  0, 41, 41,  0, 46,  0, 41,  0, 57, 41,  0, 41, 46,
  0, 57,  0, 57, 57, 46,  0, 46,  0,  0, 46,  0,  0,  0, 46, 46,
 46, 46, 46,  0, 46, 46, 46,  0, 46, 46,  0,  0,  0,  0,  0, 41,
  0,  0,  0,  0, 57,  0,  0,  0, 41, 46,  0,  0,  0,  0, 41, 41,
  0, 41, 57,  0,  0,  0, 57,  0,  0, 46,  0,  0,  0,  0,  0, 57,
  0, 41,  0, 46, 57, 57,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 57, 59, 58, 58, 61, 59, 59, 59, 59, 61, 61, 60, 58, 61, 59, 61,
 59, 60, 58, 61, 59, 59, 61, 59, 58, 59, 59, 59, 59, 59, 61, 58,
 59, 58, 59, 59, 59, 59, 61, 61, 59, 59, 59, 61, 59, 61, 59, 59,
 59, 58, 59, 59, 58, 59, 59, 58, 60, 59, 58, 58, 61, 59, 60, 58,
 59, 59, 60, 59, 58, 59, 61, 59, 59, 59, 59, 59, 59, 60, 60, 59,
 58, 59, 61, 59, 61, 59, 59, 59, 61, 59, 60, 59, 60, 58, 58,  0,
  0, 41,  0,  0, 57,  0,  0,  0, 57, 46,  0,  0, 46, 57, 57,  0,
 41,  0,  0,  0, 41,  0,  0, 41,  0,  0,  0,  0, 46,  0,  0,  0,
  0, 46,  0, 41, 41,  0,  0, 57,  0,  0,  0,  0,  0,  0, 41, 41,
  0, 41,  0, 57,  0,  0, 46,  0,  0, 57,  0,  0,  0,  0, 41,  0,
 57, 41, 57, 41,  0,  0,  0,  0,  0, 46, 41,  0,  0,  0,  0,  0,
  0, 46, 46,  0,  0, 41,  0,  0,  0,  0, 41,  0,  0,  0, 46, 41,
 57, 57,  0,  0, 41,  0,  0,  0,  0, 41,  0, 41, 41,  0, 46, 57,
  0, 41,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 41,  0,
  0, 41,  0,  0,  0, 41, 41,  0,  0, 41,  0, 41,  0,  0,  0, 41,
  0, 57,  0,  0,  0, 41,  0,  0, 41,  0, 57, 57, 41, 41, 41, 41,
  0, 59, 59, 60, 59, 59, 59, 58, 58, 59, 59, 59, 59, 59, 59, 58,
 59, 59, 59, 59, 59, 61, 59, 58, 59, 61, 59, 59, 59, 59, 58, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 60, 59, 59, 61,
 58, 58, 59, 59, 59, 59, 59, 59, 58, 59, 59, 59, 59, 58, 61, 59,
 59, 59, 59, 58, 59, 59, 59, 59, 59, 59, 59, 60, 61, 61, 59, 61,
 60, 59, 59, 59, 59, 61, 61, 59, 60, 59, 59, 59, 60, 58, 61, 46,
 46,  0,  0,  0,  0, 57,  0,  0,  0, 46, 57,  0,  0,  0, 57,  0,
  0,  0, 57,  0, 46, 46, 46,  0, 41, 57, 41,  0, 46, 46,  0,  0,
  0, 41,  0,  0, 41,  0,  0,  0,  0,  0,  0, 57, 57, 57, 46, 57,
  0, 46,  0, 57,  0,  0,  0, 57, 57, 57,  0, 46, 46, 46,  0,  0,
 46, 46, 46, 46,  0,  0,  0,  0, 57,  0, 46, 41,  0,  0,  0, 41,
  0,  0,  0,  0,  0,  0,  0,  0, 57, 57,  0, 46,  0, 41,  0, 57,
  0,  0,  0,  0, 46,  0, 46, 46, 46, 46,  0, 46, 46, 46,  0, 46,
  0, 41,  0,  0,  0,  0,  0, 46,  0, 57,  0,  0,  0, 57,  0,  0,
  0,  0,  0,  0, 41,  0,  0,  0,  0, 57, 46,  0, 41,  0,  0,  0,
 46,  0,  0, 46,  0, 46, 46,  0, 46, 57, 57,  0,  0,  0, 41,  0,
  0, 58, 59, 59, 59, 59, 60, 59, 59, 59, 59, 59, 59, 59, 59, 61,
 60, 61, 59, 59, 59, 59, 60, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 61, 59, 58, 59, 58, 60, 59, 60, 59, 60, 59,
 58, 59, 59, 59, 59, 59, 58, 59, 59, 58, 59, 59, 60, 59, 60, 59,
 59, 59, 59, 59, 60, 58, 60, 60, 61, 58, 59, 59, 58, 59, 60, 59,
 59, 59, 61, 61, 59, 59, 59, 59, 61, 59, 61, 59, 59, 60, 59,  0,
  0,  0,  0,  0, 57,  0,  0,  0,  0, 41, 57,  0,  0,  0,  0, 57,
  0,  0, 41,  0, 57,  0,  0,  0, 46, 57,  0,  0,  0,  0,  0, 57,
 46,  0, 41,  0,  0,  0,  0,  0, 46,  0,  0,  0, 57,  0,  0,  0,
  0, 41,  0, 46,  0, 46,  0,  0,  0, 57, 41,  0,  0,  0, 41,  0,
  0, 41,  0, 57,  0,  0,  0,  0, 41, 41,  0,  0,  0,  0, 57,  0,
 41,  0, 41,  0, 57, 57,  0,  0,  0,  0,  0,  0,  0,  0,  0, 41,
 46,  0,  0,  0,  0, 57, 41, 57,  0,  0,  0,  0,  0, 41, 57,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0, 46,  0, 41, 41,  0, 41, 41,
 41,  0,  0,  0,  0,  0, 57,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 41,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 41,  0, 46,  0,  0,
  0, 59, 59, 59, 59, 59, 59, 59, 61, 59, 60, 59, 60, 58, 59, 59,
 60, 61, 58, 59, 59, 60, 60, 61, 61, 61, 58, 60, 59, 60, 58, 61,
 58, 59, 59, 59, 59, 59, 58, 60, 60, 59, 59, 59, 60, 61, 59, 59,
 59, 59, 60, 59, 59, 59, 61, 59, 58, 60, 59, 60, 59, 60, 59, 60,
 59, 60, 60, 59, 59, 59, 61, 60, 59, 60, 59, 59, 59, 59, 61, 61,
 59, 59, 60, 59, 59, 61, 59, 59, 59, 60, 61, 59, 59, 58, 61, 46,
 57, 57,  0,  0, 46,  0,  0,  0,  0,  0, 46, 46,  0, 46,  0, 46,
  0,  0, 46,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 46,
  0,  0, 41,  0,  0,  0,  0, 41,  0,  0,  0,  0, 57, 46,  0, 57,
 46,  0,  0,  0, 46,  0, 46, 46, 46, 46,  0,  0,  0,  0,  0,  0,
 41, 46, 57, 46, 57,  0,  0,  0, 46,  0,  0,  0,  0, 46, 57,  0,
 57,  0, 46,  0,  0,  0,  0, 57,  0, 57,  0,  0,  0,  0, 46,  0,
 46, 57,  0,  0,  0,  0,  0,  0, 46, 57,  0,  0, 46, 46, 46, 46,
 46, 46, 46, 46, 46,  0,  0, 46, 57, 41, 46, 46, 57, 41,  0,  0,
  0, 46,  0, 46,  0,  0,  0,  0,  0,  0, 57,  0,  0,  0, 46,  0,
  0,  0,  0, 46,  0, 46, 57, 46,  0,  0,  0, 57, 57, 57, 46,  0,
  0, 61, 61, 59, 59, 60, 59, 59, 59, 60, 60, 60, 61, 59, 61, 59,
 59, 61, 59, 59, 61, 59, 58, 60, 61, 61, 59, 59, 59, 59, 60, 60,
 59, 59, 59, 59, 58, 58, 59, 59, 59, 59, 59, 59, 59, 61, 59, 59,
 60, 59, 60, 59, 59, 59, 59, 60, 59, 59, 59, 59, 59, 59, 59, 59,
 61, 59, 59, 59, 59, 59, 59, 59, 58, 59, 58, 59, 61, 61, 59, 61,
 58, 59, 58, 59, 59, 58, 59, 59, 58, 59, 58, 58, 59, 59, 61,  0,
  0,  0,  0,  0, 57,  0, 41, 57,  0, 57,  0, 57,  0,  0, 57,  0,
  0, 46,  0,  0, 41,  0, 57, 41, 41,  0,  0, 46,  0,  0,  0, 57,
  0,  0, 46,  0,  0,  0,  0, 41,  0, 57,  0, 46,  0, 41, 46, 46,
 46,  0, 57, 57,  0,  0,  0, 46,  0, 41, 46, 46,  0,  0,  0,  0,
 57,  0, 57,  0,  0,  0,  0,  0, 46, 57, 57,  0, 41, 57,  0, 57,
 46, 46,  0,  0,  0,  0, 41,  0,  0, 57,  0,  0,  0, 41, 57,  0,
 57,  0,  0, 41, 41, 57, 41, 46,  0, 57, 41,  0,  0, 57,  0,  0,
  0,  0, 46,  0,  0,  0,  0, 41,  0, 41,  0,  0,  0, 41, 41,  0,
  0, 41,  0, 57,  0, 57, 57, 41,  0, 57, 46,  0,  0,  0,  0, 46,
 46,  0,  0, 41,  0,  0,  0,  0,  0,  0, 46, 57,  0,  0,  0,  0,
 41, 58, 60, 59, 59, 60, 60,  0, 57,  0, 57, 41, 57,  0, 57, 41,
 57,  0,  0, 57, 57, 57, 57,  0, 41,  0, 41,  0, 46,  0,  0, 41,
 41, 57,  0, 41, 41,  0,  0,  0,  0,  0,  0, 41,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 57,  0, 57,  0, 57, 57, 57, 57,  0, 57, 57,
 41,  0, 41,  0, 41, 41,  0,  0, 41, 41, 41,  0,  0, 46,  0, 41,
 46,  0,  0,  0,  0,  0, 46, 46,  0,  0,  0,  0,  0,  0, 57,  0,
 46, 46, 41, 57,  0,  0,  0, 57,  0, 41,  0, 57,  0,  0, 46,  0,
 46,  0,  0,  0,  0,  0,  0,  0, 41,  0,  0,  0, 57,  0, 57, 41,
  0, 41,  0, 41,  0, 41,  0, 57, 57, 46, 41,  0,  0,  0,  0,  0,
 41,  0, 41,  0,  0, 41,  0,  0,  0, 41, 46,  0,  0, 41,  0, 41,
  0,  0,  0,  0,  0,  0, 41,  0,  0,  0, 41,  0,  0,  0,  0, 41,
  0,  0, 46,  0, 41,  0,  0,  0, 41,  0, 41,  0, 57,  0, 46,  0,
 57,  0, 57, 57, 46,  0, 57,  0,  0,  0,  0,  0,  0,  0, 57, 46,
  0,  0,  0,  0, 46,  0, 46, 57,  0,  0,  0,  0,  0,  0,  0, 46,
  0, 41,  0,  0, 57,  0,  0,  0,  0,  0,  0,  0,  0, 46,  0, 46,
  0, 57,  0, 46,  0, 41,  0,  0, 57, 46, 57, 41, 46,  0,  0, 57,
  0,  0,  0, 41,  0, 57, 41,  0, 57, 46,  0, 57, 57, 46,  0, 46,
 57, 57, 57, 57,  0, 46,  0, 57, 57,  0, 57, 46,  0,  0, 46,  0,
 46,  0,  0,  0,  0, 46,  0, 41, 46,  0,  0, 46, 57,  0, 46, 57,
  0, 41,  0, 41, 57,  0,  0,  0,  0, 57, 46, 57, 57, 41,  0,  0,
  0,  0, 41,  0,  0, 57, 57,  0,  0,  0, 57,  0,  0,  0,  0, 41,
 41,  0, 46,  0, 46, 41, 41,  0, 57, 46, 41,  0,  0,  0,  0, 57,
  0,  0,  0, 46,  0,  0, 57, 41,  0,  0, 41, 57,  0,  0, 41, 57,
  0, 57, 46,  0, 46,  0, 46, 46,  0, 46, 46,  0,  0, 57,  0, 46,
 46, 46,  0, 46, 46, 57,  0,  0,  0,  0,  0, 57, 46,  0, 46, 46,
 46, 57, 57, 57, 46, 57,  0,  0, 57, 57,  0,  0, 57, 57, 57,  0,
  0,  0, 57, 46, 46, 57,  0, 57, 46, 46, 46,  0,  0, 57,  0,  0,
  0,  0, 57,  0, 57, 57, 46,  0, 57, 41,  0, 57,  0,  0, 46,  0,
  0,  0, 57, 46, 46,  0, 46, 46, 46,  0, 46, 46,  0,  0,  0,  0,
 57, 46, 41,  0, 57,  0,  0,  0,  0, 46, 41,  0, 57,  0,  0, 46,
 57, 46,  0, 46,  0, 46,  0,  0,  0,  0, 46,  0, 46, 41,  0,  0,
 46,  0,  0,  0,  0, 46,  0, 46, 46, 57,  0, 46,  0,  0,  0, 57,
 57, 41, 57,  0, 57, 46, 57,  0,  0, 46, 46, 46,  0, 46,  0,  0,
 46,  0,  0, 46, 46, 46,  0,  0, 46,  0,  0, 41, 46,  0, 46, 46,
 46,  0, 41, 46,  0,  0,  0,  0,  0,  0,  0,  0, 57, 46, 41,  0,
  0,  0, 41,  0, 46,  0, 57,  0,  0,  0,  0,  0, 46,  0, 46,  0,
  0, 41,  0, 46, 41,  0,  0,  0,  0, 41,  0, 46, 41,  0,  0, 46,
 41,  0, 41,  0,  0,  0,  0,  0, 57,  0,  0, 57, 41, 57, 57,  0,
  0,  0, 46,  0, 57,  0, 57, 57, 46,  0,  0, 46,  0,  0, 57,  0,
 41, 46,  0, 57,  0,  0, 46,  0,  0, 46,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 46,  0,  0,  0,  0,  0,  0,  0,  0,  0, 57,  0,
  0, 46, 46,  0, 46,  0,  0,  0,  0,  0, 41,  0,  0,  0,  0, 57,
  0,  0, 57, 41,  0, 46, 57,  0, 57,  0, 57,  0,  0, 46, 46, 46,
 46, 46, 57,  0, 46,  0, 57, 46, 46,  0,  0, 57, 41,  0, 41, 57,
  0, 41,  0, 41, 41, 46,  0, 41,  0,  0,  0,  0,  0,  0, 57, 46,
  0, 46, 57,  0, 57,  0,  0,  0, 57, 46,  0,  0, 57,  0, 57,  0,
  0, 57,  0,  0, 57,  0,  0, 46, 57, 57,  0, 57,  0, 46,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0, 46, 46,  0,  0,  0, 41, 46,
 57,  0, 46,  0,  0,  0, 46,  0, 46, 57,  0,  0,  0, 46,  0, 46,
  0,  0,  0,  0,  0, 46, 46, 57, 57,  0, 57,  0, 57,  0,  0,  0,
 57, 46,  0, 46,  0,  0,  0, 46,  0,  0,  0,  0,  0, 41,  0,  0,
 46, 46,  0,  0,  0,  0,  0,  0,  0,  0, 46, 57,  0,  0,  0,  0,
  0, 57, 46, 57,  0, 46, 57,  0, 46,  0,  0, 57, 46,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0, 57,  0,  0,  0, 46, 57, 57,
 46,  0,  0,  0, 46, 46,  0,  0,  0,  0,  0, 41, 46, 46, 46,  0,
  0, 57, 46,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 41, 46,
 46,  0, 46,  0,  0, 57,  0, 46,  0, 46, 46,  0, 57, 41,  0,  0,
 57,  0,  0, 57,  0, 46,  0,  0,  0,  0,  0, 57, 41, 46,  0, 57,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 46,  0,  0,
  0,  0,  0,  0,  0,  0,  0, 57,  0,  0,  0, 57, 57,  0,  0,  0,
  0,  0, 57, 57,  0, 57,  0, 46,  0, 57,  0, 46, 46, 57, 57, 41,
  0,  0,  0, 57,  0,  0, 46,  0, 46,  0,  0,  0,  0, 46, 46, 46,
 46, 46, 57,  0,  0,  0,  0,  0,  0, 46,  0,  0, 46, 46,  0,  0,
  0, 46, 57,  0, 46,  0, 46, 46, 46,  0, 46,  0, 46, 46,  0, 46,
  0,  0,  0, 46,  0, 57, 57, 57,  0, 46,  0,  0, 57, 46,  0,  0,
 46,  0, 41,  0, 57,  0,  0, 46, 46, 46, 46, 46, 46,  0, 46,  0,
 46,  0,  0,  0,  0, 57,  0, 46,  0,  0,  0,  0, 46,  0, 46, 41,
 46,  0, 46,  0,  0, 46, 46, 46,  0,  0,  0,  0,  0, 57,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 46, 57, 57, 46, 46, 41,
  0,  0,  0,  0,  0,  0,  0, 46,  0,  0,  0,  0, 57,  0,  0,  0,
  0, 41,  0,  0,  0,  0,  0, 57,  0, 46,  0,  0, 57, 57, 57,  0,
  0, 57,  0, 46,  0,  0,  0, 57, 46,  0, 46, 46, 46,  0,  0, 46,
  0, 46,  0, 57,  0, 46,  0, 57,  0, 41,  0,  0,  0,  0,  0,  0,
 46, 46, 46, 46, 46,  0,  0,  0,  0, 46, 41, 41, 41,  0, 46,  0,
  0, 57,  0,  0,  0, 57,  0,  0,  0, 46, 57, 57,  0,  0, 41,  0,
 57,  0,  0,  0, 46, 46,  0,  0,  0, 46,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 57,  0,  0,  0, 57,  0,  0, 41,
  0,  0, 46,  0, 46, 41,  0, 46,  0,  0, 46, 41,  0,  0,  0,  0,
  0, 57,  0,  0,  0, 46,  0,  0,  0,  0,  0,  0,  0,  0, 41,  0,
  0,  0,  0, 46,  0,  0, 41,  0,  0,  0,  0,  0,  0,  0, 46,  0,
  0,  0,  0,  0, 46,  0,  0,  0,  0,  0, 41, 41, 41,  0,  0,  0,
  0,  0,  0,  0, 46,  0,  0,  0,  0,  0, 57, 46, 46,  0, 57,  0,
 57, 57,  0,  0,  0,  0, 46, 41, 57, 57,  0,  0,  0,  0,  0,  0,
 41,  0,  0, 46,  0,  0, 57, 57,  0,  0, 57, 57, 57, 57, 57, 46,
 57,  0, 46,  0,  0, 57,  0, 46, 57,  0,  0,  0,  0, 57,  0, 46,
  0,  0,  0,  0,  0,  0,  0, 46, 46,  0, 57,  0,  0,  0,  0, 41,
 46, 57,  0,  0, 46, 46,  0,  0,  0,  0, 46,  0,  0, 41, 41, 57,
  0, 41,  0,  0,  0,  0,  0,  0,  0,  0, 46,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0, 41, 57,  0,  0, 41,  0,  0,  0, 41,  0,
  0, 41,  0, 57,  0,  0,  0,  0,  0, 57, 46, 46,  0, 57, 57, 41,
 57, 57,  0, 46,  0,  0, 46,  0,  0, 57, 41, 57,  0, 46,  0,  0,
  0, 57, 57,  0,  0, 57,  0,  0, 57,  0,  0,  0,  0,  0,  0, 57,
  0,  0,  0, 46, 57,  0, 57, 57,  0, 57,  0, 46,  0, 46,  0, 46,
 46,  0,  0,  0,  0,  0,  0,  0, 46,  0,  0, 57,  0, 46,  0,  0,
 57,  0, 46, 46,  0, 41, 46,  0, 41,  0,  0, 57,  0, 57, 46,  0,
  0,  0,  0,  0, 57,  0,  0, 57,  0, 41, 57,  0, 41,  0, 46, 41,
 57,  0,  0, 46,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 41,  0,
  0, 41,  0, 46,  0,  0, 41, 57,  0, 46,  0, 57, 57, 57,  0, 57,
 41,  0,  0,  0,  0,  0, 57,  0,  0, 41,  0,  0,  0, 41, 41,  0,
  0, 46,  0,  0,  0,  0,  0, 57,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 41, 41,  0,  0,  0,  0,  0,  0, 41,  0, 41,  0,  0,  0,  0,
 57,  0,  0,  0, 57,  0, 57, 46, 46, 57, 57,  0,  0, 41,  0, 57,
 46, 57,  0, 46, 57,  0, 46,  0, 57,  0,  0,  0,  0, 46,  0,  0,
  0, 46, 57, 41,  0, 57, 46, 46, 57,  0,  0,  0, 46, 46,  0, 57,
 46,  0,  0,  0,  0, 46, 46,  0, 46, 41, 41,  0, 46, 46, 41, 41,
  0,  0,  0, 46,  0,  0,  0,  0,  0,  0, 41,  0,  0,  0,  0, 46,
  0,  0,  0,  0, 41, 41,  0, 41,  0,  0, 41, 57,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0, 46, 41,  0, 57,  0,  0,  0, 41, 46, 57,
 57,  0,  0, 57,  0, 57, 46,  0,  0,  0, 41,  0,  0, 57,  0, 57,
  0,  0,  0,  0,  0,  0, 41,  0,  0, 57, 57,  0,  0, 46,  0, 57,
  0,  0,  0, 46, 46,  0, 46,  0, 46,  0, 46, 46,  0,  0,  0, 57,
  0, 57,  0,  0, 46, 46,  0,  0,  0, 57,  0, 57,  0,  0, 57,  0,
 57,  0,  0,  0, 46, 46, 57,  0, 46,  0, 46, 46, 57, 41, 46,  0,
  0, 46,  0, 46,  0,  0,  0,  0, 46, 41, 46,  0, 46,  0, 46,  0,
  0,  0,  0,  0,  0, 46, 41, 46,  0, 57,  0, 57, 57, 41,  0, 57,
 57, 57, 57,  0, 57,  0, 57,  0, 46,  0, 46, 46,  0, 46,  0,  0,
 57,  0, 46,  0,  0,  0,  0,  0,  0,  0,  0,  0, 41,  0, 57,  0,
  0, 46, 46,  0,  0, 57,  0, 46,  0, 46,  0, 46,  0, 41, 46,  0,
 46,  0,  0,  0,  0, 46,  0, 41,  0,  0,  0, 41,  0, 46,  0, 41,
 46,  0,  0,  0, 57, 57,  0, 57,  0,  0, 41,  0, 46, 57,  0,  0,
  0, 57, 46,  0,  0,  0, 46, 46, 46, 46, 46, 46, 46, 57,  0,  0,
  0, 57,  0,  0, 57,  0,  0,  0, 57,  0,  0,  0,  0,  0,  0,  0,
 41, 57,  0,  0, 41,  0, 57, 57,  0, 41,  0,  0, 46,  0,  0,  0,
  0, 46, 41, 46,  0,  0,  0,  0,  0, 46, 46,  0,  0, 46,  0,  0,
 41, 46,  0,  0, 41, 46, 46,  0,  0, 41, 46,  0,  0,  0, 46,  0,
  0, 46,  0,  0,  0,  0,  0, 46,  0,  0,  0,  0, 46,  0, 46,  0,
  0,  0,  0,  0,  0,  0,  0, 57,  0,  0,  0, 46, 46,  0,  0, 46,
  0,  0, 41,  0,  0,  0, 46,  0,  0,  0,  0,  0,  0,  0, 41, 46,
  0, 41,  0,  0,  0,  0, 46, 57,  0,  0, 57, 41,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 46,  0,  0,  0,  0, 41, 41, 57,
 46, 46,  0, 41,  0,  0,  0,  0,  0,  0,  0,  0, 41, 57,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 41,  0,  0,  0, 41,  0,  0,  0,  0,  0,  0,  0, 41,  0,  0,  0,
  0,  0,  0, 57, 46,  0,  0,  0,  0,  0,  0, 46, 46, 46,  0,  0,
  0,  0,  0, 41,  0,  0,  0,  0,  0, 57,  0,  0,  0,  0,  0,  0,
  0, 46, 57,  0,  0, 57,  0, 57, 57,  0,  0,  0, 46, 46, 46, 57,
  0,  0, 46,  0, 46, 57,  0, 41,  0,  0, 46,  0,  0,  0, 57,  0,
  0, 57, 57, 57,  0,  0,  0,  0,  0, 57,  0,  0, 46, 46, 57,  0,
  0, 46,  0,  0,  0, 46,  0, 46, 46,  0, 57,  0, 46, 46,  0,  0,
  0,  0,  0,  0,  0, 46, 57, 46,  0, 46,  0,  0, 46,  0, 41, 57,
 57,  0,  0,  0,  0,  0,  0, 41, 46,  0,  0,  0,  0,  0,  0, 46,
  0,  0,  0,  0,  0,  0,  0,  0, 46,  0,  0, 57,  0,  0, 41,  0,
 41,  0, 41,  0, 41, 41, 41, 41, 41,  0, 57, 41,  0, 41,  0,  0,
 41,  0,  0,  0, 41,  0,  0, 41, 41, 41, 41, 41,  0,  0,  0,  0,
 57, 41, 57,  0,  0,  0,  0, 46,  0,  0,  0, 57, 41,  0, 41, 57,
 41,  0,  0, 41,  0, 41,  0,  0,  0, 41, 41,  0,  0,  0,  0,  0,
  0,  0, 41, 41, 41, 41, 41,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 41,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 41,  0,
  0, 41, 41,  0,  0,  0, 41,  0, 41,  0, 41,  0,  0,  0, 57,  0,
  0, 41, 41, 41,  0,  0, 41, 46,  0, 41,  0,  0,  0,  0,  0, 41,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 41, 41,
  0,  0,  0, 41,  0,  0,  0,  0,  0,  0,  0,  0, 41,  0,  0,  0,
 41,  0, 41,  0,  0,  0, 46,  0,  0,  0,  0,  0, 41, 41, 46,  0,
  0, 41, 41,  0, 41, 41,  0,  0, 41,  0, 41, 41,  0, 41, 41, 41,
  0,  0,  0,  0,  0,  0,  0, 41,  0,  0, 41, 41,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0, 41,  0, 41,  0, 41,  0,  0, 41, 41,  0,
 41, 41,  0, 41,  0,  0,  0,  0, 41, 41,  0,  0, 41,  0,  0, 41,
  0,  0,  0,  0, 41,  0,  0,  0,  0,  0,  0, 41,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0, 41, 41,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 41,  0,  0,  0,  0,  0, 41,  0, 41, 41, 41,
  0, 41,  0, 41,  0,  0,  0,  0,  0,  0,  0, 41,  0,  0, 41, 41,
  0, 41,  0,  0,  0,  0,  0, 41,  0,  0,  0, 46,  0, 41, 41,  0,
  0, 57,  0, 41,  0,  0, 41, 57,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 41,  0, 41, 41,  0,  0,  0,  0,  0,  0,  0,  0, 41,  0,
  0, 41,  0,  0,  0,  0,  0,  0,  0, 41, 41, 41,  0, 41,  0,  0,
 41,  0,  0,  0,  0,  0,  0,  0,  0, 41,  0,  0, 41,  0,  0,  0,
  0,  0, 57,  0,  0,  0,  0,  0,  0,  0,  0,  0, 41,  0,  0, 41,
  0,  0,  0, 41,  0,  0, 41,  0, 41,  0,  0, 57, 41,  0,  0, 46,
 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46,  0, 46,
 46, 46, 46, 46,  0, 46, 46, 46, 46, 46, 46,  0,  0, 46, 46, 46,
 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46,
 46, 46, 46, 46, 46, 46,  0, 46, 46, 46, 46, 46, 46, 46, 46, 46,
 46, 46, 46, 46,  0, 46, 46, 46, 46, 46, 46, 46,  0, 46, 46, 46,
 46, 46, 46, 46, 46, 46, 46, 46, 46,  0, 46, 46, 46, 46, 46, 46,
 46, 46, 46, 46, 46, 46, 46, 46, 46, 46,  0, 46, 46, 46, 46, 46,
  0, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46,  0, 46,
 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46,
 46, 46, 46, 46, 46, 46, 57,  0, 57,  0, 57,  0,  0,  0,  0,  0,
  0,  0, 46,  0, 46, 46,  0,  0,  0,  0,  0,  0, 41,  0,  0,  0,
 57, 46,  0,  0, 57, 57,  0, 46, 46,  0, 46,  0,  0,  0,  0, 46,
  0, 46, 46,  0,  0,  0,  0,  0, 46, 46, 57, 41,  0,  0, 57,  0,
 41, 46, 57,  0, 46, 41,  0, 41,  0, 57,  0,  0,  0,  0, 46,  0,
  0, 46,  0,  0,  0, 41,  0,  0, 41,  0, 57,  0, 57,  0, 57,  0,
  0,  0,  0,  0, 57,  0,  0,  0,  0,  0, 57,  0,  0, 46, 57, 46,
  0, 46,  0,  0, 57,  0,  0, 46, 41, 41,  0,  0,  0,  0,  0, 46,
 46,  0, 57,  0,  0,  0,  0,  0, 57, 57,  0,  0, 46, 57,  0, 46,
  0, 57,  0,  0,  0, 57,  0,  0,  0,  0, 57,  0, 57,  0, 57,  0,
  0,  0, 41,  0, 57, 57,  0,  0, 46,  0,  0,  0,  0,  0,  0, 57,
 57, 57,  0,  0,  0, 46, 46,  0,  0, 57,  0, 41,  0,  0, 46,  0,
 57, 46,  0, 46,  0,  0,  0,  0,  0, 41,  0, 46, 57,  0,  0,  0,
 57, 57,  0, 57, 46, 57, 57,  0,  0, 41,  0, 46, 57, 46,  0,  0,
 57,  0, 46,  0, 46, 57, 46, 57, 57, 46,  0,  0, 46,  0,  0,  0,
 46,  0, 46,  0,  0, 46, 46, 46, 46, 46, 46,  0,  0, 41,  0,  0,
  0, 46,  0, 57,  0, 46, 57, 46, 46,  0,  0, 46,  0, 57,  0, 57,
  0,  0, 46, 57,  0,  0, 57,  0,  0,  0, 57, 46, 46, 46,  0,  0,
  0,  0, 46,  0, 46,  0, 41,  0, 57,  0, 57,  0,  0,  0, 41,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0, 46, 46,  0,  0,  0,  0, 41,
 41, 46, 41, 41,  0,  0,  0, 41,  0,  0,  0,  0,  0, 41, 41, 57,
 46,  0,  0, 46, 57, 41, 57, 57,  0, 57,  0, 57, 57,  0,  0,  0,
  0,  0,  0, 46,  0,  0, 57,  0, 46,  0, 46, 57, 46, 57,  0, 46,
 46, 57, 57,  0, 46, 57,  0,  0,  0, 57, 57, 46,  0, 46, 46, 57,
  0, 57, 57,  0, 57,  0,  0, 46,  0,  0, 57,  0, 46, 46, 46, 46,
 46, 46, 46, 57, 57,  0, 46,  0,  0,  0,  0,  0, 57, 46, 57,  0,
  0,  0,  0,  0,  0,  0, 46, 46,  0, 46, 57, 57, 46, 46, 57,  0,
  0, 57,  0,  0, 57, 57,  0, 46, 46, 46, 46, 46, 46, 46,  0, 46,
 46, 57, 46, 46, 57,  0, 46,  0, 57,  0, 46,  0, 46, 57,  0,  0,
  0,  0, 57,  0,  0, 41, 57, 41, 41, 46, 57,  0,  0, 46, 46, 46,
 46, 46, 46, 46, 46,  0, 46,  0, 57,  0, 57, 41,  0,  0, 46,  0,
  0,  0,  0, 41,  0,  0,  0,  0,  0, 41,  0, 41, 46,  0,  0, 57,
  0, 46, 46,  0,  0,  0, 46,  0, 46, 41,  0,  0,  0,  0, 57,  0,
  0,  0,  0,  0,  0,  0, 46,  0, 46,  0, 46, 57, 46,  0, 41,  0,
 57, 57,  0, 46, 57, 57,  0,  0,  0, 46, 46,  0,  0,  0,  0,  0,
 46,  0,  0,  0,  0, 57, 41, 46,  0, 46,  0, 41,  0, 46, 46,  0,
 57, 57,  0,  0, 46,  0,  0,  0, 41, 57, 57, 46, 46, 46, 46, 57,
 57,  0, 46,  0,  0,  0,  0,  0, 57,  0, 57,  0,  0,  0,  0, 57,
  0, 46,  0,  0,  0,  0,  0,  0, 46,  0, 41, 46, 57, 57,  0,  0,
 41,  0,  0, 57,  0,  0, 46,  0, 57,  0, 46,  0,  0,  0,  0,  0,
  0,  0,  0, 57,  0, 41,  0,  0,  0,  0, 57, 46,  0, 41, 41, 41,
 57, 46, 57, 46,  0,  0, 57,  0,  0,  0, 46,  0, 46, 41,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 41,  0,  0,  0,  0,  0,  0, 41,
  0,  0,  0, 57,  0, 41,  0, 57, 41,  0, 57,  0, 46, 57,  0,  0,
  0,  0,  0, 57, 57,  0,  0,  0,  0,  0, 41, 57, 57,  0, 57,  0,
 46, 46, 46,  0, 46, 57, 46, 41, 41,  0, 41,  0, 57, 57,  0,  0,
 46,  0, 57,  0, 46,  0,  0,  0,  0,  0,  0, 57, 57,  0, 57, 57,
  0, 57, 46, 46,  0,  0,  0,  0, 46,  0, 57, 57, 57, 46,  0, 46,
 46, 46,  0, 46, 46, 57, 57, 57, 46, 57,  0, 46,  0,  0, 46,  0,
 41,  0,  0,  0, 46, 41,  0, 57,  0, 46,  0, 46,  0,  0,  0, 46,
  0,  0,  0,  0,  0,  0,  0,  0, 46, 41, 46,  0,  0,  0,  0, 46,
  0,  0,  0,  0, 41,  0, 41,  0, 46,  0,  0,  0,  0,  0, 57, 57,
 46, 41, 57, 46, 46,  0, 41,  0, 41, 46, 46,  0,  0, 46, 57, 46,
  0,  0, 46,  0, 46,  0,  0,  0, 46,  0, 46, 57,  0, 57, 57, 46,
  0, 46, 57,  0,  0,  0,  0, 46, 46, 57, 41,  0, 46, 57,  0, 57,
  0, 46,  0,  0, 46, 57, 57,  0, 46, 57, 46, 46, 57, 57, 57, 57,
 46, 57,  0, 57, 46,  0,  0, 57, 57, 57,  0, 41, 41, 57, 46, 41,
  0, 46,  0,  0, 46,  0,  0, 46, 46,  0, 46, 46, 46, 46, 46, 46,
  0, 57, 57, 46, 57, 57,  0, 57, 46,  0,  0, 57, 46,  0, 57, 57,
 46, 57,  0, 46, 46, 57, 57, 41,  0,  0,  0, 46,  0,  0,  0, 46,
  0, 57,  0,  0, 46,  0,  0, 46,  0, 46,  0, 46,  0, 41, 41,  0,
  0, 57, 57, 57, 57, 57, 46, 46, 46, 57,  0,  0, 46,  0, 46, 46,
  0, 46,  0,  0, 46, 46,  0, 57,  0,  0, 46, 46, 46,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0, 46, 57,  0,  0, 57, 46, 46,  0, 57,
  0, 57,  0, 46, 57, 57, 57,  0, 57, 57, 46,  0, 46,  0,  0,  0,
 57,  0,  0, 46,  0,  0, 46, 57,  0, 57, 41,  0,  0,  0,  0, 57,
 46, 57, 57,  0, 46,  0,  0,  0,  0,  0, 46, 46, 46,  0, 46, 46,
 46, 46,  0, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46,
  0,  0,  0, 41,  0,  0,  0, 57, 46,  0,  0, 57, 46, 46,  0,  0,
  0,  0,  0,  0,  0, 46, 46,  0,  0, 57, 41,  0,  0,  0, 57,  0,
  0,  0, 46, 46,  0,  0, 41,  0, 57,  0,  0, 46, 46,  0, 57,  0,
 46,  0, 41,  0,  0,  0,  0,  0, 46, 57, 57, 57,  0,  0,  0,  0,
 46, 46, 46, 46, 46,  0, 46, 46, 46, 46, 46,  0, 46, 57,  0,  0,
 46, 57,  0,  0,  0, 57,  0, 46,  0, 41, 57,  0, 57,  0,  0, 46,
  0,  0,  0, 41, 46,  0, 57,  0, 46,  0,  0,  0, 57, 46,  0, 46,
 46, 46,  0,  0,  0, 46,  0,  0,  0, 57, 46, 41,  0,  0,  0, 41,
 57, 57, 57,  0, 41,  0,  0,  0, 46, 57,  0,  0,  0, 57,  0,  0,
  0, 46,  0, 57, 57,  0, 46,  0,  0,  0, 41, 46, 57, 57, 57, 46,
  0, 46,  0,  0,  0,  0,  0,  0, 46,  0,  0,  0, 46, 46,  0,  0,
  0,  0,  0,  0, 46, 46, 46, 46, 46, 41,  0,  0, 41,  0,  0,  0,
  0, 57,  0,  0,  0,  0,  0,  0, 57,  0,  0,  0, 46, 57,  0,  0,
  0,  0,  0,  0,  0,  0, 46,  0,  0, 41,  0,  0,  0,  0,  0,  0,
  0, 46,  0,  0,  0,  0,  0, 57,  0, 46, 46, 57, 46,  0,  0,  0,
  0, 57,  0, 57,  0,  0, 41,  0,  0, 46,  0, 57, 57, 46,  0, 41,
  0, 46,  0, 46,  0, 57, 46,  0, 46,  0, 57,  0,  0,  0,  0,  0,
  0,  0, 46,  0,  0,  0,  0, 46, 46, 46,  0, 46, 46,  0, 46,  0,
 41,  0,  0,  0, 41,  0,  0, 46,  0, 57,  0,  0, 57,  0,  0,  0,
  0, 57,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 46,
  0,  0, 57,  0, 46,  0,  0,  0, 57, 46, 46, 41, 41, 46,  0, 57,
 41, 46, 41,  0, 57,  0, 41,  0,  0, 57, 46, 41,  0, 57,  0,  0,
 46, 57,  0, 46,  0,  0, 46,  0,  0,  0, 41,  0,  0, 46,  0, 46,
 46,  0,  0, 46,  0, 46, 46,  0,  0,  0,  0,  0, 57,  0, 41,  0,
 46,  0,  0,  0, 41,  0,  0,  0,  0,  0,  0,  0, 57,  0,  0, 46,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 46,  0,  0,  0,
  0, 57,  0, 57, 41,  0,  0, 57, 41,  0, 57,  0,  0,  0, 41, 46,
  0, 57,  0, 41,  0, 41,  0,  0,  0,  0,  0, 46, 57, 41,  0, 41,
  0,  0,  0,  0,  0,  0,  0, 46, 46, 46, 46, 46, 46, 57,  0, 41,
  0, 41,  0, 57,  0,  0,  0,  0, 46, 57, 46,  0,  0,  0, 41,  0,
  0,  0,  0, 41,  0,  0, 46,  0,  0, 57,  0,  0,  0,  0, 46,  0,
  0,  0,  0, 41, 46,  0,  0,  0, 57, 41, 41,  0,  0, 41,  0,  0,
  0,  0, 46,  0, 46,  0,  0,  0,  0, 46, 46, 46,  0,  0, 46,  0,
  0,  0,  0,  0, 57, 46,  0, 57,  0,  0,  0,  0,  0,  0,  0, 57,
  0, 41,  0,  0, 41,  0,  0,  0,  0,  0,  0, 57, 46,  0,  0,  0,
  0,  0,  0,  0, 46,  0, 41,  0, 57, 41, 57,  0,  0,  0, 46, 57,
 57,  0,  0,  0,  0,  0,  0, 46,  0, 46, 41,  0,  0,  0,  0,  0,
  0, 57,  0,  0,  0,  0,  0,  0,  0, 57,  0,  0,  0, 41, 41, 57,
 46,  0,  0, 46,  0, 57,  0,  0,  0,  0,  0,  0, 57, 41,  0,  0,
  0,  0,  0,  0, 57, 41,  0,  0,  0, 57, 41,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0, 41,  0,  0, 41, 57,  0,  0,  0, 57,
  0,  0, 41,  0,  0, 46, 41, 41,  0,  0, 41,  0,  0,  0,  0,  0,
  0, 46,  0,  0,  0,  0, 57, 41,  0,  0, 41,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0, 46,  0, 46,  0,  0,  0, 41,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 46,  0,  0,  0, 46,  0,  0, 41,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 46, 57, 46,
 57, 46,  0,  0, 57, 41,  0,  0,  0,  0, 46, 41, 41,  0, 57, 41,
  0,  0, 46,  0,  0,  0,  0, 41,  0,  0,  0, 46, 46,  0, 46,  0,
  0, 46,  0,  0,  0,  0,  0,  0,  0, 57, 46, 46, 46, 46, 46, 46,
 46, 46, 46,  0,  0,  0,  0,  0,  0,  0, 57, 46, 57, 46,  0,  0,
  0,  0,  0, 57,  0, 46,  0,  0,  0,  0,  0,  0, 46, 46,  0,  0,
  0,  0,  0, 57, 57,  0,  0, 46, 46, 57, 46,  0, 46,  0,  0, 46,
 46, 46,  0,  0, 46, 46, 46,  0,  0,  0, 46,  0,  0,  0,  0,  0,
 46,  0,  0,  0, 46,  0, 46, 57,  0, 46, 46, 57,  0,  0, 46, 46,
 46, 46,  0,  0, 57,  0,  0,  0, 46, 57,  0, 57,  0,  0, 46, 57,
  0,  0,  0,  0, 57,  0,  0,  0,  0, 46,  0,  0,  0, 57, 46,  0,
 46, 46, 46, 46, 46,  0,  0,  0, 46, 46,  0,  0,  0,  0, 57,  0,
 57,  0, 57, 57,  0,  0,  0, 46, 57, 46, 46,  0,  0, 46,  0,  0,
  0,  0, 46, 46,  0, 46,  0, 46, 57,  0, 57,  0, 57,  0, 46,  0,
  0, 46, 46, 46,  0, 46,  0,  0,  0, 46,  0,  0,  0,  0, 46,  0,
  0, 46,  0,  0, 46,  0,  0, 46,  0,  0,  0, 46,  0,  0, 46, 46,
  0,  0,  0,  0,  0,  0,  0, 46, 46, 46,  0,  0, 46,  0, 57,  0,
  0,  0,  0, 46,  0, 41,  0, 57,  0, 46,  0,  0,  0,  0,  0, 41,
 46,  0,  0, 46, 46, 46, 41,  0, 41,  0,  0,  0,  0,  0, 46,  0,
 46,  0,  0,  0, 57,  0, 57,  0, 41,  0,  0, 46, 46, 46, 46,  0,
  0,  0, 57, 46,  0, 46,  0,  0, 46,  0,  0, 46,  0, 57,  0,  0,
  0,  0,  0, 46,  0,  0,  0, 46,  0,  0,  0,  0,  0,  0,  0, 57,
  0,  0, 41,  0,  0,  0,  0,  0, 46,  0,  0, 46, 46, 46,  0, 46,
  0,  0,  0, 57,  0, 46,  0,  0,  0,  0, 57,  0,  0, 46,  0,  0,
 46,  0,  0,  0, 41,  0, 46,  0,  0,  0, 46, 46,  0,  0,  0,  0,
  0, 46, 46, 46,  0,  0,  0,  0,  0,  0,  0, 46,  0,  0,  0,  0,
 57,  0,  0,  0,  0, 46,  0,  0,  0,  0, 46,  0, 41,  0, 46, 41,
  0,  0, 41,  0,  0,  0,  0,  0,  0, 57,  0, 41,  0,  0, 57,  0,
  0,  0,  0, 46,  0, 41,  0,  0,  0,  0, 46,  0,  0,  0,  0,  0,
  0,  0,  0, 46,  0, 46, 46,  0,  0,  0,  0, 46,  0,  0,  0, 41,
  0, 46, 57, 41,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 41, 46,  0,  0,  0, 41,  0,  0, 46,  0, 41, 46,  0,  0,  0,
 57,  0,  0,  0, 46, 46, 41,  0,  0,  0,  0,  0, 57, 57,  0,  0,
  0,  0, 41, 41, 46,  0,  0, 57,  0, 57,  0, 41,  0, 41,  0,  0,
  0, 57, 57, 57, 46, 46,  0,  0, 57, 46,  0, 57, 46,  0, 46,  0,
 57,  0, 57,  0,  0,  0,  0, 57,  0,  0,  0,  0,  0, 46, 57, 57,
  0, 57, 57,  0, 46, 46,  0,  0, 57,  0,  0, 57,  0, 57,  0,  0,
  0,  0, 57,  0,  0,  0, 57, 41,  0,  0,  0,  0, 46,  0, 41,  0,
  0,  0, 46,  0, 46,  0,  0,  0,  0,  0,  0, 57,  0, 46,  0,  0,
  0, 46,  0,  0, 41,  0,  0, 46,  0,  0,  0,  0, 46,  0,  0,  0,
  0, 57, 57,  0,  0, 46, 46,  0,  0, 46,  0,  0,  0,  0, 46, 41,
  0,  0, 46,  0, 57, 57,  0,  0, 46, 57,  0,  0, 41, 41,  0, 57,
  0, 41, 46, 46, 46, 46,  0,  0, 57,  0,  0,  0,  0,  0,  0,  0,
 46, 46,  0, 57, 57, 41,  0,  0, 57, 46,  0,  0, 46, 41, 46,  0,
  0,  0, 46,  0,  0,  0,  0, 41,  0,  0, 46,  0,  0,  0,  0,  0,
 57,  0, 57, 57,  0,  0,  0,  0, 41, 57, 46, 46,  0,  0,  0,  0,
  0, 46,  0,  0,  0, 57,  0,  0,  0,  0, 57, 46,  0,  0,  0,  0,
 46,  0,  0,  0, 46,  0, 57,  0, 41,  0,  0, 41,  0,  0,  0,  0,
  0, 57,  0,  0, 57,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 46, 57,
  0,  0,  0,  0, 41,  0, 46,  0,  0,  0, 41,  0,  0,  0,  0,  0,
  0,  0, 41,  0,  0,  0,  0,  0,  0,  0,  0, 46,  0,  0,  0, 57,
  0, 57,  0, 57,  0,  0, 57, 41,  0,  0,  0, 41,  0,  0,  0, 41,
  0,  0,  0, 41,  0,  0, 41,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 41,  0,  0,  0,  0,  0,  0,  0, 41, 41,  0,  0,  0,  0,  0,
  0,  0, 41,  0,  0,  0,  0,  0,  0,  0, 41,  0,  0, 41,  0,  0,
 41, 46, 46,  0, 46, 46, 46, 46, 46, 46, 46, 46, 46,  0, 46, 46,
 46, 46, 57,  0,  0,  0, 46,  0,  0,  0, 46,  0, 46,  0, 46,  0,
  0,  0,  0, 57,  0, 46, 46,  0,  0,  0,  0, 46,  0,  0,  0, 46,
  0,  0,  0, 46, 41,  0,  0,  0, 41,  0,  0,  0,  0,  0,  0,  0,
 57,  0, 41, 41,  0,  0,  0, 46, 41,  0, 41,  0, 41,  0, 41,  0,
  0,  0,  0, 41,  0,  0, 41, 41, 41,  0,  0, 41,  0, 41,  0, 41,
  0,  0,  0, 41,  0, 41,  0,  0,  0,  0, 41,  0,  0, 41,  0,  0,
  0, 41,  0,  0, 41,  0, 41,  0,  0,  0, 41, 41,  0,  0, 46,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 46,  0,  0,  0,  0,  0,  0,  0,
 41,  0,  0,  0, 41, 41,  0,  0,  0,  0,  0, 41,  0,  0, 41,  0,
 41,  0, 41, 41,  0,  0, 41,  0,  0, 41,  0,  0,  0, 41, 41,  0,
 41, 41, 41, 41,  0, 41,  0,  0,  0, 57,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 41,  0, 41,  0, 46, 46,  0, 41, 41,  0,  0,
  0,  0,  0, 57,  0, 41,  0,  0, 41,  0,  0,  0,  0,  0, 41,  0,
 41, 41,  0, 41, 41, 41, 41,  0, 41,  0, 41,  0,  0,  0,  0,  0,
 41,  0, 41,  0,  0,  0,  0,  0,  0, 41,  0,  0, 41,  0, 41, 41,
  0,  0, 41,  0, 41,  0,  0, 41,  0,  0,  0, 41,  0, 41,  0, 41,
  0,  0, 41,  0,  0,  0, 41,  0,  0,  0,  0, 41, 41,  0,  0,  0,
  0, 41,  0,  0,  0,  0, 41, 41,  0,  0, 41, 41,  0, 41, 41,  0,
  0, 41,  0,  0,  0,  0, 41, 41, 41,  0, 41,  0,  0,  0, 41,  0,
 41, 41, 41,  0, 41,  0,  0, 46,  0,  0,  0,  0,  0,  0, 41,  0,
 41,  0,  0,  0, 41,  0, 41, 41,  0, 41, 41, 41,  0, 41,  0,  0,
 41,  0,  0,  0,  0,  0, 46,  0, 41,  0,  0, 41, 41,  0,  0,  0,
  0,  0,  0, 41,  0,  0,  0,  0,  0, 41,  0,  0,  0,  0,  0,  0,
  0, 41,  0,  0,  0,  0,  0,  0,  0, 41,  0,  0,  0,  0, 41, 41,
  0,  0,  0,  0,  0,  0,  0,  0, 41,  0, 41,  0, 41,  0,  0,  0,
  0,  0,  0,  0,  0,  0, 57,  0,  0,  0,  0,  0, 57,  0,  0, 41,
 41,  0,  0,  0, 41,  0,  0, 41,  0,  0,  0,  0,  0, 41,  0,  0,
 41,  0,  0,  0,  0,  0,  0,  0,  0,  0, 41,  0,  0,  0,  0,  0,
 41,  0, 41, 41,  0,  0, 41,  0,  0,  0, 41,  0,  0,  0,  0,  0,
 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46,  0, 46, 46, 46,
 46,  0, 46, 46, 46, 46, 46, 46, 46, 46, 46,  0, 46, 46, 46, 46,
 46, 46, 46, 46, 46, 46, 46,  0, 46, 46, 46, 46, 46, 46, 46, 46,
  0, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46,
 46, 46, 46, 46, 46, 46, 46, 46, 46, 46,  0, 46, 46, 46, 46, 46,
 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46,
 46, 46, 46, 46, 46, 46, 46, 46, 46,  0, 46, 46, 46, 46, 46, 46,
 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46,  0, 46,
 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46,
 46, 46, 46, 46, 46, 46, 46, 57,  0,  0,  0,  0,  0,  0,  0, 41,
  0, 57,  0,  0,  0,  0, 57, 46, 41, 46, 41,  0, 57,  0,  0,  0,
  0,  0,  0,  0,  0, 57,  0,  0,  0,  0, 57,  0,  0,  0,  0,  0,
  0, 57, 46,  0,  0,  0,  0,  0,  0,  0, 57, 57,  0,  0,  0,  0,
  0,  0,  0, 46,  0,  0,  0,  0, 46, 57, 57,  0,  0,  0,  0,  0,
  0,  0, 57,  0,  0, 46,  0,  0,  0, 46, 57,  0, 57,  0,  0,  0,
  0,  0,  0,  0, 46,  0,  0,  0, 46,  0,  0,  0,  0, 41, 41,  0,
 41, 41, 41,  0,  0,  0,  0, 41, 41, 41, 41, 41, 41,  0,  0, 41,
 41,  0,  0, 41, 41,  0, 41, 41, 41,  0,  0, 41, 41, 41,  0, 41,
 41, 41, 41, 41, 41,  0,  0, 41, 41,  0, 41,  0,  0,  0,  0,  0,
  0, 41,  0, 41,  0,  0,  0,  0,  0,  0, 41,  0, 41,  0, 41,  0,
 41,  0, 41, 41, 41,  0, 41,  0,  0,  0, 41,  0,  0, 41,  0,  0,
  0,  0,  0,  0, 41,  0,  0,  0,  0,  0,  0, 41, 41, 41,  0,  0,
  0,  0,  0,  0, 41, 41,  0, 41, 41,  0, 41,  0,  0, 41,  0,  0,
  0,  0,  0, 41,  0,  0, 41,  0,  0,  0,  0,  0,  0, 46, 46, 46,
  0, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46,
 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46,
 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46,
 46,  0,  0, 46, 46, 46, 46,  0, 46, 46, 46, 46, 46, 46, 46,  0,
 46, 46, 46, 46, 57,  0, 57, 46,  0,  0,  0, 57,  0, 46,  0,  0,
 57,  0,  0, 57, 57, 46, 46, 57,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 46,  0,  0, 46, 57,  0,  0,  0,  0, 57, 46,  0,  0,  0,  0,
  0, 46,  0,  0, 46,  0,  0,  0,  0, 41,  0,  0,  0,  0,  0, 46,
  0,  0,  0, 57,  0,  0,  0,  0, 41,  0,  0,  0,  0,  0,  0,  0,
  0, 46,  0, 57, 46, 46,  0,  0, 46,  0, 57,  0, 46,  0, 57, 46,
  0,  0,  0, 46, 46,  0, 57,  0,  0,  0,  0, 57, 57,  0, 46, 57,
  0, 46,  0,  0,  0,  0, 46, 46,  0,  0, 46, 57,  0, 57, 46, 46,
  0, 41,  0, 57, 46,  0,  0,  0, 57,  0, 46, 46, 46,  0,  0, 57,
  0,  0,  0, 57,  0, 46,  0, 46, 46, 46, 46, 46,  0, 46,  0,  0,
  0,  0,  0,  0,  0, 46,  0,  0,  0, 46, 57,  0, 46,  0,  0, 57,
 41,  0,  0,  0, 46,  0,  0,  0,  0,  0,  0,  0,  0, 46, 57, 46,
  0,  0, 46, 46,  0,  0,  0,  0,  0, 46, 57,  0, 46,  0, 46, 46,
 41, 46,  0,  0,  0, 57,  0,  0,  0, 46, 46,  0,  0, 46,  0,  0,
 46, 46, 57,  0, 57,  0,  0, 57, 57, 57, 57, 46,  0,  0,  0,  0,
  0, 46, 46,  0,  0,  0,  0,  0,  0, 57,  0,  0,  0,  0,  0, 41,
 41,  0,  0,  0,  0,  0, 46,  0,  0, 46,  0,  0, 46, 46,  0, 46,
 46,  0, 46,  0, 57,  0, 57,  0,  0,  0,  0,  0, 46,  0,  0, 46,
  0, 57,  0,  0,  0, 46,  0, 57,  0,  0, 41,  0,  0, 41,  0, 46,
 46,  0,  0,  0, 46,  0,  0,  0,  0,  0,  0,  0, 46,  0, 46,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 41, 57, 57,  0,  0, 46,
  0,  0, 46,  0,  0,  0,  0,  0,  0,  0, 46,  0,  0,  0,  0,  0,
 41,  0,  0,  0,  0,  0,  0,  0,  0,  0, 41, 41, 41, 41, 46,  0,
  0,  0, 41,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 41,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 41,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 41,  0,  0, 41,  0,  0, 41,  0,
  0,  0,  0, 41,  0, 41,  0,  0,  0, 41,  0,  0,  0,  0,  0,  0,
  0,  0, 41, 41, 41, 41,  0,  0,  0,  0,  0, 41, 41, 41, 41, 41,
  0,  0,  0,  0,  0,  0, 41, 41,  0, 41, 41,  0,  0,  0,  0, 41,
  0,  0,  0, 41,  0,  0,  0,  0, 41, 41,  0, 41,  0,  0, 41, 41,
  0,  0,  0,  0, 41, 41,  0,  0,  0, 41,  0,  0,  0, 41, 41,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 41,  0, 41,
  0,  0, 41,  0,  0,  0, 46, 46, 46, 46,  0, 46, 46, 46, 46, 46,
 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46,
  0, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46,  0, 46, 46, 46,
 46, 46,  0, 46, 46, 46, 46, 46, 46, 46, 46, 57, 57,  0, 46, 46,
  0,  0,  0, 57,  0,  0, 41,  0, 57, 46,  0, 46,  0, 41,  0, 41,
 57, 57, 41,  0,  0,  0, 46,  0,  0, 46,  0,  0,  0, 46, 46,  0,
  0, 46, 57,  0, 46, 57,  0, 46, 46,  0,  0,  0,  0,  0, 57,  0,
 46, 57,  0, 46, 57, 46,  0,  0, 46, 46,  0, 46, 46, 46, 46, 46,
  0,  0, 46,  0, 46, 46, 57,  0, 46, 46, 57, 57,  0, 57, 46,  0,
 57,  0, 41, 46,  0,  0,  0, 57, 46, 57,  0,  0,  0, 57,  0,  0,
 57, 57, 57, 57, 46, 57, 57,  0, 41, 46, 46, 57,  0, 57,  0, 57,
 57, 57, 46,  0, 57, 41, 46, 57,  0, 41, 57, 46,  0, 57, 57, 57,
 57, 57, 57, 41,  0,  0, 46,  0,  0,  0,  0,  0,  0, 46, 57, 46,
  0, 41, 41,  0,  0, 57, 46,  0, 57,  0,  0, 46, 57,  0, 57,  0,
  0, 57, 57,  0, 46,  0,  0, 57,  0,  0, 41, 41,  0, 57, 41, 46,
 57, 57, 46, 57, 41, 41,  0, 46, 46, 41,  0, 46, 41, 41, 41,  0,
 41, 41, 46, 57,  0, 46,  0,  0, 46, 41,  0,  0,  0, 57, 57, 41,
  0,  0, 41,  0, 46, 57,  0, 41, 41,  0, 41,  0, 41, 57,  0, 57,
 57, 41, 57, 57, 41,  0,  0, 41, 57,  0, 41, 46,  0,  0,  0, 41,
  0, 57,  0, 46,  0, 57,  0, 46,  0, 57,  0, 46,  0, 46,  0,  0,
  0, 46, 57, 57,  0,  0, 57,  0, 41,  0, 57,  0, 46,  0, 46, 57,
 57, 57,  0, 46, 46, 57, 46,  0, 57, 46, 46, 46,  0,  0, 46,  0,
  0, 57,  0,  0, 46, 46,  0, 46,  0,  0, 57,  0,  0,  0, 46, 46,
 46, 46,  0, 46,  0,  0,  0, 46,  0,  0,  0, 46, 46, 46, 41,  0,
  0, 57, 46,  0,  0,  0, 46, 46, 57,  0,  0, 46,  0, 57,  0, 46,
  0,  0,  0,  0, 46, 41,  0,  0, 46,  0,  0,  0,  0, 57, 46,  0,
  0,  0, 57,  0, 46,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 41,  0,  0, 41,  0,  0,  0, 57,  0,  0,  0,  0, 46,  0,
  0,  0, 46, 46,  0,  0,  0, 41,  0,  0,  0,  0,  0, 41,  0, 46,
  0, 46, 41,  0,  0,  0,  0,  0,  0, 46,  0,  0,  0,  0,  0,  0,
  0,  0,  0, 46,  0,  0, 46,  0,  0, 57, 57, 57, 57, 57, 57, 46,
 46,  0, 57,  0,  0,  0,  0, 46,  0,  0, 46,  0,  0, 46, 46,  0,
  0, 46, 57, 46, 46, 46,  0,  0,  0, 57, 57,  0, 57,  0, 46, 46,
 46, 46, 46,  0, 46, 57, 46, 57, 57, 46,  0,  0,  0, 46, 46, 46,
  0,  0,  0,  0,  0, 46,  0, 57,  0, 57,  0, 57, 46, 57,  0,  0,
 46, 46, 57,  0,  0,  0,  0,  0,  0,  0, 46, 46, 41,  0,  0,  0,
  0,  0, 46, 46,  0,  0,  0,  0,  0,  0, 46, 41, 41, 46, 57, 57,
  0, 41,  0,  0, 57, 57,  0,  0,  0,  0, 46,  0,  0,  0,  0,  0,
 41,  0,  0,  0,  0,  0,  0, 57,  0, 57, 46, 41, 57, 57, 57, 57,
 41, 57,  0,  0,  0,  0,  0, 41, 41,  0,  0,  0, 57, 41,  0,  0,
  0,  0,  0, 41,  0,  0,  0, 41,  0,  0, 41,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 41,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 41,  0,  0,
 41, 41, 41,  0,  0,  0,  0, 41,  0,  0,  0,  0,  0,  0, 41,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 41,  0,  0,  0,  0,  0, 41,  0,  0,  0,  0, 41,
 41,  0,  0,  0,  0, 41,  0,  0,  0, 41,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0, 41,  0,  0,  0, 41,  0,  0, 41,  0,
  0,  0, 41,  0, 41, 41, 41,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 46,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 41,  0,  0, 41,  0, 41,  0,  0,  0,  0,  0,  0,  0,  0, 46,  0,
  0, 41,  0, 41,  0,  0, 41,  0, 41,  0,  0,  0, 41,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 46,  0,
  0,  0,  0, 41,  0,  0, 41, 41,  0, 41,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 46,  0,  0,  0, 41,  0,  0, 41,
  0,  0, 41,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 41,  0,  0,  0,  0,  0, 41,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 41,  0,  0,  0, 41,  0,  0,  0,
  0,  0,  0,  0, 41,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 41,  0,  0,  0,  0,  0,  0,  0, 41,  0, 41,  0,  0,  0, 41, 41,
 41, 41, 41,  0, 41,  0, 41,  0, 41,  0,  0, 41,  0,  0, 41, 41,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 46,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 41,  0, 41, 41,  0, 41,  0,  0,
  0,  0,  0,  0, 41,  0,  0,  0,  0,  0,  0, 41,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 46,  0,  0,  0, 41,  0,
  0,  0,  0,  0,  0, 41,  0,  0,  0,  0,  0,  0, 41,  0, 41,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 41,  0,  0, 46,
  0,  0,  0,  0, 41,  0, 41,  0,  0,  0, 41,  0,  0,  0,  0,  0,
  0,  0,  0, 41,  0,  0,  0, 41,  0,  0,  0,  0, 41, 41,  0,  0,
 41,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0, 41,  0,  0,  0,  0,  0,  0, 46,  0,  0,  0,  0,  0,
  0, 41,  0,  0,  0,  0, 46,  0,  0,  0,  0,  0,  0,  0, 41,  0,
  0, 41,  0,  0, 41,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0, 41,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 41,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 41,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 41,  0,  0,  0,  0,  0, 41,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 41,  0,  0, 41,  0,  0,  0,  0,  0, 46,  0,
  0,  0,  0,  0, 41,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 41, 41,  0,  0,  0,  0,  0,  0,  0,  0, 41,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 46,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 41,  0, 41,
  0,  0,  0,  0,  0, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46,
 46,  0, 46, 46, 46, 46,  0, 46,  0, 46, 46, 46, 46, 46, 46, 46,
 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46,
 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46,
 46, 46, 46, 46, 46, 46, 46,  0, 46, 46, 46, 46, 46, 46, 46,  0,
 46, 46, 46,  0,  0, 46, 46, 46, 46, 46,  0, 46, 46, 46, 46, 46,
 46, 46, 46, 46, 46, 46,  0, 46, 46, 46, 46, 46, 46, 46, 46, 46,
 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46,  0, 46, 46, 46, 46,
 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46,
 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46,  0, 46, 46, 46,
  0, 46, 46, 46, 46, 46, 46,  0, 46, 46, 46, 46, 46, 46, 46, 46,
 46, 46, 46,  0, 46, 46, 46, 46, 46, 46, 46, 46, 46,  0, 46, 46,
 46, 46, 46,  0, 46, 46, 46, 46,  0, 46, 46,  0, 46, 46, 46, 46,
 46, 46, 46, 46, 46,  0, 46, 46, 46, 46,  0, 46, 46, 46, 46, 46,
  0, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46,  0, 46,
 46, 46, 46, 46,  0,  0, 46, 41,  0,  0,  0,  0,  0,  0,  0, 46,
 41,  0,  0, 41,  0,  0,  0,  0,  0, 41,  0, 41,  0,  0,  0, 41,
  0, 41, 41, 41, 41,  0,  0,  0, 41,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0, 41, 41, 41,  0,  0, 41,  0,  0,  0,  0, 41,  0,  0,
  0, 41,  0,  0,  0,  0,  0,  0,  0,  0,  0, 41, 41,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0, 41,  0,  0, 41,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 41, 41, 41,  0,  0,  0,  0,  0, 41,  0,  0,  0,
  0, 41, 41,  0,  0,  0,  0,  0, 46, 46, 46, 46,  0, 46, 46, 46,
 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46,  0,
 46, 46, 46, 46, 46, 46, 46,  0, 46, 46, 46, 46, 46, 46, 46, 46,
 46, 46, 46,  0, 46, 46, 46, 46,  0, 46, 46,  0, 57, 46,  0, 46,
  0, 57, 46,  0,  0,  0,  0,  0,  0,  0, 57,  0,  0,  0, 57,  0,
  0, 46, 57, 46, 46, 46, 46,  0,  0,  0,  0, 57, 46, 46,  0, 57,
 57,  0, 57,  0, 57, 46, 46, 46, 46, 46,  0, 57, 57, 57,  0,  0,
 57,  0,  0,  0, 46, 46,  0,  0,  0,  0,  0, 57, 41, 41, 41, 57,
  0, 46, 57, 41, 57,  0,  0, 46, 46, 46, 57,  0, 46,  0,  0,  0,
 41,  0, 46, 41, 46, 57, 57, 57, 41,  0,  0,  0,  0, 41,  0,  0,
  0,  0,  0,  0,  0, 57, 57,  0, 46,  0, 41, 57,  0, 57, 41, 46,
 46,  0,  0,  0, 57, 41,  0, 46, 57, 57,  0, 41, 57,  0,  0,  0,
  0,  0,  0, 41,  0,  0,  0, 57, 41,  0, 41,  0,  0,  0,  0,  0,
 46, 41,  0, 46,  0,  0, 46, 41,  0, 46,  0, 41, 46, 46, 46,  0,
 57, 57,  0,  0, 57, 57, 57, 57,  0, 57,  0, 41, 57, 57, 57, 46,
  0,  0, 46,  0,  0, 57, 41,  0,  0, 41,  0, 41, 41,  0,  0,  0,
 46,  0, 41, 41,  0,  0,  0,  0, 57, 57, 57,  0,  0,  0,  0, 57,
 41,  0, 41, 46,  0,  0, 57, 57,  0, 57,  0, 41,  0,  0, 46,  0,
 57, 46,  0,  0, 46,  0, 57, 57, 46, 46,  0,  0,  0, 46, 46, 46,
  0, 41,  0, 57,  0,  0, 57,  0,  0, 41,  0,  0, 57,  0, 57,  0,
  0,  0,  0,  0,  0,  0,  0, 41,  0,  0, 46,  0,  0, 46,  0,  0,
 57,  0, 57,  0,  0,  0,  0,  0, 46, 57,  0,  0,  0, 41, 46,  0,
  0,  0, 41,  0, 41,  0,  0,  0, 41,  0,  0,  0,  0,  0,  0,  0,
  0, 41, 46, 46,  0,  0, 57,  0,  0, 46,  0, 46, 41,  0, 57,  0,
 46, 57, 57,  0,  0, 46,  0,  0,  0, 57,  0,  0,  0, 41,  0,  0,
  0,  0,  0, 46, 57,  0, 46, 41,  0,  0, 41,  0, 46,  0,  0,  0,
  0,  0,  0,  0,  0, 46,  0,  0,  0,  0,  0, 57,  0, 57,  0, 41,
  0, 46, 46,  0, 46,  0,  0,  0, 46,  0,  0,  0,  0,  0,  0,  0,
 57,  0,  0, 46,  0,  0,  0,  0, 41,  0,  0, 57,  0, 57,  0, 46,
  0,  0, 46,  0, 46,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0, 41,  0,  0,  0,  0, 41,  0,  0,  0,  0,
  0,  0,  0, 41,  0,  0,  0,  0,  0,  0,  0,  0, 41,  0,  0,  0,
  0,  0,  0,  0,  0,  0, 46, 46,  0, 46, 46, 46, 46, 46,  0,  0,
  0,  0,  0, 57,  0, 46, 57,  0,  0,  0,  0, 41,  0,  0,  0, 41,
 41, 41, 41, 41,  0, 41, 41,  0, 41,  0, 41,  0, 41,  0,  0,  0,
 41, 41, 41, 41,  0,  0,  0, 41, 41,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 41,  0,  0,
 41,  0,  0,  0,  0,  0,  0,  0, 41, 41,  0, 41,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0, 41,  0,  0,  0,  0,  0, 41, 41, 41,  0,
  0,  0,  0,  0, 41,  0,  0,  0, 41,  0, 41,  0,  0,  0, 41,  0,
  0,  0,  0,  0,  0, 41,  0, 41,  0,  0,  0, 41,  0,  0,  0, 41,
  0,  0,  0,  0,  0, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46,
 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46,  0, 46, 46,  0, 46,
 46, 46,  0, 46, 46,  0, 46, 46, 46,  0, 46, 46, 46, 46, 46, 46,
 46, 46, 46,  0, 46, 46, 46, 46, 41,  0,  0,  0,  0,  0,  0, 41,
  0, 41,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 41,  0,  0, 41,  0,  0,  0,  0,  0,  0, 46,  0,
  0, 46, 46, 46,  0, 46,  0,  0, 46, 46, 46, 41, 41,  0, 46, 57,
  0, 41, 41,  0,  0,  0,  0, 46, 46,  0,  0,  0,  0, 41, 41, 41,
  0,  0,  0,  0, 41,  0,  0,  0,  0,  0,  0,  0, 41, 41, 41,  0,
  0,  0,  0, 41,  0,  0,  0,  0,  0, 41, 41,  0, 41, 46,  0,  0,
 57,  0,  0, 41,  0,  0,  0,  0, 41,  0,  0,  0,  0,  0, 41,  0,
 41,  0,  0,  0,  0,  0,  0,  0, 41,  0,  0,  0,  0,  0, 46,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 41,  0,  0,  0, 41,  0, 41, 41, 41,  0,  0,
  0, 41, 41,  0, 57, 46,  0, 41,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0, 46,  0, 46,  0, 46, 46, 46, 46, 46, 46, 46, 46, 46,
 46, 46, 46,  0, 46, 46, 46, 46,  0,  0, 46,  0, 46, 46,  0, 46,
 46, 46,  0,  0, 46, 46, 46, 46, 46,  0, 46, 46,  0, 46,  0, 46,
 46, 46, 46, 46, 46, 46, 57, 46, 46, 57,  0,  0,  0, 41,  0,  0,
  0,  0,  0,  0,  0, 57,  0,  0, 57,  0,  0,  0, 41, 41, 41,  0,
  0, 41,  0, 41, 41,  0,  0,  0,  0, 41,  0,  0,  0,  0,  0,  0,
  0, 41,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 41, 41, 41,  0,  0, 41,  0,  0,  0, 41,  0,  0,  0, 41,  0, 41,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 41,  0,  0,
  0, 41,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 41,
  0, 41,  0,  0,  0,  0,  0,  0, 41,  0,  0,  0,  0,  0, 41, 41,
  0,  0,  0,  0,  0,  0,  0,  0,  0, 41,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 41,  0,  0,  0,  0,
 41,  0,  0,  0,  0,  0, 41, 41,  0,  0,  0,  0,  0,  0,  0,  0,
 41,  0,  0, 41,  0, 41,  0,  0,  0,  0,  0,  0,  0, 41,  0,  0,
  0,  0,  0,  0,  0, 41,  0, 41,  0,  0, 41, 41,  0,  0,  0, 41,
  0,  0, 41,  0,  0, 41,  0,  0,  0, 41, 41,  0, 46, 46, 46, 46,
 46, 46,  0, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46,
 46, 46, 46,  0, 46, 46, 46, 46, 46,  0, 46, 46, 46,  0,  0, 46,
 46, 46, 46, 46,  0,  0, 46, 46, 46,  0, 46, 46, 46, 46, 46, 46,
 46, 46, 46, 46, 46, 46,  0, 46, 57,  0,  0,  0,  0,  0,  0,  0,
 46, 46,  0,  0,  0,  0, 46, 46, 57,  0, 46,  0, 46,  0,  0,  0,
 46, 46, 46,  0,  0, 46,  0,  0,  0,  0,  0, 46, 46,  0,  0,  0,
  0, 46,  0, 57, 41,  0,  0,  0, 57,  0,  0,  0,  0,  0,  0, 46,
  0, 46,  0,  0,  0, 41, 46,  0,  0,  0,  0, 46,  0, 46, 41, 46,
  0,  0,  0,  0,  0,  0,  0,  0,  0, 46,  0, 46,  0,  0,  0,  0,
  0,  0,  0, 46,  0,  0,  0,  0, 46,  0,  0,  0,  0,  0,  0, 46,
  0,  0,  0, 46,  0,  0,  0,  0,  0,  0, 41,  0,  0,  0,  0, 46,
  0,  0,  0, 46,  0,  0,  0, 41,  0,  0, 41,  0,  0,  0,  0, 46,
  0, 41, 46,  0,  0,  0,  0,  0,  0,  0,  0, 46, 57,  0,  0,  0,
  0, 57, 57, 57, 57, 57,  0, 46, 46, 46,  0,  0,  0, 46,  0, 57,
  0, 46,  0,  0, 57,  0,  0,  0,  0,  0, 41,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 41,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 41,  0,
  0, 41,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 41,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 41,  0,  0, 41,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0, 41,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0, 41,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 41,  0,  0,  0, 41,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 41,  0,  0,
 41,  0, 41,  0,  0, 41,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 41,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 41,  0,  0,  0,  0,  0,  0,  0,  0, 41,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0, 41,  0, 41,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0, 41,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 46,  0,  0, 46,
  0, 46, 46,  0,  0, 46, 46, 46, 46,  0,  0, 46,  0, 46, 46,  0,
 46, 46, 46,  0, 46, 46,  0,  0,  0,  0, 46, 46, 46,  0, 46, 46,
 46, 46, 46, 46, 46, 46, 46, 46, 46, 46,  0, 46,  0, 46, 46,  0,
 46, 46, 46, 46, 46, 46, 46, 46, 46,  0, 46, 46, 46, 46,  0,  0,
  0,  0,  0, 46, 46, 46, 46, 46,  0,  0, 46, 46, 46, 46, 46, 46,
 46,  0,  0, 46, 46, 46, 46, 46, 46, 46,  0,  0, 46, 46, 46, 46,
  0,  0, 46,  0,  0, 41,  0, 41,  0, 41,  0,  0,  0,  0,  0,  0,
  0,  0,  0, 41, 41,  0, 41,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0, 41,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 41,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0, 41,  0, 41,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 41,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 41,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 41,  0,  0,
 41, 41,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 41,  0,  0,  0,
  0,  0, 41,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0, 41,  0,  0,  0,  0,  0, 41,
  0,  0,  0,  0, 41,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 41,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0, 41,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 41,  0,  0,  0,  0,  0, 41, 41, 41,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 41,  0,  0,  0, 41, 46,
 46, 46, 46, 46,  0, 46, 46,  0, 46, 46, 46, 46, 46, 46,  0, 46,
  0, 46, 46, 46,  0, 46, 46, 46, 46, 46, 46,  0,  0, 46, 46, 46,
  0, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46,  0, 46, 46,
  0, 46,  0,  0,  0, 46,  0, 46, 46,  0, 46, 46, 46,  0, 46,  0,
  0,  0,  0, 46, 46,  0, 46, 46, 46, 46, 46, 46, 46, 46,  0,  0,
 46, 46,  0, 46,  0, 41,  0,  0,  0, 41,  0,  0,  0, 41, 46, 57,
  0,  0, 46,  0,  0,  0,  0, 46, 46,  0,  0, 46,  0,  0,  0,  0,
  0,  0, 57, 57,  0,  0,  0, 41,  0,  0,  0,  0,  0, 57,  0, 57,
  0,  0,  0,  0,  0, 41, 46,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 57, 41,  0,  0, 46,  0,  0, 57,  0, 46, 57,  0,
  0,  0,  0, 41, 46,  0,  0,  0,  0, 46,  0,  0,  0, 57, 57, 46,
  0, 57,  0,  0, 57,  0,  0,  0, 57,  0,  0, 57, 57, 46, 41, 46,
 46,  0, 46,  0,  0, 46,  0, 46, 41, 46, 46,  0,  0,  0,  0, 46,
  0,  0,  0,  0, 41,  0,  0,  0,  0, 46,  0, 46, 46,  0, 46,  0,
  0,  0,  0,  0,  0,  0,  0, 41, 41,  0,  0, 46,  0, 46, 57,  0,
 46,  0,  0, 57,  0,  0,  0, 46,  0, 46,  0,  0,  0,  0,  0,  0,
 57,  0, 46,  0,  0,  0,  0,  0,  0,  0,  0,  0, 46,  0,  0, 46,
  0,  0,  0,  0,  0,  0,  0, 46,  0, 46,  0, 57,  0, 46, 46,  0,
  0,  0,  0,  0, 46,  0,  0,  0,  0,  0, 41, 41,  0,  0, 41,  0,
 46, 46, 41,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 41,
  0, 41,  0,  0,  0,  0,  0, 41,  0,  0, 41,  0, 41,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0, 41,  0,  0,  0,  0,  0,  0,  0, 46,
 46,  0,  0, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 41,  0,  0,
 41,  0,  0,  0,  0, 41,  0,  0,  0, 46, 46, 46, 41,  0,  0, 46,
 46,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,
 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,
 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 57, 57, 41, 57,  0, 57, 41,
};
