/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/. 
 */

#ifndef __GTK_OLD_EDITABLE_H__
#define __GTK_OLD_EDITABLE_H__


#include <gdk/gdk.h>
#include <gtk/gtkeditable.h>
#include <gtk/gtkwidget.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define GTK_TYPE_OLD_EDITABLE            (gtk_old_editable_get_type ())
#define GTK_OLD_EDITABLE(obj)            (GTK_CHECK_CAST ((obj), GTK_TYPE_OLD_EDITABLE, GtkOldEditable))
#define GTK_OLD_EDITABLE_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), GTK_TYPE_OLD_EDITABLE, GtkOldEditableClass))
#define GTK_IS_OLD_EDITABLE(obj)         (GTK_CHECK_TYPE ((obj), GTK_TYPE_OLD_EDITABLE))
#define GTK_IS_OLD_EDITABLE_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GTK_TYPE_OLD_EDITABLE))
#define GTK_OLD_EDITABLE_GET_CLASS(obj)  (GTK_CHECK_GET_CLASS ((obj), GTK_TYPE_OLD_EDITABLE, GtkOldEditableClass))


typedef struct _GtkOldEditable       GtkOldEditable;
typedef struct _GtkOldEditableClass  GtkOldEditableClass;

typedef void (*GtkTextFunction) (GtkOldEditable  *editable, guint32 time);

struct _GtkOldEditable
{
  GtkWidget widget;

  /*< public >*/
  guint      current_pos;

  guint      selection_start_pos;
  guint      selection_end_pos;
  guint      has_selection : 1;

  /*< private >*/
  guint      editable : 1;
  guint      visible : 1;
  GdkIC     *ic;
  GdkICAttr *ic_attr;
  
  gchar *clipboard_text;
};

struct _GtkOldEditableClass
{
  GtkWidgetClass parent_class;
  
  /* Signals for notification/filtering of changes */
  void (* changed)      (GtkOldEditable    *editable);
  void (* insert_text)  (GtkOldEditable    *editable,
			 const gchar       *text,
			 gint               length,
			 gint              *position);
  void (* delete_text)  (GtkOldEditable    *editable,
			 gint               start_pos,
			 gint               end_pos);

  /* Bindings actions */
  void (* activate)        (GtkOldEditable *editable);
  void (* set_editable)    (GtkOldEditable *editable,
			    gboolean	    is_editable);
  void (* move_cursor)     (GtkOldEditable *editable,
			    gint            x,
			    gint            y);
  void (* move_word)       (GtkOldEditable *editable,
			    gint            n);
  void (* move_page)       (GtkOldEditable *editable,
			    gint            x,
			    gint            y);
  void (* move_to_row)     (GtkOldEditable *editable,
			    gint            row);
  void (* move_to_column)  (GtkOldEditable *editable,
			    gint            row);
  void (* kill_char)       (GtkOldEditable *editable,
			    gint            direction);
  void (* kill_word)       (GtkOldEditable *editable,
			    gint            direction);
  void (* kill_line)       (GtkOldEditable *editable,
			    gint            direction);
  void (* cut_clipboard)   (GtkOldEditable *editable);
  void (* copy_clipboard)  (GtkOldEditable *editable);
  void (* paste_clipboard) (GtkOldEditable *editable);

  /* Virtual functions. get_chars is in paricular not a signal because
   * it returns malloced memory. The others are not signals because
   * they would not be particularly useful as such. (All changes to
   * selection and position do not go through these functions)
   */
  void (* update_text)  (GtkOldEditable  *editable,
			 gint             start_pos,
			 gint             end_pos);
  gchar* (* get_chars)  (GtkOldEditable  *editable,
			 gint             start_pos,
			 gint             end_pos);
  void (* set_selection)(GtkOldEditable  *editable,
			 gint             start_pos,
			 gint             end_pos);
  void (* set_position) (GtkOldEditable  *editable,
			 gint             position);
};

GtkType    gtk_old_editable_get_type        (void) G_GNUC_CONST;
void       gtk_old_editable_claim_selection (GtkOldEditable *old_editable,
					     gboolean        claim,
					     guint32         time);
void       gtk_old_editable_changed         (GtkOldEditable *old_editable);

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GTK_OLD_EDITABLE_H__ */
