/*
   Support for X resource database management.
   fotang@yahoo.com, 15Apr99.
 */

#ifndef _gtk_xrm_H
#define _gtk_xrm_H

#include <gtk/gtk.h>
#include <X11/Xlib.h>
#include <X11/Xresource.h>      /* XrmOptionDescRec */
#include <sys/types.h>          /* size_t */

typedef XrmOptionDescRec GTK_CMD_OPT;
typedef enum
{
  GTK_NONE,
  GTK_BOOL, GTK_SHORT, GTK_INT, GTK_LONG,
  GTK_FLOAT, GTK_DOUBLE, GTK_STRING
}
GTK_RESOURCE_TYPE;
typedef struct
{
  char *str_name;
  char *str_class;
  GTK_RESOURCE_TYPE type;
  void *buf;                    /* result will be stored here */
  char *defval;
  size_t size;                  /* size of buf if type is GTK_STRING */
}
GTK_resource;

extern int gtk_initialize(int *argc, char **argv,
                          const char *app_class_name,
                          GTK_CMD_OPT * cmd_opt,
                          size_t cmd_opt_count);
extern char *gtk_get_app_resource(const char *str_name,
                                  const char *str_class,
                                  GTK_RESOURCE_TYPE type,
                                  const char *str_default_val,
                                  void *buf,
                                  size_t size);
extern void gtk_get_app_resources(GTK_resource * table,
                                  size_t table_size);

#endif /* #ifndef _gtk_xrm_H */
