/*
   # Example of how to customarize a gtk app using X resources.
   # Corrections to fotang@techie.com.
   #
   gcc -Wall -c gtkxrm.c -o gtkxrm.o
   gcc -Wall `gtk-config --cflags` `gtk-config --libs` gtkxrm.o demo.c -o demo 

   cat <<EOF >> ~/.Xdefaults

   demo*Timeout:1500
   demo.MaxGoto:10
   demo.Debug:yes
   demo.Button*Pixmap:demo.xpm
EOF
   xrdb -merge ~/.Xdefaults
   ./demo [-cc <char>] [-debug] [-max <val>] <filename>

 */
#include <stdio.h>
#include "gtkxrm.h"

int main(int argc, char *argv[])
{
  int debug;                    /* can be set via command line or via resources */
  int timeout;                  /* can only be set via resources */
  short max_go;                 /* can be set via command line or via resources */
  char Cmdchar[3],              /* can be set thru command line or via resources */
       OpChar[3];               /* can only be set via resources */
  char *rcfile;                 /* can only be set via resources */
  int i;

  /* some command line options */
  GTK_CMD_OPT cmd_opt[] =
  {
    {"-cc", "*.CommandCharacter", XrmoptionSepArg, 0},
    {"-debug", ".Debug", XrmoptionNoArg, "True"},
    {"-max", "*.MaxGoto", XrmoptionSepArg, 0}
  };
  /* a table of resource entries */
  GTK_resource res[] =
  {
    {"Tooltip.timeout", "NumCLASS", GTK_INT, &timeout, "800"},
    {"MaxGoto", "NumCLASS", GTK_SHORT, &max_go, "5"},
    {"CommandCharacter", "charCLASS", GTK_STRING, Cmdchar, "?", 2},
    {"OpCharacter", "charCLASS", GTK_STRING, OpChar, "%", 2},
    {"Debug", "boolCLASS", GTK_BOOL, &debug, "0"}
  };

  gtk_init(&argc, &argv);

  puts("\narguments before gtk_initialize:");
  i = argc;
  while (i-- > 0)
    printf("\t%d. %s\n", i, argv[i]);
  puts("\n");
  /* initialize resource database and parse command line args */
  gtk_initialize(&argc, argv,
                 "Demo",           /* app. class name */
                 cmd_opt,
                 sizeof(cmd_opt) / sizeof(GTK_CMD_OPT));

  puts("\narguments after gtk_initialize:");
  i = argc;
  while (i-- > 0)
    printf("\t%d. %s\n", argc, argv[i]);
  /* read the specified application resources */
  gtk_get_app_resources(res, sizeof(res) / sizeof(GTK_resource));
  puts("\n");
  printf("timeout      = %d\n", timeout);
  printf("mak_go       = %d\n", max_go);
  printf("debug        = %d\n", debug);
  printf("cmdchar      = %c\n", Cmdchar[0]);
  printf("opchar       = %c\n", OpChar[0]);
  printf("pixmap       = %s\n\n", gtk_get_app_resource(
                                                        "Button.Exit.Pixmap",
                                                    "PixmapClass", GTK_NONE,
                                                        "any.xpm", NULL, 0));
  rcfile = gtk_get_app_resource("rcFile",
                                "StringCLASS",
                                GTK_NONE,
                                "/home/tano/.demo/demorc", 0, 0);
  printf("rc file       = %s\n\n", rcfile);
  gtk_rc_parse(rcfile);
  if (argc == 1)
  {
    fprintf(stderr, "Missing file name\nUsage:"
            "%s [-cc <char>] [-debug] [-max <val>] <filename>\n", argv[0]);
    exit(-1);
  }
  puts("all done");
  return (0);
}
