#include <gdk/gdk.h>
#include <gdk/gdkprivate.h>
#include <X11/Xlib.h>
#include "gdk_bitmap_create_from_pixmap.h"


GdkBitmap *
gdk_bitmap_create_from_pixmap (GdkWindow *window,
			       GdkColor *transparent_color,
			       GdkPixmap *pixmap)
{
  GdkPixmap *bitmap;
  GdkWindowPrivate *pixmap_private;
  GdkWindowPrivate *window_private;
  GdkColormapPrivate *colormap_private;
  GdkVisual *visual;
  GdkColor color;
  XImage *ximage;
  gchar *data;

  g_return_val_if_fail (pixmap != NULL, NULL);

  if (window == NULL)
    window = (GdkWindow *) &gdk_root_parent;

  window_private = (GdkWindowPrivate *) window;
  if (window_private->destroyed)
    return NULL;

  pixmap_private = (GdkWindowPrivate *) pixmap;
  if (pixmap_private->destroyed)
    return NULL;

  if (transparent_color == NULL)
    {
      gdk_color_white (window_private->colormap, &color);
      transparent_color = &color;
    }

  ximage = XGetImage (pixmap_private->xdisplay,
		      pixmap_private->xwindow,
		      0, 0,
		      pixmap_private->width, pixmap_private->height,
		      AllPlanes, ZPixmap);

  colormap_private = (GdkColormapPrivate *) window_private->colormap;
  visual = colormap_private->visual;  
  
  transparent_color->pixel =
    (((transparent_color->red >> (16 - visual->red_prec))
      << visual->red_shift)
     + ((transparent_color->green >> (16 - visual->green_prec))
	<< visual->green_shift)
     + ((transparent_color->blue >> (16 - visual->blue_prec))
	<< visual->blue_shift));


  {
    gint x, y, len, i, mask;
    
    len = ((pixmap_private->width + 7) / 8);
    data = g_malloc (len * pixmap_private->height);

    i = 0;
    for (y = 0; y < pixmap_private->height; y++)
      {
	for (x = 0; x < pixmap_private->width; x++)
	  {
	    mask = 1 << x % 8;
	    
/* FIXME: This is slow. */
	    if (XGetPixel (ximage, x, y) != transparent_color->pixel)
	      data[i + x / 8] |= mask;
	    else
	      data[i + x / 8] &= ~mask;
	  }
	
	i += len;
      }
  }
    
  bitmap = gdk_bitmap_create_from_data (window,
					data,
					pixmap_private->width,
					pixmap_private->height);
  g_free (data);

  return bitmap;
}  
