# Spec file for building GToolKit RPM packages
# Copyright (c) 2000  Elmar Ludwig

%define name	gtoolkit
%define version	0.9.4
%define release	1
%define prefix	/usr

Summary:	GToolKit - Objective-C interface to the GIMP Toolkit
Name:		%{name}
Version:	%{version}
Release:	%{release}
Copyright:	LGPL
Group:		Development/Libraries
Packager:	Elmar Ludwig <elmar@informatik.uni-osnabrueck.de>
URL:		http://www.inf.uos.de/elmar/projects/%{name}/
Source:		ftp://ftp.inf.uos.de/pub/elmar/gtk/objc-%{name}/%{name}-%{version}.tar.gz
BuildRoot:	%{_tmppath}/%{name}-%{version}-root

%description
GToolKit is a (relatively) small library that implements a simple and easy
to use Objective-C interface to the GTK+ widget set. GTK+, which stands for
The Gimp Toolkit, is a library for creating graphical user interfaces for
the X Window System and MS Win32. Development libs, headers and docs are in
%{name}-devel.

%package	devel
Summary:        GToolKit - static library, header files and documentation
Group:		Development/Libraries
Requires:	%{name} = %{version}

%description	devel
Static library, header files and documentation required for compiling
programs using the GToolKit library.

%prep
%setup -q

%build
./configure --prefix=%{prefix} && make -C GToolKit

%install
rm -rf $RPM_BUILD_ROOT
make -C GToolKit prefix=$RPM_BUILD_ROOT%{prefix} install
strip --strip-unneeded $RPM_BUILD_ROOT%{prefix}/lib/libGToolKit-1.2.so.*.*

%clean
rm -rf $RPM_BUILD_ROOT

%post   -p /sbin/ldconfig
%postun -p /sbin/ldconfig

%files
%defattr(-, root, root)
%doc COPYING COPYING.LIB NEWS README
%{prefix}/lib/libGToolKit-1.2.so.*

%files		devel
%defattr(-, root, root)
%doc html
%{prefix}/include/GToolKit
%{prefix}/lib/libGToolKit.*a
%{prefix}/lib/libGToolKit.so
%{prefix}/share/aclocal/gtoolkit.m4
