/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * Generated automatically from gtkwidget.h by gtkgen.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
#ifndef GTOOLKIT_GTKWIDGET_H
#define GTOOLKIT_GTKWIDGET_H

#include <GToolKit/GTKObject.h>
#include <gtk/gtkwidget.h>

@class GTKAccelGroup;
@class GTKAdjustment;
@class GTKStyle;

@interface GTKWidget : GTKObject
+ (GtkType) getType;
+ (id) widgetvWithType:(GtkType) type nArgs:(guint) nargs args:(GtkArg *) args;
- (id) initvWithType:(GtkType) type nArgs:(guint) nargs args:(GtkArg *) args;
- (void) ref;
- (void) unref;
- (void) destroy;
- (void) destroyed:(GTKWidget **) widget_pointer;
- (void) get:(GtkArg *) arg;
- (void) getv:(guint) nargs args:(GtkArg *) args;
- (void) setv:(guint) nargs args:(GtkArg *) args;
- (void) unparent;
- (void) show;
- (void) showNow;
- (void) hide;
- (void) showAll;
- (void) hideAll;
- (void) map;
- (void) unmap;
- (void) realize;
- (void) unrealize;
- (void) queueDraw;
- (void) queueDrawArea:(gint) x y:(gint) y width:(gint) width height:(gint) height;
- (void) queueClear;
- (void) queueClearArea:(gint) x y:(gint) y width:(gint) width height:(gint) height;
- (void) queueResize;
- (void) draw:(GdkRectangle *) area;
- (void) drawFocus;
- (void) drawDefault;
- (void) sizeRequest:(GtkRequisition *) requisition;
- (void) sizeAllocate:(GtkAllocation *) allocation;
- (void) getChildRequisition:(GtkRequisition *) requisition;
- (void) addAccelerator:(NSString *) accel_signal accelGroup:(GTKAccelGroup *) accel_group accelKey:(guint) accel_key accelMods:(guint) accel_mods accelFlags:(GtkAccelFlags) accel_flags;
- (void) removeAccelerator:(GTKAccelGroup *) accel_group accelKey:(guint) accel_key accelMods:(guint) accel_mods;
- (void) removeAccelerators:(NSString *) accel_signal visibleOnly:(gboolean) visible_only;
- (guint) acceleratorSignal:(GTKAccelGroup *) accel_group accelKey:(guint) accel_key accelMods:(guint) accel_mods;
- (void) lockAccelerators;
- (void) unlockAccelerators;
- (gboolean) acceleratorsLocked;
- (gint) event:(GdkEvent *) event;
- (gboolean) activate;
- (gboolean) setScrollAdjustments:(GTKAdjustment *) hadjustment vadjustment:(GTKAdjustment *) vadjustment;
- (void) reparent:(GTKWidget *) new_parent;
- (void) popup:(gint) x y:(gint) y;
- (gint) intersect:(GdkRectangle *) area intersection:(GdkRectangle *) intersection;
- (void) grabFocus;
- (void) grabDefault;
- (void) setName:(NSString *) name;
- (NSString *) getName;
- (void) setState:(GtkStateType) state;
- (void) setSensitive:(gboolean) sensitive;
- (void) setAppPaintable:(gboolean) app_paintable;
- (void) setParent:(GTKWidget *) parent;
- (void) setParentWindow:(GdkWindow *) parent_window;
- (GdkWindow *) getParentWindow;
- (void) setUposition:(gint) x y:(gint) y;
- (void) setUsize:(gint) width height:(gint) height;
- (void) setEvents:(gint) events;
- (void) addEvents:(gint) events;
- (void) setExtensionEvents:(GdkExtensionMode) mode;
- (GdkExtensionMode) getExtensionEvents;
- (GTKWidget*) getToplevel;
- (GTKWidget*) getAncestor:(GtkType) widget_type;
- (GdkColormap*) getColormap;
- (GdkVisual*) getVisual;
- (void) setColormap:(GdkColormap *) colormap;
- (void) setVisual:(GdkVisual *) visual;
- (gint) getEvents;
- (void) getPointer:(gint *) x y:(gint *) y;
- (gint) isAncestor:(GTKWidget *) ancestor;
- (gint) hideOnDelete;
- (void) setStyle:(GTKStyle *) style;
- (void) setRcStyle;
- (void) ensureStyle;
- (GTKStyle*) getStyle;
- (void) restoreDefaultStyle;
- (void) modifyStyle:(GtkRcStyle *) style;
- (void) setCompositeName:(NSString *) name;
- (NSString *) getCompositeName;
- (void) resetRcStyles;
+ (void) pushStyle:(GTKStyle *) style;
+ (void) pushColormap:(GdkColormap *) cmap;
+ (void) pushVisual:(GdkVisual *) visual;
+ (void) pushCompositeChild;
+ (void) popCompositeChild;
+ (void) popStyle;
+ (void) popColormap;
+ (void) popVisual;
+ (void) setDefaultStyle:(GTKStyle *) style;
+ (void) setDefaultColormap:(GdkColormap *) colormap;
+ (void) setDefaultVisual:(GdkVisual *) visual;
+ (GTKStyle*) getDefaultStyle;
+ (GdkColormap*) getDefaultColormap;
+ (GdkVisual*) getDefaultVisual;
- (void) shapeCombineMask:(GdkBitmap *) shape_mask offsetX:(gint) offset_x offsetY:(gint) offset_y;
- (void) path:(guint *) path_length path:(NSString **) path pathReversed:(NSString **) path_reversed;
- (void) classPath:(guint *) path_length path:(NSString **) path pathReversed:(NSString **) path_reversed;
- (GTKWidget *) getParent;
- (GdkWindow *) getWindow;
@end

#endif /* GTOOLKIT_GTKWIDGET_H */
