#include <Foundation/NSAutoreleasePool.h>
#include <Foundation/NSDictionary.h>
#include <GToolKit/GToolKit.h>

@interface Manager : NSObject
{
    GTKWindow *window;
    GTKFileSelection *filesel;
    GTKDialog *info;
    GTKText *text;
}
- (void) open:sender;
- (void) clicked:sender data:(NSString *) data;
@end

@implementation Manager

- init
{
    NSDictionary *name_table = [NSDictionary dictionaryWithObjectsAndKeys:
				    self, @"owner", GTKApp, @"gtkapp", nil];
    GTKGladeXML *tree;

    [super init];

    tree = [GTKGladeXML gladeXMLFromFile:@"xml.glade" rootObject:nil
			nameTable:name_table];
    if (tree == nil) g_error("loading user interface failed");

    [tree resolveReferences:@"window", &window, @"file_dialog", &filesel,
			    @"info_dialog", &info, @"text_area", &text, nil];
    [window autorelease];
    [filesel autorelease];
    [info autorelease];
    return self;
}

- (void) open:sender
{
    if ([GTKApp runModalForWindow:filesel])
    {
	NSString *file = [[[NSString alloc] initWithContentsOfFile:
			    [filesel getFilename]] autorelease];

	[text deleteText:0 endPos:-1];
	[text insert:NULL fore:NULL back:NULL chars:file length:-1];
    }
    [filesel hide];
}

- (void) clicked:sender data:(NSString *) data
{
    [GTKApp stopModalWithCode:[data isEqualToString:@"ok"]];
}
@end

int main (int argc, char *argv[])
{
    NSAutoreleasePool *pool = [NSAutoreleasePool new];
#ifdef LIB_FOUNDATION_LIBRARY
    extern char **environ;
    [NSProcessInfo initializeWithArguments:argv count:argc environment:environ];
#endif

    [[GTKApplication alloc] initWithArgc:&argc argv:&argv];
    [[Manager new] autorelease];

    [GTKApp run];
    [pool release];
    return 0;
}
