/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <gtk/gtk.h>
#include "gtkrootwindow.h"

struct XXX_Data {
    GtkWidget *label_x;
    GtkWidget *label_y;
};

static void
motion_notify_event_handler(GtkWidget *widget, GdkEvent *event,
			    gpointer data)
{
    struct XXX_Data *xxx_data;
    GdkEventMotion *motion_event;

    gchar str_x[1024];
    gchar str_y[1024];

    motion_event = (GdkEventMotion *)event;

    sprintf(str_x, " x: %d ", (int)motion_event->x);
    sprintf(str_y, " y: %d ", (int)motion_event->y);

    xxx_data = (struct XXX_Data *)data;
    gtk_label_set(GTK_LABEL (xxx_data->label_x), str_x);
    gtk_label_set(GTK_LABEL (xxx_data->label_y), str_y);
}

static void
create_widgets()
{
    struct XXX_Data *xxx_data;
    
    GtkWidget *gtk_root_window;
    GtkWidget *label_x, *label_y;
    GtkWidget *dialog;
    GtkWidget *quit_button;


    dialog = gtk_dialog_new();

    label_x = gtk_label_new(" x: ");
    gtk_misc_set_alignment(GTK_MISC (label_x), 0.0, 0.0);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),
		       label_x, TRUE, TRUE, 3);
    gtk_widget_show(label_x);
    label_y = gtk_label_new(" y: ");
    gtk_misc_set_alignment(GTK_MISC (label_y), 0.0, 0.0);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),
		       label_y, TRUE, TRUE, 3);
    gtk_widget_show(label_y);

    quit_button = gtk_button_new_with_label("Quit");
    gtk_signal_connect(GTK_OBJECT(quit_button), "clicked",
		       (GtkSignalFunc)gtk_main_quit, NULL);
    gtk_widget_show(quit_button);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		       quit_button, TRUE, TRUE, 0);

    gtk_widget_show(dialog);


    xxx_data = g_new(struct XXX_Data, 1);
    xxx_data->label_x = label_x;
    xxx_data->label_y = label_y;

    gtk_root_window = gtk_root_window_widget();
    gtk_root_window_set_events(GTK_ROOT_WINDOW(gtk_root_window),
			       GDK_POINTER_MOTION_MASK);
    gtk_signal_connect(GTK_OBJECT (gtk_root_window),
		       "motion_notify_event",
		       (GtkSignalFunc)motion_notify_event_handler,
		       (gpointer)xxx_data);
}

int
main(int argc, char **argv)
{
    gtk_init(&argc, &argv);

    create_widgets();

    gtk_main();

    return 0;
}
