/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __GTK_TREE_FORK_H__
#define __GTK_TREE_FORK_H__


#include <gdk/gdk.h>
#include <gtk/gtkwidget.h>


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define GTK_TREE_FORK(obj)          GTK_CHECK_CAST (obj, gtk_tree_fork_get_type (), GtkTreeFork)
#define GTK_TREE_FORK_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, gtk_tree_fork_get_type (), GtkTreeForkClass)
#define GTK_IS_TREE_FORK(obj)       GTK_CHECK_TYPE (obj, gtk_tree_fork_get_type ())


typedef struct _GtkTreeFork       GtkTreeFork;
typedef struct _GtkTreeForkClass  GtkTreeForkClass;

struct _GtkTreeFork
{
  GtkWidget widget;
};

struct _GtkTreeForkClass
{
  GtkWidgetClass parent_class;

  void (* _xxx_expand)   (GtkTreeFork *tree_fork); /* XXX rename me! */
  void (* _xxx_collapse) (GtkTreeFork *tree_fork); /* XXX rename me! */
};


guint  gtk_tree_fork_get_type (void);

/* Internal method - do not use. */
void gtk_tree_fork__xxx_expand   (GtkTreeFork *tree_fork); /* XXX rename me! */
void gtk_tree_fork__xxx_collapse (GtkTreeFork *tree_fork); /* XXX rename me! */


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GTK_TREE_FORK_H__ */
