/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __GTK_TREE_FACTORY_H__
#define __GTK_TREE_FACTORY_H__


#include <gtk/gtkwidget.h>


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


typedef struct _GtkTreeEntry    GtkTreeEntry;
typedef struct _GtkTreePath     GtkTreePath;
typedef struct _GtkTreeFactory  GtkTreeFactory;

typedef void (*GtkTreeCallback) (GtkWidget *widget,
				 gpointer   user_data);

struct _GtkTreeEntry
{
  char *path;
  GtkWidget *widget;
};

struct _GtkTreePath
{
  char *path;
  GtkWidget *widget;
};

struct _GtkTreeFactory
{
  char *path;
  GtkWidget *widget;
  GList *subfactories;

  void (* create_item) (GtkTreePath *tree_path, GtkWidget *parent);
  void (* create_subtree) (GtkTreePath *tree_path);
};


GtkTreeFactory* gtk_tree_factory_new               (void);
void            gtk_tree_factory_destroy           (GtkTreeFactory     *factory);
void            gtk_tree_factory_add_entries       (GtkTreeFactory     *factory,
						    GtkTreeEntry       *entries,
						    int                 nentries);
void            gtk_tree_factory_add_subfactory    (GtkTreeFactory     *factory,
						    GtkTreeFactory     *subfactory,
						    const char         *path);
void            gtk_tree_factory_remove_paths      (GtkTreeFactory     *factory,
						    char              **paths,
						    int                 npaths);
void            gtk_tree_factory_remove_entries    (GtkTreeFactory     *factory,
						    GtkTreeEntry       *entries,
						    int                 nentries);
void            gtk_tree_factory_remove_subfactory (GtkTreeFactory     *factory,
						    GtkTreeFactory     *subfactory,
						    const char         *path);
GtkTreePath*    gtk_tree_factory_find              (GtkTreeFactory     *factory,
						    const char         *path);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GTK_TREE_FACTORY_H__ */
