/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __GTK_EDITOR_H__
#define __GTK_EDITOR_H__

#include <gdk/gdk.h>
#include <gtk/gtktext.h>


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define GTK_EDITOR(obj) GTK_CHECK_CAST (obj, gtk_editor_get_type (), GtkEditor)
#define GTK_EDITOR_CLASS(klass) \
  GTK_CHECK_CLASS_CAST (klass, gtk_editor_get_type (), GtkEditorClass)
#define GTK_IS_EDITOR(obj) GTK_CHECK_TYPE (obj, gtk_editor_get_type ())


  typedef struct _GtkEditor        GtkEditor;
  typedef struct _GtkEditorClass   GtkEditorClass;

  typedef struct _GtkEditorHilitePatterns GtkEditorHilitePatterns;
  typedef struct _GtkEditorHiliteRegexps  GtkEditorHiliteRegexps;
  typedef struct _GtkEditorHiliteColors   GtkEditorHiliteColors;

  struct _GtkEditorHilitePatterns {
    char *comment_start;
    char *comment_end;
    char *string_start;
    char *string_end;
    char *keywords;
  };

  struct _GtkEditor
  {
    GtkText text;

    /* --<hilite stuff>--------------------------------------------------- */
    /* Automatic highlighting. If this flag is true (default)
     * highlighting is done automatically, when nothing else is
     * happening.  Hightlighting takes a while, so on slow boxes, you
     * might consider turning this off, and handle hightligthing
     * yourself.  This can be done by calling gtk_editor_hilite_buffer. */
    gint hilite_when_idle : 1;

    /* don't worry about this */
    guint hilite_time;
    guint changed_from, changed_to;
    GtkEditorHiliteRegexps *regexps;
    GtkEditorHiliteColors  *colors;
    
  };

  struct _GtkEditorClass
  {
    GtkTextClass parent_class;
  };

  /* widget stuff */
  guint          gtk_editor_get_type               (void);
  GtkWidget*     gtk_editor_new                    (GtkAdjustment *hadj,
						    GtkAdjustment *vadj);

  /* search stuff */
  void           gtk_editor_search_from_point      (GtkEditor     *editor,
						    gchar         *string,
						    gboolean       casein);
  void           gtk_editor_search_back_from_point (GtkEditor     *editor, 
						    gchar         *string,
						    gboolean       casein);

  /* syntax highlighting */
  GtkEditorHiliteRegexps *gtk_editor_new_regexps   (GtkEditorHilitePatterns
						                  *patterns);
  gboolean       gtk_editor_set_regexps            (GtkEditor     *editor,
						    GtkEditorHilitePatterns
						                  *patterns);
  gboolean       gtk_editor_upd_regexps            (GtkEditor     *editor,
						    GtkEditorHilitePatterns
						                  *patterns);
  void           gtk_editor_hilite_buffer          (GtkEditor     *editor);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GTK_EDITOR_H__ */
