static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006 Øyvind Kolås <pippin@gimp.org>                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"#include <gegl-gio-private.h>                                                 \n"
"#include <stdlib.h>                                                           \n"
"                                                                              \n"
"#ifdef G_OS_WIN32                                                             \n"
"#define realpath(a,b) _fullpath(b,a,_MAX_PATH)                                \n"
"#endif                                                                        \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_file_path (path, _(\"File\"), \"\")                                  \n"
"    description (_(\"Path of file to load.\"))                                \n"
"property_uri (uri, _(\"URI\"), \"\")                                          \n"
"    description (_(\"URI of file to load.\"))                                 \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_C_SOURCE load.c                                               \n"
"                                                                              \n"
"#include \"gegl-plugin.h\"                                                    \n"
"                                                                              \n"
"struct _GeglOp                                                                \n"
"{                                                                             \n"
"  GeglOperationMeta parent_instance;                                          \n"
"  gpointer          properties;                                               \n"
"                                                                              \n"
"  GeglNode *output;                                                           \n"
"  GeglNode *load;                                                             \n"
"};                                                                            \n"
"                                                                              \n"
"typedef struct                                                                \n"
"{                                                                             \n"
"  GeglOperationMetaClass parent_class;                                        \n"
"} GeglOpClass;                                                                \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"GEGL_DEFINE_DYNAMIC_OPERATION(GEGL_TYPE_OPERATION_META)                       \n"
"                                                                              \n"
"#include <stdio.h>                                                            \n"
"                                                                              \n"
"static gchar * const                                                          \n"
"extension_from_mimetype(const gchar *mime)                                    \n"
"{                                                                             \n"
"    // XXX: maybe file loader opts should register mimetypes also?            \n"
"    static const gchar * const mime_prefix = \"image/\";                      \n"
"    if (g_str_has_prefix(mime, mime_prefix)) {                                \n"
"       return g_strdup_printf(\".%s\", mime+strlen(mime_prefix));             \n"
"    }                                                                         \n"
"    return NULL;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"do_setup (GeglOperation *operation, const gchar *new_path, const gchar *new_uri)\n"
"{                                                                             \n"
"  GeglOp  *self = GEGL_OP (operation);                                        \n"
"                                                                              \n"
"  if (new_uri && strlen (new_uri) > 0)                                        \n"
"      {                                                                       \n"
"        gchar *extension = NULL;                                              \n"
"        const gchar *handler   = NULL;                                        \n"
"                                                                              \n"
"        if (gegl_gio_uri_is_datauri(new_uri))                                 \n"
"          {                                                                   \n"
"            gchar *mime = gegl_gio_datauri_get_content_type(new_uri);         \n"
"            extension = extension_from_mimetype(mime);                        \n"
"            g_free(mime);                                                     \n"
"          }                                                                   \n"
"        else                                                                  \n"
"            extension = g_strdup(strrchr (new_uri, '.'));                     \n"
"                                                                              \n"
"        if (extension)                                                        \n"
"            handler = gegl_extension_handler_get_loader (extension);          \n"
"        gegl_node_set (self->load, \"operation\", handler, NULL);             \n"
"        gegl_node_set (self->load, \"uri\", new_uri, NULL);                   \n"
"                                                                              \n"
"        g_free(extension);                                                    \n"
"      }                                                                       \n"
"  else if (new_path && strlen (new_path) > 0)                                 \n"
"    {                                                                         \n"
"      const gchar *extension = strrchr (new_path, '.');                       \n"
"      const gchar *handler   = NULL;                                          \n"
"      char   resolved_path[PATH_MAX];                                         \n"
"                                                                              \n"
"      realpath (new_path, resolved_path);                                     \n"
"                                                                              \n"
"      if (!g_file_test (resolved_path, G_FILE_TEST_EXISTS))                   \n"
"        {                                                                     \n"
"          gchar *name = g_filename_display_name (resolved_path);              \n"
"          gchar *tmp  = g_strdup_printf (\"File '%s' does not exist\", name); \n"
"          g_free (name);                                                      \n"
"                                                                              \n"
"          g_warning (\"load: %s\", tmp);                                      \n"
"          gegl_node_set (self->load,                                          \n"
"                         \"operation\", \"gegl:text\",                        \n"
"                         \"size\", 12.0,                                      \n"
"                         \"string\", tmp,                                     \n"
"                         NULL);                                               \n"
"          g_free (tmp);                                                       \n"
"        }                                                                     \n"
"      else                                                                    \n"
"        {                                                                     \n"
"          if (extension)                                                      \n"
"            handler = gegl_extension_handler_get_loader (extension);          \n"
"          gegl_node_set (self->load,                                          \n"
"                         \"operation\", handler,                              \n"
"                         NULL);                                               \n"
"          gegl_node_set (self->load,                                          \n"
"                         \"path\", resolved_path,                             \n"
"                         NULL);                                               \n"
"        }                                                                     \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      gegl_node_set (self->load,                                              \n"
"                     \"operation\", \"gegl:text\",                            \n"
"                     \"string\",    \"No path specified\",                    \n"
"                     NULL);                                                   \n"
"    }                                                                         \n"
"                                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static void attach (GeglOperation *operation)                                 \n"
"{                                                                             \n"
"  GeglOp         *self = GEGL_OP (operation);                                 \n"
"  GeglProperties *o    = GEGL_PROPERTIES (operation);                         \n"
"                                                                              \n"
"  self->output = gegl_node_get_output_proxy (operation->node, \"output\");    \n"
"                                                                              \n"
"  self->load = gegl_node_new_child (operation->node,                          \n"
"                                    \"operation\", \"gegl:text\",             \n"
"                                    NULL);                                    \n"
"                                                                              \n"
"  do_setup (operation, o->path, o->uri);                                      \n"
"                                                                              \n"
"  gegl_node_link (self->load, self->output);                                  \n"
"                                                                              \n"
"  gegl_operation_meta_watch_node (operation, self->load);                     \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglNode *                                                             \n"
"detect (GeglOperation *operation,                                             \n"
"        gint           x,                                                     \n"
"        gint           y)                                                     \n"
"{                                                                             \n"
"  GeglOp *self = GEGL_OP (operation);                                         \n"
"  GeglNode *output = self->output;                                            \n"
"  GeglRectangle bounds;                                                       \n"
"                                                                              \n"
"  bounds = gegl_node_get_bounding_box (output); /* hopefully this is          \n"
"                                                   as correct as original     \n"
"                                                   which was peeking          \n"
"                                                   directly into output->have_rect\n"
"                                                   */                         \n"
"                                                                              \n"
"  if (x >= bounds.x &&                                                        \n"
"      y >= bounds.y &&                                                        \n"
"      x  < bounds.x + bounds.width &&                                         \n"
"      y  < bounds.y + bounds.height)                                          \n"
"    return operation->node;                                                   \n"
"                                                                              \n"
"  return NULL;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"my_set_property (GObject      *gobject,                                       \n"
"                 guint         property_id,                                   \n"
"                 const GValue *value,                                         \n"
"                 GParamSpec   *pspec)                                         \n"
"{                                                                             \n"
"  GeglOperation  *operation = GEGL_OPERATION (gobject);                       \n"
"  GeglOp         *self      = GEGL_OP (operation);                            \n"
"  GeglProperties *o         = GEGL_PROPERTIES (operation);                    \n"
"                                                                              \n"
"  gchar *old_path = g_strdup (o->path);                                       \n"
"  gchar *old_uri = g_strdup (o->uri);                                         \n"
"                                                                              \n"
"  gboolean props_changed;                                                     \n"
"                                                                              \n"
"  /* The set_property provided by the chant system does the                   \n"
"   * storing and reffing/unreffing of the input properties                    \n"
"   */                                                                         \n"
"  set_property (gobject, property_id, value, pspec);                          \n"
"  props_changed = g_strcmp0 (o->path, old_path) || g_strcmp0 (o->uri, old_uri);\n"
"                                                                              \n"
"  if (self->load && props_changed)                                            \n"
"    do_setup (operation, o->path, o->uri);                                    \n"
"  g_free (old_path);                                                          \n"
"  g_free (old_uri);                                                           \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GObjectClass       *object_class    = G_OBJECT_CLASS (klass);               \n"
"  GeglOperationClass *operation_class = GEGL_OPERATION_CLASS (klass);         \n"
"                                                                              \n"
"  object_class->set_property = my_set_property;                               \n"
"                                                                              \n"
"  operation_class->attach = attach;                                           \n"
"  operation_class->detect = detect;                                           \n"
"  operation_class->no_cache = TRUE;                                           \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\"       , \"gegl:load\",                                           \n"
"    \"title\",       \"Load Image\",                                          \n"
"    \"categories\" , \"meta:input\",                                          \n"
"    \"description\",                                                          \n"
"          _(\"Multipurpose file loader, that uses other native handlers, and \"\n"
"            \"fallback conversion using Image Magick's convert.\"),           \n"
"    NULL);                                                                    \n"
"                                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
