static const char* op_c_source =
"/* STRESS, Spatio Temporal Retinex Envelope with Stochastic Sampling          \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2007,2009 Øyvind Kolås     <pippin@gimp.org>                   \n"
" *                     Ivar Farup       <ivarf@hig.no>                        \n"
" *                     Allesandro Rizzi <rizzi@dti.unimi.it>                  \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_int (radius, _(\"Radius\"), 300)                                     \n"
"  description(_(\"Neighborhood taken into account, this is the radius \"      \n"
"                     \"in pixels taken into account when deciding which \"    \n"
"                     \"colors map to which gray values\"))                    \n"
"  value_range (2, 6000)                                                       \n"
"  ui_range    (2, 1000)                                                       \n"
"  ui_gamma    (1.6)                                                           \n"
"  ui_meta     (\"unit\", \"pixel-distance\")                                  \n"
"                                                                              \n"
"property_int  (samples, _(\"Samples\"), 4)                                    \n"
"  description (_(\"Number of samples to do per iteration looking for the range of colors\"))\n"
"  value_range (1, 1000)                                                       \n"
"  ui_range    (3, 17)                                                         \n"
"                                                                              \n"
"property_int (iterations, _(\"Iterations\"), 10)                              \n"
"  description(_(\"Number of iterations, a higher number of iterations \"      \n"
"                     \"provides less noisy results at a computational cost\"))\n"
"  value_range (1, 1000)                                                       \n"
"  ui_range (1, 30)                                                            \n"
"                                                                              \n"
"/*                                                                            \n"
"property_double (rgamma, _(\"Radial Gamma\"), 0.0, 8.0, 2.0,                  \n"
"                _(\"Gamma applied to radial distribution\"))                  \n"
"*/                                                                            \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_AREA_FILTER                                                   \n"
"#define GEGL_OP_C_SOURCE c2g.c                                                \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <math.h>                                                             \n"
"#include <stdlib.h>                                                           \n"
"#include \"envelopes.h\"                                                      \n"
"                                                                              \n"
"#define RGAMMA 2.0                                                            \n"
"                                                                              \n"
"static void c2g (GeglBuffer          *src,                                    \n"
"                 const GeglRectangle *src_rect,                               \n"
"                 GeglBuffer          *dst,                                    \n"
"                 const GeglRectangle *dst_rect,                               \n"
"                 gint                 radius,                                 \n"
"                 gint                 samples,                                \n"
"                 gint                 iterations,                             \n"
"                 gdouble              rgamma,                                 \n"
"                 gint                 level)                                  \n"
"{                                                                             \n"
"  const Babl *format = babl_format (\"RGBA float\");                          \n"
"                                                                              \n"
"  if (dst_rect->width > 0 && dst_rect->height > 0)                            \n"
"  {                                                                           \n"
"    GeglBufferIterator *i = gegl_buffer_iterator_new (dst, dst_rect, 0, babl_format(\"YA float\"),\n"
"                                                      GEGL_ACCESS_WRITE, GEGL_ABYSS_NONE);\n"
"    GeglSampler *sampler = gegl_buffer_sampler_new_at_level (src, format, GEGL_SAMPLER_NEAREST, level);\n"
"                                                                              \n"
"    while (gegl_buffer_iterator_next (i))                                     \n"
"    {                                                                         \n"
"      gint x,y;                                                               \n"
"      gint    dst_offset=0;                                                   \n"
"      gfloat *dst_buf = i->data[0];                                           \n"
"                                                                              \n"
"      for (y=i->roi[0].y; y < i->roi[0].y + i->roi[0].height; y++)            \n"
"        {                                                                     \n"
"          for (x=i->roi[0].x; x < i->roi[0].x + i->roi[0].width; x++)         \n"
"            {                                                                 \n"
"              gfloat  min[4];                                                 \n"
"              gfloat  max[4];                                                 \n"
"              gfloat  pixel[4];                                               \n"
"                                                                              \n"
"              compute_envelopes (src, sampler,                                \n"
"                                 x, y,                                        \n"
"                                 radius, samples,                             \n"
"                                 iterations,                                  \n"
"                                 FALSE, /* same spray */                      \n"
"                                 rgamma,                                      \n"
"                                 min, max, pixel, format);                    \n"
"              {                                                               \n"
"                /* this should be replaced with a better/faster projection of \n"
"                 * pixel onto the vector spanned by min -> max, currently     \n"
"                 * computed by comparing the distance to min with the sum     \n"
"                 * of the distance to min/max.                                \n"
"                 */                                                           \n"
"                                                                              \n"
"                gfloat nominator = 0;                                         \n"
"                gfloat denominator = 0;                                       \n"
"                gint c;                                                       \n"
"                for (c=0; c<3; c++)                                           \n"
"                  {                                                           \n"
"                    nominator   += (pixel[c] - min[c]) * (pixel[c] - min[c]); \n"
"                    denominator += (pixel[c] - max[c]) * (pixel[c] - max[c]); \n"
"                  }                                                           \n"
"                                                                              \n"
"                nominator = sqrtf (nominator);                                \n"
"                denominator = sqrtf (denominator);                            \n"
"                denominator = nominator + denominator;                        \n"
"                                                                              \n"
"                if (denominator>0.000)                                        \n"
"                  {                                                           \n"
"                    dst_buf[dst_offset+0] = nominator/denominator;            \n"
"                  }                                                           \n"
"                else                                                          \n"
"                  {                                                           \n"
"                    /* shouldn't happen */                                    \n"
"                    dst_buf[dst_offset+0] = 0.5;                              \n"
"                  }                                                           \n"
"                dst_buf[dst_offset+1] = pixel[3];                             \n"
"                dst_offset+=2;                                                \n"
"              }                                                               \n"
"            }                                                                 \n"
"          }                                                                   \n"
"    }                                                                         \n"
"    g_object_unref (sampler);                                                 \n"
"  }                                                                           \n"
"}                                                                             \n"
"                                                                              \n"
"static void prepare (GeglOperation *operation)                                \n"
"{                                                                             \n"
"  GeglOperationAreaFilter *area = GEGL_OPERATION_AREA_FILTER (operation);     \n"
"  area->left = area->right = area->top = area->bottom =                       \n"
"      ceil (GEGL_PROPERTIES (operation)->radius);                             \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\", babl_format (\"RGBA float\"));\n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"YA float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglRectangle  result = {0,0,0,0};                                          \n"
"  GeglRectangle *in_rect = gegl_operation_source_get_bounding_box (operation, \n"
"                                                                     \"input\");\n"
"  if (!in_rect)                                                               \n"
"    return result;                                                            \n"
"  return *in_rect;                                                            \n"
"}                                                                             \n"
"                                                                              \n"
"#include \"opencl/gegl-cl.h\"                                                 \n"
"#include \"buffer/gegl-buffer-cl-iterator.h\"                                 \n"
"                                                                              \n"
"#include \"opencl/c2g.cl.h\"                                                  \n"
"                                                                              \n"
"static GeglClRunData *cl_data = NULL;                                         \n"
"                                                                              \n"
"static gboolean                                                               \n"
"cl_c2g (cl_mem                in_tex,                                         \n"
"        cl_mem                out_tex,                                        \n"
"        size_t                global_worksize,                                \n"
"        const GeglRectangle  *src_roi,                                        \n"
"        const GeglRectangle  *roi,                                            \n"
"        gint                  radius,                                         \n"
"        gint                  samples,                                        \n"
"        gint                  iterations,                                     \n"
"        gdouble               rgamma)                                         \n"
"{                                                                             \n"
"  cl_int cl_err = 0;                                                          \n"
"  cl_mem cl_lut_cos = NULL;                                                   \n"
"  cl_mem cl_lut_sin = NULL;                                                   \n"
"  cl_mem cl_radiuses = NULL;                                                  \n"
"  const size_t gbl_size[2] = {roi->width, roi->height};                       \n"
"                                                                              \n"
"  if (!cl_data)                                                               \n"
"    {                                                                         \n"
"      const char *kernel_name[] ={\"c2g\", NULL};                             \n"
"      cl_data = gegl_cl_compile_and_build(c2g_cl_source, kernel_name);        \n"
"    }                                                                         \n"
"  if (!cl_data) return TRUE;                                                  \n"
"                                                                              \n"
"  compute_luts(rgamma);                                                       \n"
"                                                                              \n"
"  cl_lut_cos = gegl_clCreateBuffer(gegl_cl_get_context(),                     \n"
"                                   CL_MEM_USE_HOST_PTR | CL_MEM_READ_ONLY,    \n"
"                                   ANGLE_PRIME * sizeof(cl_float), lut_cos, &cl_err);\n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  cl_lut_sin = gegl_clCreateBuffer(gegl_cl_get_context(),                     \n"
"                                   CL_MEM_USE_HOST_PTR | CL_MEM_READ_ONLY,    \n"
"                                   ANGLE_PRIME * sizeof(cl_float), lut_sin, &cl_err);\n"
"                                                                              \n"
"  cl_radiuses = gegl_clCreateBuffer(gegl_cl_get_context(),                    \n"
"                                    CL_MEM_USE_HOST_PTR | CL_MEM_READ_ONLY,   \n"
"                                    RADIUS_PRIME * sizeof(cl_float), radiuses, &cl_err);\n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  {                                                                           \n"
"  cl_int cl_src_width  = src_roi->width;                                      \n"
"  cl_int cl_src_height = src_roi->height;                                     \n"
"  cl_int cl_radius     = radius;                                              \n"
"  cl_int cl_samples    = samples;                                             \n"
"  cl_int cl_iterations = iterations;                                          \n"
"                                                                              \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 0, sizeof(cl_mem), (void*)&in_tex);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 1, sizeof(cl_int), (void*)&cl_src_width);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 2, sizeof(cl_int), (void*)&cl_src_height);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 3, sizeof(cl_mem), (void*)&cl_radiuses);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 4, sizeof(cl_mem), (void*)&cl_lut_cos);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 5, sizeof(cl_mem), (void*)&cl_lut_sin);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 6, sizeof(cl_mem), (void*)&out_tex);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 7, sizeof(cl_int), (void*)&cl_radius);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 8, sizeof(cl_int), (void*)&cl_samples);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 9, sizeof(cl_int), (void*)&cl_iterations);\n"
"  CL_CHECK;                                                                   \n"
"  }                                                                           \n"
"                                                                              \n"
"  cl_err = gegl_clEnqueueNDRangeKernel(gegl_cl_get_command_queue(), cl_data->kernel[0],\n"
"                                       2, NULL, gbl_size, NULL,               \n"
"                                       0, NULL, NULL);                        \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  cl_err = gegl_clFinish(gegl_cl_get_command_queue ());                       \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  cl_err = gegl_clReleaseMemObject (cl_radiuses);                             \n"
"  CL_CHECK_ONLY (cl_err);                                                     \n"
"  cl_err = gegl_clReleaseMemObject (cl_lut_cos);                              \n"
"  CL_CHECK_ONLY (cl_err);                                                     \n"
"  cl_err = gegl_clReleaseMemObject (cl_lut_sin);                              \n"
"  CL_CHECK_ONLY (cl_err);                                                     \n"
"                                                                              \n"
"  return FALSE;                                                               \n"
"                                                                              \n"
"error:                                                                        \n"
"  if (cl_radiuses)                                                            \n"
"    gegl_clReleaseMemObject (cl_radiuses);                                    \n"
"  if (cl_lut_cos)                                                             \n"
"    gegl_clReleaseMemObject (cl_lut_cos);                                     \n"
"  if (cl_lut_sin)                                                             \n"
"    gegl_clReleaseMemObject (cl_lut_sin);                                     \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"cl_process (GeglOperation       *operation,                                   \n"
"            GeglBuffer          *input,                                       \n"
"            GeglBuffer          *output,                                      \n"
"            const GeglRectangle *result)                                      \n"
"{                                                                             \n"
"  const Babl *in_format  = babl_format(\"RGBA float\");                       \n"
"  const Babl *out_format = gegl_operation_get_format (operation, \"output\"); \n"
"  gint err;                                                                   \n"
"                                                                              \n"
"  GeglOperationAreaFilter *op_area = GEGL_OPERATION_AREA_FILTER (operation);  \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"                                                                              \n"
"  GeglBufferClIterator *i = gegl_buffer_cl_iterator_new (output,              \n"
"                                                         result,              \n"
"                                                         out_format,          \n"
"                                                         GEGL_CL_BUFFER_WRITE);\n"
"                                                                              \n"
"  gint read = gegl_buffer_cl_iterator_add_2 (i,                               \n"
"                                             input,                           \n"
"                                             result,                          \n"
"                                             in_format,                       \n"
"                                             GEGL_CL_BUFFER_READ,             \n"
"                                             op_area->left,                   \n"
"                                             op_area->right,                  \n"
"                                             op_area->top,                    \n"
"                                             op_area->bottom,                 \n"
"                                             GEGL_ABYSS_NONE);                \n"
"                                                                              \n"
"  while (gegl_buffer_cl_iterator_next (i, &err))                              \n"
"    {                                                                         \n"
"      if (err) return FALSE;                                                  \n"
"                                                                              \n"
"      err = cl_c2g(i->tex[read],                                              \n"
"                   i->tex[0],                                                 \n"
"                   i->size[0],                                                \n"
"                   &i->roi[read],                                             \n"
"                   &i->roi[0],                                                \n"
"                   o->radius,                                                 \n"
"                   o->samples,                                                \n"
"                   o->iterations,                                             \n"
"                   RGAMMA);                                                   \n"
"                                                                              \n"
"      if (err) return FALSE;                                                  \n"
"    }                                                                         \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  GeglRectangle compute;                                                      \n"
"  compute = gegl_operation_get_required_for_output (operation, \"input\",result);\n"
"                                                                              \n"
"  if (o->radius < 500 && gegl_operation_use_opencl (operation))               \n"
"    if(cl_process(operation, input, output, result))                          \n"
"      return TRUE;                                                            \n"
"                                                                              \n"
"  c2g (input, &compute, output, result,                                       \n"
"       o->radius,                                                             \n"
"       o->samples,                                                            \n"
"       o->iterations,                                                         \n"
"       /*o->rgamma*/RGAMMA,                                                   \n"
"       level);                                                                \n"
"                                                                              \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static const gchar *composition =                                             \n"
"    \"<?xml version='1.0'             encoding='UTF-8'?>\"                    \n"
"    \"<gegl>\"                                                                \n"
"    \"<node operation='gegl:c2g'>\"                                           \n"
"    \"  <params>\"                                                            \n"
"    \"    <param name='radius'>200</param>\"                                  \n"
"    \"    <param name='iterations'>90</param>\"                               \n"
"    \"  </params>\"                                                           \n"
"    \"</node>\"                                                               \n"
"    \"<node operation='gegl:load'>\"                                          \n"
"    \"  <params>\"                                                            \n"
"    \"    <param name='path'>standard-input.png</param>\"                     \n"
"    \"  </params>\"                                                           \n"
"    \"</node>\"                                                               \n"
"    \"</gegl>\";                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  filter_class->process    = process;                                         \n"
"  operation_class->prepare = prepare;                                         \n"
"                                                                              \n"
"  /* we override defined region to avoid growing the size of what is defined  \n"
"   * by the filter. This also allows the tricks used to treat alpha==0 pixels \n"
"   * in the image as source data not to be skipped by the stochastic sampling \n"
"   * yielding correct edge behavior.                                          \n"
"   */                                                                         \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"                                                                              \n"
"  operation_class->opencl_support = TRUE;                                     \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:c2g\",                                            \n"
"    \"categories\",  \"grayscale:color\",                                     \n"
"    \"title\",       \"Color to Grayscale\",                                  \n"
"    \"reference-composition\", composition,                                   \n"
"    \"description\",                                                          \n"
"    _(\"Color to grayscale conversion, uses envelopes formed with the STRESS approach \"\n"
"      \"to perform local color-difference preserving grayscale generation.\"),\n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
