static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006 Øyvind Kolås <pippin@gimp.org>                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_string (path, _(\"File\"), \"\")                                     \n"
"    description (_(\"a GeglBuffer on disk to open\"))                         \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_SOURCE                                                        \n"
"#define GEGL_OP_C_SOURCE open-buffer.c                                        \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"static void buffer_changed (GeglBuffer          *buffer,                      \n"
"                            const GeglRectangle *rect,                        \n"
"                            gpointer             userdata)                    \n"
"{                                                                             \n"
"  gegl_operation_invalidate (GEGL_OPERATION (userdata), rect, FALSE);         \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglBuffer *ensure_buffer (GeglOperation *operation)                   \n"
"{                                                                             \n"
"  GeglProperties   *o = GEGL_PROPERTIES (operation);                          \n"
"  GeglBuffer   *buffer = o->user_data;                                        \n"
"  if (buffer)                                                                 \n"
"    return buffer;                                                            \n"
"  if (!buffer)                                                                \n"
"    {                                                                         \n"
"      buffer = gegl_buffer_open (o->path);                                    \n"
"      o->user_data = buffer;                                                  \n"
"    }                                                                         \n"
"  gegl_buffer_signal_connect (buffer, \"changed\",                            \n"
"                              G_CALLBACK(buffer_changed), operation);         \n"
"  return buffer;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglRectangle result = {0,0,0,0};                                           \n"
"  GeglBuffer   *buffer = ensure_buffer (operation);                           \n"
"                                                                              \n"
"  result = *gegl_buffer_get_extent (GEGL_BUFFER (buffer));                    \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_cached_region (GeglOperation       *self,                                 \n"
"                   const GeglRectangle *roi)                                  \n"
"{                                                                             \n"
"  return get_bounding_box (self);                                             \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation         *operation,                                    \n"
"         GeglOperationContext  *context,                                      \n"
"         const gchar           *output_pad,                                   \n"
"         const GeglRectangle   *result,                                       \n"
"         gint                   level)                                        \n"
"{                                                                             \n"
"  GeglBuffer *buffer = ensure_buffer (operation);                             \n"
"                                                                              \n"
"  if (buffer)                                                                 \n"
"    {                                                                         \n"
"      g_object_ref (buffer); /* Add an extra reference, since                 \n"
"		              * gegl_operation_set_data is                                  \n"
"		              * stealing one.                                               \n"
"		              */                                                            \n"
"                                                                              \n"
"      /* override core behaviour, by resetting the buffer in the operation_context */\n"
"      gegl_operation_context_take_object (context, \"output\", G_OBJECT (buffer));\n"
"      return TRUE;                                                            \n"
"    }                                                                         \n"
"  return FALSE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"dispose (GObject *object)                                                     \n"
"{                                                                             \n"
"  GeglProperties *o      = GEGL_PROPERTIES (object);                          \n"
"  GeglBuffer     *buffer = o->user_data;                                      \n"
"                                                                              \n"
"  if (buffer)                                                                 \n"
"    {                                                                         \n"
"      g_object_unref (buffer);                                                \n"
"      o->user_data = NULL;                                                    \n"
"    }                                                                         \n"
"                                                                              \n"
"  G_OBJECT_CLASS (gegl_op_parent_class)->dispose (object);                    \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"                                                                              \n"
"  G_OBJECT_CLASS (klass)->dispose = dispose;                                  \n"
"                                                                              \n"
"  operation_class->process = process;                                         \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"  operation_class->get_cached_region = get_cached_region;                     \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\"       , \"gegl:open-buffer\",                                    \n"
"    \"title\",       _(\"Open GEGL Buffer\"),                                 \n"
"    \"categories\" , \"input\",                                               \n"
"    \"description\", _(\"Use an on-disk GeglBuffer as data source.\"),        \n"
"    NULL);                                                                    \n"
"                                                                              \n"
"  operation_class->no_cache = TRUE;                                           \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
