static const char* color_exchange_cl_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2015 Thomas Manni <thomas.manni@free.fr>                         \n"
" */                                                                           \n"
"                                                                              \n"
"__kernel void cl_color_exchange(__global const float4 *in,                    \n"
"                                __global       float4 *out,                   \n"
"                                               float3 color_diff,             \n"
"                                               float3 min,                    \n"
"                                               float3 max)                    \n"
"{                                                                             \n"
"  int gid     = get_global_id(0);                                             \n"
"  float4 in_v = in[gid];                                                      \n"
"  float4 out_v;                                                               \n"
"                                                                              \n"
"  if(in_v.x > min.x && in_v.x < max.x &&                                      \n"
"     in_v.y > min.y && in_v.y < max.y &&                                      \n"
"     in_v.z > min.z && in_v.z < max.z)                                        \n"
"    {                                                                         \n"
"      out_v.x = clamp(in_v.x + color_diff.x, 0.0f, 1.0f);                     \n"
"      out_v.y = clamp(in_v.y + color_diff.y, 0.0f, 1.0f);                     \n"
"      out_v.z = clamp(in_v.z + color_diff.z, 0.0f, 1.0f);                     \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      out_v.xyz = in_v.xyz;                                                   \n"
"    }                                                                         \n"
"                                                                              \n"
"  out_v.w  = in_v.w;                                                          \n"
"  out[gid] = out_v;                                                           \n"
"}                                                                             \n"
;
