static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * This program is free software: you can redistribute it and/or modify       \n"
" * it under the terms of the GNU General Public License as published by       \n"
" * the Free Software Foundation; either version 3 of the License, or          \n"
" * (at your option) any later version.                                        \n"
" *                                                                            \n"
" * This program is distributed in the hope that it will be useful,            \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              \n"
" * GNU General Public License for more details.                               \n"
" *                                                                            \n"
" * You should have received a copy of the GNU General Public License          \n"
" * along with this program.  If not, see <http://www.gnu.org/licenses/>.      \n"
" *                                                                            \n"
" * Copyright (C) 2017 Ell                                                     \n"
" *                                                                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (x_period, _(\"X Period\"), 128.0)                            \n"
"  description (_(\"Period for X axis\"))                                      \n"
"  value_range (0.0, G_MAXDOUBLE)                                              \n"
"  ui_range    (0.0, 256.0)                                                    \n"
"  ui_meta     (\"unit\", \"pixel-distance\")                                  \n"
"  ui_meta     (\"axis\", \"x\")                                               \n"
"                                                                              \n"
"property_double (y_period, _(\"Y Period\"), 128.0)                            \n"
"  description (_(\"Period for Y axis\"))                                      \n"
"  value_range (0.0, G_MAXDOUBLE)                                              \n"
"  ui_range    (0.0, 256.0)                                                    \n"
"  ui_meta     (\"unit\", \"pixel-distance\")                                  \n"
"  ui_meta     (\"axis\", \"y\")                                               \n"
"                                                                              \n"
"property_double (x_amplitude, _(\"X Amplitude\"), 0.0)                        \n"
"  description (_(\"Amplitude for X axis (logarithmic scale)\"))               \n"
"  value_range (-G_MAXDOUBLE, G_MAXDOUBLE)                                     \n"
"  ui_range    (-2.0, 2.0)                                                     \n"
"  ui_meta     (\"axis\", \"x\")                                               \n"
"                                                                              \n"
"property_double (y_amplitude, _(\"Y Amplitude\"), 0.0)                        \n"
"  description (_(\"Amplitude for Y axis (logarithmic scale)\"))               \n"
"  value_range (-G_MAXDOUBLE, G_MAXDOUBLE)                                     \n"
"  ui_range    (-2.0, 2.0)                                                     \n"
"  ui_meta     (\"axis\", \"y\")                                               \n"
"                                                                              \n"
"property_double (x_phase, _(\"X Phase\"), 0.0)                                \n"
"  description (_(\"Phase for X axis\"))                                       \n"
"  value_range (-G_MAXDOUBLE, G_MAXDOUBLE)                                     \n"
"  ui_range    (-512.0, 512.0)                                                 \n"
"  ui_meta     (\"unit\", \"pixel-distance\")                                  \n"
"  ui_meta     (\"axis\", \"x\")                                               \n"
"                                                                              \n"
"property_double (y_phase, _(\"Y Phase\"), 0.0)                                \n"
"  description (_(\"Phase for Y axis\"))                                       \n"
"  value_range (-G_MAXDOUBLE, G_MAXDOUBLE)                                     \n"
"  ui_range    (-512.0, 512.0)                                                 \n"
"  ui_meta     (\"unit\", \"pixel-distance\")                                  \n"
"  ui_meta     (\"axis\", \"y\")                                               \n"
"                                                                              \n"
"property_double (angle, _(\"Angle\"), 90.0)                                   \n"
"  description(_(\"Axis separation angle\"))                                   \n"
"  value_range (0.0, 360.0)                                                    \n"
"  ui_meta     (\"unit\", \"degree\")                                          \n"
"                                                                              \n"
"property_double (offset, _(\"Offset\"), 0.0)                                  \n"
"  description(_(\"Value offset\"))                                            \n"
"  value_range (-G_MAXDOUBLE, G_MAXDOUBLE)                                     \n"
"  ui_range    (-1.0, 1.0)                                                     \n"
"                                                                              \n"
"property_double (exponent, _(\"Exponent\"), 0.0)                              \n"
"  description(_(\"Value exponent (logarithmic scale)\"))                      \n"
"  value_range (-G_MAXDOUBLE, G_MAXDOUBLE)                                     \n"
"  ui_range    (-2.0, 2.0)                                                     \n"
"                                                                              \n"
"property_double (x_offset, _(\"X Offset\"), 0.0)                              \n"
"  description (_(\"Offset for X axis\"))                                      \n"
"  value_range (-G_MAXDOUBLE, G_MAXDOUBLE)                                     \n"
"  ui_range    (-512.0, 512.0)                                                 \n"
"  ui_meta     (\"unit\", \"pixel-coordinate\")                                \n"
"  ui_meta     (\"axis\", \"x\")                                               \n"
"                                                                              \n"
"property_double (y_offset, _(\"Y Offset\"), 0.0)                              \n"
"  description (_(\"Offset for Y axis\"))                                      \n"
"  value_range (-G_MAXDOUBLE, G_MAXDOUBLE)                                     \n"
"  ui_range    (-512.0, 512.0)                                                 \n"
"  ui_meta     (\"unit\", \"pixel-coordinate\")                                \n"
"  ui_meta     (\"axis\", \"y\")                                               \n"
"                                                                              \n"
"property_double (rotation, _(\"Rotation\"), 0.0)                              \n"
"  description(_(\"Pattern rotation angle\"))                                  \n"
"  value_range (0.0, 360.0)                                                    \n"
"  ui_meta     (\"unit\", \"degree\")                                          \n"
"                                                                              \n"
"property_int (supersampling, _(\"Supersampling\"), 1)                         \n"
"  description(_(\"Number of samples along each axis per pixel\"))             \n"
"  value_range (1, 8)                                                          \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_RENDER                                                  \n"
"#define GEGL_OP_NAME     linear_sinusoid                                      \n"
"#define GEGL_OP_C_SOURCE linear-sinusoid.c                                    \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"static inline gdouble                                                         \n"
"odd_pow (gdouble base,                                                        \n"
"         gdouble exponent)                                                    \n"
"{                                                                             \n"
"  if (base >= 0.0)                                                            \n"
"    return  pow ( base, exponent);                                            \n"
"  else                                                                        \n"
"    return -pow (-base, exponent);                                            \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"Y' float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  return gegl_rectangle_infinite_plane ();                                    \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         void                *out_buf,                                        \n"
"         glong                n_pixels,                                       \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  gdouble         offset;                                                     \n"
"  gdouble         exponent;                                                   \n"
"  gdouble         scale;                                                      \n"
"  gdouble         x_scale, y_scale;                                           \n"
"  gdouble         x_amplitude, y_amplitude;                                   \n"
"  gdouble         x_angle, y_angle;                                           \n"
"  gint            i, j;                                                       \n"
"  gdouble         x0, y0;                                                     \n"
"  gdouble         x, y;                                                       \n"
"  gdouble         i_dx, i_dy;                                                 \n"
"  gdouble         j_dx, j_dy;                                                 \n"
"  gdouble         supersampling_scale;                                        \n"
"  gdouble         supersampling_scale2;                                       \n"
"  gint            m, n;                                                       \n"
"  gdouble         u0, v0;                                                     \n"
"  gdouble         u, v;                                                       \n"
"  gdouble         m_du, m_dv;                                                 \n"
"  gdouble         n_du, n_dv;                                                 \n"
"  gfloat         *result = out_buf;                                           \n"
"                                                                              \n"
"  offset   = o->offset + .5;                                                  \n"
"  exponent = exp2 (o->exponent);                                              \n"
"                                                                              \n"
"  if (o->x_period == 0.0 || o->y_period == 0.0)                               \n"
"    {                                                                         \n"
"      gfloat value = odd_pow (offset, exponent);                              \n"
"                                                                              \n"
"      gegl_memset_pattern (result, &value, sizeof (value), n_pixels);         \n"
"                                                                              \n"
"      return TRUE;                                                            \n"
"    }                                                                         \n"
"                                                                              \n"
"  scale = 1.0 / (1 << level);                                                 \n"
"                                                                              \n"
"  x_scale = 2 * G_PI * scale / o->x_period;                                   \n"
"  y_scale = 2 * G_PI * scale / o->y_period;                                   \n"
"                                                                              \n"
"  x_amplitude = exp2 (o->x_amplitude) / 4.0;                                  \n"
"  y_amplitude = exp2 (o->y_amplitude) / 4.0;                                  \n"
"                                                                              \n"
"  x_angle = -G_PI *  o->rotation             / 180.0;                         \n"
"  y_angle = -G_PI * (o->rotation + o->angle) / 180.0;                         \n"
"                                                                              \n"
"  i_dx = cos (x_angle) * x_scale;                                             \n"
"  i_dy = cos (y_angle) * y_scale;                                             \n"
"                                                                              \n"
"  j_dx = sin (x_angle) * x_scale;                                             \n"
"  j_dy = sin (y_angle) * y_scale;                                             \n"
"                                                                              \n"
"  x0 = o->x_phase * x_scale          +                                        \n"
"       (roi->x - o->x_offset) * i_dx +                                        \n"
"       (roi->y - o->y_offset) * j_dx;                                         \n"
"  y0 = o->y_phase * y_scale          +                                        \n"
"       (roi->x - o->x_offset) * i_dy +                                        \n"
"       (roi->y - o->y_offset) * j_dy;                                         \n"
"                                                                              \n"
"  if (o->supersampling != 1)                                                  \n"
"    {                                                                         \n"
"      gdouble offset;                                                         \n"
"                                                                              \n"
"      supersampling_scale  = 1.0 / o->supersampling;                          \n"
"      supersampling_scale2 = supersampling_scale * supersampling_scale;       \n"
"                                                                              \n"
"      m_du = supersampling_scale * i_dx;                                      \n"
"      m_dv = supersampling_scale * i_dy;                                      \n"
"                                                                              \n"
"      n_du = supersampling_scale * j_dx;                                      \n"
"      n_dv = supersampling_scale * j_dy;                                      \n"
"                                                                              \n"
"      offset  = (1.0 - supersampling_scale) / 2.0;                            \n"
"      x0     -= offset * (i_dx + j_dx);                                       \n"
"      y0     -= offset * (i_dy + j_dy);                                       \n"
"    }                                                                         \n"
"                                                                              \n"
"  for (j = 0; j < roi->height; j++)                                           \n"
"    {                                                                         \n"
"      x = x0;                                                                 \n"
"      y = y0;                                                                 \n"
"                                                                              \n"
"      for (i = 0; i < roi->width; i++)                                        \n"
"        {                                                                     \n"
"          gdouble z;                                                          \n"
"                                                                              \n"
"          if (o->supersampling == 1)                                          \n"
"            {                                                                 \n"
"              z = offset                -                                     \n"
"                  x_amplitude * cos (x) -                                     \n"
"                  y_amplitude * cos (y);                                      \n"
"              z = odd_pow (z, exponent);                                      \n"
"            }                                                                 \n"
"          else                                                                \n"
"            {                                                                 \n"
"              z = 0.0;                                                        \n"
"                                                                              \n"
"              u0 = x;                                                         \n"
"              v0 = y;                                                         \n"
"                                                                              \n"
"              for (n = 0; n < o->supersampling; n++)                          \n"
"                {                                                             \n"
"                  u = u0;                                                     \n"
"                  v = v0;                                                     \n"
"                                                                              \n"
"                  for (m = 0; m < o->supersampling; m++)                      \n"
"                    {                                                         \n"
"                      gdouble w;                                              \n"
"                                                                              \n"
"                      w = offset                -                             \n"
"                          x_amplitude * cos (u) -                             \n"
"                          y_amplitude * cos (v);                              \n"
"                      w = odd_pow (w, exponent);                              \n"
"                                                                              \n"
"                      z += w;                                                 \n"
"                                                                              \n"
"                      u += m_du;                                              \n"
"                      v += m_dv;                                              \n"
"                    }                                                         \n"
"                                                                              \n"
"                  u0 += n_du;                                                 \n"
"                  v0 += n_dv;                                                 \n"
"                }                                                             \n"
"                                                                              \n"
"              z *= supersampling_scale2;                                      \n"
"            }                                                                 \n"
"                                                                              \n"
"          *result++ = z;                                                      \n"
"                                                                              \n"
"          x += i_dx;                                                          \n"
"          y += i_dy;                                                          \n"
"        }                                                                     \n"
"                                                                              \n"
"      x0 += j_dx;                                                             \n"
"      y0 += j_dy;                                                             \n"
"    }                                                                         \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass            *operation_class;                             \n"
"  GeglOperationPointRenderClass *point_render_class;                          \n"
"                                                                              \n"
"  operation_class    = GEGL_OPERATION_CLASS (klass);                          \n"
"  point_render_class = GEGL_OPERATION_POINT_RENDER_CLASS (klass);             \n"
"                                                                              \n"
"  point_render_class->process = process;                                      \n"
"                                                                              \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"  operation_class->prepare = prepare;                                         \n"
"  operation_class->opencl_support = FALSE;                                    \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",               \"gegl:linear-sinusoid\",                         \n"
"    \"title\",              _(\"Linear Sinusoid\"),                           \n"
"    \"categories\",         \"render\",                                       \n"
"    \"position-dependent\", \"true\",                                         \n"
"    \"license\",            \"GPL3+\",                                        \n"
"    \"description\",        _(\"Generate a linear sinusoid pattern\"),        \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
