static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2007 Mukund Sivaraman <muks@mukund.org>                          \n"
" */                                                                           \n"
"                                                                              \n"
"/* XXX                                                                        \n"
" * This plug-in isn't really useful apart for compatibility with GIMP         \n"
" * scripts, operating with HSV as a color model for filters isn't really      \n"
" * useful.                                                                    \n"
" */                                                                           \n"
"                                                                              \n"
"/*                                                                            \n"
" * The plug-in only does v = 1.0 - v; for each pixel in the image, or         \n"
" * each entry in the colormap depending upon the type of image, where 'v'     \n"
" * is the value in HSV color model.                                           \n"
" *                                                                            \n"
" * The plug-in code is optimized towards this, in that it is not a full       \n"
" * RGB->HSV->RGB transform, but shortcuts many of the calculations to         \n"
" * effectively only do v = 1.0 - v. In fact, hue is never calculated. The     \n"
" * shortcuts can be derived from running a set of r, g, b values through the  \n"
" * RGB->HSV transform and then from HSV->RGB and solving out the redundant    \n"
" * portions.                                                                  \n"
" *                                                                            \n"
" */                                                                           \n"
"                                                                              \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"   /* no properties */                                                        \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_FILTER                                                  \n"
"#define GEGL_OP_C_SOURCE value-invert.c                                       \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  gegl_operation_set_format (operation, \"input\", babl_format (\"R'G'B'A float\"));\n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"R'G'B'A float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *op,                                             \n"
"         void                *in_buf,                                         \n"
"         void                *out_buf,                                        \n"
"         glong                samples,                                        \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  glong   j;                                                                  \n"
"  gfloat *src  = in_buf;                                                      \n"
"  gfloat *dest = out_buf;                                                     \n"
"  gfloat  r, g, b;                                                            \n"
"  gfloat  value, min;                                                         \n"
"  gfloat  delta;                                                              \n"
"                                                                              \n"
"  for (j = 0; j < samples; j++)                                               \n"
"    {                                                                         \n"
"      r = *src++;                                                             \n"
"      g = *src++;                                                             \n"
"      b = *src++;                                                             \n"
"                                                                              \n"
"      if (r > g)                                                              \n"
"        {                                                                     \n"
"          value = MAX (r, b);                                                 \n"
"          min = MIN (g, b);                                                   \n"
"        }                                                                     \n"
"      else                                                                    \n"
"        {                                                                     \n"
"          value = MAX (g, b);                                                 \n"
"          min = MIN (r, b);                                                   \n"
"        }                                                                     \n"
"                                                                              \n"
"      delta = value - min;                                                    \n"
"      if ((value == 0) || (delta == 0))                                       \n"
"        {                                                                     \n"
"          r = 1.0 - value;                                                    \n"
"          g = 1.0 - value;                                                    \n"
"          b = 1.0 - value;                                                    \n"
"        }                                                                     \n"
"      else                                                                    \n"
"        {                                                                     \n"
"          if (r == value)                                                     \n"
"            {                                                                 \n"
"              r = 1.0 - r;                                                    \n"
"              b = r * b / value;                                              \n"
"              g = r * g / value;                                              \n"
"            }                                                                 \n"
"          else if (g == value)                                                \n"
"            {                                                                 \n"
"              g = 1.0 - g;                                                    \n"
"              r = g * r / value;                                              \n"
"              b = g * b / value;                                              \n"
"            }                                                                 \n"
"          else                                                                \n"
"            {                                                                 \n"
"              b = 1.0 - b;                                                    \n"
"              g = b * g / value;                                              \n"
"              r = b * r / value;                                              \n"
"            }                                                                 \n"
"        }                                                                     \n"
"                                                                              \n"
"      *dest++ = r;                                                            \n"
"      *dest++ = g;                                                            \n"
"      *dest++ = b;                                                            \n"
"                                                                              \n"
"      *dest++ = *src++;                                                       \n"
"    }                                                                         \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"#include \"opencl/value-invert.cl.h\"                                         \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass            *operation_class;                             \n"
"  GeglOperationPointFilterClass *point_filter_class;                          \n"
"                                                                              \n"
"  operation_class    = GEGL_OPERATION_CLASS (klass);                          \n"
"  point_filter_class = GEGL_OPERATION_POINT_FILTER_CLASS (klass);             \n"
"                                                                              \n"
"  point_filter_class->process = process;                                      \n"
"  operation_class->prepare = prepare;                                         \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:value-invert\",                                   \n"
"    \"title\",       _(\"Value Invert\"),                                     \n"
"    \"categories\" , \"color\",                                               \n"
"    \"description\",                                                          \n"
"        _(\"Inverts just the value component, the result is the corresponding \"\n"
"          \"`inverted' image.\"),                                             \n"
"    \"cl-source\"  , value_invert_cl_source,                                  \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
