/* CSL - Common Sound Layer
 * Copyright (C) 2000-2001 Stefan Westerfeld and Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License aint with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef __ARTS_CSL_ADAPTER_H__
#define __ARTS_CSL_ADAPTER_H__


#include "artsmcopmarshal.h"
#include "artsmcopdispatcher.h"
#include "cslpcm.h"	/* for CslPcmFormatType */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* --- structures --- */

typedef CslPcmFormatType ArtsCslStreamFormat;
typedef struct _ArtsCslAdapter ArtsCslAdapter;
typedef enum
{
  ARTS_CSL_DIR_INPUT,
  ARTS_CSL_DIR_OUTPUT
} ArtsCslDirection;

typedef struct
{
  int rate;
  int channels;
  CslPcmFormatType format;
} ArtsCslStreamParams;

typedef struct
{
  int stream_id;

  ArtsCslStreamParams *stream_params;
  int stream_buffer_used;		/* used bytes of the stream buffer */
  int stream_buffer_size;		/* size of the stream buffer */

  ArtsCslStreamParams *arts_params;
  int arts_buffer_used;		/* used bytes in server <-> hardware buffer */
  int arts_buffer_size;		/* size of the server <-> hardware buffer */
} ArtsCslStreamStatus;

/* --- prototypes --- */

/* CSL::Adapter */

ArtsCslAdapter*	     _arts_csl_adapter_from_reference	   (ArtsMcopDispatcher *dispatcher,
							    ArtsMcopObjectReference *reference,
							    CslBool need_copy);
int		     _arts_csl_adapter_open		   (ArtsCslAdapter *adapter,
							    const char *role,
							    ArtsCslDirection dir);
CslBool		     _arts_csl_adapter_set_params	   (ArtsCslAdapter *adapter,
							    int streamID, 
							    ArtsCslStreamParams *params);
void		     _arts_csl_adapter_set_title	   (ArtsCslAdapter *adapter,
							    int             streamID,
							    const char     *title);
void		     _arts_csl_adapter_close		   (ArtsCslAdapter *adapter,
							    int streamID);
void		     _arts_csl_adapter_write		   (ArtsCslAdapter *adapter,
							    int streamID,
							    unsigned char *bytes,
							    unsigned int n_bytes);
unsigned int	     _arts_csl_adapter_read		   (ArtsCslAdapter *adapter,
							    int streamID,
							    unsigned int n_bytes,
							    unsigned char *bytes);
void		     _arts_csl_adapter_activate		   (ArtsCslAdapter *adapter,
							    int streamID);
void		     _arts_csl_adapter_suspend		   (ArtsCslAdapter *adapter,
							    int streamID);
int		     _arts_csl_adapter_wait_buffer_level   (ArtsCslAdapter *adapter,
							    int streamID,
							    int bufferUsed);
ArtsCslStreamStatus* _arts_csl_adapter_status		   (ArtsCslAdapter *adapter,
							    int streamID);
int		     _arts_csl_adapter_sample_new          (ArtsCslAdapter *adapter,
                                                            const char *name,
							    const char *role,
							    const char *title);
void	             _arts_csl_adapter_sample_release      (ArtsCslAdapter *adapter,
                                                            int sampleID);
void		     _arts_csl_adapter_sample_write	   (ArtsCslAdapter *adapter,
							    int sampleID,
							    unsigned char *bytes,
							    unsigned int n_bytes);
void	             _arts_csl_adapter_sample_write_done   (ArtsCslAdapter *adapter,
                                                            int sampleID);
CslBool	             _arts_csl_adapter_sample_play         (ArtsCslAdapter *adapter,
                                                            int sampleID);
CslBool	             _arts_csl_adapter_sample_is_playing   (ArtsCslAdapter *adapter,
                                                            int sampleID);
void	             _arts_csl_adapter_sample_stop         (ArtsCslAdapter *adapter,
                                                            int sampleID);
void	             _arts_csl_adapter_sample_wait_done    (ArtsCslAdapter *adapter,
                                                            int sampleID);
void	             _arts_csl_adapter_sample_cache_add    (ArtsCslAdapter *adapter,
                                                            int sampleID);
int		     _arts_csl_adapter_sample_cache_find   (ArtsCslAdapter *adapter,
                                                            const char *name,
							    const char *role,
							    const char *title);
void	             _arts_csl_adapter_sample_cache_remove (ArtsCslAdapter *adapter,
                                                            int sampleID);

/* CSL::StreamParams */

ArtsCslStreamParams* _arts_csl_stream_params_demarshal     (ArtsBinBuffer       *buffer);
void		     _arts_csl_stream_params_marshal       (ArtsBinBuffer       *buffer,
							    ArtsCslStreamParams *params);
void		     _arts_csl_stream_params_free          (ArtsCslStreamParams *params);

/* CSL::StreamStatus */

ArtsCslStreamStatus* _arts_csl_stream_status_demarshal     (ArtsBinBuffer       *buffer);
void		     _arts_csl_stream_status_marshal       (ArtsBinBuffer       *buffer,
							    ArtsCslStreamStatus *status);
void		     _arts_csl_stream_status_free          (ArtsCslStreamStatus *status);

#if 0	/* CSL::Adapter TODO */
	boolean active(int streamID);
	void clearBuffer(int streamID);
	void waitPlayed(int streamID);
	sequence<string> channelMaps(int streamID);
	boolean setChannelMapping(int streamID, int channel, string mapping);
	string getChannelMapping(int streamID, int channel);
#endif

#ifdef __cplusplus
}
#endif /* __cplusplus */

/* vim:ts=8:sw=2:sts=2
 */
#endif /* __ARTS_CSL_ADAPTER_H__ */
