/* CSL - Common Sound Layer
 * Copyright (C) 2000-2001 Stefan Westerfeld and Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#include	"artsbinbuffer.h"


/* --- functions --- */
ArtsBinBuffer*
_arts_bin_buffer_setup_readable (ArtsBinBuffer *buffer,
				unsigned int   n_bytes,
				void          *bytes)
{
  csl_return_val_if_fail (buffer != NULL, NULL);

  buffer->bytes = bytes;
  buffer->bound = buffer->bytes + n_bytes;
  buffer->bp.cur = buffer->bytes;
  buffer->error = FALSE;

  return buffer;
}

ArtsBinBuffer*
_arts_bin_buffer_setup_writable (ArtsBinBuffer *buffer,
				unsigned int   prealloc)
{
  csl_return_val_if_fail (buffer != NULL, NULL);

  buffer->bytes = csl_malloc (prealloc);
  buffer->bound = buffer->bytes + prealloc;
  buffer->bp.cur = buffer->bytes;
  buffer->error = FALSE;
  buffer->need_free = TRUE;

  return buffer;
}

void
_arts_bin_buffer_rewind (ArtsBinBuffer *buffer)
{
  csl_return_if_fail (buffer != NULL);

  buffer->bp.cur = buffer->bytes;
  buffer->error = FALSE;
}

void
_arts_bin_buffer_free_writable (ArtsBinBuffer *buffer)
{
  csl_return_if_fail (buffer != NULL);

  csl_free (buffer->bytes);
}

void
_arts_bin_buffer_put_hex (ArtsBinBuffer *buffer,
			 const char    *hex_string)
{
  int length;

  csl_return_if_fail (buffer != NULL);
  csl_return_if_fail (hex_string != NULL);

  length = strlen (hex_string) / 2;
  while (length--)
    {
      register unsigned int hn, ln;

      hn = *hex_string++;
      hn -= hn <= '9' ? '0' : hn <= 'F' ? 'A' - 10 : 'a' - 10;
      ln = *hex_string++;
      ln -= ln <= '9' ? '0' : ln <= 'F' ? 'A' - 10 : 'a' - 10;
      _arts_bin_buffer_put_byte (buffer, (hn << 4) | ln);
    }
}
