
/*
 * Generated data (by mkcproc.pl)
 */
#line 1 "bseserver.proc"

#include <bse/bseplugin.h>
#include <bse/bseprocedure.h>
#include <bse/bseserver.h>
#include <bse/bseproject.h>
#include <bse/bseloader.h>
#include <bse/bsemidinotifier.h>
#include <bse/bsemidievent.h>
#include <bse/bsejanitor.h>
#include <bse/bsescripthelper.h>
#include <bse/bsegconfig.h>
#include <bse/bseladspa.h>
#include "topconfig.h"
#include <string.h>


#line 34 "bseserver.proc"


/* --- use-new-project --- */
static void
use_new_project_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 36 "bseserver.proc"
 {
#line 38 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("name", "Project Name", NULL,
			    NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++) = bse_param_spec_object ("project", "Project", NULL,
				 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
}
#line 45 "bseserver.proc"
 }
static BseErrorType
#line 45 "bseserver.proc"
use_new_project_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 48 "bseserver.proc"
{
#line 49 "bseserver.proc"
  
  BseServer *server     = (BseServer*) bse_value_get_object (in_values++);
  gchar *name           = sfi_value_get_string (in_values++);
  gchar *uname;
  guint num = 1;
  BseProject *project;
  
#line 56 "bseserver.proc"
  
  if (!BSE_IS_SERVER (server) || !name)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 60 "bseserver.proc"
  
  uname = g_strdup (name);
  while (bse_server_find_project (server, uname))
    {
      g_free (uname);
      uname = g_strdup_printf ("%s-%u", name, num++);
    }
  
#line 68 "bseserver.proc"
  
  project = bse_server_create_project (server, uname);
  g_free (uname);
  bse_item_use (BSE_ITEM (project));
  g_object_unref (project);
  
#line 74 "bseserver.proc"
  
  bse_value_set_object (out_values++, G_OBJECT (project));
  
  return BSE_ERROR_NONE;
}

/* --- can-load --- */
static void
can_load_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 80 "bseserver.proc"
 {
#line 82 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("file_name", "File Name", "The file to find a loader for",
			    NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_bool ("can-load", NULL, NULL,
			  FALSE, SFI_PARAM_STANDARD);
}
#line 89 "bseserver.proc"
 }
static BseErrorType
#line 89 "bseserver.proc"
can_load_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 92 "bseserver.proc"
{
#line 93 "bseserver.proc"
  
  BseServer *server	= bse_value_get_object (in_values++);
  gchar *file_name	= sfi_value_get_string (in_values++);
  BseWaveFileInfo *finfo;
  
#line 98 "bseserver.proc"
  
  if (!BSE_IS_SERVER (server) || !file_name)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 102 "bseserver.proc"
  
  finfo = bse_wave_file_info_load (file_name, NULL);
  sfi_value_set_bool (out_values++, finfo != NULL);
  if (finfo)
    bse_wave_file_info_unref (finfo);
  
  return BSE_ERROR_NONE;
}

/* --- n-scripts --- */
static void
n_scripts_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 111 "bseserver.proc"
 {
#line 113 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_int ("n_connections", NULL, "Number of Connections",
			 0, 0, G_MAXINT, 1,
			 SFI_PARAM_STANDARD);
}
#line 119 "bseserver.proc"
 }
static BseErrorType
#line 119 "bseserver.proc"
n_scripts_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 122 "bseserver.proc"
{
#line 123 "bseserver.proc"
  
  BseServer *server	= bse_value_get_object (in_values++);
  GSList *slist;
  guint n_scripts = 0;
  
#line 128 "bseserver.proc"
  
  if (!BSE_IS_SERVER (server))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 132 "bseserver.proc"
  
  for (slist = server->children; slist; slist = slist->next)
    if (BSE_IS_JANITOR (slist->data))
      n_scripts++;
  
#line 137 "bseserver.proc"
  
  sfi_value_set_int (out_values++, n_scripts);
  
  return BSE_ERROR_NONE;
}

/* --- preferences-locked --- */
static void
preferences_locked_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 143 "bseserver.proc"
 {
#line 145 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_bool ("locked", NULL, NULL,
			  FALSE, SFI_PARAM_STANDARD);
}
#line 150 "bseserver.proc"
 }
static BseErrorType
#line 150 "bseserver.proc"
preferences_locked_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 153 "bseserver.proc"
{
#line 154 "bseserver.proc"
  
  BseServer *server	= bse_value_get_object (in_values++);
  
#line 157 "bseserver.proc"
  
  if (!BSE_IS_SERVER (server))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 161 "bseserver.proc"
  
  sfi_value_set_int (out_values++, bse_gconfig_locked ());
  
  return BSE_ERROR_NONE;
}

typedef struct _ScriptRegistration ScriptRegistration;
struct _ScriptRegistration
{
  gchar         *script;
  BseErrorType (*register_func) (const gchar *script,
				 BseJanitor **janitor_p);
  ScriptRegistration *next;
};

static gboolean	register_scripts (gpointer data);

static void
script_janitor_closed (BseJanitor *janitor,
		       BseServer  *server)
{
  bse_server_registration (server, BSE_REGISTER_SCRIPT, janitor->script_name, NULL);
  bse_idle_normal (register_scripts, server);
}

static gboolean
register_scripts (gpointer data)
{
  BseServer *server = data;
  ScriptRegistration *scr = g_object_get_data (server, "script-registration-queue");
  BseJanitor *janitor = NULL;
  BseErrorType error;
  
  if (!scr)
    {
      bse_server_registration (server, BSE_REGISTER_DONE, NULL, NULL);
      return FALSE;
    }
  g_object_set_data (server, "script-registration-queue", scr->next);
  
  error = scr->register_func (scr->script, &janitor);
  if (!janitor)
    bse_server_registration (server, BSE_REGISTER_SCRIPT, scr->script, bse_error_blurb (error));
  else
    g_object_connect (janitor, "signal::shutdown", script_janitor_closed, server, NULL);
  g_free (scr->script);
  g_free (scr);
  return !janitor;
}

/* --- register-scripts --- */
static void
register_scripts_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 211 "bseserver.proc"
 {
#line 213 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_STANDARD);
}
#line 216 "bseserver.proc"
 }
static BseErrorType
#line 216 "bseserver.proc"
register_scripts_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 219 "bseserver.proc"
{
  static gboolean registration_done = FALSE;
#line 221 "bseserver.proc"
  
  BseServer *server	       = bse_value_get_object (in_values++);
  ScriptRegistration *scr_list = NULL;
  SfiRing *ring;
  
#line 226 "bseserver.proc"
  
  if (!BSE_IS_SERVER (server))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  if (registration_done)
    {
      bse_server_registration (server, BSE_REGISTER_DONE, NULL, NULL);
      return BSE_ERROR_NONE;
    }
  registration_done = TRUE;
  
  ring = bse_script_path_list_files ();
  while (ring)
    {
      ScriptRegistration *scr = g_new0 (ScriptRegistration, 1);
      scr->script = sfi_ring_pop_head (&ring);
      scr->register_func = bse_script_file_register;
      scr->next = scr_list;
      scr_list = scr;
    }
  
  g_object_set_data (server, "script-registration-queue", scr_list);
  bse_idle_normal (register_scripts, server);
  
  return BSE_ERROR_NONE;
}

static gboolean
register_core_plugins (gpointer data)
{
  BseServer *server = data;
  SfiRing *plugins = g_object_get_data (server, "plugin-registration-queue");
  const gchar *error;
  
  if (plugins)
    {
      gchar *name = sfi_ring_pop_head (&plugins);
      g_object_set_data (server, "plugin-registration-queue", plugins);
      error = bse_plugin_check_load (name);
      bse_server_registration (server, BSE_REGISTER_PLUGIN, name, error);
      g_free (name);
    }
  else
    {
      bse_server_registration (server, BSE_REGISTER_DONE, NULL, NULL);
      return FALSE;
    }
  return TRUE;
}

/* --- register-core-plugins --- */
static void
register_core_plugins_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 276 "bseserver.proc"
 {
#line 278 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_STANDARD);
}
#line 281 "bseserver.proc"
 }
static BseErrorType
#line 281 "bseserver.proc"
register_core_plugins_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 284 "bseserver.proc"
{
  static gboolean registration_done = FALSE;
#line 286 "bseserver.proc"
  
  BseServer *server	= bse_value_get_object (in_values++);
  SfiRing *ring;
  
#line 290 "bseserver.proc"
  
  if (!BSE_IS_SERVER (server))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  if (registration_done)
    {
      bse_server_registration (server, BSE_REGISTER_DONE, NULL, NULL);
      return BSE_ERROR_NONE;
    }
  registration_done = TRUE;
  
  ring = bse_plugin_path_list_files (!bse_main_args->load_drivers_early, TRUE);
  g_object_set_data (server, "plugin-registration-queue", ring);
  
  bse_idle_normal (register_core_plugins, server);
  
  return BSE_ERROR_NONE;
}

static gboolean
register_ladspa_plugins (gpointer data)
{
  BseServer *server = data;
  SfiRing *lplugins = g_object_get_data (server, "ladspa-registration-queue");
  const gchar *error;
  
  if (g_object_get_data (server, "plugin-registration-queue"))
    {
#line 318 "bseserver.proc"
      
      return TRUE;
    }
  
  if (lplugins)
    {
      gchar *name = sfi_ring_pop_head (&lplugins);
      g_object_set_data (server, "ladspa-registration-queue", lplugins);
      error = bse_ladspa_plugin_check_load (name);
      bse_server_registration (server, BSE_REGISTER_PLUGIN, name, error);
      g_free (name);
    }
  else
    {
      bse_server_registration (server, BSE_REGISTER_DONE, NULL, NULL);
      return FALSE;
    }
  return TRUE;
}

/* --- register-ladspa-plugins --- */
static void
register_ladspa_plugins_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 338 "bseserver.proc"
 {
#line 340 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_STANDARD);
}
#line 343 "bseserver.proc"
 }
static BseErrorType
#line 343 "bseserver.proc"
register_ladspa_plugins_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 346 "bseserver.proc"
{
  static gboolean registration_done = FALSE;
#line 348 "bseserver.proc"
  
  BseServer *server	= bse_value_get_object (in_values++);
  SfiRing *ring;
  
#line 352 "bseserver.proc"
  
  if (!BSE_IS_SERVER (server))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  if (registration_done)
    {
      bse_server_registration (server, BSE_REGISTER_DONE, NULL, NULL);
      return BSE_ERROR_NONE;
    }
  registration_done = TRUE;
  
  ring = bse_ladspa_plugin_path_list_files ();
  g_object_set_data (server, "ladspa-registration-queue", ring);
  
  bse_idle_normal (register_ladspa_plugins, server);
  
  return BSE_ERROR_NONE;
}

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

/* --- save-preferences --- */
static void
save_preferences_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 376 "bseserver.proc"
 {
#line 378 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_STANDARD);
}
#line 381 "bseserver.proc"
 }
static BseErrorType
#line 381 "bseserver.proc"
save_preferences_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 384 "bseserver.proc"
{
#line 385 "bseserver.proc"
  
  BseServer *server = bse_value_get_object (in_values++);
  SfiWStore *wstore;
  gchar *file_name;
  GValue *value;
  SfiRec *rec;
  gint fd;
  
#line 393 "bseserver.proc"
  
  if (!BSE_IS_SERVER (server))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  file_name = g_strconcat (g_get_home_dir (), "/.bserc", NULL);
  fd = open (file_name,
#line 399 "bseserver.proc"
	     O_WRONLY | O_CREAT | O_TRUNC, 
	     0666);
  g_free (file_name);
  if (fd < 0)
    return BSE_ERROR_NONE;
  
  wstore = sfi_wstore_new ();
  sfi_wstore_printf (wstore, "; rc-file for BSE v%s\n", BSE_VERSION);
  
#line 408 "bseserver.proc"
  
  sfi_wstore_puts (wstore, "\n; BseGConfig Dump\n");
  rec = bse_gconfig_to_rec (bse_global_config);
  value = sfi_value_rec (rec);
  sfi_wstore_put_param (wstore, value, bse_gconfig_pspec ());
  sfi_value_free (value);
  sfi_rec_unref (rec);
  sfi_wstore_puts (wstore, "\n");
  
#line 417 "bseserver.proc"
  
  sfi_wstore_flush_fd (wstore, fd);
  sfi_wstore_destroy (wstore);
  close (fd);
  
  return BSE_ERROR_NONE;
}

/* --- start-recording --- */
static void
start_recording_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 425 "bseserver.proc"
 {
#line 427 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("wave-file", NULL, NULL, NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_real ("n_seconds", NULL, "Maximum number of recorded seconds",
			  0, 0, SFI_MAXNUM, 60, SFI_PARAM_STANDARD);
}
#line 433 "bseserver.proc"
 }
static BseErrorType
#line 433 "bseserver.proc"
start_recording_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 436 "bseserver.proc"
{
#line 437 "bseserver.proc"
  
  BseServer *server     = bse_value_get_object (in_values++);
  const char *wave_file = g_value_get_string (in_values++);
  double n_seconds      = g_value_get_double (in_values++);

#line 442 "bseserver.proc"
  
  if (!BSE_IS_SERVER (server))
    return BSE_ERROR_PROC_PARAM_INVAL;

  bse_server_start_recording (server, wave_file, n_seconds);
  return BSE_ERROR_NONE;
}

/* --- get-version --- */
static void
get_version_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 450 "bseserver.proc"
 {
#line 452 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_string ("version", NULL, NULL, NULL, SFI_PARAM_STANDARD);
}
#line 456 "bseserver.proc"
 }
static BseErrorType
#line 456 "bseserver.proc"
get_version_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 459 "bseserver.proc"
{
  sfi_value_set_string (out_values++, BSE_VERSION);
  return BSE_ERROR_NONE;
}

/* --- get-demo-path --- */
static void
get_demo_path_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 464 "bseserver.proc"
 {
#line 466 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_string ("path", NULL, NULL, NULL, SFI_PARAM_STANDARD);
}
#line 470 "bseserver.proc"
 }
static BseErrorType
#line 470 "bseserver.proc"
get_demo_path_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 473 "bseserver.proc"
{
  sfi_value_set_string (out_values++, BSE_PATH_DEMOS);
  return BSE_ERROR_NONE;
}

/* --- get-sample-path --- */
static void
get_sample_path_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 478 "bseserver.proc"
 {
#line 480 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_string ("path", NULL, NULL, NULL, SFI_PARAM_STANDARD);
}
#line 484 "bseserver.proc"
 }
static BseErrorType
#line 484 "bseserver.proc"
get_sample_path_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 487 "bseserver.proc"
{
  sfi_value_take_string (out_values++, g_path_concat (BSE_PATH_SAMPLES, BSE_GCONFIG (sample_path), NULL));
  return BSE_ERROR_NONE;
}

/* --- get-custom-effect-dir --- */
static void
get_custom_effect_dir_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 492 "bseserver.proc"
 {
#line 494 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_string ("directory", NULL, NULL, NULL, SFI_PARAM_STANDARD);
}
#line 498 "bseserver.proc"
 }
static BseErrorType
#line 498 "bseserver.proc"
get_custom_effect_dir_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 501 "bseserver.proc"
{
  gchar **dirs = g_strsplit (BSE_GCONFIG (effect_path), G_SEARCHPATH_SEPARATOR_S, 2);
  sfi_value_set_string (out_values++, dirs[0]);
  g_strfreev (dirs);
  return BSE_ERROR_NONE;
}

/* --- get-effect-path --- */
static void
get_effect_path_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 508 "bseserver.proc"
 {
#line 510 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_string ("path", NULL, NULL, NULL, SFI_PARAM_STANDARD);
}
#line 514 "bseserver.proc"
 }
static BseErrorType
#line 514 "bseserver.proc"
get_effect_path_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 517 "bseserver.proc"
{
  sfi_value_take_string (out_values++, g_path_concat (BSE_PATH_EFFECTS, BSE_GCONFIG (effect_path), NULL));
  return BSE_ERROR_NONE;
}

/* --- get-custom-instrument-dir --- */
static void
get_custom_instrument_dir_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 522 "bseserver.proc"
 {
#line 524 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_string ("directory", NULL, NULL, NULL, SFI_PARAM_STANDARD);
}
#line 528 "bseserver.proc"
 }
static BseErrorType
#line 528 "bseserver.proc"
get_custom_instrument_dir_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 531 "bseserver.proc"
{
  gchar **dirs = g_strsplit (BSE_GCONFIG (instrument_path), G_SEARCHPATH_SEPARATOR_S, 2);
  sfi_value_set_string (out_values++, dirs[0]);
  g_strfreev (dirs);
  return BSE_ERROR_NONE;
}

/* --- get-instrument-path --- */
static void
get_instrument_path_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 538 "bseserver.proc"
 {
#line 540 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_string ("path", NULL, NULL, NULL, SFI_PARAM_STANDARD);
}
#line 544 "bseserver.proc"
 }
static BseErrorType
#line 544 "bseserver.proc"
get_instrument_path_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 547 "bseserver.proc"
{
  sfi_value_take_string (out_values++, g_path_concat (BSE_PATH_INSTRUMENTS, BSE_GCONFIG (instrument_path), NULL));
  return BSE_ERROR_NONE;
}

/* --- get-script-path --- */
static void
get_script_path_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 552 "bseserver.proc"
 {
#line 554 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_string ("path", NULL, NULL, NULL, SFI_PARAM_STANDARD);
}
#line 558 "bseserver.proc"
 }
static BseErrorType
#line 558 "bseserver.proc"
get_script_path_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 561 "bseserver.proc"
{
  sfi_value_take_string (out_values++, g_path_concat (BSE_PATH_SCRIPTS, BSE_GCONFIG (script_path), NULL));
  return BSE_ERROR_NONE;
}

/* --- get-plugin-path --- */
static void
get_plugin_path_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 566 "bseserver.proc"
 {
#line 568 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_string ("path", NULL, NULL, NULL, SFI_PARAM_STANDARD);
}
#line 572 "bseserver.proc"
 }
static BseErrorType
#line 572 "bseserver.proc"
get_plugin_path_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 575 "bseserver.proc"
{
  sfi_value_take_string (out_values++, g_path_concat (BSE_PATH_PLUGINS, BSE_GCONFIG (plugin_path), NULL));
  return BSE_ERROR_NONE;
}

/* --- get-ladspa-path --- */
static void
get_ladspa_path_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 580 "bseserver.proc"
 {
#line 582 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_string ("path", NULL, NULL, NULL, SFI_PARAM_STANDARD);
}
#line 586 "bseserver.proc"
 }
static BseErrorType
#line 586 "bseserver.proc"
get_ladspa_path_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 589 "bseserver.proc"
{
  sfi_value_take_string (out_values++, g_path_concat (BSE_PATH_LADSPA, BSE_GCONFIG (ladspa_path), NULL));
  return BSE_ERROR_NONE;
}

#include "gslvorbis-enc.h"

/* --- get-vorbis-version --- */
static void
get_vorbis_version_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 596 "bseserver.proc"
 {
#line 598 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_string ("version", NULL, NULL, NULL, SFI_PARAM_STANDARD);
}
#line 602 "bseserver.proc"
 }
static BseErrorType
#line 602 "bseserver.proc"
get_vorbis_version_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 605 "bseserver.proc"
{
  gchar *v = gsl_vorbis_encoder_version();
  if (v && strncmp (v, "Xiphophorus libVorbis", 21) == 0)
    sfi_value_take_string (out_values++, g_strconcat ("Ogg/Vorbis", v + 21, NULL));
  else if (v && strncmp (v, "Xiph.Org libVorbis", 18) == 0)
    sfi_value_take_string (out_values++, g_strconcat ("Ogg/Vorbis", v + 18, NULL));
  else if (v)
    sfi_value_take_string (out_values++, g_strconcat ("Ogg/Vorbis ", v, NULL));
  g_free (v);
  return BSE_ERROR_NONE;
}

#include "gsldatahandle-mad.h"

/* --- get-mp3-version --- */
static void
get_mp3_version_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 619 "bseserver.proc"
 {
#line 621 "bseserver.proc"
  *(in_pspecs++) = bse_param_spec_object ("server", "Server", NULL,
				 BSE_TYPE_SERVER, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_string ("version", NULL, NULL, NULL, SFI_PARAM_STANDARD);
}
#line 625 "bseserver.proc"
 }
static BseErrorType
#line 625 "bseserver.proc"
get_mp3_version_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 628 "bseserver.proc"
{
  const gchar *c = gsl_data_handle_mad_version ();
  if (c)
    sfi_value_take_string (out_values++, g_strconcat ("MAD ", c, NULL));
  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
static void
__enode_use_new_project__fill_strings (BseExportStrings *es)
{
  es->blurb = "Create a new project, owned by the caller (name is modified to be unique if necessary)";
  es->file = "/opt/src/beast/bse/bseserver.proc";
  es->line = 37;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_use_new_project = {
  { NULL, BSE_EXPORT_NODE_PROC,
    "BseServer+use-new-project", 
    NULL,
    "/Methods/BseServer/General/Use New Project",
    NULL,
    __enode_use_new_project__fill_strings,
  },
  0, use_new_project_setup, use_new_project_exec, 
};
static void
__enode_can_load__fill_strings (BseExportStrings *es)
{
  es->blurb = "Check whether a loader can be found for a wave file";
  es->file = "/opt/src/beast/bse/bseserver.proc";
  es->line = 81;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_can_load = {
  { (BseExportNode*) &__enode_use_new_project, BSE_EXPORT_NODE_PROC,
    "BseServer+can-load", 
    NULL,
    "/Methods/BseServer/General/Can Load",
    NULL,
    __enode_can_load__fill_strings,
  },
  0, can_load_setup, can_load_exec, 
};
static void
__enode_n_scripts__fill_strings (BseExportStrings *es)
{
  es->blurb = "Return the number of scripts currently running on this server.";
  es->file = "/opt/src/beast/bse/bseserver.proc";
  es->line = 112;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_n_scripts = {
  { (BseExportNode*) &__enode_can_load, BSE_EXPORT_NODE_PROC,
    "BseServer+n-scripts", 
    NULL,
    "/Methods/BseServer/General/N Scripts",
    NULL,
    __enode_n_scripts__fill_strings,
  },
  0, n_scripts_setup, n_scripts_exec, 
};
static void
__enode_preferences_locked__fill_strings (BseExportStrings *es)
{
  es->blurb = "Returns whether the bse-preferences property is currently locked against modifications or not.";
  es->file = "/opt/src/beast/bse/bseserver.proc";
  es->line = 144;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_preferences_locked = {
  { (BseExportNode*) &__enode_n_scripts, BSE_EXPORT_NODE_PROC,
    "BseServer+preferences-locked", 
    NULL,
    "/Methods/BseServer/General/Preferences Locked",
    NULL,
    __enode_preferences_locked__fill_strings,
  },
  0, preferences_locked_setup, preferences_locked_exec, 
};
static void
__enode_register_scripts__fill_strings (BseExportStrings *es)
{
  es->blurb = "Register external scripts.";
  es->file = "/opt/src/beast/bse/bseserver.proc";
  es->line = 212;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_register_scripts = {
  { (BseExportNode*) &__enode_preferences_locked, BSE_EXPORT_NODE_PROC,
    "BseServer+register-scripts", 
    NULL,
    "/Methods/BseServer/General/Register Scripts",
    NULL,
    __enode_register_scripts__fill_strings,
  },
  0, register_scripts_setup, register_scripts_exec, 
};
static void
__enode_register_core_plugins__fill_strings (BseExportStrings *es)
{
  es->blurb = "Register core plugins.";
  es->file = "/opt/src/beast/bse/bseserver.proc";
  es->line = 277;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_register_core_plugins = {
  { (BseExportNode*) &__enode_register_scripts, BSE_EXPORT_NODE_PROC,
    "BseServer+register-core-plugins", 
    NULL,
    "/Methods/BseServer/General/Register Core Plugins",
    NULL,
    __enode_register_core_plugins__fill_strings,
  },
  0, register_core_plugins_setup, register_core_plugins_exec, 
};
static void
__enode_register_ladspa_plugins__fill_strings (BseExportStrings *es)
{
  es->blurb = "Register LADSPA (Linux Audio Developer's Simple Plugin API) plugins.";
  es->file = "/opt/src/beast/bse/bseserver.proc";
  es->line = 339;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_register_ladspa_plugins = {
  { (BseExportNode*) &__enode_register_core_plugins, BSE_EXPORT_NODE_PROC,
    "BseServer+register-ladspa-plugins", 
    NULL,
    "/Methods/BseServer/General/Register Ladspa Plugins",
    NULL,
    __enode_register_ladspa_plugins__fill_strings,
  },
  0, register_ladspa_plugins_setup, register_ladspa_plugins_exec, 
};
static void
__enode_save_preferences__fill_strings (BseExportStrings *es)
{
  es->blurb = "Request the bse-preferences property to be saved into BSE's configuration file.";
  es->file = "/opt/src/beast/bse/bseserver.proc";
  es->line = 377;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_save_preferences = {
  { (BseExportNode*) &__enode_register_ladspa_plugins, BSE_EXPORT_NODE_PROC,
    "BseServer+save-preferences", 
    NULL,
    "/Methods/BseServer/General/Save Preferences",
    NULL,
    __enode_save_preferences__fill_strings,
  },
  0, save_preferences_setup, save_preferences_exec, 
};
static void
__enode_start_recording__fill_strings (BseExportStrings *es)
{
  es->blurb = "Start recording to a WAV file.";
  es->file = "/opt/src/beast/bse/bseserver.proc";
  es->line = 426;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_start_recording = {
  { (BseExportNode*) &__enode_save_preferences, BSE_EXPORT_NODE_PROC,
    "BseServer+start-recording", 
    NULL,
    "/Methods/BseServer/General/Start Recording",
    NULL,
    __enode_start_recording__fill_strings,
  },
  0, start_recording_setup, start_recording_exec, 
};
static void
__enode_get_version__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve BSE version.";
  es->file = "/opt/src/beast/bse/bseserver.proc";
  es->line = 451;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_version = {
  { (BseExportNode*) &__enode_start_recording, BSE_EXPORT_NODE_PROC,
    "BseServer+get-version", 
    NULL,
    "/Methods/BseServer/General/Get Version",
    NULL,
    __enode_get_version__fill_strings,
  },
  0, get_version_setup, get_version_exec, 
};
static void
__enode_get_demo_path__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve demo search path.";
  es->file = "/opt/src/beast/bse/bseserver.proc";
  es->line = 465;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_demo_path = {
  { (BseExportNode*) &__enode_get_version, BSE_EXPORT_NODE_PROC,
    "BseServer+get-demo-path", 
    NULL,
    "/Methods/BseServer/General/Get Demo Path",
    NULL,
    __enode_get_demo_path__fill_strings,
  },
  0, get_demo_path_setup, get_demo_path_exec, 
};
static void
__enode_get_sample_path__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve sample search path.";
  es->file = "/opt/src/beast/bse/bseserver.proc";
  es->line = 479;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_sample_path = {
  { (BseExportNode*) &__enode_get_demo_path, BSE_EXPORT_NODE_PROC,
    "BseServer+get-sample-path", 
    NULL,
    "/Methods/BseServer/General/Get Sample Path",
    NULL,
    __enode_get_sample_path__fill_strings,
  },
  0, get_sample_path_setup, get_sample_path_exec, 
};
static void
__enode_get_custom_effect_dir__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve user specific effects directory.";
  es->file = "/opt/src/beast/bse/bseserver.proc";
  es->line = 493;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_custom_effect_dir = {
  { (BseExportNode*) &__enode_get_sample_path, BSE_EXPORT_NODE_PROC,
    "BseServer+get-custom-effect-dir", 
    NULL,
    "/Methods/BseServer/General/Get Custom Effect Dir",
    NULL,
    __enode_get_custom_effect_dir__fill_strings,
  },
  0, get_custom_effect_dir_setup, get_custom_effect_dir_exec, 
};
static void
__enode_get_effect_path__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve effect search path.";
  es->file = "/opt/src/beast/bse/bseserver.proc";
  es->line = 509;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_effect_path = {
  { (BseExportNode*) &__enode_get_custom_effect_dir, BSE_EXPORT_NODE_PROC,
    "BseServer+get-effect-path", 
    NULL,
    "/Methods/BseServer/General/Get Effect Path",
    NULL,
    __enode_get_effect_path__fill_strings,
  },
  0, get_effect_path_setup, get_effect_path_exec, 
};
static void
__enode_get_custom_instrument_dir__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve user specific instruments directory.";
  es->file = "/opt/src/beast/bse/bseserver.proc";
  es->line = 523;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_custom_instrument_dir = {
  { (BseExportNode*) &__enode_get_effect_path, BSE_EXPORT_NODE_PROC,
    "BseServer+get-custom-instrument-dir", 
    NULL,
    "/Methods/BseServer/General/Get Custom Instrument Dir",
    NULL,
    __enode_get_custom_instrument_dir__fill_strings,
  },
  0, get_custom_instrument_dir_setup, get_custom_instrument_dir_exec, 
};
static void
__enode_get_instrument_path__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve instrument search path.";
  es->file = "/opt/src/beast/bse/bseserver.proc";
  es->line = 539;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_instrument_path = {
  { (BseExportNode*) &__enode_get_custom_instrument_dir, BSE_EXPORT_NODE_PROC,
    "BseServer+get-instrument-path", 
    NULL,
    "/Methods/BseServer/General/Get Instrument Path",
    NULL,
    __enode_get_instrument_path__fill_strings,
  },
  0, get_instrument_path_setup, get_instrument_path_exec, 
};
static void
__enode_get_script_path__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve script search path.";
  es->file = "/opt/src/beast/bse/bseserver.proc";
  es->line = 553;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_script_path = {
  { (BseExportNode*) &__enode_get_instrument_path, BSE_EXPORT_NODE_PROC,
    "BseServer+get-script-path", 
    NULL,
    "/Methods/BseServer/General/Get Script Path",
    NULL,
    __enode_get_script_path__fill_strings,
  },
  0, get_script_path_setup, get_script_path_exec, 
};
static void
__enode_get_plugin_path__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve plugin search path.";
  es->file = "/opt/src/beast/bse/bseserver.proc";
  es->line = 567;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_plugin_path = {
  { (BseExportNode*) &__enode_get_script_path, BSE_EXPORT_NODE_PROC,
    "BseServer+get-plugin-path", 
    NULL,
    "/Methods/BseServer/General/Get Plugin Path",
    NULL,
    __enode_get_plugin_path__fill_strings,
  },
  0, get_plugin_path_setup, get_plugin_path_exec, 
};
static void
__enode_get_ladspa_path__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve ladspa search path.";
  es->file = "/opt/src/beast/bse/bseserver.proc";
  es->line = 581;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_ladspa_path = {
  { (BseExportNode*) &__enode_get_plugin_path, BSE_EXPORT_NODE_PROC,
    "BseServer+get-ladspa-path", 
    NULL,
    "/Methods/BseServer/General/Get Ladspa Path",
    NULL,
    __enode_get_ladspa_path__fill_strings,
  },
  0, get_ladspa_path_setup, get_ladspa_path_exec, 
};
static void
__enode_get_vorbis_version__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve BSE Vorbis handler version.";
  es->file = "/opt/src/beast/bse/bseserver.proc";
  es->line = 597;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_vorbis_version = {
  { (BseExportNode*) &__enode_get_ladspa_path, BSE_EXPORT_NODE_PROC,
    "BseServer+get-vorbis-version", 
    NULL,
    "/Methods/BseServer/General/Get Vorbis Version",
    NULL,
    __enode_get_vorbis_version__fill_strings,
  },
  0, get_vorbis_version_setup, get_vorbis_version_exec, 
};
static void
__enode_get_mp3_version__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve BSE MP3 handler version.";
  es->file = "/opt/src/beast/bse/bseserver.proc";
  es->line = 620;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_mp3_version = {
  { (BseExportNode*) &__enode_get_vorbis_version, BSE_EXPORT_NODE_PROC,
    "BseServer+get-mp3-version", 
    NULL,
    "/Methods/BseServer/General/Get Mp3 Version",
    NULL,
    __enode_get_mp3_version__fill_strings,
  },
  0, get_mp3_version_setup, get_mp3_version_exec, 
};
BseExportNode* bse__builtin_init_bseserver_genprc_c (void);
BseExportNode* bse__builtin_init_bseserver_genprc_c (void)
{
  return (BseExportNode*) &__enode_get_mp3_version;
}

/*
 * Generated data ends here
 */
