
/**
 ** Generated data (by mkcproc.pl)
 **/
#line 1 "bsewaverepo.proc"

#include <bse/bseplugin.h>
#include <bse/bseprocedure.h>
#include <bse/bsewaverepo.h>
#include <bse/gslloader.h>
#include <bse/bsewave.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <errno.h>


#line 30 "bsewaverepo.proc"

static BseErrorType
load_file (BseWaveRepo *wrepo,
	   const gchar *file_name,
           BseWave    **wave_p)
{
  GslErrorType error;
  GslWaveFileInfo *finfo;
  GslWaveDsc *wdsc;
  BseWave *wave;
  gchar *fname;
  guint i;

  *wave_p = NULL;
  finfo = gsl_wave_file_info_load (file_name, &error);
  if (!finfo)
    return error;
  if (finfo->n_waves != 1)
    {
      gsl_wave_file_info_unref (finfo);
      return BSE_ERROR_FORMAT_UNKNOWN;
    }
  
  wdsc = gsl_wave_dsc_load (finfo, 0, &error);
  gsl_wave_file_info_unref (finfo);
  if (!wdsc)
    return error;
  
  fname = g_path_get_basename (file_name);
  wave = g_object_new (BSE_TYPE_WAVE,
		       "uname", fname,
		       NULL);
  g_free (fname);
  for (i = 0; i < wdsc->n_chunks; i++)
    {
      GslWaveChunk *wchunk = gsl_wave_chunk_create (wdsc, i, error ? NULL : &error);
      
      if (wchunk)
	bse_wave_add_chunk (wave, wchunk);
    }
  bse_wave_set_locator (wave, file_name, wdsc->name);
  
  gsl_wave_dsc_free (wdsc);
  
  if (wave->n_wchunks)
    {
      bse_container_add_item (BSE_CONTAINER (wrepo), BSE_ITEM (wave));
      *wave_p = wave;
      error = GSL_ERROR_NONE;
    }
  else
    error = BSE_ERROR_WAVE_NOT_FOUND;
  g_object_unref (wave);
  
  return error;
}


#line 88 "bsewaverepo.proc"

#line 91 "bsewaverepo.proc"


/* --- load-file --- */
static void
load_file_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 93 "bsewaverepo.proc"
 {
#line 95 "bsewaverepo.proc"
  *(in_pspecs++)    = bse_param_spec_object ("wave_repo", "Wave Repo", NULL,
				 BSE_TYPE_WAVE_REPO, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_string ("file_name", "File Name", "The file to import waves from",
			    NULL, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", NULL,
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_DEFAULT);
}
#line 94 "bsewaverepo.proc"
  proc->help = "Load wave from file";
#line 89 "bsewaverepo.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 90 "bsewaverepo.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 103 "bsewaverepo.proc"
 }
static BseErrorType
#line 103 "bsewaverepo.proc"
load_file_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 106 "bsewaverepo.proc"
{
#line 107 "bsewaverepo.proc"
  
  BseWaveRepo *self    = (BseWaveRepo*) bse_value_get_object (in_values++);
  gchar *file_name     = sfi_value_get_string (in_values++);
  BseUndoStack *ustack;
  BseErrorType error;
  BseWave *wave;
  
#line 114 "bsewaverepo.proc"
  
  if (!BSE_IS_WAVE_REPO (self) || !file_name)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  ustack = bse_item_undo_open (self, "load-wave");
  error = load_file (self, file_name, &wave);
  if (wave)
    bse_item_push_undo_proc (self, "remove-wave", wave);
  bse_item_undo_close (ustack);
  
#line 124 "bsewaverepo.proc"
  
  g_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- remove-wave --- */
static void
remove_wave_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 130 "bsewaverepo.proc"
 {
#line 132 "bsewaverepo.proc"
  *(in_pspecs++)    = bse_param_spec_object ("wave_repo", "Wave Repo", NULL,
				 BSE_TYPE_WAVE_REPO, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = bse_param_spec_object ("wave", "Wave", NULL,
				 BSE_TYPE_WAVE, SFI_PARAM_DEFAULT);
#line 131 "bsewaverepo.proc"
  proc->help = "Remove a wave from repository";
#line 89 "bsewaverepo.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 90 "bsewaverepo.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 136 "bsewaverepo.proc"
}  }
static BseErrorType
#line 136 "bsewaverepo.proc"
remove_wave_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 139 "bsewaverepo.proc"
{
#line 140 "bsewaverepo.proc"
  
  BseWaveRepo *self = (BseWaveRepo*) bse_value_get_object (in_values++);
  BseItem *child    = (BseItem*) bse_value_get_object (in_values++);
  BseUndoStack *ustack;

#line 145 "bsewaverepo.proc"
  
  if (!BSE_IS_WAVE_REPO (self) || !BSE_IS_WAVE (child) ||
      child->parent != BSE_ITEM (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 150 "bsewaverepo.proc"
  
  ustack = bse_item_undo_open (self, "remove-wave %s", bse_object_debug_name (child));
#line 152 "bsewaverepo.proc"
  
  bse_container_uncross_undoable (BSE_CONTAINER (self), child);
#line 154 "bsewaverepo.proc"
  
  bse_item_push_redo_proc (self, "remove-wave", child);
#line 156 "bsewaverepo.proc"
  
  bse_container_remove_backedup (BSE_CONTAINER (self), child, ustack);
#line 158 "bsewaverepo.proc"
  
  bse_item_undo_close (ustack);
  
  return BSE_ERROR_NONE;
}

/* --- bse-sample-file-info --- */
static void
bse_sample_file_info_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 164 "bsewaverepo.proc"
 {
#line 166 "bsewaverepo.proc"
  *(in_pspecs++) = sfi_pspec_string ("file_name", "File Name", "The file to load info from",
			    NULL, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_boxed ("sample_file_info", NULL, NULL, BSE_TYPE_SAMPLE_FILE_INFO, SFI_PARAM_DEFAULT);
}
#line 165 "bsewaverepo.proc"
  proc->help = "Load sample file info from file";
#line 89 "bsewaverepo.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 90 "bsewaverepo.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 170 "bsewaverepo.proc"
 }
static BseErrorType
#line 170 "bsewaverepo.proc"
bse_sample_file_info_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 173 "bsewaverepo.proc"
{
#line 174 "bsewaverepo.proc"
  
  gchar *filename = sfi_value_get_string (in_values++);
  BseSampleFileInfo info = { 0, };
  GslWaveFileInfo *wfi = NULL;
  struct stat sbuf = { 0, };

#line 180 "bsewaverepo.proc"
  
  if (!filename)
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 184 "bsewaverepo.proc"
  
  info.file = filename;
  info.waves = bse_string_seq_new ();
  if (stat (filename, &sbuf) < 0)
    info.error = bse_error_from_errno (errno, BSE_ERROR_FILE_OPEN_FAILED);
  else
    {
      info.size = sbuf.st_size;
      info.mtime = sbuf.st_mtime * SFI_USEC_FACTOR;
      wfi = gsl_wave_file_info_load (filename, &info.error);
      if (wfi)
	{
	  guint i;
	  for (i = 0; i < wfi->n_waves; i++)
	    bse_string_seq_append (info.waves, wfi->waves[i].name);
	  info.loader = (gchar*) gsl_wave_file_info_loader (wfi);
	}
    }

#line 203 "bsewaverepo.proc"
  
  bse_value_set_boxed (out_values++, &info);

#line 206 "bsewaverepo.proc"
  
  bse_string_seq_free (info.waves);
  if (wfi)
    gsl_wave_file_info_unref (wfi);

  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
static BseExportNodeProc __enode_load_file = {
  { NULL, BSE_EXPORT_NODE_PROC,
    "BseWaveRepo+load-file", "/Methods/BseWaveRepo/General/Load File", NULL },
  0, load_file_setup, load_file_exec, 
};
static BseExportNodeProc __enode_remove_wave = {
  { (BseExportNode*) &__enode_load_file, BSE_EXPORT_NODE_PROC,
    "BseWaveRepo+remove-wave", "/Methods/BseWaveRepo/General/Remove Wave", NULL },
  0, remove_wave_setup, remove_wave_exec, 
};
static BseExportNodeProc __enode_bse_sample_file_info = {
  { (BseExportNode*) &__enode_remove_wave, BSE_EXPORT_NODE_PROC,
    "bse-sample-file-info", "/Proc/Sample File Info", NULL },
  0, bse_sample_file_info_setup, bse_sample_file_info_exec, 
};
BseExportNode* bse__builtin_init_bsewaverepo_gen_proc_c (void);
BseExportNode* bse__builtin_init_bsewaverepo_gen_proc_c (void)
{
  return (BseExportNode*) &__enode_bse_sample_file_info;
}

/**
 ** Generated data ends here
 **/
