
/**
 ** Generated data (by mkcproc.pl)
 **/
#line 1 "bsejanitor.proc"

#include <bse/bseplugin.h>
#include <bse/bseprocedure.h>
#include <bse/bsejanitor.h>
#include <bse/bseserver.h>
#include <string.h>


#line 27 "bsejanitor.proc"


/* --- trigger-action --- */
static void
trigger_action_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 29 "bsejanitor.proc"
 {
#line 31 "bsejanitor.proc"
  *(in_pspecs++) = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_string ("action", "Action", NULL,
			    NULL, SFI_PARAM_DEFAULT);
}
#line 30 "bsejanitor.proc"
  proc->help = "Trigger an installed user action of this janitor.";
#line 25 "bsejanitor.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 26 "bsejanitor.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 36 "bsejanitor.proc"
 }
static BseErrorType
#line 36 "bsejanitor.proc"
trigger_action_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 39 "bsejanitor.proc"
{
#line 40 "bsejanitor.proc"
  
  BseJanitor  *self   = bse_value_get_object (in_values++);
  const gchar *action = sfi_value_get_string (in_values++);
  
#line 44 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self) || !action)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 48 "bsejanitor.proc"
  
  bse_janitor_trigger_action (self, action);
  
  return BSE_ERROR_NONE;
}

/* --- get-script-name --- */
static void
get_script_name_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 54 "bsejanitor.proc"
 {
#line 56 "bsejanitor.proc"
  *(in_pspecs++) = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_DEFAULT);
  *(out_pspecs++)    = sfi_pspec_string ("script_name", "Script Name", NULL,
			     NULL, SFI_PARAM_DEFAULT);
}
#line 55 "bsejanitor.proc"
  proc->help = "Retrieve the script name of this janitor.";
#line 25 "bsejanitor.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 26 "bsejanitor.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 61 "bsejanitor.proc"
 }
static BseErrorType
#line 61 "bsejanitor.proc"
get_script_name_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 64 "bsejanitor.proc"
{
#line 65 "bsejanitor.proc"
  
  BseJanitor *self = bse_value_get_object (in_values++);
  
#line 68 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 72 "bsejanitor.proc"
  
  sfi_value_set_string (out_values++, bse_janitor_get_script (self));
  
  return BSE_ERROR_NONE;
}

/* --- get-proc-name --- */
static void
get_proc_name_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 78 "bsejanitor.proc"
 {
#line 80 "bsejanitor.proc"
  *(in_pspecs++) = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_DEFAULT);
  *(out_pspecs++)    = sfi_pspec_string ("proc_name", "Proc Name", NULL,
			     NULL, SFI_PARAM_DEFAULT);
}
#line 79 "bsejanitor.proc"
  proc->help = "Retrieve the procedure name of this janitor.";
#line 25 "bsejanitor.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 26 "bsejanitor.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 85 "bsejanitor.proc"
 }
static BseErrorType
#line 85 "bsejanitor.proc"
get_proc_name_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 88 "bsejanitor.proc"
{
#line 89 "bsejanitor.proc"
  
  BseJanitor *self = bse_value_get_object (in_values++);
  
#line 92 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 96 "bsejanitor.proc"
  
  sfi_value_set_string (out_values++, self->proc_name);
  
  return BSE_ERROR_NONE;
}

/* --- n-actions --- */
static void
n_actions_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 102 "bsejanitor.proc"
 {
#line 104 "bsejanitor.proc"
  *(in_pspecs++) = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = sfi_pspec_int ("n_actions", "N Actions", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_DEFAULT);
}
#line 103 "bsejanitor.proc"
  proc->help = "Retrieve number of user actions of this janitor.";
#line 25 "bsejanitor.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 26 "bsejanitor.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 109 "bsejanitor.proc"
 }
static BseErrorType
#line 109 "bsejanitor.proc"
n_actions_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 112 "bsejanitor.proc"
{
#line 113 "bsejanitor.proc"
  
  BseJanitor *self = bse_value_get_object (in_values++);
  
#line 116 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 120 "bsejanitor.proc"
  
  sfi_value_set_int (out_values++, g_slist_length (self->actions));
  
  return BSE_ERROR_NONE;
}

/* --- get-action --- */
static void
get_action_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 126 "bsejanitor.proc"
 {
#line 128 "bsejanitor.proc"
  *(in_pspecs++) = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("nth_action", "Nth Action", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = sfi_pspec_string ("action", "Action", NULL,
			    NULL, SFI_PARAM_DEFAULT);
}
#line 127 "bsejanitor.proc"
  proc->help = "Retrieve an action of this janitor.";
#line 25 "bsejanitor.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 26 "bsejanitor.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 135 "bsejanitor.proc"
 }
static BseErrorType
#line 135 "bsejanitor.proc"
get_action_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 138 "bsejanitor.proc"
{
#line 139 "bsejanitor.proc"
  
  BseJanitor       *self = bse_value_get_object (in_values++);
  guint             nth  = sfi_value_get_int (in_values++);
  BseJanitorAction *a;
  
#line 144 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  a = g_slist_nth_data (self->actions, nth);
  
#line 150 "bsejanitor.proc"
  
  sfi_value_set_string (out_values++, a ? g_quark_to_string (a->action) : NULL);
  
  return BSE_ERROR_NONE;
}

/* --- get-action-name --- */
static void
get_action_name_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 156 "bsejanitor.proc"
 {
#line 158 "bsejanitor.proc"
  *(in_pspecs++) = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("nth_action", "Nth Action", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = sfi_pspec_string ("action-name", "Action Name", NULL,
			    NULL, SFI_PARAM_DEFAULT);
}
#line 157 "bsejanitor.proc"
  proc->help = "Retrieve the name of an action of this janitor.";
#line 25 "bsejanitor.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 26 "bsejanitor.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 165 "bsejanitor.proc"
 }
static BseErrorType
#line 165 "bsejanitor.proc"
get_action_name_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 168 "bsejanitor.proc"
{
#line 169 "bsejanitor.proc"
  
  BseJanitor       *self = bse_value_get_object (in_values++);
  guint             nth  = sfi_value_get_int (in_values++);
  BseJanitorAction *a;
  
#line 174 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  a = g_slist_nth_data (self->actions, nth);
  
#line 180 "bsejanitor.proc"
  
  sfi_value_set_string (out_values++, a ? a->name : NULL);
  
  return BSE_ERROR_NONE;
}

/* --- get-action-blurb --- */
static void
get_action_blurb_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 186 "bsejanitor.proc"
 {
#line 188 "bsejanitor.proc"
  *(in_pspecs++) = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("nth_action", "Nth Action", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = sfi_pspec_string ("action-blurb", "Action Blurb", NULL,
			    NULL, SFI_PARAM_DEFAULT);
}
#line 187 "bsejanitor.proc"
  proc->help = "Retrieve the help string of an action of this janitor.";
#line 25 "bsejanitor.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 26 "bsejanitor.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 195 "bsejanitor.proc"
 }
static BseErrorType
#line 195 "bsejanitor.proc"
get_action_blurb_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 198 "bsejanitor.proc"
{
#line 199 "bsejanitor.proc"
  
  BseJanitor       *self = bse_value_get_object (in_values++);
  guint             nth  = sfi_value_get_int (in_values++);
  BseJanitorAction *a;
  
#line 204 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  a = g_slist_nth_data (self->actions, nth);
  
#line 210 "bsejanitor.proc"
  
  sfi_value_set_string (out_values++, a ? a->blurb : NULL);
  
  return BSE_ERROR_NONE;
}

/* --- kill --- */
static void
kill_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 216 "bsejanitor.proc"
 {
#line 218 "bsejanitor.proc"
  *(in_pspecs++) = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_DEFAULT);
}
#line 217 "bsejanitor.proc"
  proc->help = "Kill a currently running janitor.";
#line 25 "bsejanitor.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 26 "bsejanitor.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 221 "bsejanitor.proc"
 }
static BseErrorType
#line 221 "bsejanitor.proc"
kill_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 224 "bsejanitor.proc"
{
#line 225 "bsejanitor.proc"
  
  BseJanitor *self = bse_value_get_object (in_values++);
  
#line 228 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 232 "bsejanitor.proc"
  
  bse_janitor_kill (self);
  
  return BSE_ERROR_NONE;
}

/* --- add-action --- */
static void
add_action_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 238 "bsejanitor.proc"
 {
#line 240 "bsejanitor.proc"
  *(in_pspecs++)    = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_string ("action", "Action", NULL,
			    NULL, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_string ("name", "Name", NULL,
			    NULL, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_string ("blurb", "Blurb", NULL,
			    NULL, SFI_PARAM_DEFAULT);
}
#line 239 "bsejanitor.proc"
  proc->help = "Install a user action for script control.";
#line 25 "bsejanitor.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 26 "bsejanitor.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 249 "bsejanitor.proc"
 }
static BseErrorType
#line 249 "bsejanitor.proc"
add_action_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 252 "bsejanitor.proc"
{
#line 253 "bsejanitor.proc"
  
  BseJanitor       *self   = bse_value_get_object (in_values++);
  const gchar      *action = sfi_value_get_string (in_values++);
  const gchar      *name   = sfi_value_get_string (in_values++);
  const gchar      *blurb  = sfi_value_get_string (in_values++);
  
#line 259 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self) || !action || !name)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 263 "bsejanitor.proc"
  
  if (!self->port || self->close_pending)
    return BSE_ERROR_PROC_EXECUTION;
  
#line 267 "bsejanitor.proc"
  
  bse_janitor_add_action (self, action, name, blurb);
  
  return BSE_ERROR_NONE;
}

/* --- remove-action --- */
static void
remove_action_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 273 "bsejanitor.proc"
 {
#line 275 "bsejanitor.proc"
  *(in_pspecs++) = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_string ("action", "Action", NULL,
			    NULL, SFI_PARAM_DEFAULT);
}
#line 274 "bsejanitor.proc"
  proc->help = "Remove a previously installed user action from script control.";
#line 25 "bsejanitor.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 26 "bsejanitor.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 280 "bsejanitor.proc"
 }
static BseErrorType
#line 280 "bsejanitor.proc"
remove_action_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 283 "bsejanitor.proc"
{
#line 284 "bsejanitor.proc"
  
  BseJanitor  *self = bse_value_get_object (in_values++);
  const gchar *action = sfi_value_get_string (in_values++);
  
#line 288 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self) || !action)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 292 "bsejanitor.proc"
  
  if (!self->port || self->close_pending)
    return BSE_ERROR_PROC_EXECUTION;
  
#line 296 "bsejanitor.proc"
  
  bse_janitor_remove_action (self, action);
  
  return BSE_ERROR_NONE;
}

/* --- bse-janitor-get-specific --- */
static void
bse_janitor_get_specific_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 302 "bsejanitor.proc"
 {
#line 304 "bsejanitor.proc"
  *(out_pspecs++)   = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_DEFAULT);
}
#line 303 "bsejanitor.proc"
  proc->help = "Retrieve the connection dependant janitor object.";
#line 25 "bsejanitor.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 26 "bsejanitor.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 307 "bsejanitor.proc"
 }
static BseErrorType
#line 307 "bsejanitor.proc"
bse_janitor_get_specific_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 310 "bsejanitor.proc"
{
  BseJanitor *self = bse_janitor_get_current ();
  
#line 313 "bsejanitor.proc"
  
  if (!self || !self->port || self->close_pending)
    return BSE_ERROR_PROC_EXECUTION;

#line 317 "bsejanitor.proc"
  
  bse_value_set_object (out_values++, self);
  
  return BSE_ERROR_NONE;
}

/* --- set-msg --- */
static void
set_msg_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 323 "bsejanitor.proc"
 {
#line 325 "bsejanitor.proc"
  *(in_pspecs++)    = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = bse_param_spec_genum ("msg_type", "Message Type", NULL,
				BSE_TYPE_USER_MSG_TYPE, BSE_USER_MSG_INFO,
				SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_string ("message", "Message", NULL,
			    NULL, SFI_PARAM_DEFAULT);
#line 324 "bsejanitor.proc"
  proc->help = "Alter script status message.";
#line 25 "bsejanitor.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 26 "bsejanitor.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 332 "bsejanitor.proc"
}  }
static BseErrorType
#line 332 "bsejanitor.proc"
set_msg_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 335 "bsejanitor.proc"
{
#line 336 "bsejanitor.proc"
  
  BseJanitor    *self = bse_value_get_object (in_values++);
  BseUserMsgType mtype   = g_value_get_enum (in_values++);
  const gchar   *message = sfi_value_get_string (in_values++);
  
#line 341 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 345 "bsejanitor.proc"
  
  if (!self->port || self->close_pending)
    return BSE_ERROR_PROC_EXECUTION;
  if (!message)
    {
      message = bse_janitor_get_ident (self);
      mtype = BSE_USER_MSG_INFO;
    }
  
#line 354 "bsejanitor.proc"
  
  bse_item_set (self,
		"user_msg_type", mtype,
		"user_msg", message,
		NULL);
  
  return BSE_ERROR_NONE;
}

/* --- progress --- */
static void
progress_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 363 "bsejanitor.proc"
 {
#line 365 "bsejanitor.proc"
  *(in_pspecs++)    = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_real ("progress", "Progress", NULL,
			  -1, -1, 1.0, 0.1,
			  SFI_PARAM_DEFAULT);
#line 364 "bsejanitor.proc"
  proc->help = "Indicate progress (from 0.0 to 1.0 or -1 for unknown amount).";
#line 25 "bsejanitor.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 26 "bsejanitor.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 370 "bsejanitor.proc"
}  }
static BseErrorType
#line 370 "bsejanitor.proc"
progress_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 373 "bsejanitor.proc"
{
#line 374 "bsejanitor.proc"
  
  BseJanitor *self = bse_value_get_object (in_values++);
  gfloat progress  = sfi_value_get_real (in_values++);
  
#line 378 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 382 "bsejanitor.proc"
  
  if (!self->port || self->close_pending)
    return BSE_ERROR_PROC_EXECUTION;
  
#line 386 "bsejanitor.proc"
  
  bse_janitor_progress (self, progress);
  
  return BSE_ERROR_NONE;
}

/* --- exit --- */
static void
exit_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 392 "bsejanitor.proc"
 {
#line 394 "bsejanitor.proc"
  *(in_pspecs++)    = bse_param_spec_object ("janitor", "Janitor", NULL,
				 BSE_TYPE_JANITOR, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = bse_param_spec_genum ("msg_type", "Message Type", NULL,
				BSE_TYPE_USER_MSG_TYPE, BSE_USER_MSG_INFO,
				SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_string ("message", "Message", NULL,
			    NULL, SFI_PARAM_DEFAULT);
#line 393 "bsejanitor.proc"
  proc->help = "Exit a script, leaving a message.";
#line 25 "bsejanitor.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 26 "bsejanitor.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 401 "bsejanitor.proc"
}  }
static BseErrorType
#line 401 "bsejanitor.proc"
exit_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 404 "bsejanitor.proc"
{
#line 405 "bsejanitor.proc"
  
  BseJanitor *self       = bse_value_get_object (in_values++);
  BseUserMsgType mtype   = g_value_get_enum (in_values++);
  const gchar   *message = sfi_value_get_string (in_values++);
  
#line 410 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self) || !message)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 414 "bsejanitor.proc"
  
  if (!BSE_IS_JANITOR (self) || !self->port || self->close_pending)
    return BSE_ERROR_PROC_EXECUTION;
  
#line 418 "bsejanitor.proc"
  
  bse_server_user_message (bse_server_get (), mtype, message);
  bse_janitor_close (self);
  
  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
static BseExportNodeProc __enode_trigger_action = {
  { NULL, BSE_EXPORT_NODE_PROC,
    "BseJanitor+trigger-action", "/Methods/BseJanitor/General/Trigger Action", NULL },
  0, trigger_action_setup, trigger_action_exec, 
};
static BseExportNodeProc __enode_get_script_name = {
  { (BseExportNode*) &__enode_trigger_action, BSE_EXPORT_NODE_PROC,
    "BseJanitor+get-script-name", "/Methods/BseJanitor/General/Get Script Name", NULL },
  0, get_script_name_setup, get_script_name_exec, 
};
static BseExportNodeProc __enode_get_proc_name = {
  { (BseExportNode*) &__enode_get_script_name, BSE_EXPORT_NODE_PROC,
    "BseJanitor+get-proc-name", "/Methods/BseJanitor/General/Get Proc Name", NULL },
  0, get_proc_name_setup, get_proc_name_exec, 
};
static BseExportNodeProc __enode_n_actions = {
  { (BseExportNode*) &__enode_get_proc_name, BSE_EXPORT_NODE_PROC,
    "BseJanitor+n-actions", "/Methods/BseJanitor/General/N Actions", NULL },
  0, n_actions_setup, n_actions_exec, 
};
static BseExportNodeProc __enode_get_action = {
  { (BseExportNode*) &__enode_n_actions, BSE_EXPORT_NODE_PROC,
    "BseJanitor+get-action", "/Methods/BseJanitor/General/Get Action", NULL },
  0, get_action_setup, get_action_exec, 
};
static BseExportNodeProc __enode_get_action_name = {
  { (BseExportNode*) &__enode_get_action, BSE_EXPORT_NODE_PROC,
    "BseJanitor+get-action-name", "/Methods/BseJanitor/General/Get Action Name", NULL },
  0, get_action_name_setup, get_action_name_exec, 
};
static BseExportNodeProc __enode_get_action_blurb = {
  { (BseExportNode*) &__enode_get_action_name, BSE_EXPORT_NODE_PROC,
    "BseJanitor+get-action-blurb", "/Methods/BseJanitor/General/Get Action Blurb", NULL },
  0, get_action_blurb_setup, get_action_blurb_exec, 
};
static BseExportNodeProc __enode_kill = {
  { (BseExportNode*) &__enode_get_action_blurb, BSE_EXPORT_NODE_PROC,
    "BseJanitor+kill", "/Methods/BseJanitor/General/Kill", NULL },
  0, kill_setup, kill_exec, 
};
static BseExportNodeProc __enode_add_action = {
  { (BseExportNode*) &__enode_kill, BSE_EXPORT_NODE_PROC,
    "BseJanitor+add-action", "/Methods/BseJanitor/General/Add Action", NULL },
  0, add_action_setup, add_action_exec, 
};
static BseExportNodeProc __enode_remove_action = {
  { (BseExportNode*) &__enode_add_action, BSE_EXPORT_NODE_PROC,
    "BseJanitor+remove-action", "/Methods/BseJanitor/General/Remove Action", NULL },
  0, remove_action_setup, remove_action_exec, 
};
static BseExportNodeProc __enode_bse_janitor_get_specific = {
  { (BseExportNode*) &__enode_remove_action, BSE_EXPORT_NODE_PROC,
    "bse-janitor-get-specific", "/Proc/Janitor/Get Specific", NULL },
  0, bse_janitor_get_specific_setup, bse_janitor_get_specific_exec, 
};
static BseExportNodeProc __enode_set_msg = {
  { (BseExportNode*) &__enode_bse_janitor_get_specific, BSE_EXPORT_NODE_PROC,
    "BseJanitor+set-msg", "/Methods/BseJanitor/General/Set Msg", NULL },
  0, set_msg_setup, set_msg_exec, 
};
static BseExportNodeProc __enode_progress = {
  { (BseExportNode*) &__enode_set_msg, BSE_EXPORT_NODE_PROC,
    "BseJanitor+progress", "/Methods/BseJanitor/General/Progress", NULL },
  0, progress_setup, progress_exec, 
};
static BseExportNodeProc __enode_exit = {
  { (BseExportNode*) &__enode_progress, BSE_EXPORT_NODE_PROC,
    "BseJanitor+exit", "/Methods/BseJanitor/General/Exit", NULL },
  0, exit_setup, exit_exec, 
};
BseExportNode* bse__builtin_init_bsejanitor_gen_proc_c (void);
BseExportNode* bse__builtin_init_bsejanitor_gen_proc_c (void)
{
  return (BseExportNode*) &__enode_exit;
}

/**
 ** Generated data ends here
 **/
