
/**
 ** Generated data (by mkcproc.pl)
 **/
#line 1 "bsesong.proc"

#include <bse/bseplugin.h>
#include <bse/bseprocedure.h>
#include <bse/bsesong.h>
#include <bse/bsepart.h>
#include <bse/bsetrack.h>
#include "bsemidireceiver.h"
#include "bseproject.h"
#include "gslcommon.h"
#include "gslengine.h"

#line 31 "bsesong.proc"


/* --- create-part --- */
static GType type_id_create_part = 0;
static void
create_part_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 33 "bsesong.proc"
 {
#line 35 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", "Song", NULL,
				 BSE_TYPE_SONG, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_DEFAULT);
#line 34 "bsesong.proc"
  proc->help = "Create a new Part in a Song";
#line 29 "bsesong.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 30 "bsesong.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 39 "bsesong.proc"
}  }
static BseErrorType
#line 39 "bsesong.proc"
create_part_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 42 "bsesong.proc"
{
#line 43 "bsesong.proc"
  
  BseSong *song = bse_value_get_object (in_values++);
  BsePart *part;
  
#line 47 "bsesong.proc"
  
  if (!BSE_IS_SONG (song))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 51 "bsesong.proc"
  
  part = g_object_new (BSE_TYPE_PART, NULL);
  bse_container_add_item (BSE_CONTAINER (song), BSE_ITEM (part));
  
#line 55 "bsesong.proc"
  
  bse_value_set_object (out_values++, G_OBJECT (part));
  g_object_unref (part);
  
  return BSE_ERROR_NONE;
}

/* --- remove-part --- */
static GType type_id_remove_part = 0;
static void
remove_part_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 62 "bsesong.proc"
 {
#line 64 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", "Song", NULL,
				 BSE_TYPE_SONG, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_DEFAULT);
#line 63 "bsesong.proc"
  proc->help = "Delete a Part from a Song";
#line 29 "bsesong.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 30 "bsesong.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 68 "bsesong.proc"
}  }
static BseErrorType
#line 68 "bsesong.proc"
remove_part_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 71 "bsesong.proc"
{
#line 72 "bsesong.proc"
  
  BseSong *self = bse_value_get_object (in_values++);
  BsePart *part = bse_value_get_object (in_values++);
  BseErrorType error = BSE_ERROR_NONE;
  
#line 77 "bsesong.proc"
  
  if (!BSE_IS_SONG (self) || !BSE_IS_PART (part) || BSE_ITEM (part)->parent != BSE_ITEM (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 81 "bsesong.proc"
  
  if (BSE_SOURCE_PREPARED (self))
    error = BSE_ERROR_SOURCE_BUSY;
  else
    bse_container_remove_item (BSE_CONTAINER (self), BSE_ITEM (part));
  
  return error;
}

/* --- create-track --- */
static GType type_id_create_track = 0;
static void
create_track_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 90 "bsesong.proc"
 {
#line 92 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", "Song", NULL,
				 BSE_TYPE_SONG, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_object ("track", "Track", NULL,
				 BSE_TYPE_TRACK, SFI_PARAM_DEFAULT);
#line 91 "bsesong.proc"
  proc->help = "Create a new Track for a Song";
#line 29 "bsesong.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 30 "bsesong.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 96 "bsesong.proc"
}  }
static BseErrorType
#line 96 "bsesong.proc"
create_track_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 99 "bsesong.proc"
{
#line 100 "bsesong.proc"
  
  BseSong *self = bse_value_get_object (in_values++);
  BseErrorType error = BSE_ERROR_NONE;
  GObject *track = NULL;
  
#line 105 "bsesong.proc"
  
  if (!BSE_IS_SONG (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 109 "bsesong.proc"
  
  if (BSE_SOURCE_PREPARED (self))
    error = BSE_ERROR_SOURCE_BUSY;
  else
    track = bse_container_new_item (BSE_CONTAINER (self), BSE_TYPE_TRACK, NULL);
  
#line 115 "bsesong.proc"
  
  bse_value_set_object (out_values++, track);
  
  return error;
}

/* --- remove-track --- */
static GType type_id_remove_track = 0;
static void
remove_track_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 121 "bsesong.proc"
 {
#line 123 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", "Song", NULL,
				 BSE_TYPE_SONG, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = bse_param_spec_object ("track", "Track", NULL,
				 BSE_TYPE_TRACK, SFI_PARAM_DEFAULT);
#line 122 "bsesong.proc"
  proc->help = "Delete a Track from a Song";
#line 29 "bsesong.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 30 "bsesong.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 127 "bsesong.proc"
}  }
static BseErrorType
#line 127 "bsesong.proc"
remove_track_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 130 "bsesong.proc"
{
#line 131 "bsesong.proc"
  
  BseSong *self   = bse_value_get_object (in_values++);
  BseTrack *track = bse_value_get_object (in_values++);
  BseErrorType error = BSE_ERROR_NONE;
  
#line 136 "bsesong.proc"
  
  if (!BSE_IS_SONG (self) || !BSE_IS_TRACK (track) ||
      BSE_ITEM (track)->parent != BSE_ITEM (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 141 "bsesong.proc"
  
  if (BSE_SOURCE_PREPARED (self))
    error = BSE_ERROR_SOURCE_BUSY;
  else
    bse_container_remove_item (BSE_CONTAINER (self), BSE_ITEM (track));
  
  return error;
}

/* --- find-track-for-part --- */
static GType type_id_find_track_for_part = 0;
static void
find_track_for_part_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 150 "bsesong.proc"
 {
#line 152 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", "Song", NULL,
				 BSE_TYPE_SONG, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_object ("track", "Track", NULL,
				 BSE_TYPE_TRACK, SFI_PARAM_DEFAULT);
#line 151 "bsesong.proc"
  proc->help = "Find a track suitable for playing notes of a given part.";
#line 29 "bsesong.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 30 "bsesong.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 158 "bsesong.proc"
}  }
static BseErrorType
#line 158 "bsesong.proc"
find_track_for_part_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 161 "bsesong.proc"
{
#line 162 "bsesong.proc"
  
  BseSong *self = bse_value_get_object (in_values++);
  BsePart *part = bse_value_get_object (in_values++);
  BseTrack *track = NULL;
  guint tick = 0;
  SfiRing *ring;

#line 169 "bsesong.proc"
  
  if (!BSE_IS_SONG (self) || !BSE_IS_PART (part) ||
      BSE_ITEM (part)->parent != BSE_ITEM (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 174 "bsesong.proc"
  
  for (ring = self->tracks_SL; ring; ring = sfi_ring_walk (ring, self->tracks_SL))
    {
      BseTrack *test_track = ring->data;
      guint start;
      if (bse_track_find_part (test_track, part, &start) &&
	  (!track || start < tick))
	{
	  track = test_track;
	  tick = start;
	}
    }
  if (!track)
    track = self->tracks_SL ? self->tracks_SL->data : NULL;

#line 189 "bsesong.proc"
  
  bse_value_set_object (out_values++, track);
  
  return BSE_ERROR_NONE;
}

/* --- synthesize-note --- */
static GType type_id_synthesize_note = 0;
static void
synthesize_note_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 195 "bsesong.proc"
 {
#line 197 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", "Song", NULL,
				 BSE_TYPE_SONG, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = bse_param_spec_object ("track", "Track", NULL,
				 BSE_TYPE_TRACK, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_int ("duration", "Tick Duration", NULL,
			 1, 1, BSE_PART_MAX_TICK, 384, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = bse_pspec_note_simple ("note", "Note", NULL,
				 SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = bse_param_spec_fine_tune ("fine_tune", "Fine Tune", "Fine tune in cents per semitone");
  *(in_pspecs++)    = sfi_pspec_real ("velocity", "Velocity", NULL,
			  1.0, 0, 1.0, 0.01,
			  SFI_PARAM_DEFAULT SFI_PARAM_HINT_SCALE);
#line 196 "bsesong.proc"
  proc->help = "Synthesize a note on a song of an active project.";
#line 29 "bsesong.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 30 "bsesong.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 209 "bsesong.proc"
}  }
static BseErrorType
#line 209 "bsesong.proc"
synthesize_note_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 212 "bsesong.proc"
{
#line 213 "bsesong.proc"
  
  BseSong *self      = bse_value_get_object (in_values++);
  BseTrack *track    = bse_value_get_object (in_values++);
  guint    duration  = sfi_value_get_int (in_values++);
  gint     note      = sfi_value_get_note (in_values++);
  gint     fine_tune = sfi_value_get_int (in_values++);
  gfloat   velocity  = sfi_value_get_real (in_values++);
  
#line 221 "bsesong.proc"
  
  if (!BSE_IS_SONG (self) || !BSE_IS_TRACK (track) ||
      BSE_ITEM (track)->parent != BSE_ITEM (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 226 "bsesong.proc"
  
  if (BSE_SOURCE_PREPARED (self) && track->midi_receiver_SL)
    {
      gfloat freq = BSE_KAMMER_FREQUENCY_f *
		    BSE_SEMITONE_FACTOR (note) *
		    BSE_FINE_TUNE_FACTOR (fine_tune);
      SfiTime tstamp = gsl_tick_stamp () + gsl_engine_block_size () * 2;
      BseMidiEvent *eon, *eoff;
      eon  = bse_midi_event_note_on (0, tstamp, freq, velocity);
      eoff = bse_midi_event_note_off (0, tstamp + duration, freq);
      bse_midi_receiver_push_event (track->midi_receiver_SL, eon);
      bse_midi_receiver_push_event (track->midi_receiver_SL, eoff);
      bse_midi_receiver_process_events (track->midi_receiver_SL, tstamp + duration);
      bse_project_keep_activated (BSE_PROJECT (BSE_ITEM (self)->parent), tstamp + duration);
    }
  
  return BSE_ERROR_NONE;
}

/* --- get-timing --- */
static GType type_id_get_timing = 0;
static void
get_timing_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 245 "bsesong.proc"
 {
#line 247 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", "Song", NULL, BSE_TYPE_SONG, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_int ("tick", "Tick", "Tick to retrieve timing info about", 0, 0, G_MAXINT, 384, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_boxed ("timing", "Timing", "Song Timing", BSE_TYPE_SONG_TIMING, SFI_PARAM_DEFAULT);
#line 246 "bsesong.proc"
  proc->help = "Retrieve song timing information at a specific tick.";
#line 29 "bsesong.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 30 "bsesong.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 250 "bsesong.proc"
}  }
static BseErrorType
#line 250 "bsesong.proc"
get_timing_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 253 "bsesong.proc"
{
#line 254 "bsesong.proc"
  
  BseSong *self = bse_value_get_object (in_values++);
  SfiInt   tick = sfi_value_get_int (in_values++);
  BseSongTiming timing = { 0, };

#line 259 "bsesong.proc"
  
  if (!BSE_IS_SONG (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 263 "bsesong.proc"
  
  bse_song_get_timing (self, tick, &timing);

#line 266 "bsesong.proc"
  
  bse_value_set_boxed (out_values++, &timing);
  
  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
BSE_EXPORTS_BEGIN (BSE_PLUGIN_NAME);
BSE_EXPORT_PROCEDURES = {
  { &type_id_create_part, "BseSong+create-part", NULL, 0, create_part_setup, create_part_exec, NULL, "/Method/BseSong/General/Create Part", { 0, }, },
  { &type_id_remove_part, "BseSong+remove-part", NULL, 0, remove_part_setup, remove_part_exec, NULL, "/Method/BseSong/General/Remove Part", { 0, }, },
  { &type_id_create_track, "BseSong+create-track", NULL, 0, create_track_setup, create_track_exec, NULL, "/Method/BseSong/General/Create Track", { 0, }, },
  { &type_id_remove_track, "BseSong+remove-track", NULL, 0, remove_track_setup, remove_track_exec, NULL, "/Method/BseSong/General/Remove Track", { 0, }, },
  { &type_id_find_track_for_part, "BseSong+find-track-for-part", NULL, 0, find_track_for_part_setup, find_track_for_part_exec, NULL, "/Method/BseSong/General/Find Track For Part", { 0, }, },
  { &type_id_synthesize_note, "BseSong+synthesize-note", NULL, 0, synthesize_note_setup, synthesize_note_exec, NULL, "/Method/BseSong/General/Synthesize Note", { 0, }, },
  { &type_id_get_timing, "BseSong+get-timing", NULL, 0, get_timing_setup, get_timing_exec, NULL, "/Method/BseSong/General/Get Timing", { 0, }, },
  { NULL, },
};
BSE_EXPORTS_END;

/**
 ** Generated data ends here
 **/
