
/**
 ** Generated data (by mkcproc.pl)
 **/
#line 1 "bsesong.proc"

#include <bse/bseplugin.h>
#include <bse/bseprocedure.h>
#include <bse/bsesong.h>
#include <bse/bsepart.h>
#include <bse/bsetrack.h>
#include "bsemidireceiver.h"
#include "bseproject.h"
#include "gslcommon.h"
#include "gslengine.h"

#line 31 "bsesong.proc"


/* --- create-part --- */
static GType type_id_create_part = 0;
static void
create_part_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 33 "bsesong.proc"
 {
#line 35 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", "Song", NULL,
				 BSE_TYPE_SONG, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_DEFAULT);
#line 34 "bsesong.proc"
  proc->help = "Create a new Part in a Song";
#line 29 "bsesong.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 30 "bsesong.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 39 "bsesong.proc"
}  }
static BseErrorType
#line 39 "bsesong.proc"
create_part_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 42 "bsesong.proc"
{
#line 43 "bsesong.proc"
  
  BseSong *self = bse_value_get_object (in_values++);
  BseUndoStack *ustack;
  BseItem *child;

#line 48 "bsesong.proc"
  
  if (!BSE_IS_SONG (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 52 "bsesong.proc"
  
  ustack = bse_item_undo_open (self, "create-part");
  child = bse_container_new_child (BSE_CONTAINER (self), BSE_TYPE_PART, NULL);
  bse_item_push_undo_proc (self, "remove-part", child);
  bse_item_undo_close (ustack);
  
#line 58 "bsesong.proc"
  
  bse_value_set_object (out_values++, child);
  
  return BSE_ERROR_NONE;
}

/* --- remove-part --- */
static GType type_id_remove_part = 0;
static void
remove_part_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 64 "bsesong.proc"
 {
#line 66 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", "Song", NULL,
				 BSE_TYPE_SONG, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_DEFAULT);
#line 65 "bsesong.proc"
  proc->help = "Delete a Part from a Song";
#line 29 "bsesong.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 30 "bsesong.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 70 "bsesong.proc"
}  }
static BseErrorType
#line 70 "bsesong.proc"
remove_part_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 73 "bsesong.proc"
{
#line 74 "bsesong.proc"
  
  BseSong *self = bse_value_get_object (in_values++);
  BseItem *child = bse_value_get_object (in_values++);
  BseErrorType error = BSE_ERROR_NONE;
  
#line 79 "bsesong.proc"
  
  if (!BSE_IS_SONG (self) || !BSE_IS_PART (child) || BSE_ITEM (child)->parent != BSE_ITEM (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 83 "bsesong.proc"
  
  if (BSE_SOURCE_PREPARED (self))
    error = BSE_ERROR_SOURCE_BUSY;
  else
    {
      BseUndoStack *ustack = bse_item_undo_open (self, "remove-child %s", bse_object_debug_name (child));
#line 89 "bsesong.proc"
      
      bse_container_uncross_undoable (BSE_CONTAINER (self), child);
#line 91 "bsesong.proc"
      
      bse_item_push_redo_proc (self, "remove-part", child);
#line 93 "bsesong.proc"
      
      bse_container_remove_backedup (BSE_CONTAINER (self), child, ustack);
#line 95 "bsesong.proc"
      
      bse_item_undo_close (ustack);
    }

  return error;
}

/* --- create-track --- */
static GType type_id_create_track = 0;
static void
create_track_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 102 "bsesong.proc"
 {
#line 104 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", "Song", NULL,
				 BSE_TYPE_SONG, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_object ("track", "Track", NULL,
				 BSE_TYPE_TRACK, SFI_PARAM_DEFAULT);
#line 103 "bsesong.proc"
  proc->help = "Create a new Track for a Song";
#line 29 "bsesong.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 30 "bsesong.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 108 "bsesong.proc"
}  }
static BseErrorType
#line 108 "bsesong.proc"
create_track_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 111 "bsesong.proc"
{
#line 112 "bsesong.proc"
  
  BseSong *self = bse_value_get_object (in_values++);
  BseErrorType error = BSE_ERROR_NONE;
  BseItem *child = NULL;

#line 117 "bsesong.proc"
  
  if (!BSE_IS_SONG (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 121 "bsesong.proc"
  
  if (BSE_SOURCE_PREPARED (self))
    error = BSE_ERROR_SOURCE_BUSY;
  else
    {
      BseUndoStack *ustack = bse_item_undo_open (self, "create-track");
      child = bse_container_new_child (BSE_CONTAINER (self), BSE_TYPE_TRACK, NULL);
      bse_item_push_undo_proc (self, "remove-track", child);
      bse_item_undo_close (ustack);
    }

#line 132 "bsesong.proc"
  
  bse_value_set_object (out_values++, child);
  
  return error;
}

/* --- remove-track --- */
static GType type_id_remove_track = 0;
static void
remove_track_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 138 "bsesong.proc"
 {
#line 140 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", "Song", NULL,
				 BSE_TYPE_SONG, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = bse_param_spec_object ("track", "Track", NULL,
				 BSE_TYPE_TRACK, SFI_PARAM_DEFAULT);
#line 139 "bsesong.proc"
  proc->help = "Delete a Track from a Song";
#line 29 "bsesong.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 30 "bsesong.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 144 "bsesong.proc"
}  }
static BseErrorType
#line 144 "bsesong.proc"
remove_track_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 147 "bsesong.proc"
{
#line 148 "bsesong.proc"
  
  BseSong *self  = bse_value_get_object (in_values++);
  BseItem *child = bse_value_get_object (in_values++);
  BseErrorType error = BSE_ERROR_NONE;
  
#line 153 "bsesong.proc"
  
  if (!BSE_IS_SONG (self) || !BSE_IS_TRACK (child) ||
      BSE_ITEM (child)->parent != BSE_ITEM (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 158 "bsesong.proc"
  
  if (BSE_SOURCE_PREPARED (self))
    error = BSE_ERROR_SOURCE_BUSY;
  else
    {
      BseUndoStack *ustack = bse_item_undo_open (self, "remove-child %s", bse_object_debug_name (child));
#line 164 "bsesong.proc"
      
      bse_container_uncross_undoable (BSE_CONTAINER (self), child);
#line 166 "bsesong.proc"
      
      bse_item_push_redo_proc (self, "remove-track", child);
#line 168 "bsesong.proc"
      
      bse_container_remove_backedup (BSE_CONTAINER (self), child, ustack);
#line 170 "bsesong.proc"
      
      bse_item_undo_close (ustack);
    }

  return error;
}

/* --- find-track-for-part --- */
static GType type_id_find_track_for_part = 0;
static void
find_track_for_part_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 177 "bsesong.proc"
 {
#line 179 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", "Song", NULL,
				 BSE_TYPE_SONG, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_object ("track", "Track", NULL,
				 BSE_TYPE_TRACK, SFI_PARAM_DEFAULT);
#line 178 "bsesong.proc"
  proc->help = "Find a track suitable for playing notes of a given part.";
#line 29 "bsesong.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 30 "bsesong.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 185 "bsesong.proc"
}  }
static BseErrorType
#line 185 "bsesong.proc"
find_track_for_part_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 188 "bsesong.proc"
{
#line 189 "bsesong.proc"
  
  BseSong *self = bse_value_get_object (in_values++);
  BsePart *part = bse_value_get_object (in_values++);
  BseTrack *track = NULL;
  guint tick = 0;
  SfiRing *ring;

#line 196 "bsesong.proc"
  
  if (!BSE_IS_SONG (self) || !BSE_IS_PART (part) ||
      BSE_ITEM (part)->parent != BSE_ITEM (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 201 "bsesong.proc"
  
  for (ring = self->tracks_SL; ring; ring = sfi_ring_walk (ring, self->tracks_SL))
    {
      BseTrack *test_track = ring->data;
      guint start;
      if (bse_track_find_part (test_track, part, &start) &&
	  (!track || start < tick))
	{
	  track = test_track;
	  tick = start;
	}
    }
  if (!track)
    track = self->tracks_SL ? self->tracks_SL->data : NULL;

#line 216 "bsesong.proc"
  
  bse_value_set_object (out_values++, track);
  
  return BSE_ERROR_NONE;
}

/* --- synthesize-note --- */
static GType type_id_synthesize_note = 0;
static void
synthesize_note_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 222 "bsesong.proc"
 {
#line 224 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", "Song", NULL,
				 BSE_TYPE_SONG, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = bse_param_spec_object ("track", "Track", NULL,
				 BSE_TYPE_TRACK, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_int ("duration", "Tick Duration", NULL,
			 1, 1, BSE_PART_MAX_TICK, 384, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = bse_pspec_note_simple ("note", "Note", NULL,
				 SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = bse_param_spec_fine_tune ("fine_tune", "Fine Tune", "Fine tune in cents per semitone");
  *(in_pspecs++)    = sfi_pspec_real ("velocity", "Velocity", NULL,
			  1.0, 0, 1.0, 0.01,
			  SFI_PARAM_DEFAULT SFI_PARAM_HINT_SCALE);
#line 223 "bsesong.proc"
  proc->help = "Synthesize a note on a song of an active project.";
#line 29 "bsesong.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 30 "bsesong.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 236 "bsesong.proc"
}  }
static BseErrorType
#line 236 "bsesong.proc"
synthesize_note_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 239 "bsesong.proc"
{
#line 240 "bsesong.proc"
  
  BseSong *self      = bse_value_get_object (in_values++);
  BseTrack *track    = bse_value_get_object (in_values++);
  guint    duration  = sfi_value_get_int (in_values++);
  gint     note      = sfi_value_get_note (in_values++);
  gint     fine_tune = sfi_value_get_int (in_values++);
  gfloat   velocity  = sfi_value_get_real (in_values++);
  
#line 248 "bsesong.proc"
  
  if (!BSE_IS_SONG (self) || !BSE_IS_TRACK (track) ||
      BSE_ITEM (track)->parent != BSE_ITEM (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 253 "bsesong.proc"
  
  if (BSE_SOURCE_PREPARED (self) && track->midi_receiver_SL)
    {
      gfloat freq = BSE_KAMMER_FREQUENCY_f *
		    BSE_SEMITONE_FACTOR (note) *
		    BSE_FINE_TUNE_FACTOR (fine_tune);
      SfiTime tstamp = gsl_tick_stamp () + gsl_engine_block_size () * 2;
      BseMidiEvent *eon, *eoff;
      eon  = bse_midi_event_note_on (0, tstamp, freq, velocity);
      eoff = bse_midi_event_note_off (0, tstamp + duration, freq);
      bse_midi_receiver_push_event (track->midi_receiver_SL, eon);
      bse_midi_receiver_push_event (track->midi_receiver_SL, eoff);
      bse_midi_receiver_process_events (track->midi_receiver_SL, tstamp + duration);
      bse_project_keep_activated (BSE_PROJECT (BSE_ITEM (self)->parent), tstamp + duration);
    }
  
  return BSE_ERROR_NONE;
}

/* --- get-timing --- */
static GType type_id_get_timing = 0;
static void
get_timing_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 272 "bsesong.proc"
 {
#line 274 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", "Song", NULL, BSE_TYPE_SONG, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_int ("tick", "Tick", "Tick to retrieve timing info about", 0, 0, G_MAXINT, 384, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_boxed ("timing", "Timing", "Song Timing", BSE_TYPE_SONG_TIMING, SFI_PARAM_DEFAULT);
#line 273 "bsesong.proc"
  proc->help = "Retrieve song timing information at a specific tick.";
#line 29 "bsesong.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 30 "bsesong.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 277 "bsesong.proc"
}  }
static BseErrorType
#line 277 "bsesong.proc"
get_timing_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 280 "bsesong.proc"
{
#line 281 "bsesong.proc"
  
  BseSong *self = bse_value_get_object (in_values++);
  SfiInt   tick = sfi_value_get_int (in_values++);
  BseSongTiming timing = { 0, };

#line 286 "bsesong.proc"
  
  if (!BSE_IS_SONG (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 290 "bsesong.proc"
  
  bse_song_get_timing (self, tick, &timing);

#line 293 "bsesong.proc"
  
  bse_value_set_boxed (out_values++, &timing);
  
  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
BSE_EXPORTS_BEGIN (BSE_PLUGIN_NAME);
BSE_EXPORT_PROCEDURES = {
  { &type_id_create_part, "BseSong+create-part", NULL, 0, create_part_setup, create_part_exec, NULL, "/Method/BseSong/General/Create Part", { 0, }, },
  { &type_id_remove_part, "BseSong+remove-part", NULL, 0, remove_part_setup, remove_part_exec, NULL, "/Method/BseSong/General/Remove Part", { 0, }, },
  { &type_id_create_track, "BseSong+create-track", NULL, 0, create_track_setup, create_track_exec, NULL, "/Method/BseSong/General/Create Track", { 0, }, },
  { &type_id_remove_track, "BseSong+remove-track", NULL, 0, remove_track_setup, remove_track_exec, NULL, "/Method/BseSong/General/Remove Track", { 0, }, },
  { &type_id_find_track_for_part, "BseSong+find-track-for-part", NULL, 0, find_track_for_part_setup, find_track_for_part_exec, NULL, "/Method/BseSong/General/Find Track For Part", { 0, }, },
  { &type_id_synthesize_note, "BseSong+synthesize-note", NULL, 0, synthesize_note_setup, synthesize_note_exec, NULL, "/Method/BseSong/General/Synthesize Note", { 0, }, },
  { &type_id_get_timing, "BseSong+get-timing", NULL, 0, get_timing_setup, get_timing_exec, NULL, "/Method/BseSong/General/Get Timing", { 0, }, },
  { NULL, },
};
BSE_EXPORTS_END;

/**
 ** Generated data ends here
 **/
