
/**
 ** Generated data (by mkcproc.pl)
 **/
#line 1 "bsetrack.proc"

#include        <bse/bseplugin.h>
#include        <bse/bseprocedure.h>
#include        <bse/bsetrack.h>
#include        <bse/bsepart.h>
#include        <bse/bsesong.h>


#line 27 "bsetrack.proc"


/* --- insert-part --- */
static GType type_id_insert_part = 0;
static void
insert_part_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 29 "bsetrack.proc"
 {
#line 31 "bsetrack.proc"
  *(in_pspecs++)    = bse_param_spec_object ("track", "Track", NULL,
				 BSE_TYPE_TRACK, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_int ("tick", "Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", NULL,
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_DEFAULT);
}
#line 30 "bsetrack.proc"
  proc->help = "Insert a part into a track.";
#line 25 "bsetrack.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 26 "bsetrack.proc"
  proc->copyright = "Copyright (C) 2003 Tim Janik";
#line 41 "bsetrack.proc"
 }
static BseErrorType
#line 41 "bsetrack.proc"
insert_part_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 44 "bsetrack.proc"
{
#line 45 "bsetrack.proc"
  
  BseTrack *self = bse_value_get_object (in_values++);
  guint     tick = sfi_value_get_int (in_values++);
  BsePart  *part = bse_value_get_object (in_values++);
  BseErrorType error;

#line 51 "bsetrack.proc"
  
  if (!BSE_IS_TRACK (self) || !BSE_IS_PART (part) ||
      !BSE_ITEM (self)->parent ||
      BSE_ITEM (self)->parent != BSE_ITEM (part)->parent)
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 57 "bsetrack.proc"
  
  error = bse_track_insert_part (self, tick, part);

#line 60 "bsetrack.proc"
  
  g_value_set_enum (out_values++, error);

  return BSE_ERROR_NONE;
}

/* --- remove-tick --- */
static GType type_id_remove_tick = 0;
static void
remove_tick_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 66 "bsetrack.proc"
 {
#line 68 "bsetrack.proc"
  *(in_pspecs++)    = bse_param_spec_object ("track", "Track", NULL,
				 BSE_TYPE_TRACK, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_int ("tick", "Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_DEFAULT);
}
#line 67 "bsetrack.proc"
  proc->help = "Remove a part at specified tick from a track.";
#line 25 "bsetrack.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 26 "bsetrack.proc"
  proc->copyright = "Copyright (C) 2003 Tim Janik";
#line 73 "bsetrack.proc"
 }
static BseErrorType
#line 73 "bsetrack.proc"
remove_tick_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 76 "bsetrack.proc"
{
#line 77 "bsetrack.proc"
  
  BseTrack *self = bse_value_get_object (in_values++);
  guint     tick = sfi_value_get_int (in_values++);

#line 81 "bsetrack.proc"
  
  if (!BSE_IS_TRACK (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 85 "bsetrack.proc"
  
  bse_track_remove_tick (self, tick);

  return BSE_ERROR_NONE;
}

/* --- list-parts --- */
static GType type_id_list_parts = 0;
static void
list_parts_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 91 "bsetrack.proc"
 {
#line 93 "bsetrack.proc"
  *(in_pspecs++)    = bse_param_spec_object ("track", "Track", NULL,
				 BSE_TYPE_TRACK, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_boxed ("part_list", "Part List", NULL,
				BSE_TYPE_TRACK_PART_SEQ, SFI_PARAM_DEFAULT);
}
#line 92 "bsetrack.proc"
  proc->help = "List parts scheduled in a track.";
#line 25 "bsetrack.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 26 "bsetrack.proc"
  proc->copyright = "Copyright (C) 2003 Tim Janik";
#line 98 "bsetrack.proc"
 }
static BseErrorType
#line 98 "bsetrack.proc"
list_parts_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 101 "bsetrack.proc"
{
#line 102 "bsetrack.proc"
  
  BseTrack *self = bse_value_get_object (in_values++);

#line 105 "bsetrack.proc"
  
  if (!BSE_IS_TRACK (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 109 "bsetrack.proc"
  
  bse_value_take_boxed (out_values++, bse_track_list_parts (self));

  return BSE_ERROR_NONE;
}

/* --- get-part --- */
static GType type_id_get_part = 0;
static void
get_part_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 115 "bsetrack.proc"
 {
#line 117 "bsetrack.proc"
  *(in_pspecs++)    = bse_param_spec_object ("track", "Track", NULL,
				 BSE_TYPE_TRACK, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_int ("tick", "Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_DEFAULT);
}
#line 116 "bsetrack.proc"
  proc->help = "Get the part starting at a specific tick position.";
#line 25 "bsetrack.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 26 "bsetrack.proc"
  proc->copyright = "Copyright (C) 2003 Tim Janik";
#line 124 "bsetrack.proc"
 }
static BseErrorType
#line 124 "bsetrack.proc"
get_part_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 127 "bsetrack.proc"
{
#line 128 "bsetrack.proc"
  
  BseTrack *self = bse_value_get_object (in_values++);
  guint     tick = sfi_value_get_int (in_values++);

#line 132 "bsetrack.proc"
  
  if (!BSE_IS_TRACK (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 136 "bsetrack.proc"
  
  bse_value_set_object (out_values++, bse_track_lookup_tick (self, tick));

  return BSE_ERROR_NONE;
}

/* --- get-timing --- */
static GType type_id_get_timing = 0;
static void
get_timing_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 142 "bsetrack.proc"
 {
#line 144 "bsetrack.proc"
  *(in_pspecs++)    = bse_param_spec_object ("track", "Track", NULL, BSE_TYPE_TRACK, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_int ("tick", "Tick", "Tick to retrieve timing info about", 0, 0, G_MAXINT, 384, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_boxed ("timing", "Timing", "Song Timing", BSE_TYPE_SONG_TIMING, SFI_PARAM_DEFAULT);
#line 143 "bsetrack.proc"
  proc->help = "Retrieve song timing information at a specific tick.";
#line 25 "bsetrack.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 26 "bsetrack.proc"
  proc->copyright = "Copyright (C) 2003 Tim Janik";
#line 147 "bsetrack.proc"
}  }
static BseErrorType
#line 147 "bsetrack.proc"
get_timing_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 150 "bsetrack.proc"
{
#line 151 "bsetrack.proc"
  
  BseTrack *self = bse_value_get_object (in_values++);
  SfiInt    tick = sfi_value_get_int (in_values++);
  BseItem  *parent;
  BseSongTiming timing = { 0, };

#line 157 "bsetrack.proc"
  
  if (!BSE_IS_TRACK (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 161 "bsetrack.proc"
  
  parent = BSE_ITEM (self)->parent;
  if (BSE_IS_SONG (parent))
    bse_song_get_timing (BSE_SONG (parent), tick, &timing);
  else
    bse_song_timing_get_default (&timing);

#line 168 "bsetrack.proc"
  
  bse_value_set_boxed (out_values++, &timing);

  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
BSE_EXPORTS_BEGIN (BSE_PLUGIN_NAME);
BSE_EXPORT_PROCEDURES = {
  { &type_id_insert_part, "BseTrack+insert-part", NULL, 0, insert_part_setup, insert_part_exec, NULL, "/Method/BseTrack/General/Insert Part", { 0, }, },
  { &type_id_remove_tick, "BseTrack+remove-tick", NULL, 0, remove_tick_setup, remove_tick_exec, NULL, "/Method/BseTrack/General/Remove Tick", { 0, }, },
  { &type_id_list_parts, "BseTrack+list-parts", NULL, 0, list_parts_setup, list_parts_exec, NULL, "/Method/BseTrack/General/List Parts", { 0, }, },
  { &type_id_get_part, "BseTrack+get-part", NULL, 0, get_part_setup, get_part_exec, NULL, "/Method/BseTrack/General/Get Part", { 0, }, },
  { &type_id_get_timing, "BseTrack+get-timing", NULL, 0, get_timing_setup, get_timing_exec, NULL, "/Method/BseTrack/General/Get Timing", { 0, }, },
  { NULL, },
};
BSE_EXPORTS_END;

/**
 ** Generated data ends here
 **/
