
/**
 ** Generated data (by mkcproc.pl)
 **/
#line 1 "bseprocedure.proc"

#include <bse/bseplugin.h>
#include <bse/bseprocedure.h>
#include <bse/bsescripthelper.h>
#include <bse/bseserver.h>


#line 26 "bseprocedure.proc"

/* --- bse-note-to-freq --- */
static GType type_id_bse_note_to_freq = 0;
static void
bse_note_to_freq_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 27 "bseprocedure.proc"
 {
#line 29 "bseprocedure.proc"
  *(in_pspecs++)    = bse_pspec_note_simple ("note", "Note", NULL, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = bse_param_spec_fine_tune ("fine_tune", "Fine Tune", NULL);
  *(out_pspecs++)   = sfi_pspec_real ("frequency", "Frequency", NULL,
			  BSE_KAMMER_FREQUENCY_f, 0, BSE_MAX_FREQUENCY_f, 0.1,
			  SFI_PARAM_DEFAULT);
#line 28 "bseprocedure.proc"
  proc->help = "Retrieve the frequency of a certain note.";
#line 24 "bseprocedure.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bseprocedure.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 34 "bseprocedure.proc"
}  }
static BseErrorType
#line 34 "bseprocedure.proc"
bse_note_to_freq_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 37 "bseprocedure.proc"
{
#line 38 "bseprocedure.proc"
  
  gint       note       = sfi_value_get_int (in_values++);
  gint       fine_tune  = sfi_value_get_int (in_values++);
  BseNoteDescription *info;
  gfloat freq;
  
#line 44 "bseprocedure.proc"
  
  info = bse_note_description (note, fine_tune);
  if (!info->name)
    freq = 0;
  else
    freq = info->freq;
  bse_note_description_free (info);
  
#line 52 "bseprocedure.proc"
  
  sfi_value_set_real (out_values++, freq);
  
  return BSE_ERROR_NONE;
}

/* --- bse-note-from-freq --- */
static GType type_id_bse_note_from_freq = 0;
static void
bse_note_from_freq_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 58 "bseprocedure.proc"
 {
#line 60 "bseprocedure.proc"
  *(in_pspecs++)    = sfi_pspec_real ("frequency", "Frequency", NULL,
			  BSE_KAMMER_FREQUENCY_f, 0, BSE_MAX_FREQUENCY_f, 0.1,
			  SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = sfi_pspec_note ("note", "Note", NULL, SFI_KAMMER_NOTE, SFI_MIN_NOTE, SFI_MAX_NOTE, TRUE, SFI_PARAM_DEFAULT);
#line 59 "bseprocedure.proc"
  proc->help = "Retrieve the note of a certain frequency.";
#line 24 "bseprocedure.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bseprocedure.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 64 "bseprocedure.proc"
}  }
static BseErrorType
#line 64 "bseprocedure.proc"
bse_note_from_freq_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 67 "bseprocedure.proc"
{
#line 68 "bseprocedure.proc"
  
  gfloat frequency = sfi_value_get_real (in_values++);
  
#line 71 "bseprocedure.proc"
  
  sfi_value_set_int (out_values++, bse_note_from_freq (frequency));
  
  return BSE_ERROR_NONE;
}

/* --- bse-type-blurb --- */
static GType type_id_bse_type_blurb = 0;
static void
bse_type_blurb_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 77 "bseprocedure.proc"
 {
#line 79 "bseprocedure.proc"
  *(in_pspecs++)    = sfi_pspec_string ("type", NULL, NULL, NULL, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = sfi_pspec_string ("blurb", NULL, NULL, NULL, SFI_PARAM_DEFAULT);
#line 78 "bseprocedure.proc"
  proc->help = "Retrieve the blurb for a specific type.";
#line 24 "bseprocedure.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bseprocedure.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 81 "bseprocedure.proc"
}  }
static BseErrorType
#line 81 "bseprocedure.proc"
bse_type_blurb_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 84 "bseprocedure.proc"
{
#line 85 "bseprocedure.proc"
  
  gchar *stype = sfi_value_get_string (in_values++);
  GType type;

#line 89 "bseprocedure.proc"
  
  if (!stype)
    return BSE_ERROR_PROC_PARAM_INVAL;

  type = g_type_from_name (stype);

#line 95 "bseprocedure.proc"
  
  sfi_value_set_string (out_values++, type ? bse_type_blurb (type) : NULL);

  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
BSE_EXPORTS_BEGIN (BSE_PLUGIN_NAME);
BSE_EXPORT_PROCEDURES = {
  { &type_id_bse_note_to_freq, "bse-note-to-freq", NULL, 0, bse_note_to_freq_setup, bse_note_to_freq_exec, NULL, "/Proc/Utils/Notes/Note to Freq", { 0, }, },
  { &type_id_bse_note_from_freq, "bse-note-from-freq", NULL, 0, bse_note_from_freq_setup, bse_note_from_freq_exec, NULL, "/Proc/Utils/Notes/Note from Freq", { 0, }, },
  { &type_id_bse_type_blurb, "bse-type-blurb", NULL, 0, bse_type_blurb_setup, bse_type_blurb_exec, NULL, "/Proc/Utils/Types/Get Blurb", { 0, }, },
  { NULL, },
};
BSE_EXPORTS_END;

/**
 ** Generated data ends here
 **/
