
/**
 ** Generated data (by mkcproc.pl)
 **/
#line 1 "bsewaverepo.proc"

#include        <bse/bseplugin.h>
#include        <bse/bseprocedure.h>
#include        <bse/bsewaverepo.h>
#include        <gsl/gslloader.h>

#include        <bse/bsewave.h>


#line 26 "bsewaverepo.proc"

static BseErrorType
load_file (BseWaveRepo *wrepo,
	   const gchar *file_name)
{
  GslErrorType error;
  GslWaveFileInfo *finfo;
  GslWaveDsc *wdsc;
  BseWave *wave;
  guint i;

  finfo = gsl_wave_file_info_load (file_name, &error);
  if (!finfo)
    return error;
  if (finfo->n_waves != 1)
    {
      gsl_wave_file_info_unref (finfo);
      return GSL_ERROR_FORMAT_UNKNOWN;
    }

  wdsc = gsl_wave_dsc_load (finfo, 0, &error);
  gsl_wave_file_info_unref (finfo);
  if (!wdsc)
    return error;
  
  wave = g_object_new (BSE_TYPE_WAVE,
		       "uname", g_basename (file_name),
		       NULL);
  for (i = 0; i < wdsc->n_chunks; i++)
    {
      GslWaveChunk *wchunk = gsl_wave_chunk_create (wdsc, i, error ? NULL : &error);

      if (wchunk)
	bse_wave_add_chunk (wave, wchunk);
    }
  bse_wave_set_locator (wave, file_name, wdsc->name);

  gsl_wave_dsc_free (wdsc);

  if (wave->n_wchunks)
    {
      bse_container_add_item (BSE_CONTAINER (wrepo), BSE_ITEM (wave));
      error = GSL_ERROR_NONE;
    }
  else
    error = GSL_ERROR_FILE_EMPTY;
  g_object_unref (wave);

  return error;
}


#line 78 "bsewaverepo.proc"

#line 82 "bsewaverepo.proc"


/* --- load-file --- */
static GType type_id_load_file = 0;
static void
load_file_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 84 "bsewaverepo.proc"
 {
#line 86 "bsewaverepo.proc"
  *(in_pspecs++)    = g_param_spec_object ("wave_repo", "Wave Repo", NULL,
			       BSE_TYPE_WAVE_REPO, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_string ("file_name", "File Name", "The file to import waves from",
 			       NULL, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_enum ("error", "Error", NULL,
			     BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
			     BSE_PARAM_DEFAULT);
}
#line 85 "bsewaverepo.proc"
  proc->help = "Load Wave from file";
#line 79 "bsewaverepo.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 80 "bsewaverepo.proc"
  proc->copyright = "Tim Janik";
#line 81 "bsewaverepo.proc"
  proc->date = "2001";
#line 94 "bsewaverepo.proc"
 }
static BseErrorType
#line 94 "bsewaverepo.proc"
load_file_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 97 "bsewaverepo.proc"
{
#line 98 "bsewaverepo.proc"
  
  BseWaveRepo *wrepo    = (BseWaveRepo*) g_value_get_object (in_values++);
  gchar *file_name      = g_value_get_string (in_values++);
  BseErrorType error = BSE_ERROR_FORMAT_MISMATCH; // FIXME
  
#line 103 "bsewaverepo.proc"
  
  if (!BSE_IS_WAVE_REPO (wrepo) || !file_name)
    return BSE_ERROR_PROC_PARAM_INVAL;

  error = load_file (wrepo, file_name);

#line 109 "bsewaverepo.proc"
  
  g_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- remove-wave --- */
static GType type_id_remove_wave = 0;
static void
remove_wave_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 115 "bsewaverepo.proc"
 {
#line 117 "bsewaverepo.proc"
  *(in_pspecs++)    = g_param_spec_object ("wave_repo", "Wave Repo", NULL,
			       BSE_TYPE_WAVE_REPO, BSE_PARAM_DEFAULT);
  *(in_pspecs++)    = g_param_spec_object ("wave", "Wave", NULL,
			       BSE_TYPE_WAVE, BSE_PARAM_DEFAULT);
#line 116 "bsewaverepo.proc"
  proc->help = "Remove a wave from repository";
#line 79 "bsewaverepo.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 80 "bsewaverepo.proc"
  proc->copyright = "Tim Janik";
#line 81 "bsewaverepo.proc"
  proc->date = "2001";
#line 121 "bsewaverepo.proc"
}  }
static BseErrorType
#line 121 "bsewaverepo.proc"
remove_wave_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 124 "bsewaverepo.proc"
{
#line 125 "bsewaverepo.proc"
  
  BseWaveRepo *wrepo = (BseWaveRepo*) g_value_get_object (in_values++);
  BseItem *wave      = (BseItem*) g_value_get_object (in_values++);

#line 129 "bsewaverepo.proc"
  
  if (!BSE_IS_WAVE_REPO (wrepo) || !BSE_IS_WAVE (wave) ||
      wave->parent != BSE_ITEM (wrepo))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 134 "bsewaverepo.proc"
  
  bse_container_remove_item (BSE_CONTAINER (wrepo), wave);

#line 137 "bsewaverepo.proc"
  

  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
BSE_EXPORTS_BEGIN (BSE_PLUGIN_NAME);
BSE_EXPORT_PROCEDURES = {
  { &type_id_load_file, "BseWaveRepo+load-file", NULL, 0, load_file_setup, load_file_exec, NULL, "/Method/BseWaveRepo/General/Load File", { 0, }, },
  { &type_id_remove_wave, "BseWaveRepo+remove-wave", NULL, 0, remove_wave_setup, remove_wave_exec, NULL, "/Method/BseWaveRepo/General/Remove Wave", { 0, }, },
  { NULL, },
};
BSE_EXPORTS_END;

/**
 ** Generated data ends here
 **/
