typedef enum
{
  BSW_BIN_DATA_RAW = 0,
  BSW_BIN_DATA_SAMPLE_VALUES = 1,
} BswBinDataType;
typedef enum
{
  BSW_BIQUAD_FILTER_RESONANT_LOWPASS = 1,
  BSW_BIQUAD_FILTER_RESONANT_HIGHPASS = 2,
} BswBiquadFilterType;
typedef enum
{
  BSW_BIQUAD_FILTER_NORM_PASSBAND = 0,
  BSW_BIQUAD_FILTER_NORM_RESONANCE_GAIN = 1,
  BSW_BIQUAD_FILTER_NORM_PEAK_GAIN = 2,
} BswBiquadFilterNorm;
typedef enum
{
  BSW_LITTLE_ENDIAN = 1234,
  BSW_BIG_ENDIAN = 4321,
} BswEndianType;
typedef enum
{
  BSW_INTERPOL_NONE = 0,
  BSW_INTERPOL_LINEAR = 1,
  BSW_INTERPOL_CUBIC = 2,
} BswInterpolType;
typedef enum
{
  BSW_LOOP_NONE = 0,
  BSW_LOOP_PATTERN = 1,
  BSW_LOOP_PATTERN_ROWS = 2,
  BSW_LOOP_SONG = 3,
} BswLoopType;
typedef enum
{
  BSW_EXEC_STATUS_START = 1,
  BSW_EXEC_STATUS_PROGRESS = 2,
  BSW_EXEC_STATUS_DONE = 3,
} BswExecStatus;
typedef enum
{
  BSW_USER_MSG_INFO = 0,
  BSW_USER_MSG_QUESTION = 1,
  BSW_USER_MSG_WARNING = 2,
  BSW_USER_MSG_ERROR = 3,
} BswUserMsgType;
typedef enum
{
  BSW_ERROR_NONE = 0,       	/* "Everything went well" */
  BSW_ERROR_INTERNAL = 1,       	/* "Internal error (please report)" */
  BSW_ERROR_UNKNOWN = 2,       	/* "Unknown error" */
  BSW_ERROR_IO = 3,       	/* "I/O error" */
  BSW_ERROR_PERMS = 4,       	/* "Insufficient permission" */
  BSW_ERROR_BUSY = 5,       	/* "Resource currently busy" */
  BSW_ERROR_EXISTS = 6,       	/* "Resource exists already" */
  BSW_ERROR_TEMP = 7,       	/* "Temporary error" */
  BSW_ERROR_EOF = 8,       	/* "File empty or premature EOF" */
  BSW_ERROR_NOT_FOUND = 9,       	/* "Resource not found" */
  BSW_ERROR_OPEN_FAILED = 10,       	/* "Open failed" */
  BSW_ERROR_SEEK_FAILED = 11,       	/* "Seek failed" */
  BSW_ERROR_READ_FAILED = 12,       	/* "Read failed" */
  BSW_ERROR_WRITE_FAILED = 13,       	/* "Write failed" */
  BSW_ERROR_FORMAT_INVALID = 14,       	/* "Invalid format" */
  BSW_ERROR_FORMAT_UNKNOWN = 15,       	/* "Unknown format" */
  BSW_ERROR_DATA_CORRUPT = 16,       	/* "Data corrupt" */
  BSW_ERROR_NO_RESOURCE = 18,       	/* "Out of memory, disk space or similar resource" */
  BSW_ERROR_CODEC_FAILURE = 19,       	/* "CODEC failure" */
  BSW_ERROR_UNIMPLEMENTED = 20,       	/* "Functionality not imlemented" */
  BSW_ERROR_SPAWN = 21,       	/* "Failed to spawn child process" */
  BSW_ERROR_NOT_OWNER = 22,       	/* "Ownership mismatch" */
  BSW_ERROR_USER_INFO = 23,       	/* "Inform User" */
  BSW_ERROR_USER_QUESTION = 24,       	/* "Ask User" */
  BSW_ERROR_USER_WARNING = 25,       	/* "Warn User" */
  BSW_ERROR_USER_ERROR = 26,       	/* "User Error" */
  BSW_ERROR_FILE_TOO_SHORT = 27,       	/* "File too short" */
  BSW_ERROR_FILE_TOO_LONG = 28,       	/* "File too long" */
  BSW_ERROR_HEADER_CORRUPT = 29,       	/* "Header corrupt" */
  BSW_ERROR_SUB_HEADER_CORRUPT = 30,       	/* "Sub-header corrupt" */
  BSW_ERROR_BINARY_DATA_CORRUPT = 31,       	/* "Binary data corrupt" */
  BSW_ERROR_PARSE_ERROR = 32,       	/* "parse-error" */
  BSW_ERROR_DEVICE_ASYNC = 33,       	/* "Device not async capable" */
  BSW_ERROR_DEVICE_BUSY = 34,       	/* "Device busy" */
  BSW_ERROR_DEVICE_GET_CAPS = 35,       	/* "Failed to query device capabilities" */
  BSW_ERROR_DEVICE_CAPS_MISMATCH = 36,       	/* "Device capabilities not sufficient" */
  BSW_ERROR_DEVICE_SET_CAPS = 37,       	/* "Failed to set device capabilities" */
  BSW_ERROR_DATE_INVALID = 38,       	/* "date-invalid" */
  BSW_ERROR_DATE_CLUTTERED = 39,       	/* "date-cluttered" */
  BSW_ERROR_DATE_YEAR_BOUNDS = 40,       	/* "date-year-bounds" */
  BSW_ERROR_DATE_MONTH_BOUNDS = 41,       	/* "date-month-bounds" */
  BSW_ERROR_DATE_DAY_BOUNDS = 42,       	/* "date-day-bounds" */
  BSW_ERROR_DATE_HOUR_BOUNDS = 43,       	/* "date-hour-bounds" */
  BSW_ERROR_DATE_MINUTE_BOUNDS = 44,       	/* "date-minute-bounds" */
  BSW_ERROR_DATE_SECOND_BOUNDS = 45,       	/* "date-second-bounds" */
  BSW_ERROR_DATE_TOO_OLD = 46,       	/* "date-too-old" */
  BSW_ERROR_SOURCE_NO_SUCH_ICHANNEL = 47,       	/* "No such input channel" */
  BSW_ERROR_SOURCE_NO_SUCH_OCHANNEL = 48,       	/* "No such output channel" */
  BSW_ERROR_SOURCE_NO_SUCH_CONNECTION = 49,       	/* "Input/Output channels not connected" */
  BSW_ERROR_SOURCE_ICHANNEL_IN_USE = 50,       	/* "Input channel already in use" */
  BSW_ERROR_SOURCE_CHANNELS_CONNECTED = 51,       	/* "Input/Output channels already connected" */
  BSW_ERROR_SOURCE_BAD_LOOPBACK = 52,       	/* "Bad loopback" */
  BSW_ERROR_SOURCE_BUSY = 53,       	/* "Synthesis module currently busy" */
  BSW_ERROR_SOURCE_TYPE_INVALID = 54,       	/* "Invalid synthsis module type" */
  BSW_ERROR_PROC_BUSY = 55,       	/* "Procedure currently busy" */
  BSW_ERROR_PROC_PARAM_INVAL = 56,       	/* "Procedure parameter invalid" */
  BSW_ERROR_PROC_EXECUTION = 57,       	/* "Procedure execution failed" */
  BSW_ERROR_PROC_ABORT = 58,       	/* "Procedure execution aborted" */
  BSW_ERROR_INVALID_OFFSET = 59,       	/* "Invalid offset" */
  BSW_ERROR_INVALID_DURATION = 60,       	/* "Invalid duration" */
  BSW_ERROR_INVALID_OVERLAP = 61,       	/* "Invalid overlap" */
  BSW_ERROR_NO_TARGET = 62,       	/* "No target" */
  BSW_ERROR_NO_PCM_DEVICE = 63,       	/* "No active PCM device present" */
  BSW_ERROR_PCM_DEVICE_ACTIVE = 64,       	/* "PCM device is active" */
} BswErrorType;
typedef enum
{
  BSW_FILE_CUSTOM_LOADER = -100,
  BSW_FILE_STANDARD_LOADER = 0,
  BSW_FILE_FALLBACK_LOADER = 100,
} BswFileHandlerType;
typedef enum
{
  BSW_TIME_RANGE_SHORT = 1,
  BSW_TIME_RANGE_MEDIUM = 2,
  BSW_TIME_RANGE_LONG = 3,
} BswTimeRangeType;
typedef enum
{
  BSW_MIDI_NOTE_OFF = 128,
  BSW_MIDI_NOTE_ON = 144,
  BSW_MIDI_KEY_PRESSURE = 160,
  BSW_MIDI_CONTROL_CHANGE = 176,
  BSW_MIDI_PROGRAM_CHANGE = 192,
  BSW_MIDI_CHANNEL_PRESSURE = 208,
  BSW_MIDI_PITCH_BEND = 224,
  BSW_MIDI_SYS_EX = 240,
  BSW_MIDI_SONG_POINTER = 242,
  BSW_MIDI_SONG_SELECT = 243,
  BSW_MIDI_TUNE = 246,
  BSW_MIDI_END_EX = 247,
  BSW_MIDI_TIMING_CLOCK = 248,
  BSW_MIDI_SONG_START = 250,
  BSW_MIDI_SONG_CONTINUE = 251,
  BSW_MIDI_SONG_STOP = 252,
  BSW_MIDI_ACTIVE_SENSING = 254,
  BSW_MIDI_SYSTEM_RESET = 255,
} BswMidiEventType;
typedef enum
{
  BSW_MIDI_SIGNAL_PROGRAM = 1,
  BSW_MIDI_SIGNAL_PRESSURE = 2,
  BSW_MIDI_SIGNAL_PITCH_BEND = 3,
  BSW_MIDI_SIGNAL_CONTINUOUS_0 = 64,
  BSW_MIDI_SIGNAL_CONTINUOUS_1 = 65,
  BSW_MIDI_SIGNAL_CONTINUOUS_2 = 66,
  BSW_MIDI_SIGNAL_CONTINUOUS_3 = 67,
  BSW_MIDI_SIGNAL_CONTINUOUS_4 = 68,
  BSW_MIDI_SIGNAL_CONTINUOUS_5 = 69,
  BSW_MIDI_SIGNAL_CONTINUOUS_6 = 70,
  BSW_MIDI_SIGNAL_CONTINUOUS_7 = 71,
  BSW_MIDI_SIGNAL_CONTINUOUS_8 = 72,
  BSW_MIDI_SIGNAL_CONTINUOUS_9 = 73,
  BSW_MIDI_SIGNAL_CONTINUOUS_10 = 74,
  BSW_MIDI_SIGNAL_CONTINUOUS_11 = 75,
  BSW_MIDI_SIGNAL_CONTINUOUS_12 = 76,
  BSW_MIDI_SIGNAL_CONTINUOUS_13 = 77,
  BSW_MIDI_SIGNAL_CONTINUOUS_14 = 78,
  BSW_MIDI_SIGNAL_CONTINUOUS_15 = 79,
  BSW_MIDI_SIGNAL_CONTINUOUS_16 = 80,
  BSW_MIDI_SIGNAL_CONTINUOUS_17 = 81,
  BSW_MIDI_SIGNAL_CONTINUOUS_18 = 82,
  BSW_MIDI_SIGNAL_CONTINUOUS_19 = 83,
  BSW_MIDI_SIGNAL_CONTINUOUS_20 = 84,
  BSW_MIDI_SIGNAL_CONTINUOUS_21 = 85,
  BSW_MIDI_SIGNAL_CONTINUOUS_22 = 86,
  BSW_MIDI_SIGNAL_CONTINUOUS_23 = 87,
  BSW_MIDI_SIGNAL_CONTINUOUS_24 = 88,
  BSW_MIDI_SIGNAL_CONTINUOUS_25 = 89,
  BSW_MIDI_SIGNAL_CONTINUOUS_26 = 90,
  BSW_MIDI_SIGNAL_CONTINUOUS_27 = 91,
  BSW_MIDI_SIGNAL_CONTINUOUS_28 = 92,
  BSW_MIDI_SIGNAL_CONTINUOUS_29 = 93,
  BSW_MIDI_SIGNAL_CONTINUOUS_30 = 94,
  BSW_MIDI_SIGNAL_CONTINUOUS_31 = 95,
  BSW_MIDI_SIGNAL_CONSTANT_HIGH = 96,
  BSW_MIDI_SIGNAL_CONSTANT_CENTER = 97,
  BSW_MIDI_SIGNAL_CONSTANT_LOW = 98,
  BSW_MIDI_SIGNAL_CONSTANT_NEGATIVE_CENTER = 99,
  BSW_MIDI_SIGNAL_CONSTANT_NEGATIVE_HIGH = 100,
  BSW_MIDI_SIGNAL_PARAMETER = 101,
  BSW_MIDI_SIGNAL_NON_PARAMETER = 102,
  BSW_MIDI_SIGNAL_CONTROL_0 = 128,
  BSW_MIDI_SIGNAL_CONTROL_1 = 129,
  BSW_MIDI_SIGNAL_CONTROL_2 = 130,
  BSW_MIDI_SIGNAL_CONTROL_3 = 131,
  BSW_MIDI_SIGNAL_CONTROL_4 = 132,
  BSW_MIDI_SIGNAL_CONTROL_5 = 133,
  BSW_MIDI_SIGNAL_CONTROL_6 = 134,
  BSW_MIDI_SIGNAL_CONTROL_7 = 135,
  BSW_MIDI_SIGNAL_CONTROL_8 = 136,
  BSW_MIDI_SIGNAL_CONTROL_9 = 137,
  BSW_MIDI_SIGNAL_CONTROL_10 = 138,
  BSW_MIDI_SIGNAL_CONTROL_11 = 139,
  BSW_MIDI_SIGNAL_CONTROL_12 = 140,
  BSW_MIDI_SIGNAL_CONTROL_13 = 141,
  BSW_MIDI_SIGNAL_CONTROL_14 = 142,
  BSW_MIDI_SIGNAL_CONTROL_15 = 143,
  BSW_MIDI_SIGNAL_CONTROL_16 = 144,
  BSW_MIDI_SIGNAL_CONTROL_17 = 145,
  BSW_MIDI_SIGNAL_CONTROL_18 = 146,
  BSW_MIDI_SIGNAL_CONTROL_19 = 147,
  BSW_MIDI_SIGNAL_CONTROL_20 = 148,
  BSW_MIDI_SIGNAL_CONTROL_21 = 149,
  BSW_MIDI_SIGNAL_CONTROL_22 = 150,
  BSW_MIDI_SIGNAL_CONTROL_23 = 151,
  BSW_MIDI_SIGNAL_CONTROL_24 = 152,
  BSW_MIDI_SIGNAL_CONTROL_25 = 153,
  BSW_MIDI_SIGNAL_CONTROL_26 = 154,
  BSW_MIDI_SIGNAL_CONTROL_27 = 155,
  BSW_MIDI_SIGNAL_CONTROL_28 = 156,
  BSW_MIDI_SIGNAL_CONTROL_29 = 157,
  BSW_MIDI_SIGNAL_CONTROL_30 = 158,
  BSW_MIDI_SIGNAL_CONTROL_31 = 159,
  BSW_MIDI_SIGNAL_CONTROL_32 = 160,
  BSW_MIDI_SIGNAL_CONTROL_33 = 161,
  BSW_MIDI_SIGNAL_CONTROL_34 = 162,
  BSW_MIDI_SIGNAL_CONTROL_35 = 163,
  BSW_MIDI_SIGNAL_CONTROL_36 = 164,
  BSW_MIDI_SIGNAL_CONTROL_37 = 165,
  BSW_MIDI_SIGNAL_CONTROL_38 = 166,
  BSW_MIDI_SIGNAL_CONTROL_39 = 167,
  BSW_MIDI_SIGNAL_CONTROL_40 = 168,
  BSW_MIDI_SIGNAL_CONTROL_41 = 169,
  BSW_MIDI_SIGNAL_CONTROL_42 = 170,
  BSW_MIDI_SIGNAL_CONTROL_43 = 171,
  BSW_MIDI_SIGNAL_CONTROL_44 = 172,
  BSW_MIDI_SIGNAL_CONTROL_45 = 173,
  BSW_MIDI_SIGNAL_CONTROL_46 = 174,
  BSW_MIDI_SIGNAL_CONTROL_47 = 175,
  BSW_MIDI_SIGNAL_CONTROL_48 = 176,
  BSW_MIDI_SIGNAL_CONTROL_49 = 177,
  BSW_MIDI_SIGNAL_CONTROL_50 = 178,
  BSW_MIDI_SIGNAL_CONTROL_51 = 179,
  BSW_MIDI_SIGNAL_CONTROL_52 = 180,
  BSW_MIDI_SIGNAL_CONTROL_53 = 181,
  BSW_MIDI_SIGNAL_CONTROL_54 = 182,
  BSW_MIDI_SIGNAL_CONTROL_55 = 183,
  BSW_MIDI_SIGNAL_CONTROL_56 = 184,
  BSW_MIDI_SIGNAL_CONTROL_57 = 185,
  BSW_MIDI_SIGNAL_CONTROL_58 = 186,
  BSW_MIDI_SIGNAL_CONTROL_59 = 187,
  BSW_MIDI_SIGNAL_CONTROL_60 = 188,
  BSW_MIDI_SIGNAL_CONTROL_61 = 189,
  BSW_MIDI_SIGNAL_CONTROL_62 = 190,
  BSW_MIDI_SIGNAL_CONTROL_63 = 191,
  BSW_MIDI_SIGNAL_CONTROL_64 = 192,
  BSW_MIDI_SIGNAL_CONTROL_65 = 193,
  BSW_MIDI_SIGNAL_CONTROL_66 = 194,
  BSW_MIDI_SIGNAL_CONTROL_67 = 195,
  BSW_MIDI_SIGNAL_CONTROL_68 = 196,
  BSW_MIDI_SIGNAL_CONTROL_69 = 197,
  BSW_MIDI_SIGNAL_CONTROL_70 = 198,
  BSW_MIDI_SIGNAL_CONTROL_71 = 199,
  BSW_MIDI_SIGNAL_CONTROL_72 = 200,
  BSW_MIDI_SIGNAL_CONTROL_73 = 201,
  BSW_MIDI_SIGNAL_CONTROL_74 = 202,
  BSW_MIDI_SIGNAL_CONTROL_75 = 203,
  BSW_MIDI_SIGNAL_CONTROL_76 = 204,
  BSW_MIDI_SIGNAL_CONTROL_77 = 205,
  BSW_MIDI_SIGNAL_CONTROL_78 = 206,
  BSW_MIDI_SIGNAL_CONTROL_79 = 207,
  BSW_MIDI_SIGNAL_CONTROL_80 = 208,
  BSW_MIDI_SIGNAL_CONTROL_81 = 209,
  BSW_MIDI_SIGNAL_CONTROL_82 = 210,
  BSW_MIDI_SIGNAL_CONTROL_83 = 211,
  BSW_MIDI_SIGNAL_CONTROL_84 = 212,
  BSW_MIDI_SIGNAL_CONTROL_85 = 213,
  BSW_MIDI_SIGNAL_CONTROL_86 = 214,
  BSW_MIDI_SIGNAL_CONTROL_87 = 215,
  BSW_MIDI_SIGNAL_CONTROL_88 = 216,
  BSW_MIDI_SIGNAL_CONTROL_89 = 217,
  BSW_MIDI_SIGNAL_CONTROL_90 = 218,
  BSW_MIDI_SIGNAL_CONTROL_91 = 219,
  BSW_MIDI_SIGNAL_CONTROL_92 = 220,
  BSW_MIDI_SIGNAL_CONTROL_93 = 221,
  BSW_MIDI_SIGNAL_CONTROL_94 = 222,
  BSW_MIDI_SIGNAL_CONTROL_95 = 223,
  BSW_MIDI_SIGNAL_CONTROL_96 = 224,
  BSW_MIDI_SIGNAL_CONTROL_97 = 225,
  BSW_MIDI_SIGNAL_CONTROL_98 = 226,
  BSW_MIDI_SIGNAL_CONTROL_99 = 227,
  BSW_MIDI_SIGNAL_CONTROL_100 = 228,
  BSW_MIDI_SIGNAL_CONTROL_101 = 229,
  BSW_MIDI_SIGNAL_CONTROL_102 = 230,
  BSW_MIDI_SIGNAL_CONTROL_103 = 231,
  BSW_MIDI_SIGNAL_CONTROL_104 = 232,
  BSW_MIDI_SIGNAL_CONTROL_105 = 233,
  BSW_MIDI_SIGNAL_CONTROL_106 = 234,
  BSW_MIDI_SIGNAL_CONTROL_107 = 235,
  BSW_MIDI_SIGNAL_CONTROL_108 = 236,
  BSW_MIDI_SIGNAL_CONTROL_109 = 237,
  BSW_MIDI_SIGNAL_CONTROL_110 = 238,
  BSW_MIDI_SIGNAL_CONTROL_111 = 239,
  BSW_MIDI_SIGNAL_CONTROL_112 = 240,
  BSW_MIDI_SIGNAL_CONTROL_113 = 241,
  BSW_MIDI_SIGNAL_CONTROL_114 = 242,
  BSW_MIDI_SIGNAL_CONTROL_115 = 243,
  BSW_MIDI_SIGNAL_CONTROL_116 = 244,
  BSW_MIDI_SIGNAL_CONTROL_117 = 245,
  BSW_MIDI_SIGNAL_CONTROL_118 = 246,
  BSW_MIDI_SIGNAL_CONTROL_119 = 247,
  BSW_MIDI_SIGNAL_CONTROL_120 = 248,
  BSW_MIDI_SIGNAL_CONTROL_121 = 249,
  BSW_MIDI_SIGNAL_CONTROL_122 = 250,
  BSW_MIDI_SIGNAL_CONTROL_123 = 251,
  BSW_MIDI_SIGNAL_CONTROL_124 = 252,
  BSW_MIDI_SIGNAL_CONTROL_125 = 253,
  BSW_MIDI_SIGNAL_CONTROL_126 = 254,
  BSW_MIDI_SIGNAL_CONTROL_127 = 255,
} BswMidiSignalType;
typedef enum
{
  BSW_STANDARD_OSC_SINE = 1,
  BSW_STANDARD_OSC_TRIANGLE = 2,
  BSW_STANDARD_OSC_SAW_RISE = 3,
  BSW_STANDARD_OSC_SAW_FALL = 4,
  BSW_STANDARD_OSC_PEAK_RISE = 5,
  BSW_STANDARD_OSC_PEAK_FALL = 6,
  BSW_STANDARD_OSC_MOOG_SAW = 7,
  BSW_STANDARD_OSC_SQUARE = 8,
  BSW_STANDARD_OSC_PULSE = 9,
} BswStandardOscWaveType;
typedef enum
{
  BSW_DEBUG_TABLES = 0x1,
  BSW_DEBUG_CLASSES = 0x2,
  BSW_DEBUG_OBJECTS = 0x4,
  BSW_DEBUG_NOTIFY = 0x8,
  BSW_DEBUG_PLUGINS = 0x10,
  BSW_DEBUG_CHUNKS = 0x20,
  BSW_DEBUG_LOOP = 0x40,
  BSW_DEBUG_PCM = 0x80,
  BSW_DEBUG_MIDI = 0x100,
  BSW_DEBUG_LEAKS = 0x200,
} BswDebugFlags;
typedef enum
{
  BSW_MAGIC_BSE_BIN_EXTENSION = 0x1,
  BSW_MAGIC_BSE_SONG = 0x4,
} BswMagicFlags;
typedef enum
{
  BSW_PARAM_READABLE = 0x1,
  BSW_PARAM_WRITABLE = 0x2,
  BSW_PARAM_MASK = 0xff,
  BSW_PARAM_SERVE_GUI = 0x100,
  BSW_PARAM_SERVE_STORAGE = 0x200,
  BSW_PARAM_SERVE_MASK = 0xf00,
  BSW_PARAM_FORCE_DIRTY = 0x2000,
  BSW_PARAM_STORAGE_FLAG_MASK = 0xf000,
  BSW_PARAM_HINT_CHECK_NULL = 0x10000,
  BSW_PARAM_HINT_RDONLY = 0x20000,
  BSW_PARAM_HINT_RADIO = 0x40000,
  BSW_PARAM_HINT_DIAL = 0x80000,
  BSW_PARAM_HINT_SCALE = 0x100000,
  BSW_PARAM_HINT_MASK = 0xffff0000,
  BSW_PARAM_READWRITE = 0x3,
  BSW_PARAM_GUI = 0x103,
  BSW_PARAM_STORAGE = 0x203,
  BSW_PARAM_DEFAULT = 0x303,
} BswParamFlags;

BswIterProxy* bsw_container_list_items (BswProxy  container);

BswProxy  bsw_container_lookup_item (BswProxy  container,
                                     const gchar* uname);

guint     bsw_data_pocket_create_entry (BswProxy  data_pocket);

BswErrorType bsw_data_pocket_delete_entry (BswProxy  data_pocket,
                                           guint     entry_id);

gfloat    bsw_data_pocket_get_float (BswProxy  data_pocket,
                                     guint     entry_id,
                                     const gchar* name);

gint      bsw_data_pocket_get_int (BswProxy  data_pocket,
                                   guint     entry_id,
                                   const gchar* name);

guint     bsw_data_pocket_get_n_entries (BswProxy  data_pocket);

guint     bsw_data_pocket_get_nth_entry_id (BswProxy  data_pocket,
                                            guint     entry_index);

BswProxy  bsw_data_pocket_get_object (BswProxy  data_pocket,
                                      guint     entry_id,
                                      const gchar* name);

gchar* bsw_data_pocket_get_string (BswProxy  data_pocket,
                                   guint     entry_id,
                                   const gchar* name);

BswErrorType bsw_data_pocket_set_float (BswProxy  data_pocket,
                                        guint     entry_id,
                                        const gchar* name,
                                        gfloat    number);

BswErrorType bsw_data_pocket_set_int (BswProxy  data_pocket,
                                      guint     entry_id,
                                      const gchar* name,
                                      gint      number);

BswErrorType bsw_data_pocket_set_object (BswProxy  data_pocket,
                                         guint     entry_id,
                                         const gchar* name,
                                         BswProxy  item);

BswErrorType bsw_data_pocket_set_string (BswProxy  data_pocket,
                                         guint     entry_id,
                                         const gchar* name,
                                         const gchar* string);

void bsw_editable_sample_close (BswProxy  esample);

BswValueBlock* bsw_editable_sample_collect_stats (BswProxy  esample,
                                                  guint     voffset,
                                                  gdouble   offset_scale,
                                                  guint     block_size,
                                                  guint     stepping,
                                                  guint     max_pairs);

guint     bsw_editable_sample_get_length (BswProxy  esample);

guint     bsw_editable_sample_get_n_channels (BswProxy  esample);

gfloat    bsw_editable_sample_get_osc_freq (BswProxy  esample);

BswErrorType bsw_editable_sample_open (BswProxy  esample);

BswValueBlock* bsw_editable_sample_read_samples (BswProxy  esample,
                                                 guint     voffset);

gboolean  bsw_item_check_is_a (BswProxy  item,
                               const gchar* type_name);

BswProxy  bsw_item_common_ancestor (BswProxy  item,
                                    BswProxy  item2);

gchar* bsw_item_get_name (BswProxy  item);

gchar* bsw_item_get_name_or_type (BswProxy  item);

BswProxy  bsw_item_get_parent (BswProxy  item);

BswProxy  bsw_item_get_project (BswProxy  item);

guint     bsw_item_get_seqid (BswProxy  item);

gulong     bsw_item_get_type (BswProxy  item);

gchar* bsw_item_get_type_blurb (BswProxy  item);

gchar* bsw_item_get_type_name (BswProxy  item);

gchar* bsw_item_get_uname_path (BswProxy  item);

BswIterProxy* bsw_item_list_proxies (BswProxy  item,
                                     const gchar* property);

void bsw_item_unuse (BswProxy  item);

BswProxy  bsw_item_use (BswProxy  item);

guint     bsw_midi_notifier_current_time (BswProxy  midi_notifier);

gboolean  bsw_object_is_a (BswProxy  item,
                           const gchar* type_name);

BswErrorType bsw_part_change_note (BswProxy  part,
                                   guint     id,
                                   guint     tick,
                                   guint     duration,
                                   gint      note,
                                   gint      fine_tune,
                                   gfloat    velocity);

BswIterPartNote* bsw_part_check_overlap (BswProxy  part,
                                         guint     tick,
                                         guint     duration,
                                         gint      note);

BswErrorType bsw_part_delete_event (BswProxy  part,
                                    guint     id);

void bsw_part_deselect_event (BswProxy  part,
                              guint     id);

void bsw_part_deselect_rectangle (BswProxy  part,
                                  guint     tick,
                                  guint     duration,
                                  gint      min_note,
                                  gint      max_note);

gint      bsw_part_get_max_note (BswProxy  part);

guint     bsw_part_get_max_tick (BswProxy  part);

gint      bsw_part_get_min_note (BswProxy  part);

BswIterPartNote* bsw_part_get_notes (BswProxy  part,
                                     guint     tick,
                                     gint      note);

guint     bsw_part_insert_note (BswProxy  part,
                                guint     tick,
                                guint     duration,
                                gint      note,
                                gint      fine_tune,
                                gfloat    velocity);

gboolean  bsw_part_is_selected_event (BswProxy  part,
                                      guint     id);

BswIterPartNote* bsw_part_list_notes_crossing (BswProxy  part,
                                               guint     tick,
                                               guint     duration);

BswIterPartNote* bsw_part_list_selected_notes (BswProxy  part);

void bsw_part_queue_notes_within (BswProxy  part,
                                  guint     tick,
                                  guint     duration,
                                  gint      min_note,
                                  gint      max_note);

void bsw_part_select_event (BswProxy  part,
                            guint     id);

void bsw_part_select_rectangle (BswProxy  part,
                                guint     tick,
                                guint     duration,
                                gint      min_note,
                                gint      max_note);

void bsw_part_select_rectangle_exclusive (BswProxy  part,
                                          guint     tick,
                                          guint     duration,
                                          gint      min_note,
                                          gint      max_note);

BswErrorType bsw_project_restore_from_file (BswProxy  project,
                                            const gchar* file_name);

BswErrorType bsw_project_store_bse (BswProxy  project,
                                    const gchar* file_name,
                                    gboolean  self_contained);

BswProxy  bsw_project_create_midi_synth (BswProxy  project,
                                         const gchar* name);

BswProxy  bsw_project_create_snet (BswProxy  project,
                                   const gchar* name);

BswProxy  bsw_project_create_song (BswProxy  project,
                                   const gchar* name);

BswProxy  bsw_project_ensure_wave_repo (BswProxy  project);

BswProxy  bsw_project_find_item (BswProxy  project,
                                 const gchar* uname_path);

BswProxy  bsw_project_get_data_pocket (BswProxy  project,
                                       const gchar* name);

gboolean  bsw_project_is_playing (BswProxy  project);

BswIterString* bsw_project_list_uname_paths (BswProxy  project,
                                             gulong     item_type);

BswIterProxy* bsw_project_match_items_by_uname (BswProxy  project,
                                                gulong     item_type,
                                                const gchar* uname);

BswErrorType bsw_snet_can_create_source (BswProxy  snet,
                                         const gchar* module_type);

BswProxy  bsw_snet_create_source (BswProxy  snet,
                                  const gchar* module_type);

BswErrorType bsw_snet_remove_source (BswProxy  snet,
                                     BswProxy  module);

gboolean  bsw_snet_supports_user_synths (BswProxy  snet);

gchar* bsw_script_control_get_action (BswProxy  script_control,
                                      guint     nth_action);

gchar* bsw_script_control_get_action_blurb (BswProxy  script_control,
                                            guint     nth_action);

gchar* bsw_script_control_get_action_name (BswProxy  script_control,
                                           guint     nth_action);

void bsw_script_control_kill (BswProxy  script_control);

guint     bsw_script_control_n_actions (BswProxy  script_control);

void bsw_script_control_trigger_action (BswProxy  script_control,
                                        const gchar* action);

gboolean  bsw_server_can_load (BswProxy  server,
                               const gchar* file_name);

BswNoteDescription* bsw_server_construct_note (BswProxy  server,
                                               guint     semitone,
                                               gint      octave,
                                               gint      fine_tune);

BswNoteDescription* bsw_server_describe_note (BswProxy  server,
                                              guint     note,
                                              gint      fine_tune);

BswProxy  bsw_server_get_midi_notifier (BswProxy  server);

void bsw_server_halt_project (BswProxy  server,
                              BswProxy  project);

guint     bsw_server_n_scripts (BswProxy  server);

BswNoteDescription* bsw_server_note_from_freq (BswProxy  server,
                                               gfloat    freq);

BswNoteDescription* bsw_server_note_from_string (BswProxy  server,
                                                 const gchar* name);

BswErrorType bsw_server_run_project (BswProxy  server,
                                     BswProxy  project);

BswProxy  bsw_server_use_new_project (BswProxy  server,
                                      const gchar* name);

BswProxy  bsw_song_create_part (BswProxy  song);

BswProxy  bsw_song_create_track (BswProxy  song);

void bsw_song_remove_part (BswProxy  song,
                           BswProxy  part);

void bsw_song_remove_track (BswProxy  song,
                            BswProxy  track);

void bsw_source_clear_inputs (BswProxy  module);

void bsw_source_clear_outputs (BswProxy  module);

gchar* bsw_source_ichannel_blurb (BswProxy  module,
                                  guint     input_channel);

gchar* bsw_source_ichannel_cname (BswProxy  module,
                                  guint     input_channel);

guint     bsw_source_ichannel_get_n_joints (BswProxy  module,
                                            guint     input_channel);

guint     bsw_source_ichannel_get_ochannel (BswProxy  module,
                                            guint     input_channel,
                                            guint     input_joint);

BswProxy  bsw_source_ichannel_get_osource (BswProxy  module,
                                           guint     input_channel,
                                           guint     input_joint);

gchar* bsw_source_ichannel_name (BswProxy  module,
                                 guint     input_channel);

gboolean  bsw_source_is_joint_ichannel (BswProxy  module,
                                        const gchar* input_channel);

gboolean  bsw_source_is_joint_ichannel_by_id (BswProxy  module,
                                              guint     input_channel);

guint     bsw_source_n_ichannels (BswProxy  module);

guint     bsw_source_n_ochannels (BswProxy  module);

gchar* bsw_source_ochannel_blurb (BswProxy  module,
                                  guint     input_channel);

gchar* bsw_source_ochannel_cname (BswProxy  module,
                                  guint     input_channel);

gchar* bsw_source_ochannel_name (BswProxy  module,
                                 guint     input_channel);

BswErrorType bsw_source_set_input (BswProxy  imodule,
                                   const gchar* input_channel,
                                   BswProxy  omodule,
                                   const gchar* output_channel);

BswErrorType bsw_source_set_input_by_id (BswProxy  imodule,
                                         guint     input_channel,
                                         BswProxy  omodule,
                                         guint     output_channel);

BswErrorType bsw_source_unset_input (BswProxy  module,
                                     const gchar* input_channel,
                                     BswProxy  omodule,
                                     const gchar* output_channel);

BswErrorType bsw_source_unset_input_by_id (BswProxy  module,
                                           guint     input_channel,
                                           BswProxy  omodule,
                                           guint     output_channel);

BswErrorType bsw_wave_load_wave (BswProxy  wave,
                                 const gchar* file_name,
                                 const gchar* wave_name);

guint     bsw_wave_n_wave_chunks (BswProxy  wave);

BswProxy  bsw_wave_use_editable (BswProxy  wave,
                                 guint     chunk_index);

void bsw_wave_osc_pcm_seek_perc (BswProxy  wosc,
                                 gfloat    pos_perc);

void bsw_wave_osc_request_pcm_position (BswProxy  wosc);

BswErrorType bsw_wave_repo_load_file (BswProxy  wave_repo,
                                      const gchar* file_name);

void bsw_wave_repo_remove_wave (BswProxy  wave_repo,
                                BswProxy  wave);

void bsw_script_add_action (const gchar* action,
                            const gchar* name,
                            const gchar* blurb);

BswProxy  bsw_script_control (void);

void bsw_script_exit (BswUserMsgType msg_type,
                      const gchar* message);

void bsw_script_progress (gfloat    progress);

void bsw_script_remove_action (BswProxy  script_control,
                               const gchar* action);

void bsw_script_set_msg (BswUserMsgType msg_type,
                         const gchar* message);

void bsw_hello_world (void);

gchar* bsw_randomizer (gboolean  use_seed,
                       gint      seed);

gchar* bsw_error_blurb (BswErrorType error);

gchar* bsw_error_name (BswErrorType error);

gboolean  bsw_proxy_check (BswProxy  item,
                           const gchar* type_name);

guint     bsw_note_from_freq (gfloat    frequency);

gfloat    bsw_note_to_freq (guint     note,
                            gint      fine_tune);

GType bsw_type_wrap_SOURCE (void);
#define BSW_TYPE_SOURCE	(bsw_type_wrap_SOURCE ())
#define BSW_IS_SOURCE(proxy)	(bsw_proxy_check_is_a ((proxy), bsw_type_wrap_SOURCE ()))
GType bsw_type_wrap_EDITABLE_SAMPLE (void);
#define BSW_TYPE_EDITABLE_SAMPLE	(bsw_type_wrap_EDITABLE_SAMPLE ())
#define BSW_IS_EDITABLE_SAMPLE(proxy)	(bsw_proxy_check_is_a ((proxy), bsw_type_wrap_EDITABLE_SAMPLE ()))
GType bsw_type_wrap_SONG (void);
#define BSW_TYPE_SONG	(bsw_type_wrap_SONG ())
#define BSW_IS_SONG(proxy)	(bsw_proxy_check_is_a ((proxy), bsw_type_wrap_SONG ()))
GType bsw_type_wrap_MIDI_SYNTH (void);
#define BSW_TYPE_MIDI_SYNTH	(bsw_type_wrap_MIDI_SYNTH ())
#define BSW_IS_MIDI_SYNTH(proxy)	(bsw_proxy_check_is_a ((proxy), bsw_type_wrap_MIDI_SYNTH ()))
GType bsw_type_wrap_SNET (void);
#define BSW_TYPE_SNET	(bsw_type_wrap_SNET ())
#define BSW_IS_SNET(proxy)	(bsw_proxy_check_is_a ((proxy), bsw_type_wrap_SNET ()))
GType bsw_type_wrap_CONTAINER (void);
#define BSW_TYPE_CONTAINER	(bsw_type_wrap_CONTAINER ())
#define BSW_IS_CONTAINER(proxy)	(bsw_proxy_check_is_a ((proxy), bsw_type_wrap_CONTAINER ()))
GType bsw_type_wrap_OBJECT (void);
#define BSW_TYPE_OBJECT	(bsw_type_wrap_OBJECT ())
#define BSW_IS_OBJECT(proxy)	(bsw_proxy_check_is_a ((proxy), bsw_type_wrap_OBJECT ()))
GType bsw_type_wrap_DATA_POCKET (void);
#define BSW_TYPE_DATA_POCKET	(bsw_type_wrap_DATA_POCKET ())
#define BSW_IS_DATA_POCKET(proxy)	(bsw_proxy_check_is_a ((proxy), bsw_type_wrap_DATA_POCKET ()))
GType bsw_type_wrap_MIDI_NOTIFIER (void);
#define BSW_TYPE_MIDI_NOTIFIER	(bsw_type_wrap_MIDI_NOTIFIER ())
#define BSW_IS_MIDI_NOTIFIER(proxy)	(bsw_proxy_check_is_a ((proxy), bsw_type_wrap_MIDI_NOTIFIER ()))
GType bsw_type_wrap_ERROR_TYPE (void);
#define BSW_TYPE_ERROR_TYPE	(bsw_type_wrap_ERROR_TYPE ())
GType bsw_type_wrap_SCRIPT_CONTROL (void);
#define BSW_TYPE_SCRIPT_CONTROL	(bsw_type_wrap_SCRIPT_CONTROL ())
#define BSW_IS_SCRIPT_CONTROL(proxy)	(bsw_proxy_check_is_a ((proxy), bsw_type_wrap_SCRIPT_CONTROL ()))
GType bsw_type_wrap_SUPER (void);
#define BSW_TYPE_SUPER	(bsw_type_wrap_SUPER ())
#define BSW_IS_SUPER(proxy)	(bsw_proxy_check_is_a ((proxy), bsw_type_wrap_SUPER ()))
GType bsw_type_wrap_WAVE_REPO (void);
#define BSW_TYPE_WAVE_REPO	(bsw_type_wrap_WAVE_REPO ())
#define BSW_IS_WAVE_REPO(proxy)	(bsw_proxy_check_is_a ((proxy), bsw_type_wrap_WAVE_REPO ()))
GType bsw_type_wrap_TRACK (void);
#define BSW_TYPE_TRACK	(bsw_type_wrap_TRACK ())
#define BSW_IS_TRACK(proxy)	(bsw_proxy_check_is_a ((proxy), bsw_type_wrap_TRACK ()))
GType bsw_type_wrap_WAVE (void);
#define BSW_TYPE_WAVE	(bsw_type_wrap_WAVE ())
#define BSW_IS_WAVE(proxy)	(bsw_proxy_check_is_a ((proxy), bsw_type_wrap_WAVE ()))
GType bsw_type_wrap_WAVE_OSC (void);
#define BSW_TYPE_WAVE_OSC	(bsw_type_wrap_WAVE_OSC ())
#define BSW_IS_WAVE_OSC(proxy)	(bsw_proxy_check_is_a ((proxy), bsw_type_wrap_WAVE_OSC ()))
GType bsw_type_wrap_PART (void);
#define BSW_TYPE_PART	(bsw_type_wrap_PART ())
#define BSW_IS_PART(proxy)	(bsw_proxy_check_is_a ((proxy), bsw_type_wrap_PART ()))
GType bsw_type_wrap_PROJECT (void);
#define BSW_TYPE_PROJECT	(bsw_type_wrap_PROJECT ())
#define BSW_IS_PROJECT(proxy)	(bsw_proxy_check_is_a ((proxy), bsw_type_wrap_PROJECT ()))
GType bsw_type_wrap_ITEM (void);
#define BSW_TYPE_ITEM	(bsw_type_wrap_ITEM ())
#define BSW_IS_ITEM(proxy)	(bsw_proxy_check_is_a ((proxy), bsw_type_wrap_ITEM ()))
GType bsw_type_wrap_SERVER (void);
#define BSW_TYPE_SERVER	(bsw_type_wrap_SERVER ())
#define BSW_IS_SERVER(proxy)	(bsw_proxy_check_is_a ((proxy), bsw_type_wrap_SERVER ()))
GType bsw_type_wrap_USER_MSG_TYPE (void);
#define BSW_TYPE_USER_MSG_TYPE	(bsw_type_wrap_USER_MSG_TYPE ())
