#include        "glib_extra.h"
#include        <string.h>
#include	<pwd.h>
#include	<unistd.h>
#include	<sys/types.h>


const gchar*
g_basename (const gchar    *file_name)
{
  register gchar *base;
  
  g_return_val_if_fail (file_name != NULL, NULL);
  
  base = strrchr (file_name, '/');
  if (base)
    base++;
  else
    base = (gchar*) file_name;
  
  return base;
}

void
g_str_canon (gchar       *string,
	     const gchar *extra_valid_chars,
	     gchar        subsitutor)
{
  register gchar *c;
  
  g_return_if_fail (string != NULL);
  
  if (!extra_valid_chars)
    extra_valid_chars = "";
  
  for (c = string; *c; c++)
    {
      if ((*c < 'a' || *c > 'z') &&
	  (*c < 'A' || *c > 'Z') &&
	  (*c < '0' || *c > '9') &&
	  !strchr (extra_valid_chars, *c))
	*c = subsitutor;
    }
}

static	gchar	*g_user_name = NULL;
static	gchar	*g_real_name = NULL;
static	gchar	*g_home_dir = NULL;
static	gchar	*g_tmp_dir = NULL;

static void
g_get_any_init (void)
{
  static gboolean need_init = FALSE;

  if (!need_init)
    {
      struct passwd *pw;
      gchar *s;

      need_init = TRUE;

      g_home_dir = g_strdup (getenv ("HOME"));

      setpwent ();
      pw = getpwuid (getuid ());
      endpwent ();

      if (pw)
	{
	  g_user_name = g_strdup (pw->pw_name);
	  g_real_name = g_strdup (pw->pw_gecos);
	  if (!g_home_dir)
	    g_home_dir = g_strdup (pw->pw_dir);
	}

      g_tmp_dir = g_strdup (getenv ("TMP"));
      if (!g_tmp_dir)
	g_tmp_dir = g_strdup (getenv ("TEMP"));
      if (!g_tmp_dir)
	g_tmp_dir = g_strdup ("/tmp");
    }
}

gchar*
g_get_user_name (void)
{
  g_get_any_init ();

  return g_user_name;
}

gchar*
g_get_real_name (void)
{
  g_get_any_init ();

  return g_real_name;
}

gchar*
g_get_home_dir (void)
{
  g_get_any_init ();

  return g_home_dir;
}

gchar*
g_get_tmp_dir (void)
{
  g_get_any_init ();

  return g_tmp_dir;
}

gchar*
g_getcwd (void)
{
  static gchar *dir = NULL;
  gchar *s;
#if	defined (sun) && !defined (__SVR4)
  gchar *getwd_buf[PATH_MAX + 1] = { 0 };

  g_free (dir);
  dir = g_strdup (getwd (getwd_buf));
#else	/* !sun */
  s = g_new (gchar, 2048);
  dir = g_strdup (getcwd (s, 2047));
  g_free (s);
#endif	/* !sun */
  
  if (!dir)
    {
      /* hm, we should probably g_error() out here...
       */
      dir = g_strdup ("/");
    }
  
  return dir;
}
