#include "defines.h"

/****************************************************************/
/*	The Merge Procedure.
/****************************************************************/
#define valid(l) ccw(orig(basel), dest(l), dest(basel))

do_merge(ldo, ldi, rdi, rdo)
EDGE_PTR ldi, rdi, *ldo, *rdo;
{
    int rvalid, lvalid;
    register EDGE_PTR basel,lcand,rcand,t;
    while (TRUE) {
	while (ccw(orig(ldi), dest(ldi), orig(rdi))) { ldi = lnext(ldi); }
	if (ccw(dest(rdi), orig(rdi), orig(ldi))) {  rdi = rprev(rdi); }
	else { break; }
    }
    
    basel = connect_left(sym(rdi), ldi);
    lcand = rprev(basel);
    rcand = oprev(basel);
    if (orig(basel) == orig(*rdo)) *rdo = basel;
    if (dest(basel) == orig(*ldo)) *ldo = sym(basel);
    
    while (TRUE) {
    	if (/* valid(lcand) && */ valid(t=onext(lcand))) {
	    while (incircle(dest(lcand), dest(t), orig(lcand), orig(basel))) {
		deleteedge(lcand);
		lcand = t;
		t = onext(lcand);
	    }
	}
    	if (/* valid(rcand) && */ valid(t=oprev(rcand))) {
	    while (incircle(dest(t), dest(rcand), orig(rcand), dest(basel))) {
		deleteedge(rcand);
		rcand = t;
		t = oprev(rcand);
	    }
	}
    
	lvalid = valid(lcand);
	rvalid = valid(rcand);
	if ((! lvalid) && (! rvalid)) { return;	}
    
	if (!lvalid || (rvalid
	    && incircle(dest(lcand), orig(lcand), orig(rcand), dest(rcand)))) {
	    basel = connect_left(rcand, sym(basel));
	    rcand = lnext(sym(basel));
	}
	else {
	    basel = sym(connect_right(lcand, basel));
	    lcand = rprev(basel);
	}
    }
};
