/* $Id: dev.c,v 1.7 89/09/20 17:59:53 mbp Exp $
 *
 * dev.c: device commands for SunView
 */

/************************************************************************
 *		Copyright (C) 1989 by Mark B. Phillips                  *
 * 									*
 * Permission to use, copy, modify, and distribute this software and    *
 * its documentation for any purpose and without fee is hereby granted, *
 * provided that the above copyright notice appear in all copies and    *
 * that both that copyright notice and this permission notice appear in *
 * supporting documentation, and that the name of Mark B. Phillips or   *
 * the University of Maryland not be used in advertising or publicity   *
 * pertaining to distribution of the software without specific, written *
 * prior permission.  This software is provided "as is" without express *
 * or implied warranty.                                                 *
 ************************************************************************/

/* NOTE: this file assumes that the preprocessor macro HELPFILE will
 * be defined on the command line with the -D option.  It should be
 * the complete pathname of the file "sunview.help".
 *
 * It also assumes that GR_HEADER is the quoted pathname of the file
 * gr.h.
 */

#include <suntool/sunview.h>
#include <stdio.h>
#include <math.h>
#include "../lgd.h"
#include "dev.h"
#include GR_HEADER

/************************************************************************
 *			 PRIVATE DEFINITIONS				*
 ************************************************************************/

#define NO  0
#define YES 1

lgd_Menu *current_menu=NULL;
static int argc=0;
static char **argv=NULL;

/* Icon definition: */
static short icon_image[] = {
#include "lgd.icon"
};
DEFINE_ICON_FROM_IMAGE(lgd_icon, icon_image);

/************************************************************************
 *			  PUBLIC PROCEDURES				*
 ************************************************************************/

/*-----------------------------------------------------------------------
 * Function:	lgd_set_suntools_args
 * Description:	specifiy generic Suntools window argument list
 * Args  IN:	argc,argv: the window args from the program's command
 *		  line
 * Notes:	The use of this procedure is entirely optional.
 */
lgd_set_suntools_args(main_argc, main_argv)
     int main_argc;
     char **main_argv;
{
  argc = main_argc;
  argv = main_argv;
}

/*--------------------------------------------------------------*/
dev_initialize()
{
  static int initialized=NO;
  extern int gr_redraw();
  char fname[256];

  if (!initialized) {	 /* If we've not yet initialized, do so */
    gr_initialize(argc, argv);
    gr_set_frame_label("LGD");
    gr_set_frame_icon(&lgd_icon);
    gr_print_button(1, gr_redraw, "LGD");
    construct_help_file_name(fname);
    gr_set_help_file(fname);
    initialized=YES;
  }
  else {		 /* If we've already initialized, just */
    gr_erase();			/* erase the screen */
  }
}

/*--------------------------------------------------------------*/
dev_set_menu( menu )
lgd_Menu *menu;
{
  current_menu = menu;
  gr_set_menu( menu );
}

/*--------------------------------------------------------------*/
dev_inquire_menu( menu )
lgd_Menu **menu;
{
  *menu = current_menu;
}

/*--------------------------------------------------------------*/
dev_main_loop()
{
  gr_main_loop();
}

/*--------------------------------------------------------------*/
dev_end_loop()
{
  gr_done();
}

/*--------------------------------------------------------------*/
dev_get_string(s)
char *s;
{
  gr_get_string(s);
}

/*--------------------------------------------------------------*/
dev_put_string(s)
char *s;
{
  gr_message( s, 1 );
}

/*--------------------------------------------------------------*/
dev_confirm(s)
char *s;
{
  return(gr_user_confirm(s));
}

/*--------------------------------------------------------------*/
dev_get_point(v)
double v[];
{
  char buf[40];
  gr_message("Enter x coordinate of point:",2);
  gr_get_string(buf);
  v[0] = atof(buf);
  gr_message("Enter y coordinate of point:",2);
  gr_get_string(buf);
  v[1] = atof(buf);
  gr_message("Enter z coordinate of point:",2);
  gr_get_string(buf);
  v[2] = atof(buf);
  gr_message("",2);
}

/*--------------------------------------------------------------*/
dev_update_display()
{
  lgd_View3 view;

  lgd_inquire_view( &view );
  gr_set_eye_display( view.eye );
  gr_set_focus_display( view.focus );
  gr_set_up_display( view.up );
  gr_set_view_plane_window_display( view.u1, view.u2, view.v1, view.v2 );
}

/*--------------------------------------------------------------*/
dev_get_ndc_point(x, y)
double *x,*y;
{
  int X,Y;

  gr_Button button;

  gr_button_message( "pick point", "", "", "", "", "", "" );
  gr_get_canvas_xy(&X, &Y, &button, GR_LEFT);
  *x = X;
  *y = Y;
  gr_button_message_clear();
}

dev_signal(sig, func)
int sig, (*func)();
{
  gr_signal(sig, func);
}

dev_set_input_func(func, fd)
int (*func)(), fd;
{
  gr_set_input_func(func, fd);
}

static
  construct_help_file_name(fname)
char *fname;
{
  extern char *getenv();
  char *lgd_lib;

  /* First look in LGD_LIB */
  lgd_lib = getenv("LGD_LIB");
  if (lgd_lib != NULL) {
    sprintf(fname,"%s%s%s",
	    lgd_lib, (lgd_lib[strlen(lgd_lib)-1]=='/') ? "" : "/",
	    "sunview.help");
    if (GR_file_openable(fname, "r")) return;
  }

  /* If not there, then use default */
  strcpy(fname, HELPFILE);
}
