/*
 * Copyright (c) 1988, John M. Sullivan
 *		       Geometry Supercomputer Project
 *                     University of Minnesota 
 *                     1200 Washington Ave. S
 *		       Minneapolis, MN  55415
 *
 * email address: sullivan@geom.umn.edu
 *
 * This software is copyrighted as noted above.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the authors, who may or may not act on them as they desire.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */


#include "vcs.h"
#define aa_quiet FALSE
/***************************************************************
#include <aarg.i.h>
double aa_etof();

#define verbose(x,y) unless (aa_quiet) fprintf(stdout,x,y);
***************************************************************/

int Flg = 0;

/***************************************************************
Set_Torus()
{
    Flg |= FlagT|FlagI;
    switch(*aargv[1])
    {
    case 's':	Torus_Same = TRUE; break;
    case 'd':	Torus_Same = FALSE; break;
    default:	error("Bad mode %c, should be s or d", *aargv[1]);
    }
    if (aargc == 4)
	new_point_x(aa_etof(aargv[2]),aa_etof(aargv[3]),
		    aa_etof(aargv[4]),Torus);
}

Flagset()
{
    char c;
    while(c = *aargv[1]++)
	switch (c)
	{
	case 'i':	Flg |= FlagI; break;
	case 'r':	Flg |= FlagR; break;
	case 'j':	Flg |= FlagJ; break;
	default:	error("Bad flag %c", *--aargv[1]);
	}
}

Volume()
{
    file fp;

    switch(*aargv[1])
    {
    case '.':	break;
    case '=':	Flg |= FlagK; break;
    case '0':	Flg |= FlagV; break;
    default:
	open_aarg(1,fp,stdin,"r");
	verbose("Reading volumes from file %s\n",aargv[1]);
	read_vols(fp);
    }
}

Omit()
{
    Omit_Level = aa_etof(aargv[1]);
    if (aargc == 2)
	switch (*aargv[2])
	{
	case 'e':	Flg |= FlagO; break;
	default:	error("Bad argument to omit %c",*aargv[2]);
	}
}

Wulff(fp)
file fp;
{
    open_aarg(1,fp,stdin,"r");
    read_wulff(fp);
    unless(aa_quiet)
	fprintf(stdout,"Read %d wulff vectors\n",Wulff_Count);
}
***************************************************************/

Print()
{
    char c;
    file fp;
    char line[80];

    printf("What type of output [hkjposvq]? ");
    gets(line);
    c = *line;

    if (c=='q') exit(0);

    printf("\nFile name (null for stdout): ");
    gets(line);
    if (*line)
	fp = fopen(line,"w");
    else
	fp = stdout;

    switch (c)
    {
    case 'h':   write_pat(fp); break;
    case 'k':	write_ken(fp); break;
    case 'j':	write_jean(fp); break;
    case 'p':	write_pixar(fp); break;
    case 'o':	/*print_odp(fp)*/; break;
    case 's':	write_sites(fp); break;
    case 'v':	write_vols(fp); break;
    default:	error("Bad output type %c", c);
    }
    if (fp != stdout) fclose(fp);
}

/*
#ifdef DEBUG
Dbg_lvl()
{
    Debug_Level = aa_etof(aargv[1]);
}
#endif
*/


Compute()
{
    site s;

    voronoi_diagram();
    unless(aa_quiet)
    {
	fprintf(stdout,"Cell counts are (1+%d) - (%d+%d) + %d - %d = 0\n",
	    N_DTet, N_BndryTri,N_DTri-N_BndryTri,
	    N_Sites+N_DTri-N_DTet-1, N_Sites);
	print_utime();
    }

    init_arrays();
    compute_areas();
    unless(aa_quiet)
    {
	fprint_volume_summary(stdout);
	print_utime();
    }


    for_moving_sites(s)
	derivs(s);
    unless(aa_quiet)
	print_utime();
}

/*  keep these listed here in case we ever want them again
check(e)
facet_edge e;
{
    int i,j;
for (i=0;i<1;i++) for (j=0;j<3;j++)
    if (e->vert[i]->cell[j])
    if (e->vert[i]->cell[j] > Sites+N_Sites || e->vert[i]->cell[j] < Sites)
     return printf("error found %x %x %x\n",e->vert[i],e->vert[i]->cell[j],e);
}
consistent()
{
    trace_all_edges(check);
}
**************************************/

/********************
Move()
{
    site s;
    real reduce = 50.;
    real mx = .01;
    real small = .02;

    unless (Pos_Err)
    {
	if (aargc>=2)
	    reduce = aa_etof(aargv[2]);
	if (aargc>=3)
	    mx = aa_etof(aargv[3]);
	if (aargc>=4)
	    small = aa_etof(aargv[4]);

	orth_proj(small);
	switch(*aargv[1])
	{
	case 'a':	proj_motion(Area_Grad,reduce,mx); break;
	case 'w':	proj_motion(Wulff_Grad,reduce,mx); break;
	default:	error("Bad type of motion %s",aargv[1]);
	}
    }
    else unless(aa_quiet)
	fprintf(stdout,"Motion overridden by Kelvin adjacency errors\n");
    for_moving_sites(s)
	sum_q(s->loc,motion(s));

}


struct aarg_cmd cmds[] = {
    AA_BEGIN
	AA_COMMENT
	"This program will compute voronoi diagrams in three dimensions\n\t\
	and drive area or energy minimization.  Sample command lines\n\t\
	might be 'vcs -s dw4 -c -m a -o 1e-4 e -p s dw4 -p p dw4.poly',\n\t\
	or 'vcs -v = -t d -s t16 -c -m a 10 -p s t16' for a kelvin\n\t\
	torus, or 'vcs -f r -s foo -w s foo' to imitate the old\n\t\
	randomize program."
    AA_NEXT
	Flagset, "[-f[lags] %s]",
	"Set any combination of flags: i,j,r; these affect the sites\n\t\
	read in before computation.  I(nfinity) adds six fixed color 0\n\t\
	points near infinity, R(andom) adds a small random component to\n\t\
	the coordinates of each site.  Both of these can be useful if\n\t\
	initial data is in a regular array for which the voronoi\n\t\
	calculation is numerically unstable.  J(ump) adds a much larger\n\t\
	random amount not to the sites' positions, but to the motion\n\t\
	vector for movable sites, which will be adjusted with -move and\n\t\
	used to write out the sites.  These flags must be set before\n\t\
	reading the sites file."
    AA_NEXT
	Set_Torus, "[-t[orus] %s [%f %f %f]]",
	"Set torus mode, colors in different blocks s(ame) or d(iff),\n\t\
	dimensions (1. 1. 1.).  Use 's' for large blobs in a torus; use\n\t\
	'd' for small kelvin configurations where cells might touch\n\t\
	themselves.  With 'd', there cannot (yet) be many sites of one\n\t\
	color.  Also, non rectangular toruses are not yet supported.\n\t\
	Torus mode must be set before sites are read in."
    AA_NEXT
	Read_Sites, "[-s[ites] [%s]]",
	"Read sites from file (or stdin).  File should contain the number\n\t\
	of sites on the first line, followed by lines with x y z:c or\n\t\
	(x,y,z):c.  The color 0 always has volume ignored.  Colors\n\t\
	cannot be negative.  To keep some sites fixed, put them at the\n\t\
	end of the file, with the word fix on a line just before them."
    AA_NEXT
	Wulff, "[-w[ulff] [%s]]",
	"Read wulff vectors from file (or stdin), enabling calculation of\n\t\
	energy as well as area.  File should have one line for each\n\t\
	vector.  Currently the same vectors are used for the interface\n\t\
	energy for every (ordered) pair of colors, so in particular the\n\t\
	Wulff shape should be symmetric."
    AA_NEXT
	Volume, "[-v[olumes] [%s]]",
	"By default, or with '-v .', all volumes (except color 0,\n\t\
	which is always ignored) are fixed.  With '-v =', they are\n\t\
	equalized.  This also produces a bit of extra output suitable\n\t\
	for the Kelvin problem.  With '-v 0' all volumes are ignored\n\t\
	like color 0.  -v filename will read a file with specific\n\t\
	target volumes for each color.  Volume mode must be set\n\t\
	before computation, but after reading in the sites if a file\n\t\
	is specified (before is best with -v =)."
    AA_NEXT
	Compute, "[-c[ompute]]",
	"Compute voronoi diagram, areas, derivatives.  Must have read in\n\t\
	sites already."
    AA_NEXT
	Move, "[-m[ove] %s [%f [%f [%f]]]]",
	"Orthogonal projection of volume vectors, then move to minimize\n\t\
	a(rea) or w(ulff energy), dividing gradient by (50), max motion\n\t\
	(.01), gradients less than (.02) ignored.  Must be done after\n\t\
	computation."
    AA_NEXT
	Omit, "[-o[mit] %f [%s]]",
	"Omit saving sites with volume less than value (0.0), also\n\t\
	optionally all e(nclosed) sites.  This option can be specified\n\t\
	at any time, but has no effect unless computation is done."
    AA_NEXT
	Print, "[-p[rint] %s [%s]]",
	"Print results of type j(ean),k(en),p(ixar),o(dp),s(ites),v(ols)\n\t\
	to named file (or stdout).  Sites can be written at any time,\n\t\
	e.g. with flags r or i even before computation.  The other\n\t\
	outputs can only be produced after computation. s and v make\n\t\
	files that can be used by -s and -v.  j gives output for Jean\n\t\
	Taylor's wulff diagrams, k for Ken Brakke's surface evolver (in\n\t\
	torus mode, you must run torus_munge), p for pixar cpolygon\n\t\
	file (use Charlie Gunn's polytoquad), o (not implemented) for\n\t\
	odp (ngs) file, h for Pat Hanrahan's tetrahedron format."
#ifdef DEBUG
    AA_NEXT
	Dbg_lvl, "[-d[ebug] %d]",
	"Set debugging level to (0),1,2,3 for more debugging printout"
#endif
    AA_NEXT
	aa_quit, "[-q [%s]]",
	"exit program"
    AA_END,
    AA_STDCMD,
    AA_LASTCMD
};

***************************/

Main()
{
    file input;

    do_flags("ir");
    if (argc < 1)
	error("Specify -i to add six sites near infinity, -r to randomize\n\
site positions; follow these flags with site file name.");

    if (Flag('i')) Flg |= FlagI;
    if (Flag('r')) Flg |= FlagR;
    open_arg_in(input);
    read_sites(input);
    if (input != stdin) fclose(input);
    extra_sites();

    Compute();
    while(1)
	Print();
}
