#include "riemannmap.h"

static 	int 		newtoncount;
static	double		minrad = MINRAD;

/********************************* MAIN ******************************************************/
/*
			riemannmap

			by	Ithiel Carter
				Department of Mathematics C-012
				University of California
				La Jolla, CA	92093
				(619) 450-9050
				icarter@ucsd.edu

	Copyright 

	1988

	All Rights Reserved

	This program approximates conformal mappings of bounded, finitely-connected regions 

	onto circle domains by constructing isomorphic circle packings.

	The idea is due to William P. Thurston.

	The domain is input by drawing directly to the screen via the mouse.

	The range circle packing is constructed by solving a system of nonlinear curvature 

	equations via Newton's method calling the Yale sparse matrix package.

	By clicking with the mouse on either domain or range circles the user can

	recompute the nullcircle.

*/
/****************************************************************************************************/



main(argc,argv)
int argc;
char **argv;
{
	/* possible min radius set by user: a mistake if he uses X arg-passing too */
 	if (argc-- > 1)	minrad = atof(*++argv);
	drawdomain_flag = INIT_DRAW_FLAG;

	/* Set up necessary windows */
	myXbegin(argc, argv);

	/* Prompt user for tangent packings or boundary-modified packings */
	getoption();

	/* Get the domain region as drawn by the mouse */
	getbdry();
	
	for ( numcircles = runcount = 0, subdividing = FALSE;
		(runcount <= 1 || subdividing); )	{

		/* Get the filling radius and fill the domain 
		with the regular hexagonal circle packing */
		mygetmesh();

		/* Find the lower right circle */
		findfix();

		/* Count the number of circles and holes */
		countcircles();
		fprintf (stderr,"%d circles\n", numcircles);

		/* Exit program if mesh is too small */
		if (numcircles > MAXCIRCLES)	graceful_exit();
		N = numcircles-2;
	
		/* Assign cnum flags of the circles with variable radii */
		indexcircles();

		/* Store colors constant on hexagons concentric with the nullpoint */
		assigncolor();

		/* Draw the domain circle packing (in color, if supported) */
		if (drawdomain_flag)	{
			drawdomain();	
		}

		/* Make an initial radius guess at the vertices of variable radii */
		guessrad(runcount);
		endguess();

		if (massagemode)	{
		/* In Thurston boundary modification mode.
		Circles overlapping the boundary will be moved in until tangent to the boundary */

			/* Move in border circles that overlap the boundary */
			massagebdry();

			/* allocate memory to store angles on edges near the boundary */
			initedge();

			/* Read and store angles of intersection */
			assignxangles();

			massagemode = FALSE;
		}

		/* Allocate memory for the sparse linear system solver ndrv() */
		initNDRVargs();

		newtoncount = 0;

		/* Do an N-dimensional Newton's method to construct a zero curvature packing.
		where N = numcircles - 2 */
		while(do_one_iteration() );

		printf ("%d circles\n\n", numcircles);
		
		/* If necessary, deallocate memory of edge array */
		if (bdrymode == THURSTONMODE)	endedge();

		/* Deallocate memory of Newton method arrays */
		endNDRVargs();

		/* Print to screen the centers and radii of the holes, if any */
		doholeinfo();

		++runcount;

		/* Handle mouse input for recomputing nullcircle
		or halving radius and resuming computations */
		mygetbutton();

		if (subdividing)	{
		/* Make a smart initial radius guess based on the previous run.
		This idea is due to Charlie Gunn */
			int		a, b;

			/* Allocate memory for saving old circle data */
			initguess();

			/* Save old circle data */
			for (a=0; a<hw; ++a)
				GCirc[a] = DCirc[a];
			for (a=0; a<MAXHOLES; ++a)
				GHole[a] = DHole[a];
			a = fixradj+fixradi*width;
			GCirc[a].state = GCirc[a-1].state = 0;

			/* Save old matrix dimensions */
			oldwidth = width;
			oldheight = height;
			XtFree ((char *) myindex);
			XtFree ((char *) mycolor);
		}
	} /*for*/
} /*main*/


