
#include 	"extern.h"

/* All these functions compute circle centers */

findcenters ()
/* given the radii in RCirc, find the centers of the circles */
{
	int		notcycled, notplotted, moretoplot;
	double  	u1, v1, u2, v2, phi0, phi1, phi2, theta, r0, r1, r2;
	int 		a, b, h, i, j, k, c, m, n, s[6],  t[6], pos1[6][2], pos2[6][2];
	int		alpha, indx, stupidcount, holeplotted[MAXHOLES];

	double		capa, capb, capc, capu, capv, capw, phi01, phi02, phi12;
	double		r0r0, r1r1, r2r2, r0r1, r0r2, r1r2, t01, t02, t12, targ;
	int		cnum0, cnum1, cnum2, pdex1, pdex2;
	
	/* copy domain info to range info */
	indx = fixradj+fixradi*width;
	for (i=0; i<hw; ++i) 
		RCirc[i] = DCirc[i];
	for (i=0; i<MAXHOLES; ++i)	{
		holeplotted[i] = 0;
		RHole[i] = DHole[i];
	}
	
	/* plot the two lower right circles */
	indx = fixradj+fixradi*width;
	RCirc[indx].state = RCirc[indx-1].state = 1;
	RCirc[indx].r = RCirc[indx-1].r = DISKRAD;

	if ((bdrymode == PLAINMODE) || (bdrymode == THURSTONMODE))	{
		RCirc[indx].x = DISKRAD;
		theta = asin (0.5);
		RCirc[indx].y =  -(2.0*DISKRAD)*cos(theta);
	}

	if (bdrymode == PLAINMODE)	{
		RCirc[indx-1].x = -DISKRAD;
		RCirc[indx-1].y = RCirc[indx].y;
	}
	if (bdrymode == THURSTONMODE)	{
		/* Compute triangle of centers for circles intersecting at prescribed angles */
		r0 = DISKRAD;
		r1 = r2 = DISKRAD;
		phi01 = phi02 = 0.0;
		cnum1 = DCirc[indx-1].cnum;
		cnum2 = DCirc[indx].cnum;
		phi12 = getxangle(cnum1, cnum2);
		r0r0 = r0*r0;
		r1r1 = r1*r1;
		r2r2 = r2*r2;
		r0r1 = r0*r1;
		r0r2 = r0*r2;
		r1r2 = r1*r2;
		t01 = cos(phi01);
		t02 = cos(phi02);
		t12 = cos(phi12);
		capw = r0r0 + r0r1*t01 + r0r2*t02 - r1r2*t12;
		capu = r0r0 + r1r1 + 2.0*r0r1*t01;
		capv = r0r0 + r2r2 + 2.0*r0r2*t02;
		targ = capw/sqrt(capu*capv);
		if (fabs(targ) <= 1.0)
			phi2 = acos(targ);
		else
			phi2 = 0.0;

		u1 = 0.0;
		v1 = 0.0;
		u2 = RCirc[indx].x;
		v2 = RCirc[indx].y;
		phi1 = atan2(v2-v1, u2-u1);
		phi1 -= phi2;
		RCirc[indx-1].x = u1+(r0+r2)*cos(phi1) ;
		RCirc[indx-1].y = v1+(r0+r2)*sin(phi1);
	}

	moretoplot = TRUE;
	while (moretoplot)	{
	/* loop through and plot neighbors of circles already plotted */
		for (i=height-2; i>0; --i) {
			for (j=width-2; j>0; --j) {
				indx = j+i*width;
				if (RCirc[indx].state == PLOTTED) {
				/* Check for unplotted neighbors neighbors both clockwise and counterclockwise */
					for (h=0; h<2; ++h) {
						if (h%2 == 0)	 getccindices (i, j, pos1);
						else	 getcindices (i, j, pos1);
						for (n=0; n<NUMNBRS; ++n)	
							s[n] = RCirc [ pos1[n][1]+pos1[n][0]*width ].state;
						notcycled = notplotted = TRUE;
						k = 0;
						/* check whether neighbors need plotting */
						while (notplotted) {
							if ((s[k] == PLOTTED) 
							&& (s[(k+1)%NUMNBRS] > PLOTTED)) {
							/* We can start plotting off of the neighbor which has already been plotted */
								notplotted = FALSE;
								for (c=0; c<NUMNBRS; ++c) {
									t[c] = s[(k+c)%NUMNBRS];
									pos2[c][0] = pos1[(k+c)%NUMNBRS][0];
									pos2[c][1] = pos1[(k+c)%NUMNBRS][1];
								} 
								break;
							} 
							else {
								if (k<NUMNBRS)	++k;
								else 	notplotted = notcycled = FALSE;
							}
						} 
		
						if (notcycled) {
						/* yes, we can plot neighbors */
						/* Find the number of unplotted neighbors */
							r0 = RCirc[indx].r;
							cnum0 = DCirc[indx].cnum;
							phi2 = 0.0;
			 				k = 1;
							notplotted = TRUE;
							while (notplotted) {
								if (t[k] > PLOTTED) 	++k;
								else {
									m = k;
									notplotted = FALSE;
									break;
								} 
							}

							u1 = RCirc[indx].x;
							v1 = RCirc[indx].y;
							u2 = RCirc[pos2[0][1]+pos2[0][0]*width].x;
							v2 = RCirc[pos2[0][1]+pos2[0][0]*width].y;
							phi1 = atan2(v2-v1, u2-u1); 	/* Base angle for plotting */
							
							for (k=1; k<m; ++k) {

								pdex1 = pos2[k-1][1]+pos2[k-1][0]*width;
								pdex2 = pos2[k][1]+pos2[k][0]*width;
								r1 = RCirc[pdex1].r;
								r2 = RCirc[pdex2].r;

								if ((bdrymode == THURSTONMODE)
								&& (DCirc[indx].state > DEEPINSIDE))	{
								/* Compute triangle of centers for circles intersecting at prescribed angles */
									cnum1 = DCirc[pdex1].cnum;
									cnum2 = DCirc[pdex2].cnum;

									phi01 = getxangle(cnum0, cnum1);
									phi02 = getxangle(cnum0, cnum2);
									phi12 = getxangle(cnum1, cnum2);

									r0r0 = r0*r0;
									r1r1 = r1*r1;
									r2r2 = r2*r2;
									r0r1 = r0*r1;
									r0r2 = r0*r2;
									r1r2 = r1*r2;
									t01 = cos(phi01);
									t02 = cos(phi02);
									t12 = cos(phi12);
									capw = r0r0 + r0r1*t01 + r0r2*t02 - r1r2*t12;
									capu = r0r0 + r1r1 + 2.0*r0r1*t01;
									capv = r0r0 + r2r2 + 2.0*r0r2*t02;
									capb = sqrt(capv);
									targ = capw/sqrt(capu*capv);
									if (fabs(targ) <= 1.0)
										phi2 = acos(targ);
									else
										phi2 = 0.0;
								}
								else	{
									capb = r0+r2;
  									phi2 = acos (1.0-2.0*r1*r2/((r0+r1)*(r0+r2)));
								}
								if (h%2 == 0)	phi1 += phi2;
								else	phi1 -= phi2;
								a = pos2[k][1]+pos2[k][0]*width;
								/* Plot neighbor */
								RCirc[a].x = u1+capb*cos(phi1) ;
								RCirc[a].y = v1+capb*sin(phi1);
				        			RCirc[a].state = PLOTTED;
							} 
						} /*if*/ 
					} /*for h*/
				} /*if*/
			} /*for j*/ 
		} /*for i*/
		/* check whether any circles were missed */
		moretoplot = FALSE;
		for (i=hw-1; i>=0; --i) {
			if (RCirc[i].state > PLOTTED) 
				moretoplot = TRUE;
		}
	} /*while moretoplot*/
						
	/* plot the holes */
	for (i=1; i<height-1; ++i) {
		for (j=1; j<width-1; ++j) {
			indx = j+i*width;
			if ((DCirc[indx].state >= INNERBDRY)
			&&(holeplotted[DCirc[indx].state-INNERBDRY] == 0))	{
			/* At an inner boundary circle whose hole circle has not been plotted */

				alpha = DCirc[indx].state-INNERBDRY;

				u1 = RCirc[indx].x;
				v1 = RCirc[indx].y;
				u2 = RCirc[indx+1].x;
				v2 = RCirc[indx+1].y;
				phi1 = atan2(v2-v1, u2-u1);
				r0 = RCirc[indx].r;
				r1 = RCirc[indx+1].r;
				r2 = RHole[alpha].r;
				if (bdrymode == PLAINMODE)	{
					capb = r0+r2;
					phi2 = acos(1.0-2.0*r1*r2/((r0+r1)*(r0+r2)));
				}
				if (bdrymode == THURSTONMODE)	{
				/* Compute triangle of centers for circles intersecting at prescribed angles */
					cnum0 = DCirc[indx].cnum;
					cnum1 = DCirc[indx+1].cnum;
					phi01 = getxangle(cnum0, cnum1);
					phi02 = 0.0;
					phi12 = 0.0;
					r0r0 = r0*r0;
					r1r1 = r1*r1;
					r2r2 = r2*r2;
					r0r1 = r0*r1;
					r0r2 = r0*r2;
					r1r2 = r1*r2;
					t01 = cos(phi01);
					t02 = cos(phi02);
					t12 = cos(phi12);
					capw = r0r0 + r0r1*t01 + r0r2*t02 - r1r2*t12;
					capu = r0r0 + r1r1 + 2.0*r0r1*t01;
					capv = r0r0 + r2r2 + 2.0*r0r2*t02;
					capb = sqrt(capv);
					targ = capw/sqrt(capu*capv);
					if (fabs(targ) <= 1.0)
						phi2 = acos(targ);
					else
						phi2 = 0.0;
				}

				phi1 -= phi2;
				/* Plot hole */
				RHole[alpha].x = u1+capb*cos(phi1);
				RHole[alpha].y = v1+capb*sin(phi1) ;
				holeplotted [alpha] = 1;
			}
		}
	}
} /* findcenters */ 

