/* Structure descibing a circle packing */
typedef	struct	circleinfo	{
	double	x, y;		/* Center of circle */
	double	r;		/* radius */
	int	state;		/* Flag describing whether the circle is, e.g., INTERIOR, INNERBDRY, etc. See circle type constants */
	int 	numnbr;
	int	cnum;		/* Index ordering the circles in this array */
	} circleinfo;

/* Structure descibing edges*/
typedef	struct	edgeinfo	{
	int 	cnum1;		/* circleinfo cnum of circle */
	int	cnum2;		/* circleinfo cnum of adjacent circle. cnum1 < cnum2 */
	double	angle;		/* prescribed angle intersection of circles */
	} edgeinfo;

/* Structure describing the centers and states of circles printed to the screen or other output */
typedef	struct	plotinfo	{
	int	x, y;			/* Center of circle */
	int	state;			/* Circle type, e.g., OUTSIDE, INTERIOR, etc. */
	} plotinfo;

typedef	struct	prowcol	{
	int	i, j;			/* index of nonzero entries in circle matrix */
	} prowcol;

typedef	struct	rowpartial	{
	int	i, j;			/* index of nonzero entries in the partial matrix */
	double	dr;			/* nonzero partial */
	} rowpartial;

#define		DISKRAD		1.0				/* assumed radius of the "unit" circle and the two fixed border radii; */
								/* do not change! */
#define		ROOT3		1.73205080756887729
#define		PI		3.1415926535897932
#define		TINY		1.0e-14				/* conditioner for singular matrices */
#define		DOMAINRAD	220.0				/* half of domain window diameter */
#define		RANGERAD	220.0				/* half of range window diameter */
#define		X360DEGREES	23040				/* 360 degrees in the X drawing commands */
#define		AVE_EDGES	4.3				/* Average number of neighboring edges lieing in region */
								/* Might need to increase to 5.0 */
#define		MAXHOLES	10				/* number of holes allocated in memory; arbitrary */
#define		MAXITERATION	13				/* maximum number of newton iterations; arbitrary */
#define		MAXCIRCLES	50000				/* max. # of circles in packing */

#define		MINRAD		1.0

#define		PLOTFREQUENCY	1				/* number of newton iterations before plotting */
#define		STACKSIZE	8192

/* Boundary modification modes */
#define		PLAINMODE	1	/* No modification */
#define		THURSTONMODE	2	/* Circles that overlap the boundary are moved in until tangent to the boundary */

/* circle type flags */
#define		OUTSIDE		0
#define		CANDIDATE	1
#define		INTERIOR	4
#define		DEEPINSIDE	2
#define		OUTERBDRY	9
#define		PLOTTED		1
#define		NUMNBRS		6
#define		INNERBDRY	10

#define		TRUE		1
#define		FALSE		0
#define DEBUG

#define		INIT_DRAW_FLAG	1
