/****
   img_translate.c:  sample user-defined interpolation routine
   Written by Toby Orloff and Jim Larson
   orloff@poincare.geom.umn.edu
   September 18, 1990
****/

/*
 * Copyright (c) 1990, Geometry Supercomputer Project
 *                     University of Minnesota
 *                     1200 Washington Ave. S
 *                     Minneapolis, MN  55415
 *
 * email address: software@geom.umn.edu
 *
 * This software is copyrighted as noted above.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the authors, who may or may not act on them as they desire.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */


/*	This routine is for use with RGB screen images.  The first data
 *	file is the background, and the second is the image.  The
 *	interpolated result is a scene of the image sliding across the
 *	background, from left to right.  Areas that are black in the
 *	image file are considered to be transparent, so the background
 *	shows through.  The value of data_chunk must be equal to the
 *	width of the image in pixels times three.
 */

#include "omni_interp.h"

/*
 *	Parameters:
 *		A - Width of screen in pixels
 *		B - Height of screen in pixels
 *	(A pixel is assumed to be a three-byte value - RGB format)
 */

global_begin ()
{
  data_chunk = (int) 3 * A;
}


void
user_interp (time, in , out, file_pos, data_pos)
     double time;			/* Time of this interpolation. */
     double **in;			/* Input data. */
     double *out;			/* Interpolated data. */
     int file_pos;			/* Position of this data chunk */
					/* in whole data file. */
     int data_pos;			/* Position of this interpolation */
					/* time among data indices. */
{
  int i, xx;

  for (i = 0; i < data_chunk; i += 3)
    {
      xx = i + 3 * (int) ((1.0 - 2.0 * time) * A);

      if (xx < 0 || xx >= 3.0 * A
	  || (in[0][xx] == 0.0 && in[0][xx+1] == 0.0 && in[0][xx+2] == 0.0))
	{
	  out[i] = in[1][i];
	  out[i+1] = in[1][i+1];
	  out[i+2] = in[1][i+2];
	}
      else				/* Use background. */
	{
	  out[i] = in[0][xx];
	  out[i+1] = in[0][xx+1];
	  out[i+2] = in[0][xx+2];
	}
    }
}
