#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include "box_types.h"
#include "box_global.h"

Window BoxInitialize(gnrc,data)

BoxStatus *gnrc;
BoxData *data;

{

  XSetWindowAttributes xswa;
  XWindowAttributes xwa;
  Window root,top;
  XGCValues xgcv;
  int x,y,width,height;
  BoxAttributeList *attr;

  root = data->root;

  x = (int) (data->x * xppmm);
  y = (int) (data->y * yppmm);
  width = (int) (data->width * xppmm);
  height = (int) (data->height * yppmm);

  xswa.border_pixel = BlackPixel(dpy,DefaultScreen(dpy));
  xswa.background_pixel = WhitePixel(dpy,DefaultScreen(dpy));;
  xswa.event_mask = (KeyPressMask|ButtonPressMask|ExposureMask|
                     ButtonReleaseMask|StructureNotifyMask);

  top = XCreateWindow(dpy,root,x,y,width,height,
                            data->border,CopyFromParent,
                            InputOutput,CopyFromParent,
                            (CWBackPixel|CWEventMask|CWBorderPixel),&xswa);
                            
  gnrc->TopWindow = top;
  if(!data->do_not_map) {
     XMapWindow(dpy,top);
     XGetWindowAttributes(dpy,top,&xwa);
    }

  /* Create GC and reverse GC for box */

  /* Load the font */

  if((gnrc->fontstruct = XLoadQueryFont(dpy,data->font)) == NULL) {
    fprintf(stderr,"Can't open font %s\n",data->font);
    exit(1);
   }

  gnrc->fth = gnrc->fontstruct->max_bounds.ascent +
                  gnrc->fontstruct->max_bounds.descent;

  /* Create the gc */

  xgcv.font = gnrc->fontstruct->fid;
  xgcv.foreground = BlackPixel(dpy,DefaultScreen(dpy));
  xgcv.background = WhitePixel(dpy,DefaultScreen(dpy));
  gnrc->gc = XCreateGC(dpy,gnrc->TopWindow,(GCFont|
                            GCForeground|GCBackground),&xgcv);

  /* Create the reverse gc */

  xgcv.foreground = WhitePixel(dpy,DefaultScreen(dpy));
  xgcv.background = BlackPixel(dpy,DefaultScreen(dpy));
  gnrc->reverse_gc = XCreateGC(dpy,gnrc->TopWindow,(GCFont|
                            GCForeground|GCBackground),&xgcv);

  if(data->urgent_present == BOX_YES) CreateBoxUrgentWindow(gnrc,data);
  else gnrc->UrgentWindow = (Window) 0;

  if(data->title_present == BOX_YES) CreateBoxTitleWindow(gnrc,data);
  else gnrc->TitleWindow = (Window) 0;

  if(data->message_present == BOX_YES)
     CreateBoxMessageWindow(gnrc,data);
  else gnrc->MessageWindow = (Window) 0;

  /* Initialize box specific data */
  gnrc->box.exclusive = BOX_NO;
  gnrc->box.next = NULL;
  gnrc->box.id = 0;
  gnrc->box.generation = 0;
  gnrc->current_box = &(gnrc->box);
  gnrc->select_box = &(gnrc->box);
  gnrc->arg = data->arg;
  gnrc->state_change = BOX_NO;

  /* Set up attributes */
  attr = &(gnrc->attribute); attr->id = 0;
  attr->gc = gnrc->gc; gnrc->attribute.reverse_gc = gnrc->reverse_gc;
  attr->fontstruct = gnrc->fontstruct; attr->fth = gnrc->fth;
  attr->fg = BlackPixel(dpy,DefaultScreen(dpy));
  attr->bg = WhitePixel(dpy,DefaultScreen(dpy));
  attr->linewidth = 1; attr->next = NULL;
  gnrc->current_attribute = &(gnrc->attribute);
}


CreateBoxMessageWindow(gnrc,data)

BoxStatus *gnrc;
BoxData *data;

{
  XSetWindowAttributes xswa;
  XWindowAttributes xwa;
  int width,height,x_offset,y_offset;

  XGetWindowAttributes(dpy,gnrc->TopWindow,&xwa);

  height = gnrc->fth + 2*BOX_PAD;
  width = xwa.width;

  x_offset = 0;
  y_offset = xwa.height - height;


  xswa.background_pixel = BlackPixel(dpy,DefaultScreen(dpy));

  xswa.win_gravity = SouthWestGravity;
  xswa.event_mask = (ExposureMask|ButtonPressMask|ButtonReleaseMask|
                     KeyPressMask);

  gnrc->MessageWindow = XCreateWindow(dpy,gnrc->TopWindow,
                           x_offset,y_offset,width,height,
                           0,CopyFromParent,InputOutput,CopyFromParent,
                           (CWBackPixel|CWWinGravity|
                            CWEventMask),&xswa);

  BoxPrintMessage(gnrc,data->message);
  XMapWindow(dpy,gnrc->MessageWindow);

}


CreateBoxTitleWindow(gnrc,data)

BoxStatus *gnrc;
BoxData *data;

{
  XSetWindowAttributes xswa;
  XWindowAttributes xwa;

  XGetWindowAttributes(dpy,gnrc->TopWindow,&xwa);

  xswa.background_pixel = WhitePixel(dpy,DefaultScreen(dpy));;
  xswa.border_pixel = BlackPixel(dpy,DefaultScreen(dpy));
  xswa.event_mask = (ExposureMask|ButtonPressMask|
                     ButtonReleaseMask);

  gnrc->TitleWindow = XCreateWindow(dpy,gnrc->TopWindow,0,0,
                            xwa.width,gnrc->fth + 2*BOX_PAD,0,
                            CopyFromParent,InputOutput,CopyFromParent,
                            (CWBackPixel|CWBorderPixel|CWEventMask),&xswa);

  strcpy(gnrc->title,data->title);
  XMapWindow(dpy,gnrc->TitleWindow);


}


CreateBoxUrgentWindow(gnrc,data)

BoxStatus *gnrc;
BoxData *data;

{
  XSetWindowAttributes xswa;
  XWindowAttributes xwa;

  XGetWindowAttributes(dpy,gnrc->TopWindow,&xwa);

  xswa.background_pixel = WhitePixel(dpy,DefaultScreen(dpy));;
  xswa.border_pixel = BlackPixel(dpy,DefaultScreen(dpy));
  xswa.event_mask = (KeyPressMask|ExposureMask|ButtonPressMask|
                     ButtonReleaseMask);

  gnrc->UrgentWindow = XCreateWindow(dpy,gnrc->TopWindow,0,
                          xwa.height/2,xwa.width,gnrc->fth + 2*BOX_PAD,
                            5,CopyFromParent,InputOutput,CopyFromParent,
                            (CWBackPixel|CWBorderPixel|CWEventMask),&xswa);

}



