#include <stdio.h>

main(argc,argv)
int argc;
char **argv;
{
	int i,imax,len;
	int model_dim,var_dim_max,param_dim_max,func_dim_max,aux_max;
	char line[200],file_from[80],file_to[80],label[80],class_label[80];
	FILE *fp,*ffp,*fopen();

	for(i=1;i<=6;i++){
		if(argv[i]==NULL){
			printf("Error in arguments of kwrite_label!!!\n");
			printf("It needs more arguments.\n");
			exit(1);
		}
	}

	strcpy(class_label,argv[1]);
	var_dim_max = atoi(argv[2]);
	param_dim_max = atoi(argv[3]);
	func_dim_max = atoi(argv[4]);
	aux_max = atoi(argv[5]);

	model_dim = argc-6;

	sprintf(file_to,"%s_kaos_def.h",class_label);
	fp = fopen(file_to,"w");
	fprintf(fp,"/* --------------------------------------------------\n");
	fprintf(fp,"This file is automatically generated by kwrite_def.\n");
	fprintf(fp,"-----------------------------------------------------*/\n");
	fprintf(fp,"/*\nKAOS DYNAMICAL SYSTEM CLASS = %s\n*/\n",class_label);
	fprintf(fp,"/*\n	# of models installed (Look up \"Makefile\" in ${KAOSDIR}/modellib)\n*/\n");
	fprintf(fp,"#define MODEL_DIM %d /* number of installed models */\n",model_dim);
	fprintf(fp,"/*\n	title labels for models installed (Look up \"%s_model_labels.h\" in ${KAOSDIR}/modellib)\n*/\n",class_label);
	fprintf(fp,"/*\n	This is used to display the list of dynamical systems in a cycle item in the main panel\n*/\n",class_label);
	fprintf(fp,"#define MODEL_LABELS\\\n"); 

	sprintf(file_from,"%s_model_labels.h",class_label);
	ffp = fopen(file_from,"r");
	i=0;
	while(fgets(line,200,ffp)!= NULL){
		len = strlen(line);
		line[len-1] = '\0';
		if(i<model_dim-1){
			fprintf(fp,"\"%s\",\\\n",line);
		}
		else if(i==model_dim-1){
			fprintf(fp,"\"%s\"\n",line);
		}
		i++;
	}
	if(i != model_dim){
		printf("Error in a number of title labels!!\n");
		printf("# of models in Makefile=%d, # of models in the file %s=%d\n",model_dim,file_from,i);
		exit(0);
	}
	fclose(ffp);

	fprintf(fp,"/*\n	Customizable definitions of maximal dimensions\n*/\n");
	fprintf(fp,"/*\n	These are used only to specify # of labels to be listed from the cycle items.\n	The memory for all data are dynamically allocated.\n*/\n");
	fprintf(fp,"#define VAR_DIM_MAX %d\n",var_dim_max);
	fprintf(fp,"#define PARAM_DIM_MAX %d\n",param_dim_max);
	fprintf(fp,"#define FUNC_DIM_MAX %d\n",func_dim_max);
	fprintf(fp,"#define AUX_MAX %d\n",aux_max);
	fprintf(fp,"#define FULL_DIM_MAX (VAR_DIM_MAX+FUNC_DIM_MAX)\n");
	fprintf(fp,"#define ALL_DIM_MAX (VAR_DIM_MAX+FUNC_DIM_MAX+PARAM_DIM_MAX)\n");

	fprintf(fp,"/*\n	primary variable labels: # of elements = VAR_DIM_MAX\n*/\n");
	fprintf(fp,"#define VAR_LABELS\\\n");
	strcpy(label,"var_label");
	imax = var_dim_max;
	for(i=0;i<imax-1;i++){
		fprintf(fp,"%s[%d],\\\n",label,i);
	}
	fprintf(fp,"%s[%d]\n",label,i);

	fprintf(fp,"/*\n	secondary variable labels: # of elements = VAR_DIM_MAX\n*/\n");
	fprintf(fp,"#define VAR_POLAR_LABELS\\\n");
	strcpy(label,"var_polar_label");
	imax = var_dim_max;
	for(i=0;i<imax-1;i++){
		fprintf(fp,"%s[%d],\\\n",label,i);
	}
	fprintf(fp,"%s[%d]\n",label,i);

	fprintf(fp,"/*\n	window variable labels: # of elements = VAR_DIM_MAX+FUNC_DIM_MAX\n*/\n");
	fprintf(fp,"#define WIN_VAR_LABELS\\\n");
	strcpy(label,"win_var_label");
	imax = var_dim_max + func_dim_max;
	for(i=0;i<imax-1;i++){
		fprintf(fp,"%s[%d],\\\n",label,i);
	}
	fprintf(fp,"%s[%d]\n",label,i);

	fprintf(fp,"/*\n	parameter variable labels: # of elements = PARAM_DIM_MAX\n*/\n");
	fprintf(fp,"#define PARAM_LABELS\\\n");
	strcpy(label,"param_label");
	imax = param_dim_max;
	for(i=0;i<imax-1;i++){
		fprintf(fp,"%s[%d],\\\n",label,i);
	}
	fprintf(fp,"%s[%d]\n",label,i);

	fprintf(fp,"/*\n	combined variable labels: # of elements = VAR_DIM_MAX+FUNC_DIM_MAX+PARAM_DIM_MAX\n*/\n");
	fprintf(fp,"#define ALL_LABELS\\\n");
	strcpy(label,"all_label");
	imax = var_dim_max+param_dim_max+func_dim_max;
	for(i=0;i<imax-1;i++){
		fprintf(fp,"%s[%d],\\\n",label,i);
	}
	fprintf(fp,"%s[%d]\n",label,i);

	fclose(fp);
}
