/*
Determines which algorithm to use to compute orbits
depending on model and parameters and returns the value of algorithm

int_driver=0,1:
int_algorithm: 0=Euler, 1=Explicit symplectic, 2=Implicit symplectic,
	3= Runge-Kutta (4th order),4= user algorithm
int_driver=2:
iint_algorithm: 0=Runge-Kutta QC (5), 1= Bulirsch-Stoer (5)
-------------------------------------------------------------------
NOTE:	(1) can block the use of wrong algorithms here
	(for example, symplectic algorithm can be used only for Hamitonian
	vector field)
	(2) any model-specific testing or error handling should be done here 
	since it is read immediatedly before every new orbit is computed
	(3) Do not touch this subroutine to select algorithm from the panel
---------------------------------------------------------------

/*
Example 1 (default) - always use panel selection
*/
int choose_algorithm()
{
	extern int int_algorithm;
	return(int_algorithm);
}

/*
Example 2
When model=0, always use the 4th order Runge-Kutta.
When model=1, always use the explicit symplectic algorithm.
Otherwise, use the panel selection
*/
int choose_algorithm()
{
	extern int model,int_algorithm;
	extern double *param;
	
	switch(model){
		case 0:
			return(3);
			break;
		case 1:
			return(1);
			break;
		default:
			return(int_algorithm);
			break;
	}
}

/*
Example 3
When model=1 and parameters are right, use the explicit symplectic algorithm.
When model=2 and algorithm=1, complain and stop
Otherwise, use the panel selection
*/
int choose_algorithm()
{
	extern int model,int_algorithm;
	extern double *param;
	
	switch(model){
		case 1:
			if(param[0] == 0 && param[1] == 0)
				return(1);
			else
				return(int_algorithm);
			break;
		case 2:
			if(int_algorithm==1){
				system_mess_proc(1,"Wrong algorithm!");
				return(-1);
			}
		default:
			return(int_algorithm);
			break;
	}
}
