
int d4symmbrgen_init()
{
	title_label = "D4 Symmetry Broken Oscillator - General";

	mapping_on = 0;
	inverse_on = 1;
	fderiv_on = 0;
	enable_polar = 1;
	enable_period = 0;
	
	var_dim = 4;
	param_dim = 10;
	func_dim = 2;
	(void) malloc_init();

	var_label[0] = "x";
	var_label[1] = "y";
	var_label[2] = "z";
	var_label[3] = "w";
	var_polar_label[0] = "r";
	var_polar_label[1] = "rp";
	var_polar_label[2] = "theta";
	var_polar_label[3] = "thetap";
	param_label[0] = "damp";
	param_label[1] = "force";
	param_label[2] = "freq";
	param_label[3] = "split";
	param_label[4] = "mode1";
	param_label[5] = "mode2";
	param_label[6] = "cross";
	param_label[7] = "mode1p";
	param_label[8] = "mode2p";
	param_label[9] = "crossp";
	func_label[0] = "Energy";
	func_label[1] = "AngMom";

	param[0] = 2;
	param[1] = 0;
	param[2] = 0;
	param[3] = 0;
	param[4] = 0;
	param[5] = 0;
	param[6] = 0;
	param[7] = 0;
	param[8] = 0;
	param[9] = 0;

	var_i[0] = 0;
	var_i[1] = 0;
	var_i[2] = 0;
	var_i[3] = 0;
	var_polar_i[0] = 0;
	var_polar_i[1] = 0;
	var_polar_i[2] = 0;
	var_polar_i[3] = 0;

	param_min[0]= -5; param_max[0]= 5;
	param_min[1]= -5; param_max[1]= 5;
	param_min[2]= -5; param_max[2]= 5;
	param_min[3]= -5; param_max[3]= 5;
	param_min[4]= -5; param_max[4]= 5;
	param_min[5]= -5; param_max[5]= 5;
	param_min[6]= -5; param_max[6]= 5;
	param_min[7]= -5; param_max[7]= 5;
	param_min[8]= -5; param_max[8]= 5;
	param_min[9]= -5; param_max[9]= 5;

	var_min[0]= -5; var_max[0]= 5;
	var_min[1]= -5; var_max[1]= 5;
	var_min[2]= -5; var_max[2]= 5;
	var_min[3]= -5; var_max[3]= 5;

	var_polar_min[0]= -5; var_polar_max[0]= 5;
	var_polar_min[1]= -5; var_polar_max[1]= 5;
	var_polar_min[2]= -pi; var_polar_max[2]= pi;
	var_polar_min[3]= -5; var_polar_max[3]= 5;

	f_p = d4symmbrgen_f;
	func_p = d4symmbrgen_func;
}
int d4symmbrgen_f(f,index,x,p,t,dim)
int index,dim;
double f[],x[],p[],t;
{
	double da,am,sp,m1,m2,cr,rs,ss,zw1,zw2,xy1,xy2,xt,y,z,w,off;
	double m1p,m2p,crp;
	da = p[0];
	am = p[1];
	off = p[2];
	sp = p[3];
	m1 = p[4];
	m2 = p[5];
	cr = p[6];
	m1p = p[7];
	m2p = p[8];
	crp = p[9];
	xt = x[0];
	y = x[1];
	z = x[2];
	w = x[3];
	rs = xt*xt+y*y;
	ss = z*z+w*w;
	zw1 = cr*(z*z-w*w);
	zw2 = 2.0*cr*z*w;
	xy1 = crp*(xt*xt-y*y);
	xy2 = 2.0*crp*xt*y;
	f[0] = (-da - zw2)*xt + ( off + am - sp - m1*rs - m2*ss + zw1)*y;
	f[1] = (-da + zw2)*y + (-off + am + sp + m1*rs + m2*ss + zw1)*xt;
	f[2] = (-da - xy2)*z + ( off + am + sp - m1p*ss - m2p*rs + xy1)*w;
	f[3] = (-da + xy2)*w + (-off + am - sp + m1p*ss + m2p*rs + xy1)*z;
}
int d4symmbrgen_func(f,x,p,t,dim)
double f[],x[],p[],t;
int dim;
{
        double v0sq,v1sq,v2sq,v3sq;

	/* energy and angular momentum are defined in euclidean
	coordinates */
	v0sq = x[0] * x[0];
	v2sq = x[2] * x[2];
	f[0] = 0.5 * ((x[1] * x[1] + x[3] * x[3]) - p[0] * (v0sq+v2sq)
		+ 0.5 * (v0sq+v2sq) * (v0sq+v2sq) - p[1] * v0sq * v2sq);
	f[1] =  x[1] * x[2] - x[0] * x[3];
	
}
