
int d4hampp_init()
{
	title_label = "D4 Nilpotent Hamiltonian ++";

	mapping_on = 0;
	inverse_on = 1;
	fderiv_on = 0;
	enable_polar = 1;
	enable_period = 0;
	
	var_dim = 4;
	param_dim = 2;
	func_dim = 3;
	(void) malloc_init();

	var_label[0] = "x";
	var_label[1] = "y";
	var_label[2] = "z";
	var_label[3] = "w";
	var_polar_label[0] = "r";
	var_polar_label[1] = "rp";
	var_polar_label[2] = "theta";
	var_polar_label[3] = "thetap";
	param_label[0] = "mu";
	param_label[1] = "delta";
	func_label[0] = "Energy";
	func_label[1] = "AngMom";
	func_label[2] = "t";

	param[0] = 2;
	param[1] = 1;

	var_i[0] = 0;
	var_i[1] = 0;
	var_i[2] = 0;
	var_i[3] = 0;
	var_polar_i[0] = 0;
	var_polar_i[1] = 0;
	var_polar_i[2] = 0;
	var_polar_i[3] = 0;

	param_min[0]= -5; param_max[0]= 5;
	param_min[1]= -5; param_max[1]= 5;

	var_min[0]= -5; var_max[0]= 5;
	var_min[1]= -5; var_max[1]= 5;
	var_min[2]= -5; var_max[2]= 5;
	var_min[3]= -5; var_max[3]= 5;

	var_polar_min[0]= -5; var_polar_max[0]= 5;
	var_polar_min[1]= -5; var_polar_max[1]= 5;
	var_polar_min[2]= -pi; var_polar_max[2]= pi;
	var_polar_min[3]= -5; var_polar_max[3]= 5;

	func_min[0]= -1; func_max[0]= 1;
	func_min[1]= -1; func_max[1]= 1;
	func_min[2]= 0; func_max[2]= 10000;

	f_p = d4hampp_f;
	func_p = d4hampp_func;
}
/* D4 Hamitonian */
int d4hampp_f(f,index,x,p,t,dim)
int index,dim;
double f[],x[],p[],t;
{
	double v0sq,v2sq;

	/* Hamiltonian vector field: 0: dH/dy 2: dH/dw 1:-dH/dx 3:-dH/dz */
	if(index !=2) {
		f[0] = x[1];
		f[2] = x[3];
	}
	if(index !=1){
		v0sq = x[0] * x[0];
		v2sq = x[2] * x[2];
		f[1] = x[0] * (p[0] + (v0sq+v2sq)) + p[1] * x[0] * v2sq;
		f[3] = x[2] * (p[0] + (v0sq+v2sq)) + p[1] * x[2] * v0sq; 
	}
	
}
int d4hampp_func(f,x,p,t,dim)
double f[],x[],p[],t;
int dim;
{
        double v0sq,v1sq,v2sq,v3sq;

	/* energy and angular momentum are defined in euclidean
	coordinates */
	v0sq = x[0] * x[0];
	v2sq = x[2] * x[2];
	f[0] = 0.5 * (( x[1] * x[1] + x[3] * x[3]) - p[0]*(v0sq+v2sq)
		+ 0.5 * (v0sq+v2sq)*(v0sq+v2sq) - p[1] * v0sq* v2sq);
	f[1] =  x[1] * x[2] - x[0] * x[3];
	f[2] =  t;
}
